/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.calendar.grid;

import ca.infodata.ofys.ui.controls.calendar.grid.MonthCell;
import ca.infodata.ofys.ui.controls.grid.CellRenderer;
import ca.infodata.ofys.ui.controls.grid.Grid;
import ca.infodata.ofys.ui.controls.grid.GridData;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.util1.date.DateUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class MonthCellRenderer
implements CellRenderer<MonthCell, GridData<?>> {
    private Color colorBackground;
    private Color colorText;
    private Font font;

    @Override
    public void render(MonthCell cell, Grid<?, ?> grid, GridData<?> gridData, Rectangle rect, GC gc, boolean selected) {
        if (this.colorText == null || this.colorBackground == null) {
            throw new IllegalStateException("color is null");
        }
        if (this.font == null) {
            throw new IllegalStateException("font is null");
        }
        String monthName = DateUtil.toMonthString((int)(cell.getMonth() - 1));
        String text = String.valueOf(monthName) + " " + String.valueOf(cell.getYear());
        cell.setTextMonth(text);
        gc.setBackground(this.getColorBackground());
        gc.setForeground(this.getColorBackground());
        gc.drawRectangle(rect);
        gc.fillRectangle(rect);
        gc.setForeground(this.getColorText());
        gc.setFont(this.getFont());
        Point textExtent = gc.textExtent(text, 1);
        int y = rect.y + rect.height / 2 - textExtent.y / 2;
        gc.drawText(text, rect.x + rect.width - textExtent.x - 10, y, true);
    }

    public Color getColorBackground() {
        return this.colorBackground;
    }

    public Color getColorText() {
        return this.colorText;
    }

    public Font getFont() {
        return this.font;
    }

    public void setColorBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cant be null");
        }
        this.colorBackground = color;
    }

    public void setColorText(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cant be null");
        }
        this.colorText = color;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font cant be null");
        }
        this.font = font;
    }

    @Override
    public void dispose() {
        if (this.font != null) {
            ResourceGetter.dispose((Object)this.font);
        }
        if (this.colorText != null) {
            ResourceGetter.dispose((Object)this.colorText);
        }
        if (this.colorBackground != null) {
            ResourceGetter.dispose((Object)this.colorBackground);
        }
    }
}

