/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class ScrolledComposite2
extends Composite {
    private FormLayout layout = new FormLayout();
    private Composite content;
    private Point initialSize;

    public ScrolledComposite2(Composite parent, int maxWi) {
        super(parent, 2560);
        this.setLayout((Layout)this.layout);
        ScrollBar bar = this.getVerticalBar();
        bar.setVisible(true);
        bar.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScrolledComposite2.this.v_scrolled();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ScrolledComposite2.this.v_scrolled();
            }
        });
    }

    public void setContent(Composite content) {
        this.content = content;
        this.content.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ScrolledComposite2.this.contentResized();
            }
        });
    }

    protected void v_scrolled() {
    }

    protected void contentResized() {
        ScrollBar bar = this.getVerticalBar();
        Point csize = this.content.getSize();
        int selection = bar.getSelection();
        int thumb = this.getSize().y;
        bar.setValues(selection, 0, csize.y, thumb, 3, 6);
        FormData data = this.newContentLayoutData(0, 0, csize.y);
        this.content.setLayoutData((Object)data);
    }

    private FormData newContentLayoutData(int x, int y, int h) {
        FormData data = new FormData();
        data.top = new FormAttachment(0, y);
        data.left = new FormAttachment(0, x);
        data.right = new FormAttachment(100);
        int containerHeight = this.getSize().y;
        data.height = Math.max(containerHeight, y + h);
        return data;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(wHint, hHint, changed);
    }

    public void layout() {
        boolean doit = !this.isLayoutDeferred();
        super.layout();
        if (doit && this.initialSize == null) {
            Point size = this.getSize();
            this.initialSize = new Point(size.x, size.y);
        }
    }
}

