/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.IProgressMonitor2;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ProgressMonitor2Composite
extends FontAwareComposite {
    private static final Logger logger = Logger.getLogger(IStatusHandlerImplementation.class.getName());
    private FontAwareComposite loadingComposite;
    private FontAwareComposite loadedComposite;
    private FontAwareComposite errorComposite;
    private StackLayout stackLayout;
    private final IProgressMonitor2 callback;
    private final FormToolkit toolkit;

    public ProgressMonitor2Composite(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        this.toolkit = toolkit;
        this.loadingComposite = this.createLoadingComposite(this, this.toolkit);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.stackLayout.topControl = this.loadingComposite;
        this.setLayout((Layout)this.stackLayout);
        this.callback = new IProgressMonitor2Extension();
    }

    public StackLayout getStackLayout() {
        return this.stackLayout;
    }

    public void showLoadedCompositeInSwtThread() {
        if (this.isDisposed()) {
            return;
        }
        if (UI.isCurrentThreadIsUIThread()) {
            this.showLoadedComposite();
        } else {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressMonitor2Composite.this.showLoadedComposite();
                }
            });
        }
    }

    protected final void showLoadedComposite() {
        if (this.isDisposed()) {
            return;
        }
        if (this.loadedComposite == null) {
            this.loadedComposite = this.createLoadedComposite(this, this.toolkit);
        } else {
            this.updateLoadedComposite();
        }
        this.stackLayout.topControl = this.loadedComposite;
        this.layout();
    }

    protected void updateLoadedComposite() {
    }

    protected abstract FontAwareComposite createLoadedComposite(Composite var1, FormToolkit var2);

    protected void showErrorCompositeInSwtThread(final String message, final Throwable e) {
        if (this.isDisposed()) {
            return;
        }
        if (UI.isCurrentThreadIsUIThread()) {
            this.showErrorComposite(message, e);
        } else {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressMonitor2Composite.this.showErrorComposite(message, e);
                }
            });
        }
    }

    public void showErrorComposite(String message) {
        this.showErrorComposite(message, null);
    }

    public void showErrorComposite(String message, Throwable e) {
        if (this.isDisposed()) {
            return;
        }
        if (this.errorComposite == null) {
            String message2 = StringUtils.isNotBlank((String)message) ? message : (e != null ? (StringUtils.isNotBlank((String)e.getLocalizedMessage()) ? e.getLocalizedMessage() : MessageUtil.UNEXPECTED_ERROR_MESSAGE) : MessageUtil.UNEXPECTED_ERROR_MESSAGE);
            this.errorComposite = this.createErrorComposite(this, this.toolkit, message2);
        }
        this.stackLayout.topControl = this.errorComposite;
        this.layout();
    }

    private FontAwareComposite createErrorComposite(Composite parent, FormToolkit toolkit, String message) {
        FontAwareComposite main = new FontAwareComposite(parent, 0);
        toolkit.adapt((Composite)main);
        MyLabel lblMessage = new MyLabel(main, message, 0x1000040, toolkit);
        lblMessage.setFont(0, 1);
        lblMessage.setForeground(ResourceGetter.getRedWarningColor());
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        lblMessage.setLayoutData(data);
        main.setLayout((Layout)layout);
        return main;
    }

    public void showLoadingComposite() {
        this.stackLayout.topControl = this.loadingComposite;
        this.layout();
    }

    private FontAwareComposite createLoadingComposite(Composite parent, FormToolkit toolkit) {
        FontAwareComposite main = new FontAwareComposite(parent, 2048);
        toolkit.adapt((Composite)main);
        MyLabel lblLoading = new MyLabel(main, Messages.getString((String)"CHARGEMENT", (String[])new String[0]), 0x1000000, toolkit);
        lblLoading.setFont(2, 1);
        ProgressBar progressBar = new ProgressBar((Composite)main, 65538);
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        FormData data = new FormData();
        data.top = new FormAttachment(50, -60);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblLoading.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(lblLoading.getControl());
        data.left = new FormAttachment(50, -50);
        data.width = 100;
        progressBar.setLayoutData((Object)data);
        main.setLayout((Layout)layout);
        return main;
    }

    public IProgressMonitor2 getProgressMonitor() {
        return this.callback;
    }

    final class IProgressMonitor2Extension
    implements IProgressMonitor2 {
        boolean skipResponseReceived;

        IProgressMonitor2Extension() {
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
            ProgressMonitor2Composite.this.showLoadedCompositeInSwtThread();
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }

        @Override
        public void exception(Exception e) {
            this.skipResponseReceived = true;
            ProgressMonitor2Composite.this.showErrorCompositeInSwtThread(e.getMessage(), e);
        }

        @Override
        public void status(final IStatus status) {
            switch (status.getSeverity()) {
                case OK: 
                case INFO: 
                case WARNING: 
                case NEED_MORE_INFO: {
                    break;
                }
                case ERROR: {
                    this.skipResponseReceived = true;
                    ProgressMonitor2Composite.this.showErrorCompositeInSwtThread(status.getMessage(), null);
                    break;
                }
                case BUG: {
                    logger.log(Level.SEVERE, status.getMessage(), status.getException());
                    this.skipResponseReceived = true;
                    if (UI.isCurrentThreadIsUIThread()) {
                        ProgressMonitor2Composite.this.showErrorCompositeInSwtThread(status.getMessage(), status.getException());
                        break;
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ProgressMonitor2Composite.this.showErrorCompositeInSwtThread(status.getMessage(), status.getException());
                        }
                    });
                }
            }
        }
    }

    final class IStatusHandlerImplementation
    implements IStatusHandler {
        String message;
        boolean skipResponseReceived;

        IStatusHandlerImplementation() {
        }

        public IStatusHandler.State handle(IStatus status) {
            this.message = null;
            this.skipResponseReceived = false;
            if (status == null) {
                return IStatusHandler.State.NOT_HANDLED;
            }
            switch (status.getSeverity()) {
                case OK: 
                case INFO: 
                case WARNING: 
                case NEED_MORE_INFO: {
                    this.message = status.getMessage();
                    ProgressMonitor2Composite.this.showErrorCompositeInSwtThread(this.message, null);
                    break;
                }
                case ERROR: {
                    this.message = status.getMessage();
                    this.skipResponseReceived = true;
                    ProgressMonitor2Composite.this.showErrorCompositeInSwtThread(this.message, null);
                    break;
                }
                case BUG: {
                    this.message = status.getMessage();
                    this.skipResponseReceived = true;
                    logger.log(Level.SEVERE, status.getMessage(), status.getException());
                    ProgressMonitor2Composite.this.showErrorCompositeInSwtThread(this.message, status.getException());
                }
            }
            return IStatusHandler.State.HANDLED;
        }
    }
}

