/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.PreferencesAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.SaveCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XUserPreferences;
import ca.infodata.ofys.ui.browser.HtmlResource;
import ca.infodata.ofys.ui.controls.CallbackComposite;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.SpellCheckerBrowser;
import ca.infodata.ofys.ui.controls.VersionedFolder;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyList;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.file.FileUtil;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.hunspell5.HunspellStemFilterFactory;
import org.apache.lucene.analysis.hunspell5.Stemmer;
import org.apache.lucene.analysis.util.FilesystemResourceLoader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.spell.PlainTextDictionary;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class CheckSpellingComposite
implements IRefreshFont {
    private static final Logger logger = Logger.getLogger(CheckSpellingComposite.class.getName());
    protected String SPELLING = Messages.getString((String)"SPELLING", (String[])new String[0]);
    protected String NOT_FOUND = Messages.getString((String)"MOT_NOT_FOUND", (String[])new String[0]);
    protected String SUGGESTIONS_DE_REMPLACEMENT = Messages.getString((String)"SUGGESTIONS_DE_REMPLACEMENT", (String[])new String[0]);
    protected String REPLACE_ALL = Messages.getString((String)"REPLACE_ALL", (String[])new String[0]);
    protected String IGNORE_ALL = Messages.getString((String)"IGNORE_ALL", (String[])new String[0]);
    protected String LEARN = Messages.getString((String)"LEARN", (String[])new String[0]);
    protected String FERMER = Messages.getString((String)"CANCEL", (String[])new String[0]);
    protected String CONFIRMER = Messages.getString((String)"CONFIRMER", (String[])new String[0]);
    protected String CORRECTION_MANUELLE = Messages.getString((String)"CORRECTION_MANUELLE", (String[])new String[0]);
    protected SpellCheckerBrowser browser;
    protected MyLabel lblNotFound;
    protected MyLabel lblReplaceWith;
    protected MyText txtOtherReplacement;
    protected MyList<String> lstBadSpelling;
    protected MyList<String> lstSuggestions;
    protected FormToolkit toolkit;
    protected FontAwareComposite composite;
    protected MyButton btnReplaceAll;
    protected MyButton btnIgnorAll;
    protected MyButton btnLearn;
    protected MyButton btnClose;
    protected MyButton btnCancel;
    Map<String, WordsPositionsAndSuggestions> mapBadSpelling = null;
    Map<String, WordsPositionsAndSuggestions> mapBaseBadSpelling = new LinkedHashMap<String, WordsPositionsAndSuggestions>();
    protected Map<Point, String> mapPositions = new HashMap<Point, String>();
    protected Map<String, String> mapReplace = new HashMap<String, String>();
    protected Set<String> setAddedIgnore = new HashSet<String>();
    protected Set<String> setLearn = new HashSet<String>();
    private static final String DICT_FR_dic = "fr-toutesvariantes.dic";
    private static final String DICT_FR_aff = "fr-toutesvariantes.aff";
    private static final String DICT_FR_txt = "fr_CA.txt";
    private static final String DICT_FR_SUPP_txt = "fr_CA_supp.txt";
    private static final String DICT_EN_dic = "en_CA.dic";
    private static final String DICT_EN_aff = "en_CA.aff";
    private static final String DICT_EN_txt = "en_CA.txt";
    private static final String DICT_EN_SUPP_txt = "en_CA_supp.txt";
    protected static SpellChecker spellcheckerFr = null;
    protected static SpellChecker spellcheckerSuppFr = null;
    protected static SpellChecker spellcheckerEn = null;
    protected static SpellChecker spellcheckerSuppEn = null;
    protected static Stemmer stemmerFr = null;
    protected static Stemmer stemmerEn = null;
    protected static DirCopiedForLanguage dictCopied;
    protected Shell shell;
    final XUserPreferences userPreferences = Application.get().getGlobalInstances().getSession().getUser().getUserPreferences();
    private final String dictLangue;
    protected String textContent = null;
    static Set<String> setWordsToIgnore;
    protected CallbackComposite recallComp;
    private static String dictsPath;

    static {
        setWordsToIgnore = new HashSet<String>();
        setWordsToIgnore.add("Tx");
        setWordsToIgnore.add("Dx");
        setWordsToIgnore.add("Ex");
        setWordsToIgnore.add("Px");
        setWordsToIgnore.add("Kg");
        setWordsToIgnore.add("Pds");
        setWordsToIgnore.add("Pls");
        setWordsToIgnore.add("TX");
        setWordsToIgnore.add("DX");
        setWordsToIgnore.add("EX");
        setWordsToIgnore.add("PX");
        setWordsToIgnore.add("KG");
        setWordsToIgnore.add("PDS");
        setWordsToIgnore.add("PLS");
    }

    public CheckSpellingComposite(Shell parent, String langue, int style) {
        this.createMyControl(parent, null);
        this.dictLangue = langue;
        this.shell.setText(String.valueOf(Messages.getString((String)"CORRECTEUR", (String[])new String[0])) + " - " + langue.toUpperCase());
        if (dictCopied == null) {
            dictCopied = new DirCopiedForLanguage(langue);
        } else {
            dictCopied.setActiveLangue(langue);
        }
        Set<String> lstDictIgnore = this.getActiveDictIgnore();
        if (lstDictIgnore != null) {
            setWordsToIgnore.addAll(lstDictIgnore);
        }
        if (dictCopied.getActiveDirCopied() == null) {
            String dicts = this.getActiveDictSupp();
            String dictTxt = String.valueOf(dictsPath) + dicts;
            String wordsToAdd = this.getActiveDictRetainString();
            try {
                File dirSupp = new File(dictTxt);
                FileUtils.deleteQuietly((File)dirSupp);
                FileUtils.writeStringToFile((File)dirSupp, (String)wordsToAdd);
            }
            catch (IOException e1) {
                logger.log(Level.SEVERE, "writeStringToFile: " + wordsToAdd, e1);
            }
            dictCopied.setActiveDirCopied(CheckSpellingComposite.copyDictionnariesToDicts());
        }
        if (dictCopied.getActiveDirCopied() != null && dictCopied.getActiveDirCopied().booleanValue() && (this.getActiveSpellChecker() == null || this.getActiveSpellCheckerSupp() == null || this.getActiveStemmer() == null)) {
            try {
                OpendictsThread op = new OpendictsThread(this, "Chargement des dictionnaires");
                new ProgressMonitorDialog(this.shell).run(true, true, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)this.shell, (String)"Error", (String)e.getMessage());
            }
            catch (InterruptedException e) {
                MessageDialog.openInformation((Shell)this.shell, (String)"Cancelled", (String)e.getMessage());
            }
        }
    }

    public boolean setFocus() {
        return true;
    }

    protected void createMyControl(Shell sh, FormToolkit t) {
        this.shell = new Shell(sh, 65600);
        this.shell.setLayout((Layout)new FillLayout());
        if (t == null) {
            this.toolkit = UI.createToolKit((Widget)this.shell);
        }
        this.composite = new FontAwareComposite((Composite)this.shell, 0);
        FormLayout form = new FormLayout();
        form.marginTop = 0;
        form.marginLeft = 0;
        form.marginRight = 0;
        form.marginBottom = 0;
        form.spacing = 0;
        this.composite.setLayout((Layout)form);
        this.browser = new SpellCheckerBrowser((Composite)this.composite, this.toolkit);
        FontAwareComposite compositeDroit = new FontAwareComposite(this.composite, 0);
        form = new FormLayout();
        form.marginTop = 10;
        form.marginLeft = 10;
        form.marginRight = 10;
        form.marginBottom = 10;
        form.spacing = 5;
        compositeDroit.setLayout((Layout)form);
        this.lblNotFound = new MyLabel(compositeDroit, this.NOT_FOUND, 0, this.toolkit);
        this.lstBadSpelling = new MyList(compositeDroit, 2564);
        ProviderAR<String, String> provider = new ProviderAR<String, String>(){

            public String get(String object) {
                return object;
            }
        };
        this.lstBadSpelling.setLabelProvider(provider);
        this.lblReplaceWith = new MyLabel(compositeDroit, this.SUGGESTIONS_DE_REMPLACEMENT, 0, this.toolkit);
        this.lstSuggestions = new MyList(compositeDroit, 2564);
        this.txtOtherReplacement = new MyText((Composite)compositeDroit, this.toolkit, 0);
        this.txtOtherReplacement.setMessage(this.CORRECTION_MANUELLE);
        this.btnReplaceAll = new MyButton(compositeDroit, this.REPLACE_ALL, 8, this.toolkit);
        this.btnIgnorAll = new MyButton(compositeDroit, this.IGNORE_ALL, 8, this.toolkit);
        this.btnLearn = new MyButton(compositeDroit, this.LEARN, 8, this.toolkit);
        this.btnCancel = new MyButton(compositeDroit, this.FERMER, 8, this.toolkit);
        this.btnClose = new MyButton(compositeDroit, this.CONFIRMER, 8, this.toolkit);
        this.lstBadSpelling.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selected = CheckSpellingComposite.this.lstBadSpelling.getSelection3();
                if (StringUtils.isNotEmpty((String)selected)) {
                    CheckSpellingComposite.this.browser.highlight(selected);
                    List<String> lst = CheckSpellingComposite.this.mapBadSpelling.get(selected).getSuggestionsOrdered();
                    CheckSpellingComposite.this.lstSuggestions.removeAll();
                    if (lst != null && !lst.isEmpty()) {
                        CheckSpellingComposite.this.lstSuggestions.setItems(lst);
                    } else {
                        CheckSpellingComposite.this.lstSuggestions.removeAll();
                    }
                } else {
                    CheckSpellingComposite.this.lstSuggestions.removeAll();
                    CheckSpellingComposite.this.browser.execute("$('#thenote').removeHighlight();");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnReplaceAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String repString = null;
                int selected = CheckSpellingComposite.this.lstBadSpelling.getSelectionIndex();
                String badString = CheckSpellingComposite.this.lstBadSpelling.getSelection3();
                int repSelected = CheckSpellingComposite.this.lstSuggestions.getSelectionIndex();
                if (repSelected > -1) {
                    repString = CheckSpellingComposite.this.lstSuggestions.getSelection3();
                } else if (StringUtils.isNotEmpty((String)CheckSpellingComposite.this.txtOtherReplacement.getText())) {
                    repString = CheckSpellingComposite.this.txtOtherReplacement.getText();
                    List<CharsRef> lst = CheckSpellingComposite.this.getActiveStemmer().stem(repString);
                    boolean found = lst.size() > 0;
                    try {
                        if (!(found || CheckSpellingComposite.this.getActiveSpellChecker().exist(repString) || CheckSpellingComposite.this.getActiveSpellCheckerSupp().exist(repString))) {
                            CheckSpellingComposite.this.setLearn.add(repString);
                        }
                    }
                    catch (IOException e1) {
                        logger.log(Level.SEVERE, "de check", e1);
                    }
                }
                if (repString != null) {
                    CheckSpellingComposite.this.lstBadSpelling.select(null);
                    List<Point> positions = CheckSpellingComposite.this.mapBadSpelling.get(badString).getPositionsReverseSort();
                    CheckSpellingComposite.this.mapReplace.put(badString, repString);
                    CheckSpellingComposite.this.lstBadSpelling.remove(badString);
                    CheckSpellingComposite.this.mapBadSpelling.remove(badString);
                    int diffLength = repString.length() - badString.length();
                    for (Point pp : positions) {
                        CheckSpellingComposite.this.browser.execute("replaceInNote(" + pp.x + "," + pp.y + ",'" + repString + "');");
                        if (diffLength == 0) continue;
                        Collection<WordsPositionsAndSuggestions> otherWordPositions = CheckSpellingComposite.this.mapBadSpelling.values();
                        for (WordsPositionsAndSuggestions wps : otherWordPositions) {
                            for (Point ppp : wps.getPositionsReverseSort()) {
                                if (pp.x >= ppp.x) continue;
                                ppp.x += diffLength;
                            }
                        }
                    }
                    List<Point> basePositions = CheckSpellingComposite.this.mapBaseBadSpelling.get(badString).getPositionsReverseSort();
                    for (Point pp : basePositions) {
                        CheckSpellingComposite.this.mapPositions.put(pp, repString);
                    }
                    CheckSpellingComposite.this.lstBadSpelling.refresh();
                    CheckSpellingComposite.this.lstBadSpelling.select(selected);
                    CheckSpellingComposite.this.lstBadSpelling.notifyListeners(13, new Event());
                    CheckSpellingComposite.this.txtOtherReplacement.setText("");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnIgnorAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selected = CheckSpellingComposite.this.lstBadSpelling.getSelectionIndex();
                String badString = CheckSpellingComposite.this.lstBadSpelling.getSelection3();
                if (badString != null) {
                    CheckSpellingComposite.this.setAddedIgnore.add(badString);
                    CheckSpellingComposite.this.setAddedIgnore.add(badString.toLowerCase());
                    CheckSpellingComposite.this.lstBadSpelling.remove(badString);
                    CheckSpellingComposite.this.mapBadSpelling.remove(badString);
                    CheckSpellingComposite.this.lstBadSpelling.refresh();
                    CheckSpellingComposite.this.lstBadSpelling.select(selected);
                    CheckSpellingComposite.this.lstBadSpelling.notifyListeners(13, new Event());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnLearn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selected = CheckSpellingComposite.this.lstBadSpelling.getSelectionIndex();
                String badString = CheckSpellingComposite.this.lstBadSpelling.getSelection3();
                if (badString != null) {
                    CheckSpellingComposite.this.setLearn.add(badString);
                    if (badString.length() < 4) {
                        CheckSpellingComposite.this.setLearn.add(badString.toUpperCase());
                    }
                    CheckSpellingComposite.this.setLearn.add(badString.toLowerCase());
                    CheckSpellingComposite.this.lstBadSpelling.remove(badString);
                    CheckSpellingComposite.this.mapBadSpelling.remove(badString);
                    CheckSpellingComposite.this.lstBadSpelling.refresh();
                    CheckSpellingComposite.this.lstBadSpelling.select(selected);
                    CheckSpellingComposite.this.lstBadSpelling.notifyListeners(13, new Event());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnCancel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CheckSpellingComposite.this.cancel();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnClose.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CheckSpellingComposite.this.setAddedIgnore.size() > 0) {
                    CheckSpellingComposite.this.addToDictIgnore(CheckSpellingComposite.this.setAddedIgnore);
                }
                if (CheckSpellingComposite.this.setLearn.size() > 0) {
                    CheckSpellingComposite.this.addToDictRetain(CheckSpellingComposite.this.setLearn);
                    String dicts = CheckSpellingComposite.this.getActiveDictSupp();
                    String dictTxt = String.valueOf(dictsPath) + dicts;
                    String wordsToAdd = CheckSpellingComposite.this.getActiveDictRetainString();
                    try {
                        FileUtils.writeStringToFile((File)new File(dictTxt), (String)wordsToAdd, (boolean)true);
                        CheckSpellingComposite.this.setActiveSpellCheckerNull();
                    }
                    catch (IOException e1) {
                        logger.log(Level.SEVERE, "writeStringToFile: " + wordsToAdd, e1);
                    }
                }
                if (CheckSpellingComposite.this.userPreferences.isUpdated()) {
                    SaveCallback callback = new SaveCallback(Application.get().getGlobalInstances().getSession()){

                        public void responseReceived(ReturnObject response) {
                            super.responseReceived(response);
                            response.getStatus().isOkToProceed();
                        }

                        public void exception(Exception e) {
                            super.exception(e);
                        }

                        public void kill() {
                            super.kill();
                        }
                    };
                    try {
                        PreferencesAccessorClient.getInstance().save(this.hashCode(), Application.get().getGlobalInstances().getSession(), callback, (IDataObject)CheckSpellingComposite.this.userPreferences, true);
                    }
                    catch (CannotConnectToServerException e1) {
                        logger.log(Level.SEVERE, "saveUserPreference for setLearn et setAddedIgnore", e1);
                    }
                }
                CheckSpellingComposite.this.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.txtOtherReplacement.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckSpellingComposite.this.lstSuggestions.deselectAll();
            }
        });
        this.browser.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                CheckSpellingComposite.this.browser.refreshFont();
            }
        });
        int iRightList = 60;
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(70);
        data.bottom = new FormAttachment(100);
        this.browser.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.browser.getControl());
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        compositeDroit.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.lblNotFound.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.lblNotFound.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(iRightList);
        data.height = 120;
        this.lstBadSpelling.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.lstBadSpelling.getControl());
        data.left = new FormAttachment(0);
        this.lblReplaceWith.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.lblReplaceWith.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(iRightList);
        data.bottom = new FormAttachment(this.txtOtherReplacement.getControl());
        this.lstSuggestions.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(iRightList);
        data.bottom = new FormAttachment(this.btnCancel.getControl());
        this.txtOtherReplacement.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.lstBadSpelling.getControl(), 0, 128);
        data.left = new FormAttachment(this.lstSuggestions.getControl(), 10);
        data.right = new FormAttachment(100);
        this.btnReplaceAll.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.btnReplaceAll.getControl());
        data.left = new FormAttachment(this.lstSuggestions.getControl(), 10);
        data.right = new FormAttachment(100);
        this.btnIgnorAll.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.btnIgnorAll.getControl());
        data.left = new FormAttachment(this.lstSuggestions.getControl(), 10);
        data.right = new FormAttachment(100);
        this.btnLearn.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        data.bottom = new FormAttachment(100);
        this.btnCancel.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(this.btnCancel.getControl());
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.btnClose.setLayoutData(data);
        Point parentSize = sh.getSize();
        this.shell.setSize((int)((double)parentSize.x * 0.7), (int)((double)parentSize.y * 0.7));
        this.toolkit.adapt((Composite)this.composite);
        UI.centerComposite((Composite)this.shell, (Composite)sh);
        this.shell.open();
    }

    public void refreshFont() {
        this.composite.refreshFont();
    }

    public void cancel() {
        this.mapPositions.clear();
        this.mapReplace.clear();
        this.setAddedIgnore.clear();
        this.setLearn.clear();
        this.close();
    }

    public abstract void close();

    public void addBadSpelling(Map<String, WordsPositionsAndSuggestions> map) {
        this.lstBadSpelling.setItems(map.keySet());
        this.mapBadSpelling = map;
    }

    public void addTextContent(String textNote) {
        HtmlResource browserReadyHtml = this.browser.setContent(textNote);
        this.browser.browser.setHtml(browserReadyHtml);
        this.browser.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                String textContent = (String)CheckSpellingComposite.this.browser.evaluate("return getNoteVal()");
                CheckSpellingComposite.this.setTextContent(textContent);
                LinkedHashMap<String, WordsPositionsAndSuggestions> localMapBadSpelling = new LinkedHashMap<String, WordsPositionsAndSuggestions>();
                String regEx0 = "";
                String regEx1 = "(?!([^<]+)?>)";
                Pattern p = Pattern.compile(String.valueOf(regEx0) + "((?<!&)([A-\u00ff\u0153]{2,30})['\u2019-][0-9A-\u00ff\u0153]{1,10}['\u2019-][A-\u00ff\u0153]{1,10}['\u2019-]([A-\u00ff\u0153]{2,30}))" + regEx1 + "|" + regEx0 + "((?<!&)([A-\u00ff\u0153]{2,30})['\u2019-][A-\u00ff\u0153]{1,10}['\u2019-][A-\u00ff\u0153]{1,10}['\u2019-]([A-\u00ff\u0153]{2,30}))" + regEx1 + "|" + regEx0 + "((?<!&)([A-\u00ff\u0153]{2,30})['\u2019-][0-9A-\u00ff\u0153]{1,10}['\u2019-]([A-\u00ff\u0153]{2,30}))" + regEx1 + "|" + regEx0 + "((?<!&)([A-\u00ff\u0153]{2,30})['\u2019-]([A-\u00ff\u0153]{2,30}))" + regEx1 + "|" + regEx0 + "(?<!&)([A-\u00ff\u0153]{3,})" + regEx1);
                Matcher m = p.matcher(textContent);
                while (m.find()) {
                    boolean found;
                    String s = m.group();
                    if (setWordsToIgnore.contains(s) || setWordsToIgnore.contains(s.toLowerCase())) continue;
                    Point pt = new Point(m.start(), m.end() - m.start());
                    List<CharsRef> lst = CheckSpellingComposite.this.getActiveStemmer().stem(s);
                    boolean bl = found = lst.size() > 0;
                    if (!found && s.indexOf("oe") > -1) {
                        String soe = s.replace("oe", "\u0153");
                        lst = CheckSpellingComposite.this.getActiveStemmer().stem(soe);
                        found = lst.size() > 0;
                    }
                    String lowerS = s.toLowerCase();
                    found = found ? found : CheckSpellingComposite.this.getActiveDictRetain().contains(lowerS) || CheckSpellingComposite.this.getActiveDictRetain().contains(s);
                    try {
                        WordsPositionsAndSuggestions wps;
                        String newSugg;
                        HashSet<String> addedSuggestions;
                        int n;
                        if (found || CheckSpellingComposite.this.getActiveSpellChecker().exist(lowerS) || CheckSpellingComposite.this.getActiveSpellCheckerSupp().exist(lowerS) || CheckSpellingComposite.this.getActiveSpellChecker().exist(s) || CheckSpellingComposite.this.getActiveSpellCheckerSupp().exist(s)) continue;
                        HashSet<String> suggestions = new HashSet<String>();
                        String[] s1 = CheckSpellingComposite.this.getActiveSpellChecker().suggestSimilar(s, 6, 0.9f);
                        if (s1.length > 0) {
                            String[] stringArray = s1;
                            n = s1.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String string = stringArray[n2];
                                suggestions.add(string.trim());
                                ++n2;
                            }
                        }
                        if (suggestions.size() < 2) {
                            String[] s3;
                            String[] s2 = CheckSpellingComposite.this.getActiveSpellChecker().suggestSimilar(s, 6, 0.75f);
                            if (s2.length > 0) {
                                String[] stringArray = s2;
                                int n3 = s2.length;
                                n = 0;
                                while (n < n3) {
                                    String string = stringArray[n];
                                    suggestions.add(string.trim());
                                    ++n;
                                }
                            }
                            if (suggestions.size() < 2 && (s3 = CheckSpellingComposite.this.getActiveSpellChecker().suggestSimilar(s, 6, 0.6f)).length > 0) {
                                String[] stringArray = s3;
                                int n4 = s3.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    String string = stringArray[n5];
                                    suggestions.add(string.trim());
                                    ++n5;
                                }
                            }
                        }
                        if (s.endsWith("s")) {
                            addedSuggestions = new HashSet<String>();
                            for (String sugg : suggestions) {
                                if (sugg.endsWith("s") || sugg.endsWith("x")) continue;
                                newSugg = String.valueOf(sugg) + "s";
                                if (CheckSpellingComposite.this.getActiveStemmer().stem(newSugg).size() <= 0 && !CheckSpellingComposite.this.getActiveSpellChecker().exist(newSugg) && !CheckSpellingComposite.this.getActiveSpellCheckerSupp().exist(newSugg)) continue;
                                addedSuggestions.add(newSugg);
                            }
                            if (!addedSuggestions.isEmpty()) {
                                suggestions.addAll(addedSuggestions);
                            }
                        } else if (s.endsWith("x")) {
                            addedSuggestions = new HashSet();
                            for (String sugg : suggestions) {
                                if (sugg.endsWith("x")) continue;
                                newSugg = String.valueOf(sugg) + "x";
                                if (CheckSpellingComposite.this.getActiveStemmer().stem(newSugg).size() <= 0 && !CheckSpellingComposite.this.getActiveSpellChecker().exist(newSugg) && !CheckSpellingComposite.this.getActiveSpellCheckerSupp().exist(newSugg)) continue;
                                addedSuggestions.add(newSugg);
                            }
                            if (!addedSuggestions.isEmpty()) {
                                suggestions.addAll(addedSuggestions);
                            }
                        } else if (s.endsWith("\u00e9")) {
                            addedSuggestions = new HashSet();
                            for (String sugg : suggestions) {
                                if (!sugg.endsWith("e")) continue;
                                newSugg = String.valueOf(sugg.substring(0, sugg.length() - 1)) + "\u00e9";
                                if (CheckSpellingComposite.this.getActiveStemmer().stem(newSugg).size() <= 0 && !CheckSpellingComposite.this.getActiveSpellChecker().exist(newSugg) && !CheckSpellingComposite.this.getActiveSpellCheckerSupp().exist(newSugg)) continue;
                                addedSuggestions.add(newSugg);
                            }
                            if (!addedSuggestions.isEmpty()) {
                                suggestions.addAll(addedSuggestions);
                            }
                        }
                        String firstLetter = s.substring(0, 1);
                        HashSet<String> newSugg2 = new HashSet<String>();
                        if (firstLetter.equals(firstLetter.toUpperCase())) {
                            for (String sss : suggestions) {
                                newSugg2.add(String.valueOf(sss.substring(0, 1).toUpperCase()) + sss.substring(1));
                            }
                        } else {
                            newSugg2.addAll(suggestions);
                        }
                        if (localMapBadSpelling.containsKey(s)) {
                            wps = (WordsPositionsAndSuggestions)localMapBadSpelling.get(s);
                            wps.addPositions(pt);
                            wps.addSuggestions(newSugg2);
                        } else {
                            wps = new WordsPositionsAndSuggestions(pt, newSugg2);
                        }
                        localMapBadSpelling.put(s, wps);
                        CheckSpellingComposite.this.mapBaseBadSpelling.put(s, wps.clone());
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "addTextContent", e);
                        break;
                    }
                }
                CheckSpellingComposite.this.addBadSpelling(localMapBadSpelling);
            }
        });
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    private static boolean copyDictionnariesToDicts() {
        String version = "4";
        VersionedFolder versionedFolder = new VersionedFolder(new File(LibPlugin.OFYS_HOME), "dicts", version){

            @Override
            public void fill(File folder) throws Exception {
                String[] dics = new String[]{CheckSpellingComposite.DICT_FR_dic, CheckSpellingComposite.DICT_FR_aff, CheckSpellingComposite.DICT_FR_txt, CheckSpellingComposite.DICT_EN_dic, CheckSpellingComposite.DICT_EN_aff, CheckSpellingComposite.DICT_EN_txt, CheckSpellingComposite.DICT_EN_SUPP_txt, CheckSpellingComposite.DICT_FR_SUPP_txt};
                int i = 0;
                while (i < dics.length) {
                    InputStream is = CheckSpellingComposite.class.getResourceAsStream(dics[i]);
                    FileUtil.saveToFile((File)new File(folder, dics[i]), (InputStream)is);
                    ++i;
                }
            }
        };
        boolean ok = versionedFolder.init();
        dictsPath = String.valueOf(versionedFolder.getFolder().getPath()) + File.separator;
        return ok;
    }

    protected String getActiveDictIgnoreString() {
        String wordsToIgnore = "";
        Set<String> l = this.getActiveDictIgnore();
        if (l != null) {
            wordsToIgnore = String.valueOf(new JoinList("\n", l).toString()) + "\n";
        }
        return wordsToIgnore;
    }

    protected String getActiveDictRetainString() {
        String wordsToAdd = "";
        Set<String> l = this.getActiveDictRetain();
        if (l != null) {
            wordsToAdd = String.valueOf(new JoinList("\n", l).toString()) + "\n";
        }
        return wordsToAdd;
    }

    protected Set<String> getActiveDictIgnore() {
        return new HashSet<String>();
    }

    protected Set<String> getActiveDictRetain() {
        return new HashSet<String>();
    }

    protected Stemmer getActiveStemmer() {
        if ("en".equals(this.dictLangue)) {
            return stemmerEn;
        }
        return stemmerFr;
    }

    protected SpellChecker getActiveSpellChecker() {
        if ("en".equals(this.dictLangue)) {
            return spellcheckerEn;
        }
        return spellcheckerFr;
    }

    protected SpellChecker getActiveSpellCheckerSupp() {
        if ("en".equals(this.dictLangue)) {
            return spellcheckerSuppEn;
        }
        return spellcheckerSuppFr;
    }

    protected void addToDictIgnore(Set<String> s) {
    }

    protected void addToDictRetain(Set<String> s) {
    }

    protected String[] getActiveDicts() {
        String[] dicts = new String[3];
        if (this.dictLangue.equals("en")) {
            dicts[0] = DICT_EN_dic;
            dicts[1] = DICT_EN_aff;
            dicts[2] = DICT_EN_txt;
        } else {
            dicts[0] = DICT_FR_dic;
            dicts[1] = DICT_FR_aff;
            dicts[2] = DICT_FR_txt;
        }
        return dicts;
    }

    protected String getActiveDict() {
        String dicts = this.dictLangue.equals("en") ? DICT_EN_txt : DICT_FR_txt;
        return dicts;
    }

    protected String getActiveDictSupp() {
        String dicts = this.dictLangue.equals("en") ? DICT_EN_SUPP_txt : DICT_FR_SUPP_txt;
        return dicts;
    }

    protected void setActiveStemmer() throws IOException {
        String[] dicts = this.getActiveDicts();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("dictionary", String.valueOf(dictsPath) + dicts[0]);
        m.put("affix", String.valueOf(dictsPath) + dicts[1]);
        m.put("path", dictsPath);
        HunspellStemFilterFactory filter = new HunspellStemFilterFactory(m);
        FilesystemResourceLoader loader = new FilesystemResourceLoader();
        filter.inform(loader);
        if (this.dictLangue.equals("en")) {
            stemmerEn = new Stemmer(filter.getDictionary());
        } else {
            stemmerFr = new Stemmer(filter.getDictionary());
        }
    }

    protected void setActiveSpellCheckerSupp() throws FileNotFoundException, IOException {
        String dicts = this.getActiveDictSupp();
        String file1 = String.valueOf(dictsPath) + dicts;
        FileInputStream textInputStreamSupp = new FileInputStream(file1);
        PlainTextDictionary textDict = new PlainTextDictionary(textInputStreamSupp);
        FSDirectory dir = SimpleFSDirectory.open(new File(String.valueOf(dictsPath) + "idx_supp_" + this.dictLangue + "/"));
        if (this.dictLangue.equals("en")) {
            spellcheckerSuppEn = new SpellChecker(dir);
            spellcheckerSuppEn.indexDictionary(textDict, new IndexWriterConfig(Version.LUCENE_45, null), false);
        } else {
            spellcheckerSuppFr = new SpellChecker(dir);
            spellcheckerSuppFr.indexDictionary(textDict, new IndexWriterConfig(Version.LUCENE_45, null), false);
        }
    }

    protected void setActiveSpellChecker() throws FileNotFoundException, IOException {
        String dicts = this.getActiveDict();
        String file1 = String.valueOf(dictsPath) + dicts;
        FileInputStream textInputStream = new FileInputStream(file1);
        PlainTextDictionary textDict = new PlainTextDictionary(textInputStream);
        FSDirectory dir = SimpleFSDirectory.open(new File(String.valueOf(dictsPath) + "idx_" + this.dictLangue + "/"));
        if (this.dictLangue.equals("en")) {
            spellcheckerEn = new SpellChecker(dir);
            spellcheckerEn.indexDictionary(textDict, new IndexWriterConfig(Version.LUCENE_45, null), false);
        } else {
            spellcheckerFr = new SpellChecker(dir);
            spellcheckerFr.indexDictionary(textDict, new IndexWriterConfig(Version.LUCENE_45, null), false);
        }
    }

    protected void delActiveSpellCheckerSupDir() {
        FileUtils.deleteQuietly((File)new File(String.valueOf(dictsPath) + "idx_supp_" + this.dictLangue + "/"));
    }

    private void setActiveSpellCheckerNull() {
        try {
            if (this.dictLangue.equals("en")) {
                spellcheckerSuppEn.close();
                spellcheckerSuppEn = null;
                this.delActiveSpellCheckerSupDir();
            } else {
                spellcheckerSuppFr.close();
                spellcheckerSuppFr = null;
                this.delActiveSpellCheckerSupDir();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "setActiveSpellCheckerNull", e);
        }
    }

    public static void closeSpellCheckers() {
        try {
            if (spellcheckerSuppEn != null) {
                spellcheckerSuppEn.close();
                spellcheckerSuppEn = null;
            }
            if (spellcheckerSuppFr != null) {
                spellcheckerSuppFr.close();
                spellcheckerSuppFr = null;
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "closeSpellers", e);
        }
    }

    protected class ComparePoint
    implements Comparator<Point> {
        protected ComparePoint() {
        }

        @Override
        public int compare(Point p0, Point p1) {
            return p1.x == p0.x ? 0 : (p1.x > p0.x ? 1 : -1);
        }
    }

    protected static class DirCopiedForLanguage {
        private Boolean dict_copied_fr = null;
        private Boolean dict_copied_en = null;
        private String activeLangue;

        DirCopiedForLanguage(String l) {
            this.activeLangue = l;
        }

        protected void setActiveLangue(String l) {
            this.activeLangue = l;
        }

        protected void setActiveDirCopied(Boolean b) {
            if ("en".equals(this.activeLangue)) {
                this.dict_copied_en = b;
            } else {
                this.dict_copied_fr = b;
            }
        }

        protected Boolean getActiveDirCopied() {
            Boolean b = "en".equals(this.activeLangue) ? this.dict_copied_en : this.dict_copied_fr;
            return b;
        }
    }

    private static class OpendictsThread
    implements IRunnableWithProgress {
        private String titre;
        private CheckSpellingComposite spelling;

        public OpendictsThread(CheckSpellingComposite spelling, String titre) {
            this.spelling = spelling;
            this.titre = titre;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(this.titre, 3);
            if (this.spelling.getActiveSpellChecker() == null) {
                monitor.subTask("Dict.1");
                try {
                    this.spelling.setActiveSpellChecker();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Probleme de copie des dictionnaires", e);
                }
                monitor.worked(1);
            }
            if (this.spelling.getActiveSpellCheckerSupp() == null) {
                monitor.subTask("Dict.2");
                try {
                    this.spelling.setActiveSpellCheckerSupp();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Probleme de copie des dictionnaires", e);
                }
                monitor.worked(1);
            }
            if (this.spelling.getActiveStemmer() == null) {
                monitor.subTask("Dict.3");
                try {
                    this.spelling.setActiveStemmer();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Probleme de copie des dictionnaires", e);
                }
                monitor.worked(1);
            }
            if (monitor.isCanceled()) {
                monitor.done();
                return;
            }
            monitor.done();
        }
    }

    protected class WordsPositionsAndSuggestions {
        private final List<Point> positions = new ArrayList<Point>();
        private final Set<String> suggestions = new HashSet<String>();

        protected WordsPositionsAndSuggestions() {
        }

        protected WordsPositionsAndSuggestions(Point p, Set<String> list) {
            this.positions.add(p);
            this.suggestions.addAll(list);
        }

        protected void addPositions(Point p) {
            this.positions.add(p);
        }

        protected void addSuggestions(Set<String> l) {
            this.suggestions.addAll(l);
        }

        protected List<String> getSuggestionsOrdered() {
            ArrayList<String> list = new ArrayList<String>(this.suggestions);
            Collections.sort(list, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            return list;
        }

        protected List<Point> getPositionsReverseSort() {
            ArrayList<Point> list = new ArrayList<Point>(this.positions);
            Collections.sort(list, new ComparePoint());
            return list;
        }

        protected WordsPositionsAndSuggestions clone() {
            WordsPositionsAndSuggestions w = new WordsPositionsAndSuggestions();
            for (Point p : this.positions) {
                w.addPositions(new Point(p.x, p.y));
            }
            for (String s : this.suggestions) {
                w.suggestions.add(s);
            }
            return w;
        }
    }
}

