/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser.util;

import ca.infodata.ofys.ui.browser.ClasspathResourceHandler;
import ca.infodata.ofys.ui.browser.resource.BadResource;
import ca.infodata.ofys.ui.browser.resource.URLResource2;
import ca.infodata.ofys.ui.browser.sonar.ComponentLoader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.FileResource;
import org.eclipse.jetty.util.resource.Resource;
import org.osgi.framework.BundleContext;

public class PlainResourceLoader {
    private static final Logger logger = Logger.getLogger(ClasspathResourceHandler.class.getName());
    private ComponentLoader cloader;

    PlainResourceLoader() {
    }

    public ComponentLoader getCloader() {
        return this.cloader;
    }

    public void setCloader(ComponentLoader cloader) {
        this.cloader = cloader;
    }

    public Resource getResource(String path) throws MalformedURLException {
        if (this.cloader != null) {
            BundleContext loader = this.cloader.getCtx();
            String path2 = path;
            URL url = loader.getBundle().getResource(path2);
            if (url != null) {
                path2 = URIUtil.canonicalPath((String)path);
                return PlainResourceLoader.newResource(url, true);
            }
        }
        return null;
    }

    private static Resource newResource(URL url, boolean useCaches) {
        if (url == null) {
            return null;
        }
        String url_string = url.toExternalForm();
        if (url_string.startsWith("file:")) {
            try {
                FileResource fileResource = new FileResource(url);
                return fileResource;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error loading resource with url " + url, e);
                return new BadResource(url, e.toString());
            }
        }
        if (url_string.startsWith("jar:file:")) {
            logger.severe("unsupported resource type jar:file with url " + url);
            return new BadResource(url, "unsupported resource type jar:file");
        }
        if (url_string.startsWith("jar:")) {
            logger.severe("unsupported resource type jar: with url " + url);
            return new BadResource(url, "unsupported resource type jar:");
        }
        return new URLResource2(url, null, useCaches);
    }

    public String getResourceLoaderRoot() {
        String root = this.cloader.getComponentPath();
        return root;
    }
}

