/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.core.IWebResource;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.browser.Activator;
import ca.infodata.ofys.ui.browser.ApssResourceHandler;
import ca.infodata.ofys.ui.browser.BrowserSockets;
import ca.infodata.ofys.ui.browser.BrowserWebSocketServlet;
import ca.infodata.ofys.ui.browser.ClasspathDevModeResourceHandler;
import ca.infodata.ofys.ui.browser.ClasspathResourceHandler;
import ca.infodata.ofys.ui.browser.CleanHeaderProxyServlet;
import ca.infodata.ofys.ui.browser.HtmlImageViewerResource;
import ca.infodata.ofys.ui.browser.HtmlMultiResource;
import ca.infodata.ofys.ui.browser.HtmlPdfViewerResource;
import ca.infodata.ofys.ui.browser.HtmlResource;
import ca.infodata.ofys.ui.browser.InMemoryResourceHandler;
import ca.infodata.ofys.ui.browser.JettyConnector;
import ca.infodata.ofys.ui.browser.sonar.JettySonar;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.file.FileUtil;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.DatagramSocket;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class HtmlBrowserTools {
    private static final Logger logger = Logger.getLogger(HtmlBrowserTools.class.getName());
    private static final int MIN_PORT_NUMBER = 10000;
    private static final int MAX_PORT_NUMBER = 65535;
    private static Server server;
    private static ClasspathResourceHandler classpathHandler;
    private static JettySonar dispatchHandler;
    private static InMemoryResourceHandler inMemoryResourceHandler;
    private static ApssResourceHandler apssResourceHandler;
    private static JettyConnector connector0;
    private static JettyConnector connectorApss;
    private static final List<IJettyListener> jettyListeners;
    private static final String AJOUTER;
    public static final String VIEWER_HTML = "templates/viewer.html";
    public static final String VIEWER2_HTML = "templates/pdf2/viewer.html";
    public static final String VIEWER_HTML_DEBUG = "templates/viewer-debug.html";
    public static final String VIEWER_HTML_NO_PRINT = "templates/viewer-noprint.html";
    public static final String VIEWER2_HTML_NO_PRINT = "templates/pdf2/viewer-noprint.html";
    public static final String VIEWER_HTML_NO_PRINT_DEBUG = "templates/viewer-noprint-debug.html";
    public static final String VIEWER_IMAGE_HTML = "templates/viewer_image.html";
    private static Map<String, String> originalHtmlTemplates;

    static {
        jettyListeners = new ArrayList<IJettyListener>();
        AJOUTER = Messages.getString((String)"AJOUTER", (String[])new String[0]);
        originalHtmlTemplates = new HashMap<String, String>();
    }

    public static synchronized ClasspathResourceHandler getClasspathHandler() {
        return classpathHandler;
    }

    public static synchronized void startJetty(BundleContext bundleContext) {
        block16: {
            HtmlBrowserTools.saveFilesToTools();
            ServerConnector serverConnector0 = null;
            ServerConnector serverConnectorApss = null;
            try {
                server = new Server();
                server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)-1);
                serverConnector0 = new ServerConnector(server);
                if (!Platform.inDebugMode()) {
                    serverConnector0.setHost("127.0.0.1");
                }
                serverConnector0.setPort(HtmlBrowserTools.getPortNumber());
                serverConnector0.setIdleTimeout(180000L);
                connector0 = new JettyConnector("127.0.0.1", serverConnector0.getPort(), false);
                serverConnectorApss = new ServerConnector(server);
                serverConnectorApss.setPort(HtmlBrowserTools.getRandomAvailablePortNumber());
                serverConnectorApss.setIdleTimeout(180000L);
                if (!Platform.inDebugMode()) {
                    serverConnectorApss.setHost("127.0.0.1");
                }
                connectorApss = new JettyConnector("127.0.0.1", serverConnectorApss.getPort(), false);
                ServletContextHandler context = new ServletContextHandler(1);
                DefaultServlet defaultServlet = new DefaultServlet();
                ServletHolder holder = new ServletHolder((Servlet)defaultServlet);
                holder.setInitParameter("useFileMappedBuffer", "false");
                context.setResourceBase(LibPlugin.OFYS_HOME);
                context.addServlet(holder, "/");
                SslContextFactory sslContextFactory = new SslContextFactory();
                sslContextFactory.setTrustAll(true);
                sslContextFactory.setEndpointIdentificationAlgorithm("");
                HttpClient httpClient = new HttpClient(sslContextFactory);
                httpClient.setRequestBufferSize(8192);
                httpClient.setResponseBufferSize(8192);
                httpClient.setConnectTimeout(10000L);
                httpClient.setIdleTimeout(15000L);
                try {
                    httpClient.start();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to start HttpClient", e);
                }
                ServletHolder proxyServlet = new ServletHolder((Servlet)new CleanHeaderProxyServlet(httpClient));
                String sofiapayUrl = Application.get().getGlobalInstances().getSofiapayConnectionInfo().getServerAddress();
                if (sofiapayUrl == null || sofiapayUrl.contains("127.0.0.1:18203") || sofiapayUrl.contains("localhost:18203")) {
                    logger.log(Level.SEVERE, "ERREUR CRITIQUE: L'URL Sofiapay pointe vers le serveur local: " + sofiapayUrl);
                    logger.log(Level.SEVERE, "Le proxy ne peut pas pointer vers lui-m\u00eame!");
                    String url = Application.get().getGlobalInstances().getTemplateConnectionInfo().getServerAddress();
                    sofiapayUrl = url.contains("test.ofys.biz") || url.contains("69.70.129.198") ? "https://test.ofys.biz/sofiapay" : (url.contains("ofyspro.ca") || url.contains("ofys.ca") ? "https://ofyspro.ca/sofiapay" : "https://ofyspro.ca/sofiapay");
                }
                proxyServlet.setInitParameter("proxyTo", String.valueOf(sofiapayUrl) + "/");
                proxyServlet.setInitParameter("prefix", "/sofiapay");
                context.addServlet(proxyServlet, "/sofiapay/*");
                FilterHolder cors = new FilterHolder(CrossOriginFilter.class);
                cors.setInitParameter("allowedOrigins", "*");
                cors.setInitParameter("Access-Control-Allow-Origin", "*");
                cors.setInitParameter("allowedMethods", "GET,POST,HEAD");
                cors.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin");
                context.addFilter(cors, "/*", EnumSet.of(DispatcherType.REQUEST));
                Bundle middleBundle = Platform.getBundle((String)"ca.infodata.ofys.data.middle.dataobjects_client");
                if (middleBundle.getState() != 32) {
                    middleBundle.start();
                }
                classpathHandler = Platform.inDebugMode() && ClasspathDevModeResourceHandler.shouldTakeOverTheApplication() ? new ClasspathDevModeResourceHandler() : new ClasspathResourceHandler();
                classpathHandler.setServer(server);
                classpathHandler.addClassLoader("/tools/*", middleBundle.getBundleContext());
                dispatchHandler = new JettySonar();
                dispatchHandler.setServer(server);
                BrowserWebSocketServlet wsDispatchHandler = new BrowserWebSocketServlet();
                ServletHolder wsHolder = new ServletHolder("lidiws", (Servlet)wsDispatchHandler);
                context.addServlet(wsHolder, "/lidiws");
                inMemoryResourceHandler = new InMemoryResourceHandler();
                inMemoryResourceHandler.setCacheControl("max-age=0,public");
                apssResourceHandler = new ApssResourceHandler(serverConnector0);
                HandlerList handlerList = new HandlerList();
                handlerList.addHandler((Handler)apssResourceHandler);
                handlerList.addHandler((Handler)classpathHandler);
                handlerList.addHandler((Handler)dispatchHandler);
                handlerList.addHandler((Handler)inMemoryResourceHandler);
                handlerList.addHandler((Handler)context);
                server.setConnectors(new Connector[]{serverConnector0, serverConnectorApss});
                handlerList.addHandler((Handler)new DefaultHandler());
                server.setHandler((Handler)handlerList);
                try {
                    server.setStopTimeout(5L);
                    server.start();
                    while (server.isStarting()) {
                        logger.log(Level.INFO, "starting jetty");
                    }
                    logger.log(Level.INFO, "Jetty is " + (server.isStarted() ? "STARTED on PORT " + serverConnector0.getPort() + " with base root " + LibPlugin.OFYS_HOME : "NOT started"));
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to start Jetty ", e);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to start jetty server", e);
                if (server != null) {
                    server.destroy();
                }
                if (serverConnector0 != null) {
                    serverConnector0.destroy();
                }
                if (serverConnectorApss == null) break block16;
                serverConnectorApss.destroy();
            }
        }
        for (IJettyListener listener : jettyListeners) {
            try {
                listener.jettyStarted();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error while notifying jetty listener " + listener, e);
            }
        }
    }

    public static void sendMessageToWebClient(String clientUid, String message) {
        if (clientUid != null) {
            BrowserSockets ss = null;
            int i = 0;
            while (i < 50 && (ss = BrowserSockets.getInstances().get(clientUid)) == null) {
                try {
                    Thread.sleep(100L);
                    ++i;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (ss != null) {
                ss.sendMessage(message);
            }
        } else if (!BrowserSockets.getInstances().isEmpty()) {
            for (BrowserSockets socket : BrowserSockets.getInstances().values()) {
                socket.sendMessage(message);
            }
        }
    }

    public static void stopJetty() {
        if (server != null && server.isStarted()) {
            try {
                server.stop();
                inMemoryResourceHandler.dispose();
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Erreur pour server.stop() de Jetty ", e);
            }
            for (IJettyListener listener : jettyListeners) {
                try {
                    listener.jettyStopped();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error while notifying jetty listener " + listener, e);
                }
            }
        }
    }

    private static int getDebugPortNumber() {
        int p = 18203;
        while (!HtmlBrowserTools.portCanConnect(p)) {
            ++p;
        }
        return p;
    }

    private static int getPortNumber() {
        return HtmlBrowserTools.getDebugPortNumber();
    }

    private static int getRandomAvailablePortNumber() {
        Random r = new Random();
        int p = r.nextInt(55535) + 10000;
        while (!HtmlBrowserTools.available(p)) {
            p = r.nextInt(55535) + 10000;
        }
        return p;
    }

    public static boolean available(int port) {
        if (port < 10000 || port > 65535) {
            return false;
        }
        return HtmlBrowserTools.portCanConnect(port);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean portCanConnect(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        ss = new ServerSocket(port);
        ss.setReuseAddress(true);
        ds = new DatagramSocket(port);
        ds.setReuseAddress(true);
        if (ds != null) {
            ds.close();
        }
        if (ss == null) return true;
        try {
            ss.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException iOException) {
            try {
                if (ds != null) {
                    ds.close();
                }
                if (ss == null) return false;
            }
            catch (Throwable throwable) {
                if (ds != null) {
                    ds.close();
                }
                if (ss == null) throw throwable;
                try {
                    ss.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                ss.close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    private HtmlBrowserTools() {
    }

    public static HtmlResource newErrorTemplateResource(String message, String hostAddr) {
        String htmlTemplate = HtmlBrowserTools.getHtmlTemplate("templates/error.html", new String[0]);
        String htmlTemplate2 = htmlTemplate.replace("__MESSAGE__", message);
        String fileName = "error-" + System.currentTimeMillis() + ".html";
        return HtmlBrowserTools.newHtmlResource(fileName, hostAddr, (Object)htmlTemplate2);
    }

    public static HtmlResource newErrorTemplateResource(Exception e, String hostAddr) {
        return HtmlBrowserTools.newErrorTemplateResource(connector0, hostAddr, e);
    }

    public static HtmlResource newErrorTemplateResource(JettyConnector connector, String hostAddr, Exception e) {
        String message = "<br><br>" + e.getClass().getName() + "<br>" + e.getMessage();
        return HtmlBrowserTools.newErrorTemplateResource(message, hostAddr);
    }

    public static String getJettyUrl(String hostAddr) {
        return HtmlBrowserTools.getJettyUrl(connector0, hostAddr);
    }

    public static URL getJettyURL() {
        try {
            String protocol = HtmlBrowserTools.connector0.ssl ? "https" : "http";
            String host = HtmlBrowserTools.connector0.host;
            int port = HtmlBrowserTools.connector0.port;
            return new URL(protocol, host, port, "");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getJettyUrl(JettyConnector connector, String hostAddr) {
        return String.valueOf(connector.ssl ? "https://" : "http://") + (hostAddr == null ? String.valueOf(connector.host) + ":" + connector.port : hostAddr);
    }

    public static String getHtmlTemplate(String filename, String ... addItemName) {
        return HtmlBrowserTools.getHtmlTemplate(Activator.getDefault().getBundle(), filename, addItemName);
    }

    public static HtmlResource newHtmlResource(Object resource, String hostAddr) {
        return HtmlBrowserTools.newHtmlResource(connector0, hostAddr, resource);
    }

    private static HtmlResource newHtmlResource(JettyConnector connector, String hostAddr, Object resource) {
        return HtmlBrowserTools.newHtmlResource(connector, "htmlResource" + System.currentTimeMillis(), hostAddr, resource);
    }

    public static HtmlResource newHtmlResource(String resourceName, String hostAddr, Object resource) {
        return HtmlBrowserTools.newHtmlResource(connector0, resourceName, hostAddr, resource);
    }

    public static HtmlResource newHtmlResourceNoHost(String resourceName, Object resource) {
        String urlSuffix = HtmlBrowserTools.getUrlSuffix(resourceName);
        inMemoryResourceHandler.addResource(urlSuffix, resource, true);
        HtmlResource r = new HtmlResource(inMemoryResourceHandler, resourceName, urlSuffix);
        return r;
    }

    public static HtmlResource getOrCreateHtmlResource(String resourceName, String hostAddr, Object resource, boolean withH2Cache) {
        return HtmlBrowserTools.getOrCreateHtmlResource(connector0, resourceName, hostAddr, resource, withH2Cache);
    }

    public static HtmlResource getOrCreateHtmlResource(String resourceName, String hostAddr, Object resource) {
        return HtmlBrowserTools.getOrCreateHtmlResource(connector0, resourceName, hostAddr, resource, true);
    }

    public static HtmlResource getOrCreateHtmlResourceNoHost(String resourceName, Object resource) {
        String urlSuffix = HtmlBrowserTools.getUrlSuffix(resourceName);
        HtmlResource r = new HtmlResource(inMemoryResourceHandler, resourceName, urlSuffix);
        if (!inMemoryResourceHandler.hasResource(urlSuffix)) {
            inMemoryResourceHandler.addResource(urlSuffix, resource, true);
        }
        return r;
    }

    private static boolean hasHtmlResource(String resourceName) {
        String urlSuffix = HtmlBrowserTools.getUrlSuffix(resourceName);
        return inMemoryResourceHandler.hasResource(urlSuffix);
    }

    public static HtmlResource getHtmlResource(String resourceName, String hostAddr) {
        return HtmlBrowserTools.getHtmlResource(connector0, resourceName, hostAddr);
    }

    private static HtmlResource getHtmlResource(JettyConnector connector, String resourceName, String hostAddr) {
        String urlSuffix = HtmlBrowserTools.getUrlSuffix(resourceName);
        if (!inMemoryResourceHandler.hasResource(urlSuffix)) {
            return null;
        }
        return new HtmlResource(inMemoryResourceHandler, urlSuffix, HtmlBrowserTools.getJettyUrlResource(connector, urlSuffix, hostAddr));
    }

    private static HtmlResource getOrCreateHtmlResource(JettyConnector connector, String resourceName, String hostAddr, Object resource, boolean withH2Cache) {
        String urlSuffix = HtmlBrowserTools.getUrlSuffix(resourceName);
        HtmlResource r = new HtmlResource(inMemoryResourceHandler, urlSuffix, HtmlBrowserTools.getJettyUrlResource(connector, urlSuffix, hostAddr));
        if (!inMemoryResourceHandler.hasResource(urlSuffix)) {
            inMemoryResourceHandler.addResource(urlSuffix, resource, withH2Cache);
        }
        return r;
    }

    private static String getUrlSuffix(String resourceName) {
        String urlSuffix = resourceName.startsWith("/temp/") ? resourceName : "/temp/" + resourceName;
        return urlSuffix;
    }

    public static HtmlResource newHtmlResource(JettyConnector connector, String resourceName, String hostAddr, Object resource) {
        String urlSuffix = HtmlBrowserTools.getUrlSuffix(resourceName);
        inMemoryResourceHandler.addResource(urlSuffix, resource, true);
        HtmlResource r = new HtmlResource(inMemoryResourceHandler, urlSuffix, HtmlBrowserTools.getJettyUrlResource(connector, urlSuffix, hostAddr));
        return r;
    }

    public static String getJettyUrlResource(String resourceName, String hostAddr) {
        return HtmlBrowserTools.getJettyUrlResource(connector0, resourceName, hostAddr);
    }

    public static String getJettyUrlResource(JettyConnector connector, String resourceName, String hostAddr) {
        String urlSuffix = HtmlBrowserTools.getUrlSuffix(resourceName);
        return String.valueOf(HtmlBrowserTools.getJettyUrl(connector, hostAddr)) + urlSuffix;
    }

    public static String getUrl(String urlSuffix, String hostAddr) {
        if (urlSuffix.endsWith("/") && !urlSuffix.startsWith("/")) {
            return String.valueOf(HtmlBrowserTools.getJettyUrl(hostAddr)) + "/" + urlSuffix;
        }
        return String.valueOf(HtmlBrowserTools.getJettyUrl(hostAddr)) + urlSuffix;
    }

    private static File getHtmlPdfFolder() {
        File temp = new File(LibPlugin.OFYS_HOME_FILE, "temp");
        File pdfFolder = new File(temp, "pdf");
        return pdfFolder;
    }

    private static String getHtmlPdfUrl() {
        return "/temp/pdf/";
    }

    public static IWebResource newHtmlPdfResource(byte[] pdf) throws IOException {
        String resourceName = String.valueOf(HtmlBrowserTools.newUUID()) + ".pdf";
        return HtmlBrowserTools.newHtmlPdfResource(resourceName, null, pdf);
    }

    public static IWebResource newHtmlPdfViewerResource(byte[] pdf, boolean allowPrinting, boolean recentViewer) throws IOException {
        String resourceName = String.valueOf(HtmlBrowserTools.newUUID()) + ".pdf";
        return HtmlBrowserTools.newHtmlPdfViewerResource(resourceName, pdf, allowPrinting, recentViewer);
    }

    private static String newUUID() {
        return UUID.randomUUID().toString();
    }

    public static HtmlResource newHtmlPdfViewerResource(File pdfFile, String hostAddr) throws IOException {
        File pdfFile2 = new File(HtmlBrowserTools.getHtmlPdfFolder(), pdfFile.getName());
        if (!pdfFile2.exists()) {
            FileUtil.copyFile((File)pdfFile, (File)pdfFile2);
        }
        HtmlResource pdfFileResource = HtmlBrowserTools.newHtmlResource(String.valueOf(HtmlBrowserTools.getHtmlPdfUrl()) + pdfFile2.getName(), hostAddr, (Object)pdfFile);
        boolean recentViewer = (Boolean)Application.get().getPreferencesPluginController().getUserProp("user_settings_UseNewPDFViewer");
        String viewerHtml = HtmlBrowserTools.getViewerHtml(false, recentViewer);
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"PDF_URL_TO_LOAD", (String)"");
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"PDF_FILE_URL", (String)(String.valueOf(HtmlBrowserTools.getJettyUrlResource(pdfFile2.getName(), hostAddr)) + ".html"));
        HtmlMultiResource htmlResource = HtmlBrowserTools.newHtmlResource(String.valueOf(pdfFile2.getName()) + ".html", hostAddr, (Object)viewerHtml).toHtmlMultiResource();
        htmlResource.addChildren(pdfFileResource);
        return htmlResource;
    }

    public static HtmlResource newHtmlPdfViewerResource(File pdfFile, boolean recentViewer) throws IOException {
        File pdfFile2 = new File(HtmlBrowserTools.getHtmlPdfFolder(), pdfFile.getName());
        if (!pdfFile2.exists()) {
            FileUtil.copyFile((File)pdfFile, (File)pdfFile2);
        }
        HtmlResource pdfFileResource = HtmlBrowserTools.newHtmlResourceNoHost(String.valueOf(HtmlBrowserTools.getHtmlPdfUrl()) + pdfFile2.getName(), pdfFile);
        String viewerHtml = HtmlBrowserTools.getViewerHtml(false, recentViewer);
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"PDF_URL_TO_LOAD", (String)"");
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"PDF_FILE_URL", (String)(String.valueOf(pdfFileResource.getUrl()) + ".html"));
        HtmlMultiResource htmlResource = HtmlBrowserTools.newHtmlResourceNoHost(String.valueOf(pdfFile2.getName()) + ".html", viewerHtml).toHtmlMultiResource();
        htmlResource.addChildren(pdfFileResource);
        return htmlResource;
    }

    public static boolean hasHtmlPdfViewerResource(String resourceName, String hostAddr) {
        return HtmlBrowserTools.hasHtmlResource(String.valueOf(HtmlBrowserTools.getHtmlPdfUrl()) + resourceName) && HtmlBrowserTools.hasHtmlResource(String.valueOf(resourceName) + ".html");
    }

    public static HtmlPdfViewerResource getHtmlPdfViewerResource(String resourceName, String hostAddr) {
        HtmlResource htmlResource;
        HtmlResource pdfFileResource = HtmlBrowserTools.getHtmlResource(String.valueOf(HtmlBrowserTools.getHtmlPdfUrl()) + resourceName, hostAddr);
        if (pdfFileResource != null && (htmlResource = HtmlBrowserTools.getHtmlResource(String.valueOf(resourceName) + ".html", hostAddr)) != null) {
            HtmlPdfViewerResource pdfViewerResource = new HtmlPdfViewerResource(inMemoryResourceHandler, htmlResource.getName(), htmlResource.getUrl());
            pdfViewerResource.setFileResource(pdfFileResource);
            pdfViewerResource.setViewerResource(htmlResource);
            return pdfViewerResource;
        }
        return null;
    }

    public static HtmlPdfViewerResource getOrCreateHtmlPdfViewerResource(String resourceName, String hostAddr, byte[] pdf, boolean allowPrinting, boolean recentViewer) throws IOException {
        HtmlResource pdfFileResource = HtmlBrowserTools.getOrCreateHtmlResource(String.valueOf(HtmlBrowserTools.getHtmlPdfUrl()) + resourceName, hostAddr, pdf);
        String viewerHtml = HtmlBrowserTools.getViewerHtml(allowPrinting, recentViewer);
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"PDF_URL_TO_LOAD", (String)pdfFileResource.getUrl());
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"PDF_FILE_URL", (String)(String.valueOf(HtmlBrowserTools.getJettyUrlResource(resourceName, hostAddr)) + ".html"));
        HtmlResource htmlResource = HtmlBrowserTools.getOrCreateHtmlResource(String.valueOf(resourceName) + ".html", hostAddr, viewerHtml);
        HtmlPdfViewerResource pdfViewerResource = new HtmlPdfViewerResource(inMemoryResourceHandler, htmlResource.getName(), htmlResource.getUrl());
        pdfViewerResource.setFileResource(pdfFileResource);
        pdfViewerResource.setViewerResource(htmlResource);
        return pdfViewerResource;
    }

    public static HtmlPdfViewerResource getOrCreateHtmlPdfViewerResource(String resourceName, byte[] pdf, boolean allowPrinting, boolean recentViewer) throws IOException {
        HtmlResource pdfFileResource = HtmlBrowserTools.getOrCreateHtmlResource("pdf/" + resourceName, null, pdf, true);
        String viewerHtml = HtmlBrowserTools.getViewerHtml(allowPrinting, recentViewer);
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"PDF_URL_TO_LOAD", (String)pdfFileResource.getUrl());
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"PDF_FILE_URL", (String)(String.valueOf(pdfFileResource.getUrl()) + ".html"));
        HtmlResource htmlResource = HtmlBrowserTools.getOrCreateHtmlResourceNoHost(String.valueOf(resourceName) + ".html", viewerHtml);
        HtmlPdfViewerResource pdfViewerResource = new HtmlPdfViewerResource(inMemoryResourceHandler, htmlResource.getName(), htmlResource.getUrl());
        pdfViewerResource.setFileResource(pdfFileResource);
        pdfViewerResource.setViewerResource(htmlResource);
        return pdfViewerResource;
    }

    public static HtmlPdfViewerResource newHtmlPdfViewerResource(String resourceName, String hostAddr, byte[] pdf, boolean allowPrinting, boolean recentViewer) throws IOException {
        HtmlResource pdfFileResource = HtmlBrowserTools.newHtmlResource(String.valueOf(HtmlBrowserTools.getHtmlPdfUrl()) + resourceName, hostAddr, (Object)pdf);
        String viewerHtml = HtmlBrowserTools.getViewerHtml(allowPrinting, recentViewer);
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"PDF_URL_TO_LOAD", (String)pdfFileResource.getUrl());
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"PDF_FILE_URL", (String)(String.valueOf(HtmlBrowserTools.getJettyUrlResource(resourceName, hostAddr)) + ".html"));
        HtmlResource htmlResource = HtmlBrowserTools.newHtmlResource(String.valueOf(resourceName) + ".html", hostAddr, (Object)viewerHtml);
        HtmlPdfViewerResource pdfViewerResource = new HtmlPdfViewerResource(inMemoryResourceHandler, htmlResource.getName(), htmlResource.getUrl());
        pdfViewerResource.setFileResource(pdfFileResource);
        pdfViewerResource.setViewerResource(htmlResource);
        return pdfViewerResource;
    }

    public static HtmlPdfViewerResource newHtmlPdfViewerResource(String resourceName, byte[] pdf, boolean allowPrinting, boolean recentViewer) throws IOException {
        HtmlResource pdfFileResource = HtmlBrowserTools.newHtmlResourceNoHost(String.valueOf(HtmlBrowserTools.getHtmlPdfUrl()) + resourceName, pdf);
        String viewerHtml = HtmlBrowserTools.getViewerHtml(allowPrinting, recentViewer);
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"PDF_URL_TO_LOAD", (String)pdfFileResource.getUrl());
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"PDF_FILE_URL", (String)(String.valueOf(pdfFileResource.getUrl()) + ".html"));
        HtmlResource htmlResource = HtmlBrowserTools.newHtmlResourceNoHost(String.valueOf(resourceName) + ".html", viewerHtml);
        HtmlPdfViewerResource pdfViewerResource = new HtmlPdfViewerResource(inMemoryResourceHandler, htmlResource.getName(), htmlResource.getUrl());
        pdfViewerResource.setFileResource(pdfFileResource);
        pdfViewerResource.setViewerResource(htmlResource);
        return pdfViewerResource;
    }

    public static HtmlResource getOrCreateHtmlPdfResource(String resourceName, String hostAddr, byte[] pdf) throws IOException {
        HtmlResource res = HtmlBrowserTools.getHtmlPdfResource(resourceName, hostAddr);
        if (res == null) {
            res = HtmlBrowserTools.newHtmlPdfResource(resourceName, hostAddr, pdf);
        }
        return res;
    }

    public static HtmlResource getHtmlPdfResource(String resourceName, String hostAddr) {
        return HtmlBrowserTools.getHtmlResource(String.valueOf(HtmlBrowserTools.getHtmlPdfUrl()) + resourceName, hostAddr);
    }

    public static HtmlResource newHtmlPdfResource(String resourceName, String hostAddr, byte[] pdf) throws IOException {
        HtmlResource pdfFileResource = HtmlBrowserTools.newHtmlResource(String.valueOf(HtmlBrowserTools.getHtmlPdfUrl()) + resourceName, hostAddr, (Object)pdf);
        return pdfFileResource;
    }

    private static String getViewerHtml(boolean allowPrinting, boolean recentViewer) {
        String viewer = allowPrinting ? (recentViewer ? VIEWER2_HTML : VIEWER_HTML) : (recentViewer ? VIEWER2_HTML_NO_PRINT : VIEWER_HTML_NO_PRINT);
        String viewerHtml = HtmlBrowserTools.getHtmlTemplate(viewer, new String[0]);
        return viewerHtml;
    }

    public static HtmlImageViewerResource getOrCreateImageViewerResource(String resourceName, byte[] data) throws IOException {
        HtmlResource fileResource = HtmlBrowserTools.newHtmlResourceNoHost(resourceName, data);
        String viewerHtml = HtmlBrowserTools.getHtmlTemplate(VIEWER_IMAGE_HTML, new String[0]);
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"IMG_URL_TO_LOAD", (String)fileResource.getUrl());
        HtmlResource htmlResource = HtmlBrowserTools.getOrCreateHtmlResourceNoHost(String.valueOf(resourceName) + ".html", viewerHtml);
        HtmlImageViewerResource imageViewerResource = new HtmlImageViewerResource(inMemoryResourceHandler, htmlResource.getName(), htmlResource.getUrl());
        imageViewerResource.setFileResource(fileResource);
        imageViewerResource.setViewerResource(htmlResource);
        return imageViewerResource;
    }

    public static HtmlImageViewerResource getOrCreateImageViewerResource(String resourceName, String hostAddr, byte[] data) throws IOException {
        HtmlResource fileResource = HtmlBrowserTools.getOrCreateHtmlResource(resourceName, hostAddr, data);
        String viewerHtml = HtmlBrowserTools.getHtmlTemplate(VIEWER_IMAGE_HTML, new String[0]);
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"IMG_URL_TO_LOAD", (String)fileResource.getUrl());
        HtmlResource htmlResource = HtmlBrowserTools.getOrCreateHtmlResource(String.valueOf(resourceName) + ".html", hostAddr, viewerHtml);
        HtmlImageViewerResource imageViewerResource = new HtmlImageViewerResource(inMemoryResourceHandler, htmlResource.getName(), htmlResource.getUrl());
        imageViewerResource.setFileResource(fileResource);
        imageViewerResource.setViewerResource(htmlResource);
        return imageViewerResource;
    }

    public static HtmlImageViewerResource getImageViewerResourceNoHost(String resourceName) {
        HtmlResource htmlResource;
        String urlSuffix = HtmlBrowserTools.getUrlSuffix(resourceName);
        HtmlResource fileResource = new HtmlResource(inMemoryResourceHandler, resourceName, urlSuffix);
        if (!inMemoryResourceHandler.hasResource(urlSuffix)) {
            inMemoryResourceHandler.addResource(urlSuffix, fileResource, true);
        }
        if (fileResource != null && (htmlResource = HtmlBrowserTools.getHtmlResource(String.valueOf(resourceName) + ".html", null)) != null) {
            HtmlImageViewerResource imageViewerResource = new HtmlImageViewerResource(inMemoryResourceHandler, htmlResource.getName(), htmlResource.getUrl());
            imageViewerResource.setFileResource(fileResource);
            imageViewerResource.setViewerResource(htmlResource);
            return imageViewerResource;
        }
        return null;
    }

    public static HtmlImageViewerResource getImageViewerResource(String resourceName, String hostAddr) {
        HtmlResource htmlResource;
        HtmlResource fileResource = HtmlBrowserTools.getHtmlResource(resourceName, hostAddr);
        if (fileResource != null && (htmlResource = HtmlBrowserTools.getHtmlResource(String.valueOf(resourceName) + ".html", hostAddr)) != null) {
            HtmlImageViewerResource imageViewerResource = new HtmlImageViewerResource(inMemoryResourceHandler, htmlResource.getName(), htmlResource.getUrl());
            imageViewerResource.setFileResource(fileResource);
            imageViewerResource.setViewerResource(htmlResource);
            return imageViewerResource;
        }
        return null;
    }

    public static boolean hasHtmlImageViewerResource(String resourceName) {
        return HtmlBrowserTools.hasHtmlResource(resourceName) && HtmlBrowserTools.hasHtmlResource(String.valueOf(resourceName) + ".html");
    }

    public static HtmlImageViewerResource newHtmlImageViewerResourceNoHost(String resourceName, byte[] data) throws IOException {
        HtmlResource fileResource = HtmlBrowserTools.newHtmlResourceNoHost(resourceName, data);
        String viewerHtml = HtmlBrowserTools.getHtmlTemplate(VIEWER_IMAGE_HTML, new String[0]);
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"IMG_URL_TO_LOAD", (String)fileResource.getUrl());
        HtmlResource htmlResource = HtmlBrowserTools.newHtmlResourceNoHost(String.valueOf(resourceName) + ".html", viewerHtml);
        HtmlImageViewerResource imageViewerResource = new HtmlImageViewerResource(inMemoryResourceHandler, htmlResource.getName(), htmlResource.getUrl());
        imageViewerResource.setFileResource(fileResource);
        imageViewerResource.setViewerResource(htmlResource);
        return imageViewerResource;
    }

    public static HtmlImageViewerResource newHtmlImageViewerResource(String resourceName, String hostAddr, byte[] data) throws IOException {
        HtmlResource fileResource = HtmlBrowserTools.newHtmlResource(resourceName, hostAddr, (Object)data);
        String viewerHtml = HtmlBrowserTools.getHtmlTemplate(VIEWER_IMAGE_HTML, new String[0]);
        viewerHtml = StringUtils.replace((String)viewerHtml, (String)"IMG_URL_TO_LOAD", (String)fileResource.getUrl());
        HtmlResource htmlResource = HtmlBrowserTools.newHtmlResource(String.valueOf(resourceName) + ".html", hostAddr, (Object)viewerHtml);
        HtmlImageViewerResource imageViewerResource = new HtmlImageViewerResource(inMemoryResourceHandler, htmlResource.getName(), htmlResource.getUrl());
        imageViewerResource.setFileResource(fileResource);
        imageViewerResource.setViewerResource(htmlResource);
        return imageViewerResource;
    }

    public static String getHtmlTemplate(Bundle bundle, String filename, String ... addItemName) {
        String key = addItemName != null && addItemName.length > 0 ? String.valueOf(filename) + "&" + Arrays.toString(addItemName) : filename;
        try {
            byte[] data = Application.get().getResourceDelegate().get(key, () -> {
                String html = null;
                if (!Platform.inDebugMode()) {
                    html = originalHtmlTemplates.get(key);
                }
                if (html == null) {
                    StringWriter writer;
                    block10: {
                        writer = new StringWriter();
                        FileInputStream is = null;
                        try {
                            try {
                                URL url = bundle.getEntry(filename);
                                URL resolvedFileURL = FileLocator.toFileURL((URL)url);
                                URI resolvedURI = new URI(resolvedFileURL.getProtocol(), resolvedFileURL.getPath(), null);
                                File file = new File(resolvedURI);
                                is = new FileInputStream(file);
                                IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Error loading resource " + filename, e);
                                IOUtils.closeQuietly(is);
                                break block10;
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(is);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    html = writer.toString();
                    if (addItemName != null && addItemName.length > 0) {
                        String[] stringArray2 = addItemName;
                        int n = addItemName.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray2[n2];
                            String nameToAdd = " " + s;
                            html = StringUtils.replaceOnce((String)html, (String)"__AJOUTER__", (String)(String.valueOf(AJOUTER) + nameToAdd).trim());
                            ++n2;
                        }
                    }
                    html = StringUtils.replace((String)html, (String)"__AJOUTER__", (String)AJOUTER);
                    if (!Platform.inDebugMode()) {
                        originalHtmlTemplates.put(key, html);
                    }
                }
                return html.getBytes(StandardCharsets.UTF_8);
            });
            return new String(data, StandardCharsets.UTF_8);
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Failed to getHtmlTemplate " + key, e2);
            return null;
        }
    }

    public static String escapeSS(String base) {
        return HtmlBrowserTools.escapeSS(base, "\"");
    }

    public static String escapeSS(String base, String stringCollapse) {
        return base.replace("\\", "\\\\").replace(stringCollapse, "\\" + stringCollapse).replace("\r\n", "\\n").replace("\r", "\\n").replace("\n", "\\n");
    }

    public static String replaceString(String base, String pattern, String newString) {
        int index = base.indexOf(pattern);
        if (index != -1) {
            String s = base.substring(0, index);
            s = String.valueOf(s) + newString;
            s = String.valueOf(s) + base.substring(index + pattern.length());
            return s;
        }
        return base;
    }

    public static String formatHtmlString(String txt) {
        return txt.replace("\r\n", "<br/>").replace("\r", "<br/>").replace("\n", "<br/>").replace("  ", " &#160;");
    }

    private static boolean saveFilesToTools() {
        try {
            HtmlBrowserTools.deleteToolsFolders();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "failed to deploy or update tools folder", e);
            return false;
        }
    }

    private static void deleteToolsFolders() {
        try {
            File[] files;
            File rootFolder = new File(LibPlugin.OFYS_HOME);
            File[] fileArray = files = rootFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return dir.isDirectory() && (name.startsWith("tools_") || name.equals("tools"));
                }
            });
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    FileUtils.deleteDirectory((File)file);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to delete old tools folder " + file.getName(), e);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while clean old tools folders ", e);
        }
    }

    public static String[] divideStringAtFirstNewline(String s) {
        int i = s.indexOf("<br />");
        String[] ret = new String[2];
        if (i == -1) {
            ret[0] = new String(s);
            ret[1] = null;
        } else {
            ret[0] = s.substring(0, i);
            ret[1] = s.substring(i + 6);
        }
        return ret;
    }

    public static String getStringFromFile(String file, String url) {
        String s;
        block17: {
            s = file;
            InputStream is = null;
            try {
                try {
                    is = HtmlBrowserTools.class.getResourceAsStream(file);
                    s = IOUtils.toString((InputStream)is, (String)"UTF-8");
                }
                catch (IOException iOException) {
                    if (url != null) {
                        InputStream in = null;
                        try {
                            in = new URL(String.valueOf(url) + file).openStream();
                        }
                        catch (MalformedURLException e2) {
                            logger.log(Level.WARNING, "bad url exception loading file:" + file + ", url:" + url, e2);
                        }
                        catch (IOException e2) {
                            logger.log(Level.WARNING, "oi exception loading file:" + file + ", url:" + url, e2);
                        }
                        if (in != null) {
                            try {
                                try {
                                    s = IOUtils.toString((InputStream)in, (String)"UTF-8");
                                }
                                catch (IOException e) {
                                    logger.log(Level.WARNING, "oi exception loading file:" + file + ", url:" + url, e);
                                }
                            }
                            finally {
                                IOUtils.closeQuietly((InputStream)in);
                            }
                        }
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    break block17;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        return s;
    }

    public static byte[] addPrintedByToPdf(byte[] pdf, String printedBy) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            PdfReader reader = new PdfReader(pdf);
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)output);
            int p = 1;
            while (p <= reader.getNumberOfPages()) {
                PdfContentByte overContent = stamper.getOverContent(p);
                BaseFont font = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
                overContent.setFontAndSize(font, 10.0f);
                overContent.beginText();
                float x = overContent.getPdfDocument().getPageSize().getWidth() / 2.0f;
                float y = overContent.getPdfDocument().getPageSize().getBorderWidthBottom() + 5.0f;
                overContent.showTextAligned(1, printedBy, x, y, 0.0f);
                overContent.endText();
                overContent.stroke();
                ++p;
            }
            stamper.close();
        }
        catch (Exception exception) {
            return pdf;
        }
        return output.toByteArray();
    }

    public static JettyConnector getConnector0() {
        return connector0;
    }

    public static JettyConnector getConnectorApss() {
        return connectorApss;
    }

    public static List<IJettyListener> getJettylisteners() {
        return jettyListeners;
    }

    public static interface IJettyListener {
        public void jettyStarted();

        public void jettyStopped();
    }
}

