/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser;

import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.proxy.ProxyServlet;

public class CleanHeaderProxyServlet
extends ProxyServlet {
    private static final Logger logger = Logger.getLogger(CleanHeaderProxyServlet.class.getName());
    private final HttpClient httpClient;
    private static int requestCounter = 0;

    public CleanHeaderProxyServlet(HttpClient httpClient) {
        this.httpClient = httpClient;
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "========== CleanHeaderProxyServlet INITIALIZED ==========");
        }
    }

    protected HttpClient createHttpClient() {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "createHttpClient() called - returning custom HttpClient");
        }
        return this.httpClient;
    }

    protected URI rewriteURI(HttpServletRequest request) {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "\n=== rewriteURI START ===");
            logger.log(Level.INFO, "Original Request URI: " + request.getRequestURI());
            logger.log(Level.INFO, "Original Query String: " + request.getQueryString());
        }
        String targetUrl = this.getInitParameter("proxyTo");
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Target URL from proxyTo: " + targetUrl);
        }
        if (targetUrl == null) {
            logger.log(Level.SEVERE, "ERROR: proxyTo parameter is NULL!");
            return null;
        }
        try {
            if (targetUrl.endsWith("/")) {
                targetUrl = targetUrl.substring(0, targetUrl.length() - 1);
            }
            String path = request.getRequestURI();
            if (targetUrl.contains("/sofiapay") && path.startsWith("/sofiapay") && !(path = path.substring("/sofiapay".length())).isEmpty() && !path.startsWith("/")) {
                path = "/" + path;
            }
            String query = request.getQueryString();
            String fullUrl = String.valueOf(targetUrl) + path;
            if (query != null && !query.isEmpty()) {
                fullUrl = String.valueOf(fullUrl) + "?" + query;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Manually constructed URL: " + fullUrl);
            }
            URI rewrittenURI = new URI(fullUrl);
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "=== REWRITTEN URI ===");
                logger.log(Level.INFO, "Rewritten Full URI: " + rewrittenURI.toString());
                logger.log(Level.INFO, "Rewritten Scheme: " + rewrittenURI.getScheme());
                logger.log(Level.INFO, "Rewritten Host: " + rewrittenURI.getHost());
                logger.log(Level.INFO, "Rewritten Port: " + rewrittenURI.getPort());
                logger.log(Level.INFO, "Rewritten Path: " + rewrittenURI.getPath());
                logger.log(Level.INFO, "Rewritten Query: " + rewrittenURI.getQuery());
            }
            return rewrittenURI;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "ERROR creating URI: ", e);
            return null;
        }
    }

    protected void customizeProxyRequest(Request proxyRequest, HttpServletRequest request) {
        String[] headersToRemove;
        HttpFields headers;
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "=== customizeProxyRequest START ===");
            logger.log(Level.INFO, "PROXY REQUEST URI: " + proxyRequest.getURI());
            logger.log(Level.INFO, "PROXY REQUEST Scheme: " + proxyRequest.getScheme());
            logger.log(Level.INFO, "PROXY REQUEST Host: " + proxyRequest.getHost());
            logger.log(Level.INFO, "PROXY REQUEST Port: " + proxyRequest.getPort());
            logger.log(Level.INFO, "PROXY REQUEST Path: " + proxyRequest.getPath());
        }
        if ((headers = proxyRequest.getHeaders()) != null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "=== HEADERS BEFORE CLEANING ===");
            }
            for (HttpField field : headers) {
                if (field == null || !logger.isLoggable(Level.INFO)) continue;
                logger.log(Level.INFO, "BEFORE: " + field.getName() + " = " + field.getValue());
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "=== REMOVING DUPLICATE HEADERS ===");
        }
        String[] stringArray = headersToRemove = new String[]{"X-Forwarded-Proto", "X-Forwarded-Host", "X-Forwarded-Server", "X-Forwarded-For", "Via"};
        int n = headersToRemove.length;
        int n2 = 0;
        while (n2 < n) {
            String headerName = stringArray[n2];
            HttpField existing = headers.getField(headerName);
            if (existing != null) {
                logger.log(Level.WARNING, "REMOVING header: " + headerName + " (was: " + existing.getValue() + ")");
                proxyRequest.header(headerName, null);
            }
            ++n2;
        }
        String targetHost = proxyRequest.getHost();
        int targetPort = proxyRequest.getPort();
        String hostHeaderValue = proxyRequest.getScheme().equals("https") && targetPort != 443 || proxyRequest.getScheme().equals("http") && targetPort != 80 ? String.valueOf(targetHost) + ":" + targetPort : targetHost;
        proxyRequest.header("Host", hostHeaderValue);
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Setting Host header to: " + hostHeaderValue);
        }
        super.customizeProxyRequest(proxyRequest, request);
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "=== HEADERS AFTER CUSTOMIZATION ===");
        }
        if (headers != null) {
            for (HttpField field : headers) {
                if (field == null || !logger.isLoggable(Level.INFO)) continue;
                logger.log(Level.INFO, "AFTER: " + field.getName() + " = " + field.getValue());
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "=== customizeProxyRequest END ===");
        }
    }

    protected void onRewriteFailed(HttpServletRequest request, HttpServletResponse response) {
        logger.log(Level.SEVERE, "\n=== onRewriteFailed CALLED ===");
        logger.log(Level.SEVERE, "FAILED to rewrite URI for request: " + request.getRequestURI());
        logger.log(Level.SEVERE, "Request Method: " + request.getMethod());
        logger.log(Level.SEVERE, "Request Query: " + request.getQueryString());
        logger.log(Level.SEVERE, "Request Full URL: " + request.getRequestURL().toString());
        logger.log(Level.SEVERE, "=== REQUEST HEADERS (on failure) ===");
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            logger.log(Level.SEVERE, "HEADER: " + headerName + " = " + request.getHeader(headerName));
        }
        logger.log(Level.SEVERE, "=== SERVLET INIT PARAMS ===");
        logger.log(Level.SEVERE, "proxyTo: " + this.getInitParameter("proxyTo"));
        logger.log(Level.SEVERE, "prefix: " + this.getInitParameter("prefix"));
        logger.log(Level.SEVERE, "viaHost: " + this.getInitParameter("viaHost"));
        try {
            super.onRewriteFailed(request, response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.log(Level.SEVERE, "=== onRewriteFailed END ===\n");
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int reqId = ++requestCounter;
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "\n========== PROXY REQUEST #" + reqId + " START ==========");
            logger.log(Level.INFO, "[REQ #" + reqId + "] Method: " + request.getMethod());
            logger.log(Level.INFO, "[REQ #" + reqId + "] URI: " + request.getRequestURI());
            logger.log(Level.INFO, "[REQ #" + reqId + "] Query: " + request.getQueryString());
            logger.log(Level.INFO, "[REQ #" + reqId + "] Remote Address: " + request.getRemoteAddr());
            logger.log(Level.INFO, "[REQ #" + reqId + "] === INCOMING HEADERS ===");
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.log(Level.INFO, "[REQ #" + reqId + "] IN: " + headerName + " = " + (String)headerValues.nextElement());
            }
        }
        try {
            try {
                super.service(request, response);
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "[REQ #" + reqId + "] Service completed");
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "[REQ #" + reqId + "] ERROR in service(): ", e);
                throw new IOException(e);
            }
        }
        finally {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "========== PROXY REQUEST #" + reqId + " END ==========\n");
            }
        }
    }

    protected void onResponseSuccess(HttpServletRequest request, HttpServletResponse response, Response proxyResponse) {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "=== onResponseSuccess ===");
            logger.log(Level.INFO, "Response Status: " + proxyResponse.getStatus());
            logger.log(Level.INFO, "Response Reason: " + proxyResponse.getReason());
        }
        super.onResponseSuccess(request, response, proxyResponse);
    }

    protected void onResponseFailure(HttpServletRequest request, HttpServletResponse response, Response proxyResponse, Throwable failure) {
        logger.log(Level.SEVERE, "=== onResponseFailure ===");
        logger.log(Level.SEVERE, "Response FAILED for URI: " + request.getRequestURI());
        logger.log(Level.SEVERE, "Failure: ", failure);
        super.onResponseFailure(request, response, proxyResponse, failure);
    }
}

