/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.b2b.simple;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.patient.XConsentement;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XFormatDate;
import ca.infodata.ofys.mb.listener.object.IObjectListener;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.ui.b2b.simple.PatientB2BControl;
import ca.infodata.ofys.ui.b2b.simple.PatientB2bDialogController;
import ca.infodata.ofys.ui.controls.FontAwareShell;
import ca.infodata.ofys.ui.controls.IProgressMonitorWithLog;
import ca.infodata.ofys.ui.controls.IRunnableWithProgressWithLog;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialog;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialogWithLog;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.date.IPartialDate;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class PatientB2bDialog {
    private static final Logger logger = Logger.getLogger(PatientB2bDialog.class.getName());
    private static final String INFORMATIONS_EN_DATE_DU = Messages.getString((String)"B2B.DIALOG.INFORMATIONS_EN_DATE_DU", (String[])new String[0]);
    private static final String INSCRIPTION_RAMQ = Messages.getString((String)"B2B.DIALOG.INSCRIPTION_RAMQ", (String[])new String[0]);
    private static final String SAUVEGARDE_EN_COURS = Messages.getString((String)"B2B.DIALOG.SAUVEGARDE_EN_COURS", (String[])new String[0]);
    private static final String QUESTION = Messages.getString((String)"QUESTION", (String[])new String[0]);
    private static final String ETES_VOUS_CERTAINS_VOULOIR_ANNULER_LES_MODIFICAITONS = Messages.getString((String)"ETES_VOUS_CERTAINS_VOULOIR_ANNULER_LES_MODIFICAITONS", (String[])new String[0]);
    private static final String TRANSMISSION_A_LA_RAMQ_EN_COURS = Messages.getString((String)"B2B.DIALOG.TRANSMISSION_A_LA_RAMQ_EN_COURS", (String[])new String[0]);
    private static final String JE_MODIFIE = Messages.getString((String)"B2B.DIALOG.JE_MODIFIE", (String[])new String[0]);
    private static final String TRANSMETTRE_A_LA_RAMQ = Messages.getString((String)"B2B.DIALOG.TRANSMETTRE_A_LA_RAMQ", (String[])new String[0]);
    private static final String SAUVEGARDER = Messages.getString((String)"B2B.DIALOG.SAUVEGARDER", (String[])new String[0]);
    private static final String ANNULER = Messages.getString((String)"ANNULER", (String[])new String[0]);
    private static final String FERMER = Messages.getString((String)"FERMER", (String[])new String[0]);
    private Shell dialog;
    private FormToolkit toolkit;
    private PatientB2bDialogController controller;
    private IObjectListener<PatientB2bDialogController> listener;
    private MyButton btnSend;
    private MyButton btnCancel;
    private MyButton chkModifyOnly;
    private Label separator;
    private ScrolledForm form;
    private PatientB2BControl patientB2BControl;

    public static boolean hasRightToSee(XPatient patient) {
        boolean showPatient = true;
        boolean showPatientOther = true;
        boolean showToAll = true;
        XConsentement consent = null;
        Integer idUser = Application.get().getGlobalInstances().getSession().getUser().getId();
        XPatient xsp = patient;
        if (!xsp.getConsentement().isEmpty()) {
            showToAll = false;
            for (XConsentement consentement : xsp.getConsentement()) {
                if (!consentement.getIdUserAnchor().equals(idUser)) continue;
                consent = consentement;
                break;
            }
        }
        boolean checkDroit = false;
        if (!showToAll && consent != null) {
            checkDroit = true;
        }
        showPatient = showToAll || checkDroit && consent.hasRightPatient();
        boolean bl = showPatientOther = showToAll || checkDroit && consent.hasRightPatientOther();
        return showPatient && showPatientOther;
    }

    public PatientB2bDialog(Shell parent, XPatient patient) {
        this.controller = new PatientB2bDialogController(patient);
        this.createDialog(parent);
        this.listener = new IObjectListener<PatientB2bDialogController>(){

            public void objectModified(PatientB2bDialogController object) {
                try {
                    UI.runInSwtThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PatientB2bDialog.this.refresh();
                        }
                    });
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error doing refresh", e);
                }
            }
        };
        ObjectListenerManager.addListener((Object)this.controller, this.listener);
        this.refresh();
    }

    private void createDialog(Shell parent) {
        this.dialog = new FontAwareShell(parent, 67696);
        this.setDialogText();
        this.dialog.setImage(ResourceGetter.getImage((String)"images/ramq32.jpg"));
        Color white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        ResourceGetter.linkResourceWithWidgetLife((Object)white, (Widget)this.dialog);
        this.dialog.setBackground(white);
        this.toolkit = UI.createToolKit((Widget)this.dialog);
        this.createBody((Composite)this.dialog);
        this.dialog.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = PatientB2bDialog.this.canClose();
            }
        });
    }

    private void setDialogText() {
        String s = INSCRIPTION_RAMQ;
        if (this.controller.getVerificationDate() != null) {
            s = String.valueOf(s) + " (" + INFORMATIONS_EN_DATE_DU + " " + XFormatDate.formatPartialDate((IPartialDate)this.controller.getVerificationDate()) + ")";
        }
        this.dialog.setText(s);
    }

    public boolean canClose() {
        if (this.controller.isDirty()) {
            return MessageUtil.askQuestion((Shell)this.dialog, (String)QUESTION, (String)ETES_VOUS_CERTAINS_VOULOIR_ANNULER_LES_MODIFICAITONS, (boolean)false);
        }
        return true;
    }

    public void close() {
        this.dialog.close();
    }

    private void createBody(Composite parent) {
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.getBody().setLayout((Layout)new FormLayout());
        this.form.setAlwaysShowScrollBars(false);
        this.patientB2BControl = new PatientB2BControl(this.form.getBody(), this.toolkit);
        this.patientB2BControl.setModel(this.controller.getPatient(), this.controller, this.controller);
        this.chkModifyOnly = new MyButton(parent, JE_MODIFIE, 32, this.toolkit);
        this.chkModifyOnly.setFont(1, 0);
        this.chkModifyOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientB2bDialog.this.controller.setDontSendToRamq(PatientB2bDialog.this.chkModifyOnly.getSelection());
            }
        });
        this.btnCancel = new MyButton(parent, ANNULER, 0, this.toolkit);
        this.btnCancel.setFont(2, 0);
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PatientB2bDialog.this.close();
            }
        });
        this.btnSend = new MyButton(parent, this.controller.isDontSendToRamq() ? SAUVEGARDER : TRANSMETTRE_A_LA_RAMQ, 0, this.toolkit);
        this.btnSend.setFont(2, 1);
        this.btnSend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (PatientB2bDialog.this.controller.isDontSendToRamq()) {
                    PatientB2bDialog.this.save();
                } else {
                    PatientB2bDialog.this.send();
                }
            }
        });
        this.separator = this.toolkit.createSeparator(parent, 256);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 8;
        layout.marginTop = 8;
        layout.marginLeft = 8;
        layout.marginRight = 8;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        this.refreshLayout();
    }

    protected void send() {
        MyProgressMonitorDialogWithLog dialog = new MyProgressMonitorDialogWithLog(this.dialog);
        try {
            dialog.runWithLog(true, false, new IRunnableWithProgressWithLog(){

                public void run(IProgressMonitorWithLog monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(TRANSMISSION_A_LA_RAMQ_EN_COURS, -1);
                    try {
                        PatientB2bDialog.this.controller.send(monitor);
                    }
                    catch (Exception e) {
                        monitor.log(Level.SEVERE, "Erreur", (Throwable)e);
                    }
                    monitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "Error with trying to send b2bModif to server", e);
            MessageUtil.unexpectedExceptionMsg((Shell)this.dialog, (Exception)e);
        }
    }

    protected void save() {
        final MyProgressMonitorDialog dialog = new MyProgressMonitorDialog(this.dialog);
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(SAUVEGARDE_EN_COURS, -1);
                    try {
                        PatientB2bDialog.this.controller.save(monitor);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error", e);
                        MessageUtil.show((Shell)dialog.getShell(), (Exception)e);
                    }
                    monitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "Error with trying to send b2bModif to server", e);
            MessageUtil.unexpectedExceptionMsg((Shell)this.dialog, (Exception)e);
        }
    }

    private void refreshLayout() {
        FormData data;
        if (this.btnSend.getVisible()) {
            data = new FormData();
            data.right = new FormAttachment(100);
            data.bottom = new FormAttachment(100);
            this.btnSend.setLayoutData((Object)data);
            data = new FormData();
            data.right = new FormAttachment((Control)this.btnSend);
            data.bottom = new FormAttachment(100);
            this.btnCancel.setLayoutData((Object)data);
        } else {
            data = new FormData();
            data.right = new FormAttachment(100);
            data.bottom = new FormAttachment(100);
            this.btnCancel.setLayoutData((Object)data);
        }
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment((Control)this.btnCancel);
        this.separator.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment((Control)this.separator);
        this.chkModifyOnly.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment((Control)this.chkModifyOnly);
        this.form.setLayoutData((Object)data);
        this.dialog.layout(true);
    }

    protected void refresh() {
        this.setDialogText();
        this.chkModifyOnly.setSelection(this.controller.isDontSendToRamq());
        boolean changed = false;
        if (!this.controller.isDirty()) {
            changed = this.chkModifyOnly.getVisible() || this.btnSend.getVisible() || !this.btnCancel.getText().equals(FERMER);
            this.btnCancel.setText(FERMER);
            this.chkModifyOnly.setVisible(false);
            this.btnSend.setVisible(false);
        } else {
            changed = !this.btnCancel.getText().equals(ANNULER) || !this.btnSend.getVisible() || !this.chkModifyOnly.getVisible();
            changed = changed || this.controller.isDontSendToRamq() && !SAUVEGARDER.equals(this.btnSend.getText());
            changed = changed || !this.controller.isDontSendToRamq() && !TRANSMETTRE_A_LA_RAMQ.equals(this.btnSend.getText());
            this.btnCancel.setText(ANNULER);
            this.btnSend.setText(this.controller.isDontSendToRamq() ? SAUVEGARDER : TRANSMETTRE_A_LA_RAMQ);
            this.btnSend.setVisible(true);
            this.chkModifyOnly.setVisible(true);
        }
        this.patientB2BControl.refresh();
        if (changed) {
            this.refreshLayout();
        }
    }

    public void open() {
        this.dialog.pack();
        UI.centerComposite((Composite)this.dialog, (Composite)this.dialog.getParent());
        Rectangle bounds = this.dialog.getMonitor().getClientArea();
        Point size = this.dialog.getSize();
        Point location = this.dialog.getLocation();
        if (size.x > bounds.width) {
            size.x = bounds.width;
            location.x = 0;
        }
        if (size.y > bounds.height) {
            size.y = bounds.height;
            location.y = 0;
        }
        this.dialog.setSize(size);
        this.dialog.setLocation(location);
        this.dialog.open();
    }
}

