/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.menu;

import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentControllerAdapter;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentMainController;
import java.util.ArrayList;
import java.util.List;

public class AppointmentElementController {
    public static final int PROPERTY_APPOINTMENT_CHANGED = 1;
    private AppointmentMainController controller;
    private AppointmentControllerAdapterExtension controllerListener;
    private IAppointment appointment;

    public AppointmentElementController(AppointmentMainController controller, IAppointment appointment) {
        this.appointment = appointment;
        this.controller = controller;
        this.controllerListener = new AppointmentControllerAdapterExtension();
        this.controller.addListener(this.controllerListener);
    }

    public synchronized IAppointment getReadOnlyAppointment() {
        return this.appointment;
    }

    public synchronized List<? extends IPatient> getReadOnlyPatients() {
        return this.appointment.getPatients();
    }

    public synchronized List<IPatient> getClonePatients() {
        ArrayList<IPatient> list = new ArrayList<IPatient>();
        for (IPatient patient : this.appointment.getPatients()) {
            list.add(patient.clone());
        }
        return list;
    }

    public synchronized void setPatientArrived() {
        this.controller.setPatientStatus(this.appointment, XPatientStatus.ARRIVED);
    }

    public synchronized void setPatientSeen() {
        this.controller.setPatientStatus(this.appointment, XPatientStatus.SEEN);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.appointment == null ? 0 : this.appointment.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppointmentElementController other = (AppointmentElementController)obj;
        return !(this.appointment == null ? other.appointment != null : !this.appointment.equals(other.appointment));
    }

    private final class AppointmentControllerAdapterExtension
    extends AppointmentControllerAdapter {
        private AppointmentControllerAdapterExtension() {
        }

        @Override
        public void objectModified(Object object) {
            if (object != null) {
                if (object == AppointmentElementController.this.appointment) {
                    PropertyListenerManager.firePropertyChanged((Object)AppointmentElementController.this, (int)1);
                }
                if (AppointmentElementController.this.getReadOnlyPatients().contains(object)) {
                    PropertyListenerManager.firePropertyChanged((Object)AppointmentElementController.this, (int)1);
                }
            }
        }

        @Override
        public void appointmentChanged(IAppointment o2) {
            if (this.isEquals(AppointmentElementController.this.appointment, o2)) {
                AppointmentElementController.this.appointment = o2;
                PropertyListenerManager.firePropertyChanged((Object)AppointmentElementController.this, (int)1);
            }
        }

        @Override
        public void currentAppointmentChanged(IAppointment o2) {
            if (this.isEquals(AppointmentElementController.this.appointment, o2)) {
                AppointmentElementController.this.appointment = o2;
                PropertyListenerManager.firePropertyChanged((Object)AppointmentElementController.this, (int)1);
            }
        }

        public boolean isEquals(IAppointment o1, IAppointment o2) {
            if (o1 == null && o2 == null) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return o1.equals(o2) || o1.equalsByTag((IMinimalEditableDataObject)o2);
        }
    }
}

