/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.multiprof;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IVisualAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XBaseAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.control.AppointmentDatePrintDialog;
import ca.infodata.ofys.ui.appointment.editor.AppointmentSelection;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentControllerAdapter;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentMainController;
import ca.infodata.ofys.ui.appointment.editor.multiprof.AppointmentDateControl2;
import ca.infodata.ofys.ui.appointment.editor.multiprof.AppointmentMultiProfPreferencesDialog;
import ca.infodata.ofys.ui.appointment.editor.multiprof.AppointmentVisualStructureScaleManagerMultiProf;
import ca.infodata.ofys.ui.appointment.editor.multiprof.AppointmentVisualStructureTimeManagerMultiProf;
import ca.infodata.ofys.ui.appointment.editor.multiprof.MultiProfInput;
import ca.infodata.ofys.ui.appointment.editor.multiprof.ProfControl;
import ca.infodata.ofys.ui.appointment.editor.multiprof.TimeControl;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.FontAwareHyperlink;
import ca.infodata.ofys.ui.controls.IPrintable;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.popup.CheckListPopupFeature;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteCombo;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.util1.IPair;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mb.listeners.GenListenerManager;

public class AppointmentMultiProfEditor
extends EditorPart
implements ISelectionProvider,
IPatientRelated,
IPrintable,
IRefreshFont {
    private static final String PREFERENCES = Messages.getString((String)"PREFERENCES", (String[])new String[0]);
    private static final String PROFESSIONNELS_AVEC_HORAIRE = Messages.getString((String)"AppointmentMultiProfEditor.PROFESSIONNELS_AVEC_HORAIRE", (String[])new String[0]);
    private static final String PROFESSIONNELS_AVEC_HORAIRE_TOOLTIP = Messages.getString((String)"AppointmentMultiProfEditor.PROFESSIONNELS_AVEC_HORAIRE_TOOLTIP", (String[])new String[0]);
    private static final String PROFESSIONNELS = Messages.getString((String)"AppointmentMultiProfEditor.PROFESSIONNELS", (String[])new String[0]);
    private static final Logger logger = Logger.getLogger(AppointmentMultiProfEditor.class.getName());
    public static final String KEYBINDING_CONTEXT_ID = "ca.infodata.ofys.ui.appointment.AppointmentMultiProfEditor.keybinding.context";
    private GenListenerManager<ISelectionChangedListener> managers = new GenListenerManager(ISelectionChangedListener.class);
    private boolean initializing;
    private FormToolkit toolkit;
    private FontAwareComposite toolbarComp;
    private FontAwareComposite centerComp;
    private MyButton btnPreferences;
    private MyButton btnProfessionnals;
    private MyButton btnProfessionnalsWithSchedule;
    private FontAwareHyperlink lblDate;
    private TimeControl timeControl;
    private Map<XBaseProfessionnal, ProfControl> profControls;
    private Map<XBaseProfessionnal, AppointmentControllerAdapter> controllerListeners;
    private AppointmentVisualStructureScaleManagerMultiProf scaleManager = new AppointmentVisualStructureScaleManagerMultiProf();
    private AppointmentVisualStructureTimeManagerMultiProf timeManager = new AppointmentVisualStructureTimeManagerMultiProf();
    private boolean ignore;

    public AppointmentMultiProfEditor() {
        this.profControls = new LinkedHashMap<XBaseProfessionnal, ProfControl>();
        this.controllerListeners = new LinkedHashMap<XBaseProfessionnal, AppointmentControllerAdapter>();
    }

    public void createPartControl(Composite parent) {
        this.toolkit = UI.createToolKit((Widget)parent);
        this.toolkit.adapt(parent);
        this.toolbarComp = new FontAwareComposite(parent, 0);
        this.toolkit.adapt((Composite)this.toolbarComp);
        Label toolbarSeparator = this.toolkit.createSeparator(parent, 256);
        this.centerComp = new FontAwareComposite(parent, 0);
        this.toolkit.adapt((Composite)this.centerComp);
        this.timeControl = new TimeControl(parent, 0, this.toolkit, this.scaleManager, this.timeManager){

            @Override
            protected void zoomOverride(int count) {
                AppointmentMultiProfEditor.this.zoom(count);
            }
        };
        this.addScrollBarSynchronizer((Control)this.timeControl, this.timeControl.getDateControl().getScroll());
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.toolbarComp.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.toolbarComp);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        toolbarSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.toolbarComp);
        data.left = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        this.timeControl.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.toolbarComp);
        data.left = new FormAttachment((Control)this.timeControl);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.centerComp.setLayoutData((Object)data);
        this.btnProfessionnals = new MyButton((Composite)this.toolbarComp, PROFESSIONNELS, 8, this.toolkit);
        final List workSites = SitePlugin.getDefault().getWorkSites();
        CheckListPopupFeature<IPair<XBaseProfessionnal, XSite>> feature = new CheckListPopupFeature<IPair<XBaseProfessionnal, XSite>>(this.btnProfessionnals.getControl()){
            private MyButton btnActiver;

            protected Shell createPopupControlOverride(Shell parent) {
                Shell shell = super.createPopupControlOverride(parent);
                this.setPopupSizeY(350);
                this.btnActiver = new MyButton((Composite)shell, 8);
                this.btnActiver.setText(Messages.getString((String)"ACTIVATE", (String[])new String[0]));
                FormData data = new FormData();
                data.left = new FormAttachment(0);
                data.right = new FormAttachment(100);
                data.bottom = new FormAttachment(100);
                this.btnActiver.setLayoutData((Object)data);
                data = new FormData();
                data.top = new FormAttachment(0);
                data.left = new FormAttachment(0);
                data.right = new FormAttachment(100);
                data.bottom = new FormAttachment(this.btnActiver.getControl(), 0, 128);
                this.getList().setLayoutData((Object)data);
                this.btnActiver.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.hidePopupWindow();
                        AppointmentMultiProfEditor.this.disposeAllProfControls();
                        List<XBaseProfessionnal> profs = AppointmentMultiProfEditor.this.getInput().getProfessionnals();
                        for (XBaseProfessionnal prof : profs) {
                            AppointmentMultiProfEditor.this.newProfControl(prof);
                        }
                    }
                });
                return shell;
            }

            protected String getTextForItem(IPair<XBaseProfessionnal, XSite> e) {
                if (workSites.size() > 1) {
                    String text = e.getSecond() == null ? ((XBaseProfessionnal)e.getFirst()).getName() : String.valueOf(((XSite)e.getSecond()).getNameCommon()) + " - " + ((XBaseProfessionnal)e.getFirst()).getName();
                    return text;
                }
                String text = ((XBaseProfessionnal)e.getFirst()).getName();
                return text;
            }

            protected List<IPair<XBaseProfessionnal, XSite>> getItems() {
                List items = ProfessionalBySiteCombo.toProfessionnalBySiteList(AppointmentPlugin.getDefault().getProfessionnals());
                if (workSites.size() > 1) {
                    ProfessionalBySiteCombo.sortBySiteAndProf((List)items);
                } else {
                    ProfessionalBySiteCombo.sortByProf((List)items);
                }
                return items;
            }

            protected boolean getChecked(IPair<XBaseProfessionnal, XSite> e) {
                return AppointmentMultiProfEditor.this.getInput().hasProf((XBaseProfessionnal)e.getFirst());
            }

            public void checked(IPair<XBaseProfessionnal, XSite> e, boolean checked) {
                if (checked) {
                    AppointmentMultiProfEditor.this.getInput().addProf((XBaseProfessionnal)e.getFirst());
                } else {
                    AppointmentMultiProfEditor.this.getInput().removeProf((XBaseProfessionnal)e.getFirst());
                }
            }
        };
        this.btnProfessionnals.addSelectionListener((SelectionListener)new SelectionAdapter((CheckListPopupFeature)feature){
            private final /* synthetic */ CheckListPopupFeature val$feature;
            {
                this.val$feature = checkListPopupFeature;
            }

            public void widgetSelected(SelectionEvent e) {
                this.val$feature.openPopupWindow();
            }
        });
        this.btnProfessionnalsWithSchedule = new MyButton((Composite)this.toolbarComp, PROFESSIONNELS_AVEC_HORAIRE, 8, this.toolkit);
        this.btnProfessionnalsWithSchedule.setToolTipText(PROFESSIONNELS_AVEC_HORAIRE_TOOLTIP);
        this.btnProfessionnalsWithSchedule.addSelectionListener((SelectionListener)new SelectionAdapter((CheckListPopupFeature)feature){
            private final /* synthetic */ CheckListPopupFeature val$feature;
            {
                this.val$feature = checkListPopupFeature;
            }

            public void widgetSelected(SelectionEvent e) {
                XSite site = SitePlugin.getDefault().getContextSite();
                final Integer contextSiteId = site != null ? site.getId() : null;
                JobCallback callback = null;
                try {
                    try {
                        callback = new JobCallback(Messages.getString((String)"CHARGEMENT", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                            public void responseReceived(final ReturnObject response) {
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        List lst = (List)response.getObj();
                                        List<XBaseProfessionnal> lstAllProfs = AppointmentPlugin.getDefault().getProfessionnals();
                                        List items = ProfessionalBySiteCombo.toProfessionnalBySiteList(lstAllProfs);
                                        ProfessionalBySiteCombo.sort((List)items);
                                        for (IPair xx : items) {
                                            if (contextSiteId == null) continue;
                                            if (xx.getSecond() != null && contextSiteId.equals(((XSite)xx.getSecond()).getId())) {
                                                if (lst.contains(((XBaseProfessionnal)xx.getFirst()).getId())) {
                                                    val$feature.checked((Object)xx, true);
                                                    continue;
                                                }
                                                val$feature.checked((Object)xx, false);
                                                continue;
                                            }
                                            val$feature.checked((Object)xx, false);
                                        }
                                        AppointmentMultiProfEditor.this.btnProfessionnals.notifyListeners(13, new Event());
                                    }
                                });
                            }
                        };
                        AppointmentAccessorClient.getInstance().getProfessionalsWithSchedule(((Object)((Object)this)).hashCode(), Application.get().getGlobalInstances().getSession(), AppointmentMultiProfEditor.this.getDate(), (ICallback)callback);
                    }
                    catch (Exception e1) {
                        logger.log(Level.SEVERE, "Erreur", e1);
                        if (callback != null) {
                            callback.kill();
                        }
                    }
                }
                finally {
                    if (callback != null) {
                        callback.kill();
                    }
                }
            }
        });
        this.btnPreferences = new MyButton((Composite)this.toolbarComp, null, 8, this.toolkit);
        this.btnPreferences.setImage(ResourceGetter.getScaledImageFixed((Image)ResourceGetter.getImage((String)"images/Heart-icon16.png"), (float)14.0f, (float)14.0f));
        this.btnPreferences.setToolTipText(PREFERENCES);
        this.btnPreferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new AppointmentMultiProfPreferencesDialog(AppointmentMultiProfEditor.this.getSite().getShell());
            }
        });
        this.lblDate = new FontAwareHyperlink((Composite)this.toolbarComp, "", 0x1000000, this.toolkit);
        this.lblDate.setFont(2, 1);
        this.lblDate.setUnderlined(false);
        this.lblDate.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    UI.genericExecuteCommand((AbstractUIPlugin)AppointmentPlugin.getDefault(), (String)"ca.infodata.ofys.ui.appointment.multiprof.gotodate");
                }
                catch (Exception exception) {}
            }
        });
        String help = "Voici les commandes clavier pour changer rapidement la date en cours. \n\n\n Ctrl + \u2190    Hier\n\n Ctrl + \u2192    Demain\n\n Ctrl + \u2191    Semaine pass\u00e9e\n\n Ctrl + \u2193    Semaine prochaine\n\n Ctrl + T      Ouvre un dialogue pour saisir une date texte";
        ControlDecorator.decorateWithHelp((Control)this.lblDate, (Runnable)ControlDecorator.newInfoMessageRunnable((Control)this.lblDate, (String)help), (int)3, (int)0x1004000);
        layout = new FormLayout();
        layout.spacing = 10;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        this.toolbarComp.setLayout((Layout)layout);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.btnProfessionnalsWithSchedule.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.btnProfessionnalsWithSchedule.getControl(), 5);
        this.btnProfessionnals.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnProfessionnals.getControl(), 0, 0x1000000);
        data.right = new FormAttachment((Control)this.btnPreferences, -20);
        data.width = 350;
        this.lblDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.btnPreferences.setLayoutData((Object)data);
        this.centerComp.setLayout((Layout)new FillLayout(256));
        this.refresh();
        this.initializing = false;
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        ResourceGetter.addListener((IRefreshFont)this);
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(KEYBINDING_CONTEXT_ID);
    }

    protected void zoom(int count) {
        this.timeControl.zoom(count);
        for (ProfControl profControl : this.profControls.values()) {
            profControl.zoom(count);
        }
    }

    public void refresh() {
        this.lblDate.setText(LocalDateFormat.format((LocalDate)this.getInput().getDate(), (String)"EEEE d MMMM yyyy"));
        this.disposeAllProfControls();
        for (XBaseProfessionnal prof : this.getInput().getProfessionnals()) {
            this.newProfControl(prof);
        }
    }

    public LocalDate getDate() {
        return this.getInput().getDate();
    }

    public void setDate(LocalDate date) {
        this.getInput().setDate(date);
        for (ProfControl control : this.profControls.values()) {
            control.setDate(date);
        }
        this.timeControl.setDate(date);
        this.lblDate.setText(LocalDateFormat.format((LocalDate)this.getInput().getDate(), (String)"EEEE d MMMM yyyy"));
        this.timeManager.clearCache();
        this.scaleManager.clearCache();
        this.scaleManager.resetAllVs();
    }

    private void newProfControl(XBaseProfessionnal prof) {
        final ProfControl profControl = new ProfControl((Composite)this.centerComp, 0, this.toolkit, this.getInput().getDate(), prof, this.scaleManager, this.timeManager){

            @Override
            protected void zoomOverride(int count) {
                AppointmentMultiProfEditor.this.zoom(count);
            }
        };
        this.profControls.put(prof, profControl);
        this.centerComp.layout();
        AppointmentControllerAdapter currentAppointmentListener = new AppointmentControllerAdapter(){

            @Override
            public void currentAppointmentChanged(IAppointment appt) {
                if (AppointmentMultiProfEditor.this.ignore) {
                    return;
                }
                AppointmentMultiProfEditor.this.ignore = true;
                for (ProfControl profControl2 : AppointmentMultiProfEditor.this.profControls.values()) {
                    if (profControl2 == profControl) continue;
                    profControl2.getController().setCurrentAppointment(null);
                    profControl2.getDateControl().getVisualStructure().setSelection((IVisualAppointment)null);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((ISelectionChangedListener)AppointmentMultiProfEditor.this.managers.getProxy()).selectionChanged(new SelectionChangedEvent((ISelectionProvider)AppointmentMultiProfEditor.this, (ISelection)AppointmentMultiProfEditor.this.getSelection()));
                    }
                });
                AppointmentMultiProfEditor.this.ignore = false;
            }
        };
        this.controllerListeners.put(prof, currentAppointmentListener);
        profControl.getController().addListener(currentAppointmentListener);
        AppointmentDateControl2 dateControl = profControl.getDateControl();
        this.addScrollBarSynchronizer((Control)profControl, dateControl.getScroll());
    }

    private void addScrollBarSynchronizer(final Control control, final ScrollBar scroll) {
        scroll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AppointmentMultiProfEditor.this.ignore) {
                    return;
                }
                AppointmentMultiProfEditor.this.ignore = true;
                int selection = scroll.getSelection();
                for (ProfControl profControl2 : AppointmentMultiProfEditor.this.profControls.values()) {
                    if (profControl2 == control) continue;
                    profControl2.getDateControl().getScroll().setSelection(selection);
                    profControl2.getDateControl().redraw();
                }
                if (control != AppointmentMultiProfEditor.this.timeControl) {
                    AppointmentMultiProfEditor.this.timeControl.getDateControl().getScroll().setSelection(selection);
                    AppointmentMultiProfEditor.this.timeControl.getDateControl().redraw();
                }
                AppointmentMultiProfEditor.this.ignore = false;
            }
        });
    }

    private void disposeAllProfControls() {
        for (ProfControl c : this.profControls.values()) {
            c.dispose();
        }
        this.profControls.clear();
        this.controllerListeners.clear();
    }

    private MultiProfInput getInput() {
        return (MultiProfInput)super.getEditorInput();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.initializing = true;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void setInput(IEditorInput input) {
        if (input == null || !(input instanceof MultiProfInput)) {
            throw new IllegalArgumentException();
        }
        super.setInputWithNotify(input);
        if (!this.initializing) {
            this.refresh();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        MultiStatus status = new MultiStatus();
        for (ProfControl control : this.profControls.values()) {
            if (!control.getController().isDirty()) continue;
            status.add(control.getController().saveAll());
        }
        if (!status.isOK()) {
            MessageUtil.show((IStatus)status);
        }
        if (!status.isOkToProceed()) {
            monitor.setCanceled(true);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        for (ProfControl control : this.profControls.values()) {
            if (!control.getController().isDirty()) continue;
            return true;
        }
        return false;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.managers.addListener((Object)listener);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void finalize() throws Throwable {
        System.err.println((Object)((Object)this) + "was finalized by gc");
        super.finalize();
    }

    public IPatient getPatient() {
        IPatient patient;
        AppointmentSelection selection = this.getSelection();
        IAppointment appointment = selection.getAppointment();
        if (appointment != null && (patient = appointment.getPatient()) != null) {
            return patient.clone();
        }
        return null;
    }

    public AppointmentSelection getSelection() {
        AppointmentSelection selection = new AppointmentSelection();
        for (ProfControl control : this.profControls.values()) {
            AppointmentMainController controller = control.getController();
            IAppointment currentAppointment = controller.getCurrentAppointment();
            if (currentAppointment == null || !controller.canSeeAndModifyAppointment(currentAppointment)) continue;
            selection = new AppointmentSelection(currentAppointment);
        }
        return selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.managers.removeListener((Object)listener);
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }

    public MessageLink getMessageLink() {
        return null;
    }

    public void dispose() {
        ResourceGetter.removeListener((IRefreshFont)this);
        this.disposeAllProfControls();
        super.dispose();
    }

    public void setFocus() {
        this.toolbarComp.setFocus();
    }

    public void print() {
        ArrayList<XBaseAppointmentDate> dates = new ArrayList<XBaseAppointmentDate>();
        for (ProfControl c : this.profControls.values()) {
            XBaseAppointmentDate xdate = c.getDateControl().getAppointmentVisualStructure().getBaseAppointmentDate();
            if (xdate == null) continue;
            dates.add(xdate);
        }
        if (dates.size() > 0) {
            AppointmentDatePrintDialog dialog = new AppointmentDatePrintDialog(this.getSite().getShell(), dates);
            UI.centerComposite((Composite)dialog.getShell(), (Composite)this.getSite().getShell());
            dialog.open();
        }
    }

    public void gotoPreviousDay() {
        this.setDate(this.getDate().plusDay(-1));
    }

    public void gotoNextDay() {
        this.setDate(this.getDate().plusDay(1));
    }

    public void gotoNextWeek() {
        this.setDate(this.getDate().plusDay(7));
    }

    public void gotoPreviousWeek() {
        this.setDate(this.getDate().plusDay(-7));
    }

    public void gotoToday() {
        this.setDate(LocalDate.today());
    }

    public void refreshFont() {
        if (this.toolbarComp != null && !this.toolbarComp.isDisposed()) {
            this.toolbarComp.refreshFont();
        }
        if (this.centerComp != null && !this.centerComp.isDisposed()) {
            this.centerComp.refreshFont();
        }
        if (this.toolbarComp != null && !this.toolbarComp.isDisposed()) {
            this.toolbarComp.getParent().layout(true, true);
        }
    }

    public boolean isPrintAllowed() {
        return true;
    }
}

