/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XObjectContainer;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateKey;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentWeekTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XBaseAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XReservedAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.site.SiteAddedAs;
import ca.infodata.ofys.data.middle.dataobjects.site.XPersonSite;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.mb.listener.object.IObjectListener;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.editor.controller.Crud2;
import ca.infodata.ofys.ui.appointment.editor.controller.IControllerObjectResolver;
import ca.infodata.ofys.ui.appointment.editor.controller.XObjectContainer2;
import ca.infodata.ofys.ui.appointment.editor.model2.IServer;
import ca.infodata.ofys.ui.appointment.editor.model2.Model;
import ca.infodata.ofys.ui.controls.IUserInteractionHelper;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.ClosureA;
import ca.infodata.util1.ClosureAR;
import ca.infodata.util1.IdentityArrayList;
import ca.infodata.util1.IntegerRange;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.Range;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mb.listeners.GenListenerManager;
import org.mb.listeners.IListenerManager;

final class Controller
implements Model.IAppointmentModelListener,
IObjectListener<Object> {
    private static final Logger logger = Logger.getLogger(Controller.class.getName());
    private static final String EXEMPLE = Messages.getString((String)"EXEMPLE", (String[])new String[0]);
    private final IListenerManager<ControllerListener> manager;
    private ControllerListener proxy;
    private Model model;
    private Integer currentStartTime;
    private Integer currentEndTime;
    private XReservedAppointment currentReservedAppointment;
    private XAppointment currentAppointment;
    private XAppointmentDateTemplate currentDateTemplate;
    private XAppointmentWeekTemplate currentWeekTemplate;
    private XAppointmentPeriod currentPeriod;
    private LocalDate currentCalendarDate;
    private final List<LocalDate> currentCalendarDates;
    private XBaseProfessionnal currentProfessional;
    private LocalDate cursorStartDate;
    private LocalDate cursorEndDate;
    private boolean disposed;
    private boolean moveBaseAppointmentDateMonth = true;
    private boolean moveAppointmentDateWeek = true;
    private final XObjectContainer2 clones;
    private IUserInteractionHelper helper;
    private IControllerObjectResolver objectResolver;
    private IServer server;
    private String controllerId;

    Controller(String id, Model model, LocalDate cursorStartDate, LocalDate cursorEndDate, Integer initialCurrentProfessional, IUserInteractionHelper helper, IControllerObjectResolver objectResolver) {
        this.controllerId = id;
        this.model = model;
        this.server = this.model.getServer();
        this.helper = helper;
        this.objectResolver = objectResolver;
        this.clones = new XObjectContainer2(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void logInfo(String message) {
                Controller.this.logInfo(message);
            }
        };
        this.currentProfessional = objectResolver.getProfessionnal(initialCurrentProfessional);
        if (this.currentProfessional != null) {
            Application.get().getGlobalInstances().getNotificationSystem().addProfIdForApptNotification(this.currentProfessional.getId());
        }
        this.cursorStartDate = cursorStartDate;
        this.cursorEndDate = cursorEndDate;
        this.manager = new GenListenerManager(ControllerListener.class);
        this.proxy = (ControllerListener)this.manager.getProxy();
        this.currentCalendarDate = null;
        this.currentCalendarDates = new IdentityArrayList();
        this.currentDateTemplate = null;
        this.currentWeekTemplate = null;
        this.currentAppointment = null;
        this.model.addListener(this);
    }

    private void logInfo(String log) {
        XBaseProfessionnal prof = this.getCurrentProfessional();
        String key = "Controller" + this.controllerId + "-Prof" + (prof == null ? "null" : prof.getId());
        logger.info(String.valueOf(key) + "  " + log);
    }

    private void logSevere(String log) {
        logger.log(Level.SEVERE, log);
    }

    private void logSevere(String log, Exception e) {
        XBaseProfessionnal prof = this.getCurrentProfessional();
        String key = "Controller" + this.controllerId + "-Prof" + (prof == null ? "null" : prof.getId());
        logger.log(Level.SEVERE, String.valueOf(key) + "  " + log, e);
    }

    public void moveBaseAppointmentDateCursor(LocalDate dateThatMustBeInCursorRange) {
        this.checkUsable();
        this.moveBaseAppointmentDateCursor(dateThatMustBeInCursorRange.withDayOfWeek(1), dateThatMustBeInCursorRange.withDay(dateThatMustBeInCursorRange.getMonthEnd()));
    }

    public void moveBaseAppointmentDateCursor(LocalDate start, LocalDate end) {
        this.checkUsable();
        this.cursorStartDate = start.withDay(1);
        this.cursorEndDate = end.withDay(end.getMonthEnd());
        List dates = LocalDate.generateList((LocalDate)this.cursorStartDate, (LocalDate)this.cursorEndDate);
        this.getModel().checkCacheForBaseAppointmentDates(dates, this.setProfOrPersonGroup());
    }

    private List<Integer> setProfOrPersonGroup() {
        ArrayList<Integer> asList = new ArrayList<Integer>();
        asList.add(this.currentProfessional.getId());
        return asList;
    }

    public void moveAppointmentDateCursor(List<LocalDate> oldDates, List<LocalDate> dates) {
        this.checkUsable();
        Collections.sort(oldDates);
        Collections.sort(dates);
        this.getModel().markAsUnusing(this.currentProfessional, oldDates);
        this.getModel().markAsUsing(this.currentProfessional, dates);
        if (this.currentProfessional.getIdPerson() != null) {
            LocalDateRange range;
            LocalDate end;
            LocalDate start;
            ArrayList<Integer> profIds = new ArrayList<Integer>();
            profIds.add(this.currentProfessional.getId());
            if (oldDates.size() > 0) {
                start = oldDates.get(0);
                range = start == (end = oldDates.get(oldDates.size() - 1)) ? new LocalDateRange(start, end, RangeNotation.CLOSED) : new LocalDateRange(start, end, RangeNotation.LEFT_CLOSED);
                this.objectResolver.getWhoProfReplace(this.getCurrentProfessional().getId(), range).forEach(prof -> this.getModel().markAsUnusing((XBaseProfessionnal)prof, (Collection<LocalDate>)oldDates));
            }
            if (dates.size() > 0) {
                start = dates.get(0);
                range = start == (end = dates.get(dates.size() - 1)) ? new LocalDateRange(start, end, RangeNotation.CLOSED) : new LocalDateRange(start, end, RangeNotation.LEFT_CLOSED);
                this.objectResolver.getWhoProfReplace(this.getCurrentProfessional().getId(), range).forEach(prof -> {
                    this.getModel().markAsUsing((XBaseProfessionnal)prof, (Collection<LocalDate>)dates);
                    profIds.add(prof.getId());
                });
            }
        }
        this.model.checkCacheForAppointmentDates(dates, this.setProfOrPersonGroup());
    }

    public Collection<XAppointmentPeriodType> getLstAppointmentPeriodType() {
        return this.objectResolver.getPeriodTypes();
    }

    public Collection<XAppointmentType> getLstAppointmentType() {
        return this.objectResolver.getAppointmentTypes();
    }

    public Collection<XBaseProfessionnal> getLstProfessional() {
        return this.getModel().getLstProfessional();
    }

    public Collection<XPersonGroup> getLstPersonGroup() {
        return this.getModel().getLstPersonGroup();
    }

    public int getDateTemplateDefaultScale() {
        return this.objectResolver.getDefaultTemplateScale();
    }

    public int getDateTemplateDefaultEndHour() {
        return this.objectResolver.getDefaultTemplateEndHour();
    }

    public int getDateTemplateDefaultStartHour() {
        return this.objectResolver.getDefaultTemplateStartHour();
    }

    public EditableDataObjectList<XAppointmentDateTemplate> getAppointmentDateTemplateList() {
        this.checkUsable();
        final EditableDataObjectList list = new EditableDataObjectList();
        for (XAppointmentDateTemplate template : this.getModel().getLstAppointmentDateTemplate()) {
            if (!template.getIsReusable()) continue;
            list.add((IMinimalEditableDataObject)template);
        }
        this.clones.iterator(new ClosureA<IMinimalEditableDataObject>(){

            public void execute(IMinimalEditableDataObject e) {
                if (e instanceof XAppointmentDateTemplate) {
                    int index = list.indexOf((Object)e);
                    if (index != -1) {
                        list.set(index, (IMinimalEditableDataObject)((XAppointmentDateTemplate)e));
                    } else {
                        list.add((IMinimalEditableDataObject)((XAppointmentDateTemplate)e));
                    }
                }
            }
        });
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            XAppointmentDateTemplate template = (XAppointmentDateTemplate)iterator.next();
            if (!Boolean.TRUE.equals(template.getIsDeleted()) && (template.getProfessionnal() == null || this.currentProfessional.getIdPerson() == null || template.getProfessionnal().equals(this.currentProfessional.getId()))) continue;
            iterator.remove();
        }
        return list;
    }

    public EditableDataObjectList<XAppointmentWeekTemplate> getAppointmentWeekTemplateList() {
        this.checkUsable();
        final EditableDataObjectList list = new EditableDataObjectList();
        for (XAppointmentWeekTemplate template : this.getModel().getLstAppointmentWeekTemplate()) {
            list.add((IMinimalEditableDataObject)template);
        }
        this.clones.iterator(new ClosureA<IMinimalEditableDataObject>(){

            public void execute(IMinimalEditableDataObject e) {
                if (e instanceof XAppointmentWeekTemplate) {
                    int index = list.indexOf((Object)e);
                    if (index != -1) {
                        list.set(index, (IMinimalEditableDataObject)((XAppointmentWeekTemplate)e));
                    } else {
                        list.add((IMinimalEditableDataObject)((XAppointmentWeekTemplate)e));
                    }
                }
            }
        });
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            XAppointmentWeekTemplate template = (XAppointmentWeekTemplate)iterator.next();
            if (!Boolean.TRUE.equals(template.getIsDeleted()) && (template.getProfessionnal() == null || this.currentProfessional.getIdPerson() == null || template.getProfessionnal().equals(this.currentProfessional.getId()))) continue;
            iterator.remove();
        }
        return list;
    }

    public XAppointmentType getDEFAULT_APPOINTMENT_TYPE() {
        this.checkUsable();
        return this.objectResolver.getDefaultAppointmentType();
    }

    public XAppointmentPeriodType getDEFAULT_APPOINTMENT_PERIOD_TYPE() {
        this.checkUsable();
        return this.objectResolver.getDefaultAppointmentPeriodType();
    }

    public IEditableDataObjectList<XReservedAppointment> getReservedAppointments(XAppointmentDate xdate) {
        this.checkUsable();
        IEditableDataObjectList<XReservedAppointment> reservedAppointments = this.model.getReservedAppointments(xdate.getDate(), xdate.getProfessional());
        EditableDataObjectList list = new EditableDataObjectList(reservedAppointments.size());
        for (XReservedAppointment r : reservedAppointments) {
            if (r == this.currentReservedAppointment) continue;
            list.add((IMinimalEditableDataObject)r);
        }
        return list;
    }

    public IEditableDataObjectList<XAppointment> getAppointments(XAppointmentDate xdate) {
        this.checkUsable();
        LocalDate date = xdate.getDate();
        EditableDataObjectList list = new EditableDataObjectList();
        list.addAll(this.model.getAppointments(xdate.getDate(), xdate.getProfessional()));
        HashSet setAddedProfIds = new HashSet();
        this.objectResolver.getWhoProfReplace(this.getCurrentProfessional().getId(), date).forEach(arg_0 -> this.lambda$2(setAddedProfIds, (IEditableDataObjectList)list, date, arg_0));
        Application.get().getGlobalInstances().getNotificationSystem().addProfIdForApptNotification(setAddedProfIds);
        this.clones.iterator(new ClosureA<IMinimalEditableDataObject>((IEditableDataObjectList)list, date, xdate){
            private final /* synthetic */ IEditableDataObjectList val$list;
            private final /* synthetic */ LocalDate val$date;
            private final /* synthetic */ XAppointmentDate val$xdate;
            {
                this.val$list = iEditableDataObjectList;
                this.val$date = localDate;
                this.val$xdate = xAppointmentDate;
            }

            public void execute(IMinimalEditableDataObject e) {
                if (e instanceof XAppointment) {
                    XAppointment a = (XAppointment)e;
                    int index = this.val$list.indexOf((Object)e);
                    if (index != -1) {
                        this.val$list.set(index, (IMinimalEditableDataObject)a);
                    } else if (a.getDate().equals((Object)this.val$date) && a.getIdProfessional().equals(this.val$xdate.getProfessional())) {
                        this.val$list.add((IMinimalEditableDataObject)a);
                    }
                }
            }
        });
        return list;
    }

    public XAppointmentDateTemplate getAppointmentDateTemplate(final XAppointmentDateTemplate w) {
        if (w == null) {
            return null;
        }
        IMinimalEditableDataObject found = this.clones.find(new ClosureAR<IMinimalEditableDataObject, Boolean>(){

            public Boolean execute(IMinimalEditableDataObject e) {
                if (e instanceof XAppointmentDateTemplate && (w.equals((Object)e) || w.equalsByTag(e))) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        if (found != null) {
            return (XAppointmentDateTemplate)found;
        }
        for (XAppointmentDateTemplate w2 : this.getAppointmentDateTemplateList()) {
            if (!w.equals((Object)w2) && !w.equalsByTag((IMinimalEditableDataObject)w2)) continue;
            return w2;
        }
        return w;
    }

    public XAppointmentWeekTemplate getAppointmentWeekTemplate(final XAppointmentWeekTemplate w) {
        if (w == null) {
            return null;
        }
        IMinimalEditableDataObject found = this.clones.find(new ClosureAR<IMinimalEditableDataObject, Boolean>(){

            public Boolean execute(IMinimalEditableDataObject e) {
                if (e instanceof XAppointmentWeekTemplate && w.equals((Object)e)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        if (found != null) {
            return (XAppointmentWeekTemplate)found;
        }
        for (XAppointmentWeekTemplate w2 : this.getAppointmentWeekTemplateList()) {
            if (!w.equals((Object)w2)) continue;
            return w2;
        }
        return w;
    }

    public XAppointment getAppointment(final XAppointment appointment) {
        if (appointment == null) {
            return null;
        }
        IMinimalEditableDataObject found = this.clones.find(new ClosureAR<IMinimalEditableDataObject, Boolean>(){

            public Boolean execute(IMinimalEditableDataObject e) {
                if (e instanceof XAppointment && appointment.equals((Object)e)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        if (found != null) {
            return (XAppointment)found;
        }
        return this.model.getAppointment(appointment.getId());
    }

    public XAppointment getAppointment(XAppointmentDate date, int startTime, int endTime) {
        this.checkUsable();
        for (XAppointment item : this.getAppointments(date)) {
            if (item.getStartTime().intValue() != startTime || item.getEndTime().intValue() != endTime) continue;
            return item;
        }
        return null;
    }

    public boolean isAppointmentWithinPeriod(XAppointment appointment, XAppointmentPeriod period) {
        this.checkUsable();
        return period.getStartTime() <= appointment.getStartTime() && period.getEndTime() >= appointment.getEndTime();
    }

    public XAppointmentDate getAppointmentDate(final LocalDate date) {
        this.checkUsable();
        if (date == null) {
            return null;
        }
        IMinimalEditableDataObject found = this.clones.find(new ClosureAR<IMinimalEditableDataObject, Boolean>(){

            public Boolean execute(IMinimalEditableDataObject e) {
                XAppointmentDate xdate;
                if (e instanceof XAppointmentDate && date.equals((Object)(xdate = (XAppointmentDate)e).getDate()) && Controller.this.getCurrentProfessional().getId().equals(xdate.getProfessional())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        if (found != null) {
            return (XAppointmentDate)found;
        }
        List<Integer> asList = this.setProfOrPersonGroup();
        XAppointmentDate appointmentDate = this.getModel().getDate(date, asList.isEmpty() ? null : asList.get(0));
        if (appointmentDate == null) {
            appointmentDate = this.createAndAddNewDummyXAppointmentDate(date);
        }
        appointmentDate = this.clone(appointmentDate);
        this.register((EditableDataObject)appointmentDate);
        return appointmentDate;
    }

    private XAppointmentDate createAndAddNewDummyXAppointmentDate(LocalDate date) {
        XAppointmentDate adate = new XAppointmentDate();
        adate.setNew();
        adate.setDate(date);
        adate.setProfessionnal(this.getCurrentProfessional().getId());
        adate.setIsDeleted(false);
        XAppointmentDateTemplate atemplate = new XAppointmentDateTemplate();
        atemplate.setScale(Short.valueOf((short)this.getDateTemplateDefaultScale()));
        atemplate.setStartHour(Short.valueOf((short)this.getDateTemplateDefaultStartHour()));
        atemplate.setEndHour(Short.valueOf((short)this.getDateTemplateDefaultEndHour()));
        atemplate.setIsReusable(false);
        atemplate.modificationStatus.plain_set((Object)ModificationStatus.STATUS_NEUTRAL);
        atemplate.setListenerEnabled(true);
        adate.setDateTemplate(atemplate);
        adate.setListenerEnabled(true);
        adate.modificationStatus.plain_set((Object)ModificationStatus.STATUS_NEUTRAL);
        return adate;
    }

    public XBaseAppointmentDate getBaseAppointmentDate(LocalDate date) {
        this.checkUsable();
        if (date == null) {
            return null;
        }
        List<Integer> asList = this.setProfOrPersonGroup();
        XBaseAppointmentDate base = this.getModel().getBaseDate(date, asList.isEmpty() ? null : asList.get(0));
        return base;
    }

    public boolean isAppointmentDateInCache(LocalDate date) {
        this.checkUsable();
        return this.model.isAppointmentDateInCache(date, this.getCurrentProfessional().getId());
    }

    public boolean isBaseAppointmentDateInCache(LocalDate date) {
        this.checkUsable();
        return this.model.isBaseAppointmentDateInCache(date, this.getCurrentProfessional().getId());
    }

    public Integer getCurrentStartTime() {
        this.checkUsable();
        return this.currentStartTime;
    }

    public Integer getCurrentEndTime() {
        this.checkUsable();
        return this.currentEndTime;
    }

    public void setCurrentStartTime(Integer time) {
        this.checkUsable();
        if (time != null && (time < 0 || time >= 1440)) {
            time = null;
        }
        if (this.currentStartTime != time) {
            this.currentStartTime = time;
            this.proxy.currentStartTimeChanged();
        }
    }

    public void setCurrentEndTime(Integer time) {
        this.checkUsable();
        if (time != null && (time < 0 || time >= 1440)) {
            time = null;
        }
        if (this.currentEndTime != time) {
            this.currentEndTime = time;
            this.proxy.currentEndTimeChanged();
        }
    }

    public XAppointmentPeriod getCurrentPeriod() {
        this.checkUsable();
        return this.currentPeriod;
    }

    public void setCurrentPeriod(XAppointmentPeriod period) {
        this.checkUsable();
        if (this.currentPeriod != period) {
            if (this.currentPeriod != null) {
                this.currentPeriod.setListenerEnabled(false);
            }
            this.currentPeriod = period;
            if (this.currentPeriod != null) {
                this.currentPeriod.setListenerEnabled(true);
            }
            this.proxy.currentPeriodChanged();
        }
    }

    public IAppointment getCurrentAppointment() {
        this.checkUsable();
        return this.currentAppointment;
    }

    public XReservedAppointment getCurrentReservedAppointment() {
        this.checkUsable();
        return this.currentReservedAppointment;
    }

    public void setCurrentAppointment(XAppointment appointment) {
        this.checkUsable();
        if (this.currentAppointment != appointment) {
            Log.logOperation((String)"setCurrentAppointment", (Object[])new Object[]{String.valueOf(appointment)});
            this.unregister((EditableDataObject)this.currentAppointment);
            this.removeNonDirtyFromClones((IMinimalEditableDataObject)this.currentAppointment);
            this.currentAppointment = this.clone(appointment);
            this.register((EditableDataObject)this.currentAppointment);
            this.proxy.currentAppointmentChanged((IAppointment)this.currentAppointment);
        }
    }

    public void setCurrentReservedAppointment(XReservedAppointment appointment) {
        if (appointment != null) {
            this.checkUsable();
        }
        if (this.currentReservedAppointment != appointment) {
            this.currentReservedAppointment = appointment;
        }
    }

    public void setCurrentCalendarDates(List<LocalDate> dates) {
        this.checkUsable();
        if (!this.currentCalendarDates.equals(dates)) {
            if (dates != null && dates.size() > 0) {
                this.moveAppointmentDateCursor(this.currentCalendarDates, dates);
            }
            this.currentCalendarDates.clear();
            if (dates != null) {
                this.currentCalendarDates.addAll(dates);
            }
            this.proxy.currentCalendarDatesChanged();
        }
    }

    public void setCurrentCalendarDates(LocalDate dateInTheWeek) {
        Log.logOperation((String)"Controller.setCurrentCalendarDates", (Object[])new Object[]{dateInTheWeek});
        this.checkUsable();
        if (dateInTheWeek == null) {
            this.setCurrentCalendarDates(Collections.EMPTY_LIST);
        } else if (this.moveAppointmentDateWeek) {
            this.setCurrentCalendarDates(Controller.getDatesInTheWeek(dateInTheWeek));
        } else {
            this.setCurrentCalendarDates(Arrays.asList(dateInTheWeek));
        }
        if (this.currentCalendarDate != dateInTheWeek) {
            this.currentCalendarDate = dateInTheWeek;
        }
        this.proxy.currentCalendarDateChanged();
        if (this.currentCalendarDate == null) {
            this.currentDateTemplate = null;
        } else {
            XAppointmentDate date = this.getAppointmentDate(this.currentCalendarDate);
            this.currentDateTemplate = date.getDateTemplate();
        }
        this.proxy.currentDateTemplateChanged();
    }

    private static List<LocalDate> getDatesInTheWeek(LocalDate date) {
        return LocalDate.generateList((LocalDate)date.withDayOfWeek(1), (LocalDate)date.withDayOfWeek(7));
    }

    public LocalDate getCurrentCalendarDate() {
        this.checkUsable();
        return this.currentCalendarDate;
    }

    public List<LocalDate> getCurrentCalendarDates() {
        this.checkUsable();
        return this.currentCalendarDates;
    }

    public void setCurrentProfessional(Integer professional) {
        this.setCurrentProfessional(this.objectResolver.getProfessionnal(professional));
    }

    public void setCurrentProfessional(XBaseProfessionnal professional) {
        if (!MiscUtil.areObjectsEquals((Object)professional, (Object)this.currentProfessional)) {
            Log.logOperation((String)"Controller.setCurrentProfessional", (Object[])new Object[]{professional});
            if (this.currentProfessional != null) {
                this.getModel().markAsUnusing(this.currentProfessional, this.getCurrentCalendarDates());
            }
            this.currentProfessional = professional;
            if (this.currentProfessional != null) {
                this.proxy.usableStateChanged(this.isUsable());
                this.moveBaseAppointmentDateCursor(this.cursorStartDate, this.cursorEndDate);
                this.moveAppointmentDateCursor(this.currentCalendarDates, this.currentCalendarDates);
                this.setCurrents(null, null, null);
                this.setCurrentAppointment(null);
                this.setCurrentEndTime(null);
                this.setCurrentStartTime(null);
            } else {
                this.setCurrents(null, null, null);
                this.setCurrentAppointment(null);
                this.setCurrentEndTime(null);
                this.setCurrentStartTime(null);
                this.proxy.usableStateChanged(this.isUsable());
            }
            Application.get().getGlobalInstances().getNotificationSystem().addProfIdForApptNotification(this.currentProfessional.getId());
            this.proxy.currentProfessionalChanged();
        }
    }

    public XBaseProfessionnal getCurrentProfessional() {
        return this.currentProfessional;
    }

    public XAppointmentDateTemplate getCurrentDateTemplate() {
        this.checkUsable();
        return this.currentDateTemplate;
    }

    public XAppointmentWeekTemplate getCurrentWeekTemplate() {
        this.checkUsable();
        return this.currentWeekTemplate;
    }

    public void setCurrentDateTemplate(XAppointmentDateTemplate dateTemplate, boolean clone) {
        this.checkUsable();
        if (this.currentDateTemplate != dateTemplate) {
            this.removeNonDirtyFromClones((IMinimalEditableDataObject)this.currentDateTemplate);
            this.unregister((EditableDataObject)this.currentDateTemplate);
            this.currentDateTemplate = clone ? this.clone(dateTemplate) : dateTemplate;
            this.register((EditableDataObject)this.currentDateTemplate);
            this.proxy.currentDateTemplateChanged();
        }
    }

    private void setCurrentWeekTemplate(XAppointmentWeekTemplate weekTemplate) {
        this.checkUsable();
        if (this.currentWeekTemplate != weekTemplate) {
            this.removeNonDirtyFromClones((IMinimalEditableDataObject)this.currentWeekTemplate);
            this.unregister((EditableDataObject)this.currentWeekTemplate);
            this.currentWeekTemplate = this.clone(weekTemplate);
            this.register((EditableDataObject)this.currentWeekTemplate);
            this.proxy.currentWeekTemplateChanged();
        }
    }

    public void setCurrents(XAppointmentWeekTemplate weekTemplate, XAppointmentDateTemplate dateTemplate, XAppointmentPeriod period) {
        Log.log((Logger)logger, (String)"Controller.setCurrents", (String[])new String[]{"weekTemplate", "dateTemplate", "period"}, (Object[])new Object[]{weekTemplate, dateTemplate, period});
        this.checkUsable();
        this.setCurrentWeekTemplate(weekTemplate);
        boolean clone = weekTemplate == null;
        this.setCurrentDateTemplate(dateTemplate, clone);
        this.setCurrentPeriod(period);
    }

    public void clearCurrents() {
        this.checkUsable();
        this.currentAppointment = null;
        this.currentCalendarDate = null;
        this.currentCalendarDates.clear();
        this.currentDateTemplate = null;
        this.currentEndTime = null;
        this.currentStartTime = null;
        this.currentProfessional = null;
        this.currentWeekTemplate = null;
        this.currentPeriod = null;
        this.cursorEndDate = null;
        this.cursorStartDate = null;
        this.proxy.currentAppointmentChanged(null);
        this.proxy.currentCalendarDatesChanged();
        this.proxy.currentCalendarDateChanged();
        this.proxy.currentEndTimeChanged();
        this.proxy.currentStartTimeChanged();
        this.proxy.currentProfessionalChanged();
        this.proxy.currentDateTemplateChanged();
        this.proxy.currentPeriodChanged();
        this.proxy.currentWeekTemplateChanged();
    }

    public void deletePeriod(XAppointmentPeriod period) {
        Log.logOperation((String)"Controller.deletePeriod", (Object[])new Object[]{period});
        this.checkUsable();
        if (period == null) {
            throw new IllegalArgumentException("period cant be null");
        }
        if (this.currentDateTemplate == null) {
            throw new IllegalStateException("current date template is null");
        }
        if (this.currentDateTemplate.getPeriods().indexOf((Object)period) == -1) {
            throw new IllegalStateException("period is not in current date template");
        }
        period.setDeleted();
        if (period == this.currentPeriod) {
            this.setCurrentPeriod(null);
        }
    }

    public void closePeriod(XAppointmentPeriod period) {
        Log.logOperation((String)"Controller.closePeriod", (Object[])new Object[]{period});
        this.checkUsable();
        if (period == null) {
            throw new IllegalArgumentException("period cant be null");
        }
        if (this.currentDateTemplate == null) {
            throw new IllegalStateException("current date template is null");
        }
        if (this.currentDateTemplate.getPeriods().indexOf((Object)period) == -1) {
            throw new IllegalStateException("period is not in current date template");
        }
        if (this.currentCalendarDate == null) {
            throw new IllegalStateException("period is not in a appointment date templte");
        }
        List<Integer> asList = this.setProfOrPersonGroup();
        this.getModel().checkCacheForAppointmentDates(this.currentCalendarDate, asList.isEmpty() ? null : asList.get(0));
        period.setIsClosed(Boolean.valueOf(true));
        XAppointmentDate xdate = this.getAppointmentDate(this.currentCalendarDate);
        IntegerRange periodRange = new IntegerRange(period.getStartTime(), period.getEndTime(), RangeNotation.OPEN);
        IntegerRange appointmentRange = new IntegerRange(null, null, RangeNotation.CLOSED);
        for (IAppointment appointment : this.getAppointments(xdate)) {
            XAppointment xappointment = (XAppointment)appointment;
            appointmentRange.start = Integer.valueOf(xappointment.getStartTime().intValue());
            appointmentRange.end = Integer.valueOf(xappointment.getEndTime().intValue());
            if (!periodRange.intersect((Range)appointmentRange) || appointment.getStatus() == XAppointmentStatus.TO_MOVE) continue;
            XAppointment c = this.clone(xappointment);
            c.setStatus(XAppointmentStatus.TO_MOVE);
        }
        IStatus status = this.saveAll();
        if (!status.isOkToProceed()) {
            this.cancelAll();
        }
    }

    public synchronized void setPatientStatus(XAppointment appointment, XPatientStatus status) {
        this.checkUsable();
        if (appointment == null) {
            throw new NullPointerException("appointment");
        }
        appointment = this.clone(appointment);
        appointment.setPatientStatus(status);
        IStatus status2 = this.saveAll();
        if (!status2.isOkToProceed()) {
            this.cancelAll();
        }
    }

    public void setTimes(XAppointment appointment, int start, int end) {
        this.checkUsable();
        if (appointment == null) {
            throw new NullPointerException("appointment");
        }
        if (this.canSeeAndModifyAppointment((IAppointment)appointment)) {
            appointment = this.clone(appointment);
            ObjectListenerManager.disable((Object)appointment);
            appointment.setStartTime(Short.valueOf((short)start));
            appointment.setEndTime(Short.valueOf((short)end));
            ObjectListenerManager.enable((Object)appointment, (boolean)true);
        }
    }

    public void setEndTime(XAppointment appointment, int t) {
        this.checkUsable();
        if (appointment == null) {
            throw new NullPointerException("appointment");
        }
        if (this.canSeeAndModifyAppointment((IAppointment)appointment)) {
            appointment = this.clone(appointment);
            appointment.setEndTime(Short.valueOf((short)t));
        }
    }

    public void setAppointmentStatus(XAppointment appointment, XAppointmentStatus state) {
        this.checkUsable();
        if (appointment == null) {
            throw new NullPointerException("appointment");
        }
        if (this.canSeeAndModifyAppointment((IAppointment)appointment)) {
            appointment = this.clone(appointment);
            appointment.setStatus(state);
            IStatus status = this.saveAll();
            if (!status.isOkToProceed()) {
                this.cancelAll();
            }
        }
    }

    public void addAppointmentNote(XAppointment appointment, String note) {
        this.checkUsable();
        if (appointment == null) {
            throw new NullPointerException("appointment");
        }
        if (StringUtils.isNotBlank((String)(appointment = this.clone(appointment)).getNote())) {
            appointment.setNote(String.valueOf(appointment.getNote()) + "\n" + note);
        } else {
            appointment.setNote(note);
        }
        IStatus status = this.saveAll();
        if (!status.isOkToProceed()) {
            this.cancelAll();
        }
    }

    public void replaceAppointmentNote(XAppointment appointment, String note) {
        this.checkUsable();
        if (appointment == null) {
            throw new NullPointerException("appointment");
        }
        appointment = this.clone(appointment);
        appointment.setNote(note);
        IStatus status = this.saveAll();
        if (!status.isOkToProceed()) {
            this.cancelAll();
        }
    }

    public void undeleteAppointment(XAppointment appointment) {
        Log.logOperation((String)"Controller.undeleteAppointment", (Object[])new Object[]{appointment});
        this.checkUsable();
        if (appointment == null) {
            throw new NullPointerException("appointment");
        }
        if (this.canSeeAndModifyAppointment((IAppointment)appointment)) {
            appointment = this.clone(appointment);
            appointment.setIsDeleted(Boolean.valueOf(false));
            IStatus status = this.saveAll();
            if (!status.isOkToProceed()) {
                this.cancelAll();
            }
        }
    }

    public void deleteAppointment(XAppointment appointment) {
        Log.logOperation((String)"Controller.deleteAppointment", (Object[])new Object[]{appointment});
        this.checkUsable();
        if (appointment == null) {
            throw new NullPointerException("appointment");
        }
        if (this.canSeeAndModifyAppointment((IAppointment)appointment)) {
            if (appointment.getIdProfessionals().size() > 1) {
                int r = this.helper.warning(Messages.getString((String)"RENDEZ-VOUS.AVERTISSEMENT_SUPPRESSION_MULTI_PROF", (String[])new String[0]), new String[]{Messages.getString((String)"RENDEZ-VOUS.SUPPRIMER_LE_RENDEZ_VOUS", (String[])new String[0]), Messages.getString((String)"RENDEZ-VOUS.DESASSOCIER_X_DU_RENDEZ_VOUS", (String[])new String[]{StringUtils.capitalize((String)this.getCurrentProfessional().getName())}), Messages.getString((String)"ANNULER", (String[])new String[0])}, 2);
                if (r == 0) {
                    appointment = this.clone(appointment);
                    appointment.setIsDeleted(Boolean.valueOf(true));
                    IStatus status = this.saveAll();
                    if (!status.isOkToProceed()) {
                        this.cancelAll();
                    }
                } else if (r == 1) {
                    IStatus status;
                    appointment = this.clone(appointment);
                    Integer currentProfId = this.getCurrentProfessional().getId();
                    appointment.getIdProfessionals().remove(currentProfId);
                    if (currentProfId.equals(appointment.getIdProfessional())) {
                        appointment.setIdProfessional(null);
                    }
                    if (!(status = this.saveAll()).isOkToProceed()) {
                        this.cancelAll();
                    }
                } else if (r == 2) {
                    return;
                }
            } else {
                appointment = this.clone(appointment);
                appointment.setIsDeleted(Boolean.valueOf(true));
                IStatus status = this.saveAll();
                if (!status.isOkToProceed()) {
                    this.cancelAll();
                }
            }
        }
    }

    private void moveAppointmentToDate(XAppointment pappointment, XAppointmentDate xdate, Integer newStartTime) {
        this.moveAppointmentToDate(pappointment, xdate, newStartTime, false);
    }

    private void moveAppointmentToDate(XAppointment pappointment, XAppointmentDate xdate, Integer newStartTime, boolean forceDontClearProf) {
        this.checkUsable();
        if (pappointment == null) {
            throw new NullPointerException("appointment");
        }
        if (xdate == null) {
            throw new NullPointerException("date");
        }
        if (!this.canSeeAndModifyAppointment((IAppointment)pappointment)) {
            return;
        }
        if (newStartTime == null) {
            this.logSevere("Try to move an appointment with no newStartTime: " + pappointment);
            return;
        }
        XAppointment appointment = this.clone(pappointment);
        if (appointment.getDate().equals((Object)xdate.getDate()) && appointment.getIdProfessionals().contains(xdate.getProfessional()) && MiscUtil.areObjectsEquals((Object)appointment.getStartTime(), (Object)newStartTime)) {
            return;
        }
        boolean clearAllProf = !forceDontClearProf;
        boolean skipProfAddition = false;
        if (!forceDontClearProf && appointment.getIdProfessionals().size() > 1 && !appointment.getIdProfessionals().contains(xdate.getProfessional())) {
            int r = this.helper.warning(Messages.getString((String)"RENDEZ-VOUS.AVERTISSEMENT_DEPLACEMENT_MULTI_PROF_VERS_NOUVEAU_PROF", (String[])new String[0]), new String[]{Messages.getString((String)"RENDEZ-VOUS.ADD_TO_PROFS", (String[])new String[0]), Messages.getString((String)"RENDEZ-VOUS.ONLY_THIS_PROF", (String[])new String[0]), Messages.getString((String)"CANCEL", (String[])new String[0])}, 2);
            if (r == 2) {
                return;
            }
            clearAllProf = r == 1;
        } else if (appointment.getIdProfessionals().size() > 1 && appointment.getIdProfessionals().contains(xdate.getProfessional())) {
            clearAllProf = false;
            skipProfAddition = true;
        }
        try {
            ObjectListenerManager.disable((Object)appointment);
            appointment.setDate(xdate.getDate());
            appointment.setIdAppointmentDate(xdate.getId());
            if (clearAllProf) {
                appointment.getIdProfessionals().clear();
            }
            appointment.setIdProfessional(xdate.getProfessional());
            if (!skipProfAddition) {
                appointment.getIdProfessionals().add(xdate.getProfessional());
            }
            if (newStartTime != null) {
                int len = appointment.getEndTime() - appointment.getStartTime();
                appointment.setStartTime(Short.valueOf(newStartTime.shortValue()));
                appointment.setEndTime(Short.valueOf((short)(newStartTime + len)));
            }
            ObjectListenerManager.enable((Object)appointment, (boolean)true);
            XAppointment appointment2 = this.saveAll2();
            if (appointment2 != null) {
                this.setCurrentAppointment(appointment2);
            }
        }
        catch (Exception e) {
            this.logSevere("Failed to move " + appointment + " to date " + xdate + " at startTime " + newStartTime, e);
        }
    }

    private void copyAppointmentToDate(XAppointment appointment, XAppointmentDate date, Integer newStartTime) {
        int r;
        this.checkUsable();
        if (appointment == null) {
            throw new NullPointerException("appointment");
        }
        if (date == null) {
            throw new NullPointerException("date");
        }
        if (!this.canSeeAndModifyAppointment((IAppointment)appointment)) {
            return;
        }
        if (newStartTime == null) {
            this.logSevere("Try to copy an appointment with no newStartTime: " + appointment);
            return;
        }
        if (appointment.getIdProfessionals().size() == 1 && !appointment.getIdProfessionals().contains(date.getProfessional()) && appointment.getDate().equals((Object)date.getDate()) && MiscUtil.areObjectsEquals((Object)appointment.getStartTime(), (Object)newStartTime) && (r = this.helper.warning(Messages.getString((String)"RENDEZ-VOUS.AVERTISSEMENT_DEPLACEMENT_UNI_PROF_VERS_NOUVEAU_PROF", (String[])new String[0]), IUserInteractionHelper.YES_NO, 1)) == 0) {
            this.moveAppointmentToDate(appointment, date, newStartTime, true);
            return;
        }
        XAppointment copy = appointment.clone();
        copy.setTag();
        copy.setListenerEnabled(false);
        copy = this.addToClones(copy);
        try {
            copy.setId(null);
            copy.setVersion(null);
            if (newStartTime != null) {
                int len = copy.getEndTime() - copy.getStartTime();
                copy.setStartTime(Short.valueOf(newStartTime.shortValue()));
                copy.setEndTime(Short.valueOf((short)(newStartTime + len)));
            }
            copy.setDate(date.getDate());
            copy.setIdAppointmentDate(date.getId());
            if (!copy.getIdProfessionals().contains(date.getProfessional())) {
                copy.getIdProfessionals().clear();
                copy.getIdProfessionals().add(date.getProfessional());
            }
            copy.setIdProfessional(date.getProfessional());
            copy.setSeenTime(null);
            copy.setArrivedTime(null);
            copy.setPatientStatus(XPatientStatus.NONE);
            copy.setStatus(XAppointmentStatus.NORMAL);
            copy.setNeutral();
            copy.setNew();
            XAppointment a = this.saveAll2();
            this.setCurrentAppointment(a);
        }
        catch (Exception e) {
            this.logSevere("Failed to copy " + appointment + " to date " + date + " at startTime " + newStartTime, e);
        }
    }

    public boolean[] pasteRecall(XPatientRecall recall) {
        boolean[] result = new boolean[2];
        this.checkUsable();
        XAppointmentDate date = this.getAppointmentDate(this.currentCalendarDate);
        Integer startTime = this.currentStartTime;
        Integer endTime = this.currentEndTime;
        if (date == null) {
            throw new NullPointerException("date");
        }
        if (startTime == null) {
            this.logSevere("Try to copy a recall with no startTime: " + recall);
            return result;
        }
        if (endTime == null) {
            this.logSevere("Try to copy a recall with no endTime: " + recall);
            return result;
        }
        XAppointmentPeriod period = date.getDateTemplate().getPeriod(startTime, endTime);
        XSite site = null;
        Integer length = null;
        if (period != null) {
            site = this.objectResolver.getSite(period.getIdSite());
            length = period.getDefaultLength();
        }
        if (site == null) {
            site = this.objectResolver.getContextSite();
        }
        XAppointment app = new XAppointment();
        app.setTag();
        app.setListenerEnabled(false);
        app = this.addToClones(app);
        app.setId(null);
        app.setVersion(null);
        app.setIdProfessional(date.getProfessional());
        app.getIdProfessionals().add(date.getProfessional());
        app.setSite(site.getId());
        app.getPatients().add((XPatient)recall.getPatient());
        app.setStartTime(Short.valueOf(startTime.shortValue()));
        app.setEndTime(Short.valueOf(length == null ? endTime.shortValue() : (short)(startTime + length)));
        app.setTypeAppointment(this.getDEFAULT_APPOINTMENT_TYPE().getId());
        app.setNote(recall.getReason());
        app.setDate(date.getDate());
        app.setNeutral();
        app.setNew();
        try {
            XAppointment a = this.saveAll2();
            if (a != null) {
                this.setCurrentAppointment(a);
                result[0] = true;
                recall.setStatus(XStatus.APPOINTMENT_GIVEN);
                result[1] = this.saveRecall(recall);
            }
        }
        catch (Exception e) {
            this.logSevere("Failed to copy recall to appointment " + app + " to date " + date + " at startTime " + startTime + " to " + endTime, e);
        }
        return result;
    }

    private boolean saveRecall(XPatientRecall recall) {
        try {
            ReturnObject returnObject = AppointmentAccessorClient.getInstance().saveSync(recall.hashCode(), Application.get().getGlobalInstances().getSession(), (Serializable)recall, false);
            if (!returnObject.getStatus().isOkToProceed()) {
                throw new Exception("Couldn't save Patient Recall " + recall);
            }
            return true;
        }
        catch (Exception e) {
            this.logSevere("", e);
            return false;
        }
    }

    public boolean canPaste() {
        if (!this.isUsable()) {
            return false;
        }
        IAppointment copyTemp = this.model.getCopyTemp();
        IAppointment cutTemp = this.model.getCutTemp();
        if (copyTemp == null && cutTemp == null) {
            return false;
        }
        if (!(copyTemp instanceof XAppointment) && !(cutTemp instanceof XAppointment)) {
            return false;
        }
        if (copyTemp instanceof XAppointment && Boolean.TRUE.equals(((XAppointment)copyTemp).getIsDeleted())) {
            return false;
        }
        if (cutTemp instanceof XAppointment && Boolean.TRUE.equals(((XAppointment)cutTemp).getIsDeleted())) {
            return false;
        }
        if (this.getCurrentCalendarDate() == null || this.getCurrentStartTime() == null || this.getCurrentEndTime() == null || !this.canHaveAppointment(this.getCurrentCalendarDate(), this.getCurrentStartTime(), this.getCurrentEndTime())) {
            return false;
        }
        if (this.model.getCopyTemp() != null) {
            return Boolean.FALSE.equals(((XAppointment)this.model.getCopyTemp()).getIsDeleted());
        }
        if (this.model.getCutTemp() != null) {
            return Boolean.FALSE.equals(((XAppointment)this.model.getCutTemp()).getIsDeleted());
        }
        return false;
    }

    public void cancelCopyOrCut() {
        Log.logOperation((String)"appointment.cancelCopyOrCut", (Object[])new Object[0]);
        this.model.setCutTemp(null);
        this.model.setCopyTemp(null);
    }

    public void cut(IAppointment object) {
        Log.logOperation((String)"appointment.cut", (Object[])new Object[]{object});
        this.checkUsable();
        if (object instanceof XAppointment && !this.canSeeAndModifyAppointment((IAppointment)((XAppointment)object))) {
            return;
        }
        this.model.setCopyTemp(null);
        this.model.setCutTemp(object);
    }

    public void copy(IAppointment object) {
        Log.logOperation((String)"appointment.copy", (Object[])new Object[]{object});
        this.checkUsable();
        if (object instanceof XAppointment && !this.canSeeAndModifyAppointment((IAppointment)((XAppointment)object))) {
            return;
        }
        this.model.setCopyTemp(object);
        this.model.setCutTemp(null);
    }

    public void moveApppointmentToApppointmentDate(XAppointment pappointment, XAppointmentDate xdate) {
        if (pappointment == null) {
            throw new NullPointerException("appointment");
        }
        if (xdate == null) {
            throw new NullPointerException("date");
        }
        if (!this.canSeeAndModifyAppointment((IAppointment)pappointment)) {
            return;
        }
        XAppointment appointment = this.clone(pappointment);
        if (appointment.getDate().equals((Object)xdate.getDate()) && appointment.getIdProfessionals().contains(xdate.getProfessional())) {
            return;
        }
        boolean clearAllProf = false;
        boolean skipProfAddition = false;
        if (appointment.getIdProfessionals().size() > 1 && !appointment.getIdProfessionals().contains(xdate.getProfessional())) {
            int r = this.helper.warning(Messages.getString((String)"RENDEZ-VOUS.AVERTISSEMENT_DEPLACEMENT_MULTI_PROF_VERS_NOUVEAU_PROF", (String[])new String[0]), new String[]{Messages.getString((String)"RENDEZ-VOUS.ADD_TO_PROFS", (String[])new String[0]), Messages.getString((String)"RENDEZ-VOUS.ONLY_THIS_PROF", (String[])new String[0]), Messages.getString((String)"CANCEL", (String[])new String[0])}, 2);
            if (r == 2) {
                return;
            }
            clearAllProf = r == 1;
        } else if (appointment.getIdProfessionals().size() > 1 && appointment.getIdProfessionals().contains(xdate.getProfessional())) {
            clearAllProf = false;
            skipProfAddition = true;
        } else {
            clearAllProf = true;
            skipProfAddition = false;
        }
        try {
            ObjectListenerManager.disable((Object)appointment);
            appointment.setDate(xdate.getDate());
            appointment.setIdAppointmentDate(xdate.getId());
            if (clearAllProf) {
                appointment.getIdProfessionals().clear();
            }
            appointment.setIdProfessional(xdate.getProfessional());
            if (!skipProfAddition) {
                appointment.getIdProfessionals().add(xdate.getProfessional());
            }
            ObjectListenerManager.enable((Object)appointment, (boolean)true);
            this.saveAll2();
        }
        catch (Exception e) {
            this.logSevere("Failed to move " + appointment + " to date " + xdate, e);
        }
    }

    public void paste(IUserInteractionHelper helper) {
        this.checkUsable();
        boolean isCut = this.model.getCutTemp() != null;
        IAppointment object = isCut ? this.model.getCutTemp() : this.model.getCopyTemp();
        Log.logOperation((String)"appointment.paste", (Object[])new Object[]{isCut ? "cut" : "copy", object});
        if (isCut) {
            this.model.setCutTemp(null);
        }
        if (object instanceof XAppointment) {
            XAppointment appointment = (XAppointment)object;
            XAppointmentDate date = this.getAppointmentDate(this.currentCalendarDate);
            if (date != null) {
                if (isCut) {
                    this.moveAppointmentToDate(appointment, date, this.currentStartTime);
                    this.model.setCopyTemp((IAppointment)appointment);
                    this.model.setCutTemp(null);
                } else {
                    this.copyAppointmentToDate(appointment, date, this.currentStartTime);
                    this.model.setCopyTemp((IAppointment)appointment);
                    this.model.setCutTemp(null);
                }
            }
        }
    }

    public boolean canSeeAndModifyAppointment(IAppointment appointment) {
        return this.objectResolver.canSeeAndModifyAppointment(appointment);
    }

    public XAppointment createNewAppointment(int length) {
        int endTime;
        this.checkUsable();
        if (this.currentCalendarDate == null || this.currentStartTime == null) {
            return null;
        }
        if (length <= 0) {
            return null;
        }
        LocalDate date = this.currentCalendarDate;
        int startTime = this.currentStartTime;
        if (this.canHaveAppointment(date, startTime, endTime = startTime + length)) {
            Log.logOperation((String)"Controller.createNewAppointment", (Object[])new Object[]{"date", date, "starttime", startTime, "endTime", endTime});
            XAppointmentDate xdate = this.getAppointmentDate(date);
            XAppointmentPeriod period = xdate.getDateTemplate().getPeriod(Integer.valueOf(startTime), Integer.valueOf(endTime));
            XSite site = null;
            if (period != null) {
                site = this.objectResolver.getSite(period.getIdSite());
            }
            if (site == null) {
                site = this.objectResolver.getContextSite();
            }
            Application.get().getGlobalInstances().getSession().getClientPreferences();
            XAppointment appointment = new XAppointment();
            appointment.setTag();
            appointment.setId(null);
            appointment.setListenerEnabled(false);
            appointment.setNew();
            appointment.setStartTime(Short.valueOf((short)startTime));
            appointment.setEndTime(Short.valueOf((short)endTime));
            appointment.setDate(xdate.getDate());
            appointment.setIdAppointmentDate(xdate.getId());
            appointment.setIdProfessional(xdate.getProfessional());
            appointment.getIdProfessionals().add(xdate.getProfessional());
            appointment.setSite(site.getId());
            appointment.setIdService(period == null ? null : period.getAppointmentPeriodType());
            appointment.getPatients().add(new XPatient());
            Integer apptTypeId = this.getDEFAULT_APPOINTMENT_TYPE().getId();
            if (apptTypeId == null) {
                for (XAppointmentType x : AppointmentPlugin.getDefault().getAppointmentTypes()) {
                    if (!Boolean.TRUE.equals(x.getIsDefault())) continue;
                    apptTypeId = x.getId();
                }
            }
            appointment.setTypeAppointment(apptTypeId);
            XPersonSite ps = new XPersonSite();
            ps.setIdSite(site.getId());
            ps.setAddedAs(SiteAddedAs.WORK_SITE);
            ps.setNew();
            appointment.getPatient().getLstSites().add((IMinimalEditableDataObject)ps);
            appointment.getPatient().modificationStatus.plain_set((Object)ModificationStatus.STATUS_NEW);
            appointment.setNeutral();
            appointment.setNew();
            appointment = this.addToClones(appointment);
            this.setCurrentAppointment(appointment);
            XObjectContainer2 container = new XObjectContainer2();
            XReservedAppointment xr = new XReservedAppointment();
            xr.date = xdate.getDate();
            xr.idProfessional = xdate.getProfessional();
            xr.endTime = appointment.getEndTime();
            xr.startTime = appointment.getStartTime();
            xr.idClient = Application.get().getGlobalInstances().getSession().getClient().getId();
            xr.idSite = appointment.getSite();
            xr.timeOfExpiration = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L);
            xr.numberOfSecToExpire = (int)TimeUnit.MINUTES.toSeconds(5L);
            container.add((IMinimalEditableDataObject)xr);
            this.saveReservation(container);
            ObjectListenerManager.fireObjectModified((Object)xdate);
            return appointment;
        }
        return null;
    }

    private boolean canHaveAppointment(LocalDate date, int startTime, int endTime) {
        List periods = this.getAppointmentDate(date).getDateTemplate().getPeriods(startTime, endTime);
        for (XAppointmentPeriod period : periods) {
            if (period.isClosed()) {
                return false;
            }
            if (Boolean.TRUE.equals(this.objectResolver.getPeriodType(period.getAppointmentPeriodType()).getCanHaveAppointment())) continue;
            return false;
        }
        return true;
    }

    public XAppointmentPeriod createNewPeriod(XAppointmentDateTemplate dateTemplate, int startTime, int endTime) {
        Log.logOperation((String)"Controller.createNewPeriod", (Object[])new Object[]{"dateTemplate", dateTemplate, "startTime", startTime, "endTime", endTime});
        this.checkUsable();
        XAppointmentPeriod period = null;
        int endTime2 = dateTemplate.getScale() + startTime;
        if (endTime2 <= dateTemplate.getEndHour().intValue() * 60) {
            short defaultLength = dateTemplate.getScale();
            XAppointmentPeriod existingPeriod = dateTemplate.getPeriod(Integer.valueOf(startTime), Integer.valueOf(endTime2));
            if (existingPeriod == null) {
                period = new XAppointmentPeriod();
                ObjectListenerManager.disable((Object)period);
                period.setNew();
                if (defaultLength > endTime - startTime) {
                    period.setDefaultLength(Integer.valueOf(endTime - startTime));
                } else {
                    period.setDefaultLength(Integer.valueOf(defaultLength));
                }
                period.setAppointmentPeriodType(this.getDEFAULT_APPOINTMENT_PERIOD_TYPE().getId());
                period.setStartTime(Integer.valueOf(startTime));
                period.setEndTime(Integer.valueOf(endTime2));
                period.setIdSite(this.objectResolver.getContextSite().getId());
                period.setListenerEnabled(true);
                ObjectListenerManager.enable((Object)period);
                dateTemplate.getPeriods().add((IMinimalEditableDataObject)period);
            }
        }
        return period;
    }

    public XAppointmentDateTemplate createNewAppointmentDateTemplate() {
        Log.logOperation((String)"Controller.createNewAppointmentDateTemplate", (Object[])new Object[0]);
        this.checkUsable();
        XAppointmentDateTemplate dateTemplate = new XAppointmentDateTemplate();
        ObjectListenerManager.disable((Object)dateTemplate);
        dateTemplate.setNew();
        dateTemplate.setNote(EXEMPLE);
        dateTemplate.setScale(Short.valueOf((short)this.getDateTemplateDefaultScale()));
        dateTemplate.setStartHour(Short.valueOf((short)this.getDateTemplateDefaultStartHour()));
        dateTemplate.setEndHour(Short.valueOf((short)this.getDateTemplateDefaultEndHour()));
        ObjectListenerManager.enable((Object)dateTemplate);
        this.addToClones(dateTemplate);
        return dateTemplate;
    }

    public XAppointmentDateTemplate createNewAppointmentDateTemplateInWeekTemplate(int dayOfWeek, XAppointmentWeekTemplate weekTemplate) {
        Log.logOperation((String)"Controller.createNewAppointmentDateTemplateInWeekTemplate", (Object[])new Object[]{"dayOfWeek", dayOfWeek, "weekTemplate", weekTemplate});
        this.checkUsable();
        XAppointmentDateTemplate dateTemplate = new XAppointmentDateTemplate();
        ObjectListenerManager.disable((Object)dateTemplate);
        dateTemplate.setNew();
        dateTemplate.setProfessionnal(weekTemplate.getProfessionnal());
        dateTemplate.setNote("template for week " + weekTemplate.getNote());
        dateTemplate.setScale(Short.valueOf((short)this.getDateTemplateDefaultScale()));
        dateTemplate.setStartHour(Short.valueOf((short)this.getDateTemplateDefaultStartHour()));
        dateTemplate.setEndHour(Short.valueOf((short)this.getDateTemplateDefaultEndHour()));
        dateTemplate.setIsReusable(false);
        ObjectListenerManager.enable((Object)dateTemplate);
        dateTemplate.setListenerEnabled(true);
        weekTemplate.setDateTemplate(dayOfWeek, dateTemplate);
        return dateTemplate;
    }

    public XAppointmentWeekTemplate createNewAppointmentWeekTemplate() {
        Log.logOperation((String)"Controller.createNewAppointmentWeekTemplate", (Object[])new Object[0]);
        this.checkUsable();
        XAppointmentWeekTemplate weekTemplate = new XAppointmentWeekTemplate();
        ObjectListenerManager.disable((Object)weekTemplate);
        weekTemplate.setNew();
        weekTemplate.setNote(EXEMPLE);
        ObjectListenerManager.enable((Object)weekTemplate);
        this.addToClones(weekTemplate);
        return weekTemplate;
    }

    public void deleteWeekTemplate(XAppointmentWeekTemplate weekTemplate) {
        Log.logOperation((String)"Controller.deleteWeekTemplate", (Object[])new Object[]{"weekTemplate", weekTemplate});
        this.checkUsable();
        weekTemplate = this.clone(weekTemplate);
        weekTemplate.setIsDeleted(true);
        if (weekTemplate == this.currentWeekTemplate) {
            this.setCurrents(null, null, null);
        }
    }

    public void deleteDateTemplate(XAppointmentDateTemplate dateTemplate, XAppointmentWeekTemplate week, int dayOfWeek) {
        Log.logOperation((String)"Controller.deleteDateTemplate", (Object[])new Object[]{"dateTemplate", dateTemplate, "week", week, "dow", dayOfWeek});
        this.checkUsable();
        week.setListenerEnabled(true);
        week.setDateTemplate(dayOfWeek, null);
        if (dateTemplate == this.currentDateTemplate) {
            this.setCurrents(this.getCurrentWeekTemplate(), null, null);
        }
    }

    public void deleteDateTemplate(XAppointmentDateTemplate dateTemplate) {
        Log.logOperation((String)"Controller.deleteDateTemplate", (Object[])new Object[]{dateTemplate});
        this.checkUsable();
        if (dateTemplate != null) {
            dateTemplate = this.clone(dateTemplate);
            dateTemplate.setIsDeleted(true);
            if (dateTemplate == this.currentDateTemplate) {
                this.setCurrents(this.currentWeekTemplate, null, null);
            }
        }
    }

    public void closeAppointmentDate(List<LocalDate> dates) {
        Log.logOperation((String)"Controller.closeAppointmentDate", (Object[])new Object[]{dates});
        this.checkUsable();
        List<Integer> asList = this.setProfOrPersonGroup();
        this.getModel().checkCacheForAppointmentDates(dates, asList);
        ArrayList<XAppointmentDate> datesToClose = new ArrayList<XAppointmentDate>(dates.size());
        for (LocalDate localDate : dates) {
            XAppointmentDate appointmentDate = this.getAppointmentDate(localDate);
            if (appointmentDate == null) continue;
            datesToClose.add(appointmentDate);
        }
        if (datesToClose.size() > 0) {
            for (XAppointmentDate xAppointmentDate : datesToClose) {
                for (XAppointmentPeriod period : xAppointmentDate.getDateTemplate().getPeriods()) {
                    period.setIsClosed(Boolean.valueOf(true));
                }
                for (IAppointment appointment : this.getAppointments(xAppointmentDate)) {
                    XAppointment xappointment = (XAppointment)appointment;
                    if (appointment.getStatus() == XAppointmentStatus.TO_MOVE) continue;
                    XAppointment c = this.clone(xappointment);
                    c.setStatus(XAppointmentStatus.TO_MOVE);
                }
            }
            IStatus iStatus = this.saveAll();
            if (!iStatus.isOkToProceed()) {
                this.cancelAll();
            }
        }
    }

    public void deleteAppointmentDate(Collection<LocalDate> dates) {
        Log.logOperation((String)"Controller.deleteAppointmentDate", (Object[])new Object[]{dates});
        this.checkUsable();
        List<Integer> asList = this.setProfOrPersonGroup();
        this.getModel().checkCacheForAppointmentDates(dates, asList);
        ArrayList<XAppointmentDate> datesToDelete = new ArrayList<XAppointmentDate>(dates.size());
        for (LocalDate localDate : dates) {
            XAppointmentDate appointmentDate = this.getAppointmentDate(localDate);
            if (appointmentDate == null) continue;
            datesToDelete.add(appointmentDate);
        }
        if (datesToDelete.size() > 0) {
            for (XAppointmentDate xAppointmentDate : datesToDelete) {
                xAppointmentDate.setTag(null);
                xAppointmentDate.setIsDeleted(true);
            }
            IStatus iStatus = this.saveAll();
            if (!iStatus.isOkToProceed()) {
                this.cancelAll();
            }
        }
    }

    public void deleteAppointmentDate(LocalDate date) {
        Log.logOperation((String)"Controller.deleteAppointmentDate", (Object[])new Object[]{date});
        this.checkUsable();
        List<Integer> asList = this.setProfOrPersonGroup();
        this.getModel().checkCacheForAppointmentDates(date, asList.isEmpty() ? null : asList.get(0));
        XAppointmentDate appointmentDate = this.getAppointmentDate(date);
        if (appointmentDate != null) {
            appointmentDate.setTag(null);
            appointmentDate.setIsDeleted(true);
            IStatus status = this.saveAll();
            if (!status.isOkToProceed()) {
                this.cancelAll();
            }
        }
    }

    public void copyDateTemplateToWeekTemplate(XAppointmentDateTemplate dateTemplate, XAppointmentWeekTemplate weekTemplate, int dayOfWeek) {
        this.checkUsable();
        if (weekTemplate == null) {
            throw new NullPointerException("weekTemplate");
        }
        if (!weekTemplate.equals((Object)this.currentWeekTemplate)) {
            throw new IllegalStateException("weekTemplate != currentWeekTemplate");
        }
        if (dateTemplate != null) {
            XAppointmentDateTemplate newTemplate = dateTemplate.clone();
            newTemplate.setNew();
            newTemplate.setTag(null);
            newTemplate.setId(null);
            newTemplate.setNote(weekTemplate.getNote());
            newTemplate.setIsReusable(false);
            weekTemplate.setDateTemplate(dayOfWeek, newTemplate);
            this.setCurrentDateTemplate(newTemplate, false);
        }
    }

    public void moveDateTemplateWithinWeekTemplate(XAppointmentWeekTemplate weekTemplate, int fromDayOfWeek, int toDayOfWeek) {
        if (weekTemplate == null) {
            throw new IllegalArgumentException("weekTemplate cant be null");
        }
        if (!weekTemplate.equals((Object)this.currentWeekTemplate)) {
            throw new IllegalStateException("weekTemplate != currentWeekTemplate");
        }
        this.checkUsable();
        XAppointmentDateTemplate dateTemplate = weekTemplate.setDateTemplate(fromDayOfWeek, null);
        weekTemplate.setDateTemplate(toDayOfWeek, dateTemplate);
        this.setCurrentDateTemplate(dateTemplate, false);
    }

    public boolean assignDay(XAppointmentDateTemplate dateTemplateModel, LocalDate date) {
        this.checkUsable();
        XAppointmentDate appointmentDate = this.getAppointmentDate(date);
        if (dateTemplateModel == null) {
            if (appointmentDate == null) {
                return false;
            }
            appointmentDate.setIsDeleted(true);
            return true;
        }
        dateTemplateModel = this.getAppointmentDateTemplate(dateTemplateModel);
        if (appointmentDate == null) {
            appointmentDate = new XAppointmentDate();
            appointmentDate.setDate(date);
            appointmentDate.setProfessionnal(this.getCurrentProfessional().getId());
            XAppointmentDateTemplate dateTemplate = new XAppointmentDateTemplate();
            dateTemplate.setStartHour(dateTemplateModel.getStartHour());
            dateTemplate.setEndHour(dateTemplateModel.getEndHour());
            dateTemplate.setScale(dateTemplateModel.getScale());
            for (XAppointmentPeriod period : dateTemplateModel.getPeriods().getObject_NOT_WithStatus(EnumSet.of(ModificationStatus.STATUS_NON_EXISTING, ModificationStatus.STATUS_DELETED))) {
                XAppointmentPeriod newPeriod = period.clone();
                newPeriod.setId(null);
                newPeriod.setTag(null);
                newPeriod.setVersionDateTime(null);
                newPeriod.setModificationStatus(ModificationStatus.STATUS_NEW);
                dateTemplate.getPeriods().add((IMinimalEditableDataObject)newPeriod);
            }
            appointmentDate.setDateTemplate(dateTemplate);
            appointmentDate.setNew();
        } else {
            XAppointmentDateTemplate dateTemplate = appointmentDate.getDateTemplate();
            dateTemplate.setStartHour(dateTemplateModel.getStartHour());
            dateTemplate.setEndHour(dateTemplateModel.getEndHour());
            dateTemplate.setScale(dateTemplateModel.getScale());
            for (XAppointmentPeriod period : dateTemplate.getPeriods()) {
                period.setDeleted();
            }
            for (XAppointmentPeriod period : dateTemplateModel.getPeriods().getObject_NOT_WithStatus(EnumSet.of(ModificationStatus.STATUS_NON_EXISTING, ModificationStatus.STATUS_DELETED))) {
                XAppointmentPeriod newPeriod = period.clone();
                newPeriod.setId(null);
                newPeriod.setTag(null);
                newPeriod.setVersionDateTime(null);
                newPeriod.setModificationStatus(ModificationStatus.STATUS_NEW);
                dateTemplate.getPeriods().add((IMinimalEditableDataObject)newPeriod);
            }
            appointmentDate.setUpdated();
        }
        return true;
    }

    public void assignWeek(XAppointmentWeekTemplate weekTemplate, LocalDate dateInTheWeek) {
        this.checkUsable();
        weekTemplate = this.getAppointmentWeekTemplate(weekTemplate);
        LocalDate date = LocalDate.getFirstDayOfWeek((LocalDate)dateInTheWeek);
        int i = 0;
        while (i < 7) {
            this.assignDay(weekTemplate.getDay(i), LocalDate.fromDayFrom1970((int)(date.dayFrom1970 + i)));
            ++i;
        }
        IStatus status = this.saveAll();
        if (!status.isOkToProceed()) {
            this.cancelAll();
        }
    }

    @Override
    public void appointmentDatesChanged() {
        if (!this.isDisposed()) {
            this.proxy.appointmentDatesChanged();
        }
    }

    @Override
    public void appointmentsChanged() {
        if (!this.isDisposed()) {
            List<IMinimalEditableDataObject> notDirtyObjects = this.clones.findNotDirtyObjects();
            for (IMinimalEditableDataObject o : notDirtyObjects) {
                if (!(o instanceof XAppointment)) continue;
                XAppointment o2 = this.model.getAppointment(o.getId());
                this.clones.remove(o);
                this.addToClones(o2);
            }
            this.proxy.appointmentsChanged();
            if (this.currentAppointment != null && this.currentAppointment.getId() != null) {
                this.handleNotification(new DataObjectUpdatedNotification((IDataObject)this.currentAppointment));
            }
        }
    }

    @Override
    public void currentAppointmentChanged(XAppointment appt) {
        if (!this.isDisposed()) {
            this.proxy.currentAppointmentChanged((IAppointment)appt);
        }
    }

    @Override
    public void appointmentDateTemplatesChanged() {
        if (!this.isDisposed()) {
            this.proxy.appointmentDateTemplatesChanged();
        }
    }

    @Override
    public void appointmentWeekTemplateChanged() {
        if (!this.isDisposed()) {
            this.proxy.appointmentWeekTemplatesChanged();
        }
    }

    @Override
    public void baseAppointmentDatesChanged() {
        if (!this.isDisposed()) {
            this.proxy.baseAppointmentDatesChanged();
        }
    }

    @Override
    public void professionalsChanged() {
        if (!this.isDisposed()) {
            this.proxy.professionalsChanged();
        }
    }

    private <T extends EditableDataObject> T clone(T t) {
        EditableDataObject t2;
        if (t == null) {
            return null;
        }
        int index = this.clones.indexOf(t);
        if (index == -1) {
            t2 = t.clone();
            t2.setListenerEnabled(true);
            t2.setTag();
            this.clones.add((IMinimalEditableDataObject)t2);
        } else {
            t2 = (EditableDataObject)this.clones.get(index);
        }
        return (T)t2;
    }

    private <T extends IMinimalEditableDataObject> T addToClones(T t) {
        if (t == null) {
            return null;
        }
        int index = this.clones.indexOf(t);
        if (index == -1) {
            t.setTag();
            this.clones.add(t);
            return t;
        }
        return (T)this.clones.get(index);
    }

    private Model getModel() {
        return this.model;
    }

    public void cancelAll() {
        this.cancelCurrentReservation();
        List<IMinimalEditableDataObject> list = this.clones.findDirtyObjects();
        if (list.size() > 0) {
            this.clones.removeAll(list);
            for (IMinimalEditableDataObject e : list) {
                if (!(e instanceof XAppointment)) continue;
                if (e.equals(this.currentAppointment)) {
                    if (e.getId() == null) {
                        this.setCurrentAppointment(null);
                    } else {
                        XAppointment original = this.model.getAppointment(e.getId());
                        XAppointment appointment = this.clone(original);
                        this.setCurrentAppointment(appointment);
                    }
                }
                this.getAppointmentDate(((XAppointment)e).getDate()).meModified();
            }
            this.proxy.appointmentDatesChanged();
        }
    }

    public void cancelCurrentReservation() {
        if (this.currentReservedAppointment != null) {
            this.checkUsable();
            XObjectContainer2 container = new XObjectContainer2();
            container.add((IMinimalEditableDataObject)this.currentReservedAppointment);
            Crud2 crud2 = new Crud2(this.server, container, false, this.objectResolver.getDefaultStatusHandler());
            crud2.cancelReservation();
        }
    }

    public IStatus extendsReservation(XObjectContainer2 reservation) {
        ArrayList data;
        this.checkUsable();
        Crud2 crud2 = new Crud2(this.server, reservation, false, this.objectResolver.getDefaultStatusHandler());
        IStatus status = crud2.extendsReservation();
        if (status.isOkToProceed() && (data = (ArrayList)status.getData()) != null) {
            for (IMinimalEditableDataObject e : data) {
                if (!this.currentReservedAppointment.getTag().equals(e.getTag())) continue;
                this.currentReservedAppointment = (XReservedAppointment)e;
            }
        }
        return status;
    }

    public IStatus saveReservation(XObjectContainer2 reservation) {
        ArrayList data;
        this.currentReservedAppointment = reservation != null && reservation.size() == 1 ? (XReservedAppointment)reservation.get(0) : null;
        this.checkUsable();
        Crud2 crud2 = new Crud2(this.server, reservation, false, this.objectResolver.getDefaultStatusHandler());
        IStatus status = crud2.saveReservation();
        if (status.isOkToProceed() && (data = (ArrayList)status.getData()) != null) {
            for (IMinimalEditableDataObject e : data) {
                if (!this.currentReservedAppointment.getTag().equals(e.getTag())) continue;
                this.currentReservedAppointment = (XReservedAppointment)e;
            }
        }
        return status;
    }

    public IStatus saveAll() {
        return this.saveAll(true, this.objectResolver.getDefaultStatusHandler());
    }

    public IStatus saveAll(boolean askQuestion, IStatusHandler statusHandler) {
        this.logInfo("Controller" + this.controllerId + " Save all");
        this.checkUsable();
        Crud2 crud2 = new Crud2(this.server, this.clones, askQuestion, statusHandler);
        IStatus status = crud2.save();
        if (status.isOkToProceed()) {
            XObjectContainer data = (XObjectContainer)status.getData();
            if (data != null) {
                for (IMinimalEditableDataObject e : data.getObjects()) {
                    this.model.handle(new DataObjectUpdatedNotification((IDataObject)e));
                }
            }
            this.logInfo("Controller" + this.controllerId + " After successful save all controller dirty state is " + this.isDirty());
            if (this.isDirty()) {
                this.logInfo("Controller" + this.controllerId + " After successful save all controller objectToSave = \n\t" + new JoinList("\n\t", Crud2.getObjectToSaveNoLog(this.clones)));
            }
        } else {
            IStatus newerVersion;
            this.logInfo("Controller" + this.controllerId + " After non-successful save all controller dirty state is " + this.isDirty());
            if (this.isDirty()) {
                this.logInfo("Controller" + this.controllerId + " After successful save all controller objectToSave = \n\t" + new JoinList("\n\t", Crud2.getObjectToSaveNoLog(this.clones)));
            }
            if ((newerVersion = status.getStatus("RECORD_HAS_NEWER_VERSION")) == null) {
                newerVersion = status.getStatus("RECORD_HAS_NEWER_VERSION_RELOAD");
            }
            if (newerVersion != null) {
                this.model.refresFromServer((List<? extends IDataObject>)crud2.getSavedObjects());
                status = Status.OK_STATUS;
                this.logInfo("Controller" + this.controllerId + " After non-successful saveAll and managing newerVersion status, controller dirty state is " + this.isDirty());
                if (this.isDirty()) {
                    this.logSevere("Controller" + this.controllerId + " After successful save all controller objectToSave = \n\t" + new JoinList("\n\t", Crud2.getObjectToSaveNoLog(this.clones)));
                }
            }
        }
        return status;
    }

    public XAppointment saveAll2() {
        XObjectContainer data;
        IStatus status = this.saveAll();
        if (!status.isOkToProceed()) {
            this.cancelAll();
        }
        if ((data = (XObjectContainer)status.getData()) != null) {
            for (IMinimalEditableDataObject e : data.getObjects()) {
                if (!(e instanceof XAppointment)) continue;
                return (XAppointment)e;
            }
        }
        return null;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.currentProfessional != null && this.currentCalendarDates != null) {
            this.getModel().markAsUnusing(this.currentProfessional, this.currentCalendarDates);
        }
        this.getModel().removeListener(this);
        ObjectListenerManager.removeListener((IObjectListener)this);
        this.manager.clear();
        this.proxy = null;
        this.model = null;
        this.currentCalendarDates.clear();
        this.currentProfessional = null;
        this.currentAppointment = null;
        this.currentDateTemplate = null;
        this.currentWeekTemplate = null;
        this.currentPeriod = null;
        this.currentCalendarDate = null;
        this.cursorStartDate = null;
        this.cursorEndDate = null;
    }

    public boolean isUsable() {
        return this.currentProfessional != null && !this.isDisposed();
    }

    private void checkUsable() {
        if (!this.isUsable()) {
            throw new IllegalStateException("controller is not useable. currentProfessionnal=" + this.currentProfessional + "; isDisposed=" + this.isDisposed());
        }
    }

    private void checkDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("controller is disposed");
        }
    }

    public void addListener(ControllerListener listener) {
        this.checkDisposed();
        this.manager.addListener((Object)listener);
    }

    public void removeListener(ControllerListener listener) {
        this.manager.removeListener((Object)listener);
    }

    public boolean isDirty() {
        return this.clones.isDirty();
    }

    public boolean isSaving() {
        return false;
    }

    private void unregister(EditableDataObject e) {
        ObjectListenerManager.removeListener((Object)e, (IObjectListener)this);
    }

    private void register(EditableDataObject e) {
        if (e != null) {
            e.setListenerEnabled(true);
            if (e instanceof XAppointment) {
                ObjectListenerManager.addListener((Object)e, (IObjectListener)this);
            }
            if (e instanceof XAppointmentWeekTemplate) {
                ObjectListenerManager.addListener((Object)e, (IObjectListener)this);
            }
            if (e instanceof XAppointmentDateTemplate) {
                ObjectListenerManager.addListener((Object)e, (IObjectListener)this);
            }
        }
    }

    private void removeNonDirtyFromClones(IMinimalEditableDataObject e) {
        if (e != null && !e.isDirty() && this.clones.contains(e)) {
            this.clones.remove(e);
        }
        this.logInfo("Clones size " + this.clones.size());
    }

    public String toString() {
        return "";
    }

    @Override
    public synchronized void handleNotification(DataObjectUpdatedNotification notification) {
        XAppointment a;
        if (!this.isUsable()) {
            return;
        }
        if (notification == null) {
            return;
        }
        IDataObject object = notification.getObject();
        if (object instanceof XAppointment) {
            a = (XAppointment)object;
            if (!(this.getCurrentCalendarDates().contains(a.getDate()) && a.getIdProfessionals().contains(this.getCurrentProfessional().getId()) || this.clones.contains((IMinimalEditableDataObject)a))) {
                return;
            }
        } else if (object instanceof XAppointmentDate) {
            a = (XAppointmentDate)object;
            if (!a.getProfessional().equals(this.getCurrentProfessional().getId())) {
                return;
            }
        } else if (object instanceof XReservedAppointment) {
            a = (XReservedAppointment)object;
            if (!this.getCurrentCalendarDates().contains(a.getDate()) || !this.getCurrentProfessional().getId().equals(a.getIdProfessional())) {
                return;
            }
        } else if (object instanceof XAppointmentDateKey) {
            a = (XAppointmentDateKey)object;
            if (!this.getCurrentProfessional().getId().equals(a.professional)) {
                return;
            }
        }
        this.logInfo("Controller" + this.controllerId + " handle notification " + object);
        if (object instanceof XReservedAppointment) {
            XReservedAppointment xreserved = (XReservedAppointment)object;
            this.proxy.reservedAppointmentChanged(xreserved);
            List<XAppointmentDate> list = this.internal_getAppointmentDates(xreserved);
            for (XAppointmentDate xdate : list) {
                xdate.meModified();
            }
        } else if (object instanceof EditableDataObject) {
            XAppointmentDate xdate;
            XAppointmentDate xdate2;
            EditableDataObject eFromOutside = (EditableDataObject)object;
            EditableDataObject clone = eFromOutside.clone();
            if (eFromOutside.getTag() != null) {
                clone.setTag(eFromOutside.getTag());
            } else {
                clone.setTag();
                this.logInfo("Controller" + this.controllerId + " eFromOutside had no tag, setting a new tag is " + clone.getTag());
            }
            boolean replaced = this.clones.replace((IMinimalEditableDataObject)clone);
            if (replaced) {
                clone.setListenerEnabled(true);
            }
            if (Controller.equalsTagOnly((IMinimalEditableDataObject)this.currentAppointment, (IMinimalEditableDataObject)eFromOutside)) {
                this.setCurrentAppointment((XAppointment)clone);
            } else if (Controller.equalsTagOnly((IMinimalEditableDataObject)this.currentWeekTemplate, (IMinimalEditableDataObject)eFromOutside)) {
                int dayOfWeek = -1;
                if (this.currentDateTemplate != null) {
                    dayOfWeek = this.currentWeekTemplate.getDayOfWeek(this.currentDateTemplate);
                }
                this.currentWeekTemplate = (XAppointmentWeekTemplate)clone;
                clone.setListenerEnabled(true);
                if (dayOfWeek != -1) {
                    this.currentDateTemplate = this.currentWeekTemplate.getDay(dayOfWeek);
                }
                if (this.currentPeriod != null && this.currentDateTemplate != null) {
                    this.currentPeriod = this.currentDateTemplate.getPeriod(this.currentPeriod.getStartTime(), this.currentPeriod.getEndTime());
                }
                this.proxy.currentWeekTemplateChanged();
                this.proxy.currentDateTemplateChanged();
                this.proxy.currentPeriodChanged();
            } else if (Controller.equalsTagOnly((IMinimalEditableDataObject)this.currentDateTemplate, (IMinimalEditableDataObject)eFromOutside)) {
                this.currentDateTemplate = (XAppointmentDateTemplate)clone;
                clone.setListenerEnabled(true);
                if (this.currentPeriod != null) {
                    this.currentPeriod = this.currentDateTemplate.getPeriod(this.currentPeriod.getStartTime(), this.currentPeriod.getEndTime());
                }
                this.proxy.currentDateTemplateChanged();
                this.proxy.currentPeriodChanged();
            } else if (Controller.equalsOnly((IMinimalEditableDataObject)this.currentAppointment, (IMinimalEditableDataObject)eFromOutside)) {
                if (this.currentAppointment.isDirty()) {
                    this.proxy.beforeCurrentAppointmentChanged();
                    this.setCurrentAppointment((XAppointment)clone);
                } else {
                    this.setCurrentAppointment((XAppointment)clone);
                }
            } else if (eFromOutside instanceof XAppointmentDate && (xdate2 = this.clones.findAppointmentDate((xdate = (XAppointmentDate)eFromOutside).getDate(), xdate.getProfessional())) != null) {
                this.clones.remove((IMinimalEditableDataObject)xdate2);
                this.proxy.appointmentDatesChanged();
                XAppointmentDate xdate3 = this.clone(xdate);
                if (xdate2.getDateTemplate().equals((Object)this.currentDateTemplate)) {
                    this.setCurrentDateTemplate(xdate3.getDateTemplate(), false);
                    if (this.currentPeriod != null) {
                        this.setCurrentPeriod(this.currentDateTemplate.getPeriod(this.currentStartTime, this.currentEndTime));
                    }
                }
            }
            if (clone instanceof XAppointment) {
                this.proxy.appointmentChanged((IAppointment)((XAppointment)clone));
                List<XAppointmentDate> list = this.internal_getAppointmentDates((XAppointment)clone);
                for (XAppointmentDate xdate3 : list) {
                    xdate3.meModified();
                }
            }
            if (clone instanceof IPatient) {
                final XPatient patient = this.objectResolver.getSimplePatient(clone);
                this.clones.iterator(new ClosureA<IMinimalEditableDataObject>(){

                    public void execute(IMinimalEditableDataObject c) {
                        if (c instanceof XAppointment) {
                            XAppointment appointment = (XAppointment)c;
                            boolean equalsCurrentAppointment = Controller.equalsOnly((IMinimalEditableDataObject)Controller.this.currentAppointment, (IMinimalEditableDataObject)appointment);
                            List patients = appointment.getPatients();
                            boolean beforeNotificationSent = false;
                            int indexOf = patients.indexOf(patient);
                            if (indexOf != -1) {
                                if (equalsCurrentAppointment && !beforeNotificationSent) {
                                    Controller.this.proxy.beforeCurrentAppointmentChanged();
                                    beforeNotificationSent = true;
                                }
                                ObjectListenerManager.disable((Object)patients);
                                patients.set(indexOf, patient);
                                ObjectListenerManager.disable((Object)patients);
                                Controller.this.proxy.appointmentChanged((IAppointment)((XAppointment)c));
                            }
                            if (equalsCurrentAppointment) {
                                Controller.this.proxy.currentAppointmentChanged((IAppointment)appointment);
                            }
                        }
                    }
                });
            }
        }
    }

    private static boolean equalsOnly(IMinimalEditableDataObject o1, IMinimalEditableDataObject o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (!o1.getClass().equals(o2.getClass())) {
            return false;
        }
        return o1.equals(o2);
    }

    private static boolean equalsTagOnly(IMinimalEditableDataObject o1, IMinimalEditableDataObject o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (!o1.getClass().equals(o2.getClass())) {
            return false;
        }
        return o1.equalsByTag(o2);
    }

    private List<XAppointmentDate> internal_getAppointmentDates(XAppointment appointment) {
        XAppointmentDate xdate;
        final List<LocalDate> currentDates = this.getCurrentCalendarDates();
        final Integer currentProfId = this.getCurrentProfessional().getId();
        final ArrayList<XAppointmentDate> list = new ArrayList<XAppointmentDate>();
        LocalDate date = appointment.getDate();
        if (currentProfId != null && appointment.getIdProfessionals() != null && appointment.getIdProfessionals().contains(currentProfId) && (xdate = this.model.getDateFromCache(date, currentProfId)) != null) {
            list.add(xdate);
        }
        this.clones.iterator(new ClosureA<IMinimalEditableDataObject>(){

            public void execute(IMinimalEditableDataObject e) {
                if (e instanceof XAppointmentDate) {
                    XAppointmentDate a = (XAppointmentDate)e;
                    int index = list.indexOf(e);
                    if (index != -1) {
                        list.set(index, a);
                    } else if (currentDates.contains(a.getDate()) && a.getProfessional().equals(currentProfId)) {
                        list.add(a);
                    }
                }
            }
        });
        this.logInfo("internal_xdate size " + list.size());
        return list;
    }

    private List<XAppointmentDate> internal_getAppointmentDates(XReservedAppointment reservedAppointment) {
        final ArrayList<XAppointmentDate> list = new ArrayList<XAppointmentDate>();
        final Integer prof = reservedAppointment.getIdProfessional();
        final LocalDate date = reservedAppointment.getDate();
        XAppointmentDate xdate = this.model.getDateFromCache(date, prof);
        if (xdate != null) {
            list.add(xdate);
        }
        this.clones.iterator(new ClosureA<IMinimalEditableDataObject>(){

            public void execute(IMinimalEditableDataObject e) {
                if (e instanceof XAppointmentDate) {
                    XAppointmentDate a = (XAppointmentDate)e;
                    int index = list.indexOf(e);
                    if (index != -1) {
                        list.set(index, a);
                    } else if (a.getDate().equals((Object)date) && a.getProfessional().equals(prof)) {
                        list.add(a);
                    }
                }
            }
        });
        return list;
    }

    public void objectModified(Object object) {
        if (object instanceof XAppointment) {
            XAppointment a = (XAppointment)object;
            XAppointmentDate xdate = this.getAppointmentDate(a.getDate());
            ObjectListenerManager.fireObjectModified((Object)xdate);
        }
        this.proxy.objectModified(object);
    }

    public boolean isMoveBaseAppointmentDateMonth() {
        return this.moveBaseAppointmentDateMonth;
    }

    public void setMoveBaseAppointmentDateMonth(boolean moveBaseAppointmentDateMonth) {
        this.moveBaseAppointmentDateMonth = moveBaseAppointmentDateMonth;
    }

    public boolean isMoveAppointmentDateWeek() {
        return this.moveAppointmentDateWeek;
    }

    public void setMoveAppointmentDateWeek(boolean moveAppointmentDateWeek) {
        this.moveAppointmentDateWeek = moveAppointmentDateWeek;
    }

    public IUserInteractionHelper getHelper() {
        return this.helper;
    }

    public IControllerObjectResolver getObjectResolver() {
        return this.objectResolver;
    }

    @Override
    public void appointmentPeriodTypesChanged() {
        this.proxy.appointmentPeriodTypesChanged();
    }

    private /* synthetic */ void lambda$2(Set set, IEditableDataObjectList iEditableDataObjectList, LocalDate localDate, XBaseProfessionnal prof) {
        set.add(prof.getId());
        iEditableDataObjectList.addAll(this.model.getAppointments(localDate, prof.getId()));
    }

    public static interface ControllerListener
    extends IObjectListener<Object> {
        public void appointmentDatesChanged();

        public void appointmentDateTemplatesChanged();

        public void appointmentPeriodTypesChanged();

        public void appointmentTypesChanged();

        public void appointmentWeekTemplatesChanged();

        public void baseAppointmentDatesChanged();

        public void appointmentsChanged();

        public void objectModified(Object var1);

        public void professionalsChanged();

        public void currentStartTimeChanged();

        public void currentEndTimeChanged();

        public void currentPeriodChanged();

        public void currentCalendarDateChanged();

        public void currentCalendarDatesChanged();

        public void currentProfessionalChanged();

        public void currentDateTemplateChanged();

        public void currentWeekTemplateChanged();

        public void beforeCurrentAppointmentChanged();

        public void currentAppointmentChanged(IAppointment var1);

        public void appointmentChanged(IAppointment var1);

        public void usableStateChanged(boolean var1);

        public void reservedAppointmentChanged(XReservedAppointment var1);
    }
}

