/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.appointment.IAppointmentPluginController;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XConsultationReason;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.ui.appointment.AppointmentPluginController;
import ca.infodata.ofys.ui.appointment.editor.AppointmentMainEditor;
import ca.infodata.ofys.ui.appointment.editor.AppointmentMainEditorInput;
import ca.infodata.ofys.ui.appointment.editor.model2.Model;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.util1.PredicateA;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AppointmentPlugin
extends AbstractUIPlugin {
    public static final String SHOW_DELETED_APPOINTMENT_PREF = "appointment/show_deleted_appointment";
    public static final String SHOW_CANCELED_APPOINTMENT_PREF = "appointment/show_canceled_appointment";
    public static final String LAST_OPENED_EDITOR_TYPE = "appointment/last-opened-editor-type";
    public static final String SINGLE_PROF_EDITOR = "single-prof";
    public static final String MULTI_PROF_EDITOR = "multi-prof";
    public static final String SINGLE_PROF_EDITOR_INPUT = "appointment/single-prof-input";
    public static final String MULTI_PROF_EDITOR_INPUT = "appointment/multi-prof-input";
    public static final int PROP_APPOINTMENT_NOTIFICATION = 1;
    public static final int PROP_APPOINTMENT_DATE_NOTIFICATION = 2;
    private static AppointmentPlugin plugin;
    private static IStatusHandler statusHandler;
    private final GlobalInstancesAdapter sessionListener = new GlobalInstancesAdapter(){

        public void logout() {
            if (Application.get().getGlobalInstances().getSession() == null) {
                Model.disposeInstance();
            }
        }
    };
    private AppointmentPluginController appointmentPluginController;
    private XPatientRecall patientRecallTemp;

    static {
        statusHandler = ControlsPlugin.getDefaultStatusHandler();
    }

    public AppointmentPlugin() {
        plugin = this;
    }

    public static void setDefaultStatusHandler(IStatusHandler statusHandler) {
        if (statusHandler == null) {
            throw new NullPointerException("statusHandler");
        }
        AppointmentPlugin.statusHandler = statusHandler;
    }

    public static IStatusHandler getDefaultStatusHandler() {
        return statusHandler;
    }

    public void start(BundleContext context) throws Exception {
        System.out.println("AppointmentPlugin.start()");
        super.start(context);
        this.appointmentPluginController = new AppointmentPluginController();
        Application.get().setAppointmentPluginController((IAppointmentPluginController)this.appointmentPluginController);
        Application.get().getGlobalInstances().addGlobalInstancesListener((GlobalInstancesListener)this.sessionListener);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static AppointmentPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"ca.infodata.ofys.ui.appointment", (String)path);
    }

    public XAppointmentPeriodType getPeriodType(Integer idType) {
        return this.appointmentPluginController.getPeriodType(idType);
    }

    public List<XAppointmentPeriodType> getPeriodTypes() {
        return this.appointmentPluginController.getPeriodTypes();
    }

    public XAppointmentType getAppointmentType(Integer id) {
        return this.appointmentPluginController.getAppointmentType(id);
    }

    public List<XAppointmentType> getAppointmentTypes() {
        return this.appointmentPluginController.getAppointmentTypes();
    }

    public XConsultationReason getConsultationReason(String id) {
        return this.appointmentPluginController.getConsultationReason(id);
    }

    public List<XBaseProfessionnal> getProfessionnals() {
        return this.appointmentPluginController.findNonDeletedProfessionnalsThatUseAppointments();
    }

    public int getDefaultTemplateStartHour() {
        return this.appointmentPluginController.getDefaultTemplateStartHour();
    }

    public int getDefaultTemplateEndHour() {
        return this.appointmentPluginController.getDefaultTemplateEndHour();
    }

    public int getDefaultTemplateScale() {
        return this.appointmentPluginController.getDefaultTemplateScale();
    }

    public XAppointmentType getDefaultAppointmentType() {
        return this.appointmentPluginController.getDefaultAppointmentType();
    }

    public XAppointmentPeriodType getDefaultAppointmentPeriodType() {
        return this.appointmentPluginController.getDefaultAppointmentPeriodType();
    }

    public boolean canSeeAndModifyAppointment(IAppointment appointment) {
        return this.appointmentPluginController.canSeeAndModifyAppointment(appointment);
    }

    public Comparator<IAppointment> getXAppointmentComparator(boolean ASC) {
        return this.appointmentPluginController.getXAppointmentComparator(ASC);
    }

    public Comparator<XPatientRecall> getXRecallComparator(boolean ASC) {
        return this.appointmentPluginController.getXRecallComparator(ASC);
    }

    public void openAppointmentEditor(String inputId, IAppointment appointment) {
        AppointmentMainEditorInput input = new AppointmentMainEditorInput("AppointmentMainEditor");
        input.setProfessional(appointment.getIdProfessional());
        List references = BaseEditor.findOpenEditorReferences((PredicateA)new BaseEditor.EditorNameAndInputFilter(AppointmentMainEditor.class.getName(), (IEditorInput)input));
        if (references.size() > 0) {
            AppointmentMainEditor editor = (AppointmentMainEditor)((IEditorReference)references.get(0)).getEditor(false);
            editor.setEditorStateTo_DATE(appointment);
            BaseEditor.setActiveEditor((IEditorPart)editor);
        } else {
            input.setAppointment(appointment);
            BaseEditor.openEditorSafe((IEditorInput)input, (String)AppointmentMainEditor.class.getName());
        }
    }

    public XPatientRecall getPatientRecallTemp() {
        return this.patientRecallTemp;
    }

    public void setPatientRecallTemp(XPatientRecall patientRecallTemp) {
        this.patientRecallTemp = patientRecallTemp;
    }

    public RGB getColorByStatus(XAppointmentStatus appointmentStatus) {
        int[] color = this.appointmentPluginController.getColorByStatus(appointmentStatus);
        return ResourceGetter.getRGB((int[])color);
    }

    public RGB getColorByPatientStatus(XPatientStatus patientStatus) {
        int[] color = this.appointmentPluginController.getColorByPatientStatus(patientStatus);
        return ResourceGetter.getRGB((int[])color);
    }

    public RGB getColorByAppointmentType(XAppointmentType type) {
        int[] color = this.appointmentPluginController.getColorByAppointmentType(type);
        return ResourceGetter.getRGB((int[])color);
    }

    public RGB getColorByAppointmentPeriodType(XAppointmentPeriodType type) {
        int[] color = this.appointmentPluginController.getColorByAppointmentPeriodType(type);
        return ResourceGetter.getRGB((int[])color);
    }
}

