/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IndexedListIterator<E>
implements Iterator<E> {
    private final List<E> list;
    private final int[] indexes;
    private int currentIndex;
    private int nextIndex;

    public IndexedListIterator(List<E> list, int ... indexes) {
        this.list = list;
        this.indexes = indexes;
        this.nextIndex = this.currentIndex = 0;
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.indexes.length;
    }

    @Override
    public E next() {
        this.currentIndex = this.nextIndex++;
        E e = this.list.get(this.indexes[this.currentIndex]);
        return e;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        ArrayList<Integer> a = new ArrayList<Integer>();
        a.add(0);
        a.add(1);
        a.add(2);
        a.add(3);
        a.add(4);
        a.add(5);
        System.out.println(a);
        IndexedListIterator iterator = new IndexedListIterator(a, 0, 3, 4, 5, 1);
        while (iterator.hasNext()) {
            Integer i = (Integer)iterator.next();
            System.out.println("value " + i);
        }
    }
}

