/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util;

import java.util.ArrayList;
import java.util.List;

public class BooleanArrayList {
    private static final int DEFAULT_CAPACITY = 16;
    private boolean[] array;
    private int size = 0;

    public BooleanArrayList() {
        this(16);
    }

    public BooleanArrayList(int capacity) {
        this.array = new boolean[capacity];
    }

    public BooleanArrayList(boolean ... b) {
        this.array = b;
    }

    public boolean set(int index, boolean value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index : " + index);
        }
        boolean old = this.array[index];
        this.array[index] = value;
        return old;
    }

    public void add(boolean value) {
        this.ensureCapacity(this.size + 1);
        this.array[this.size] = value;
        ++this.size;
    }

    public boolean get(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index : " + index);
        }
        return this.array[index];
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.array.length) {
            int newCap = Math.max(this.array.length << 1, capacity);
            boolean[] tmp = new boolean[newCap];
            System.arraycopy(this.array, 0, tmp, 0, this.array.length);
            this.array = tmp;
        }
    }

    public boolean contains(boolean i) {
        return this.indexOf(i) != -1;
    }

    public boolean containsOnly(boolean i) {
        return !this.contains(i);
    }

    public int count(boolean i) {
        int c = 0;
        for (boolean element : this.array) {
            if (element != i) continue;
            ++c;
        }
        return c;
    }

    public int indexOf(boolean i) {
        for (int j = 0; j < this.array.length; ++j) {
            if (this.array[j] != i) continue;
            return j;
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        int iMax = this.size - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.array[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public int[] toArray() {
        int[] result = new int[this.size];
        System.arraycopy(this.array, 0, result, 0, this.size);
        return result;
    }

    public List<Boolean> toList() {
        ArrayList<Boolean> list = new ArrayList<Boolean>(this.size);
        for (int i = 0; i < this.size; ++i) {
            list.add(this.array[i]);
        }
        return list;
    }

    public void addAll(boolean[] array) {
        this.ensureCapacity(this.size + array.length);
        boolean[] blArray = array;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            boolean element;
            this.array[this.size] = element = blArray[i];
            ++this.size;
        }
    }
}

