/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.mb.listener.property;

import ca.infodata.ofys.mb.listener.property.IPropertyListener2;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mb.listeners.GenListenerManager;
import org.mb.listeners.IListenerManager;

public final class PropertyListenerManager2 {
    private static final Logger logger = Logger.getLogger(PropertyListenerManager2.class.getName());
    static final PropertyListenerManager2 instance = new PropertyListenerManager2();
    final ConcurrentHashMap<Key, GenListenerManager<IPropertyListener2>> managers = new ConcurrentHashMap();
    final ConcurrentHashMap<Key, Boolean> disabledObjects = new ConcurrentHashMap();
    private final Class _interface = IPropertyListener2.class;
    private Thread cleanupThread;

    protected PropertyListenerManager2() {
        this.createAndStartCleanupThread();
    }

    private void createAndStartCleanupThread() {
        this.cleanupThread = new ThreadExtension("ListenerManager cleanup thread");
        this.cleanupThread.setPriority(1);
        this.cleanupThread.setDaemon(true);
        this.cleanupThread.start();
    }

    public static void addListener(Object object, IPropertyListener2 listener) {
        if (listener == null || object == null) {
            return;
        }
        Key key = new Key(object);
        GenListenerManager manager = PropertyListenerManager2.instance.managers.get(key);
        if (manager == null) {
            manager = new GenListenerManager(PropertyListenerManager2.instance._interface);
            PropertyListenerManager2.instance.managers.put(key, (GenListenerManager<IPropertyListener2>)manager);
        }
        manager.addListener((Object)listener);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "PropertyListenerManager.addListener " + key + " " + listener);
        }
    }

    public static void removeListener(Object object, IPropertyListener2 listener) {
        if (object == null || listener == null) {
            return;
        }
        Key key = new Key(object);
        GenListenerManager<IPropertyListener2> manager = PropertyListenerManager2.instance.managers.get(key);
        if (manager != null) {
            manager.removeListener((Object)listener);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "PropertyListenerManager.removeListener " + key + " " + listener);
        }
    }

    public static void removeListener(IPropertyListener2 listener) {
        IListenerManager[] array;
        if (listener == null) {
            return;
        }
        for (IListenerManager element : array = PropertyListenerManager2.instance.managers.values().toArray(new IListenerManager[0])) {
            element.removeListener((Object)listener);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "PropertyListenerManager.removeListener " + listener);
        }
    }

    public static void remove(Object object) {
        if (object == null) {
            return;
        }
        Key key = new Key(object);
        GenListenerManager<IPropertyListener2> manager = PropertyListenerManager2.instance.managers.get(key);
        if (manager != null) {
            manager.clear();
        }
        PropertyListenerManager2.instance.managers.remove(key);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "PropertyListenerManager.remove " + key);
        }
    }

    public static boolean isListenerOn(Object object, IPropertyListener2 listener) {
        boolean listenerOn;
        if (object == null || listener == null) {
            return false;
        }
        Key key = new Key(object);
        GenListenerManager<IPropertyListener2> manager = PropertyListenerManager2.instance.managers.get(key);
        boolean bl = listenerOn = manager != null && manager.isListener((Object)listener);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "PropertyListenerManager.listenerOn " + key + " : " + listenerOn);
        }
        return listenerOn;
    }

    public static boolean isListened(Object object) {
        boolean listened;
        if (object == null) {
            return false;
        }
        Key key = new Key(object);
        boolean bl = listened = PropertyListenerManager2.instance.managers.get(key) != null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "PropertyListenerManager.isListened " + key + " : " + listened);
        }
        return listened;
    }

    public static void firePropertyChanged(Object object, int propertyId, Object arg) {
        if (object == null) {
            return;
        }
        Key key = new Key(object);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "PropertyListenerManager.firePropertyChanged " + key);
        }
        if (PropertyListenerManager2.instance.disabledObjects.containsKey(key)) {
            PropertyListenerManager2.instance.disabledObjects.put(key, true);
        } else {
            GenListenerManager<IPropertyListener2> manager = PropertyListenerManager2.instance.managers.get(key);
            if (manager != null) {
                ((IPropertyListener2)manager.getProxy()).propertyChanged(propertyId, arg);
            }
        }
    }

    private final class ThreadExtension
    extends Thread {
        private ThreadExtension(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            while (true) {
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ConcurrentHashMap<Key, GenListenerManager<IPropertyListener2>> concurrentHashMap = PropertyListenerManager2.this.managers;
                synchronized (concurrentHashMap) {
                    logger.finer("Cleaning listeners....");
                    Iterator<Map.Entry<Key, GenListenerManager<IPropertyListener2>>> iterator = PropertyListenerManager2.this.managers.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Key, GenListenerManager<IPropertyListener2>> item = iterator.next();
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finer("Cleaning... " + item.getKey());
                        }
                        if (((IPropertyListener2[])item.getValue().getListeners()).length != 0) continue;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("No listener on manager " + item.getValue() + " for hashcode " + item.getKey() + ". Removed");
                        }
                        iterator.remove();
                    }
                }
            }
        }
    }

    public static final class Key {
        final String objectClassName;
        final WeakReference<Object> object;
        final int hashcode;

        public Key(Object object) {
            this.objectClassName = object.getClass().getName();
            this.object = new WeakReference<Object>(object);
            this.hashcode = System.identityHashCode(object);
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return this.hashcode == other.hashcode;
        }

        public String toString() {
            StringBuilder b = new StringBuilder(100);
            b.append("Key [");
            b.append(this.objectClassName);
            b.append(", ");
            b.append(this.object.get());
            b.append(", ");
            b.append(this.hashcode);
            b.append("]");
            return b.toString();
        }

        public String getObjectClassName() {
            return this.objectClassName;
        }

        public Object getObject() {
            return this.object.get();
        }
    }
}

