/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.site;

import ca.infodata.ofys.data.middle.dataobjects.XCity;
import ca.infodata.ofys.data.middle.dataobjects.XCountry;
import ca.infodata.ofys.data.middle.dataobjects.XProvince;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XSiteB2b;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.util.Arrays;
import java.util.List;

public final class XSite
extends EditableDataObject
implements ICompletionComboItem {
    private static final long serialVersionUID = 1L;
    public static String type = "site";
    public Integer id;
    @FieldSerializer.NotNull
    public String nameOfficial;
    public String nameCommon;
    public transient List<String> searchWord;
    public String code;
    public int[] color;
    public Boolean isDeleted;
    public Boolean isDrugStore;
    public Boolean isWorkSite;
    public String phonenumber1;
    public String phonenumber2;
    public String street;
    public String postalCode;
    public String note;
    public String faxAccount;
    public String faxUser;
    public String faxPasswd;
    public String faxNumber;
    public XCountry country;
    public XCity city;
    public XProvince province;
    public String dsqNiu;
    public String rrssNiu;
    public XSiteB2b b2bInformations;
    public Boolean patientCanSetArrived;
    public Boolean patientCanCancelAppointment;
    public Integer survey2Q;
    public String aptMsgFr;
    public String aptMsgEn;

    @Override
    public void initialize() {
        this.setNew();
        this.setNameOfficial("");
        this.setNameCommon("");
        this.setCode("");
        this.setPhonenumber1("");
        this.setPhonenumber2("");
        this.setStreet("");
        this.setPostalCode("");
        this.setNote("");
        this.setIsDeleted(false);
        this.setIsDrugStore(false);
        this.setIsWorkSite(false);
        this.setCity(new XCity());
        this.getCity().initialize();
        this.getCity().modificationStatus.plain_set(ModificationStatus.STATUS_NEUTRAL);
        this.setProvince(new XProvince());
        this.getProvince().initialize();
        this.getProvince().modificationStatus.plain_set(ModificationStatus.STATUS_NEUTRAL);
        this.setCountry(new XCountry());
        this.getCountry().initialize();
        this.getCountry().modificationStatus.plain_set(ModificationStatus.STATUS_NEUTRAL);
        this.setB2bInformations(new XSiteB2b());
        this.modificationStatus.plain_set(ModificationStatus.STATUS_NEUTRAL);
    }

    @Override
    public boolean isDirty() {
        boolean dirty = super.isDirty() || this.country != null && this.country.isDirty() || this.city != null && this.city.isDirty() || this.province != null && this.province.isDirty() || this.b2bInformations != null && this.b2bInformations.isDirty();
        return dirty;
    }

    public Boolean getIsDrugStore() {
        return this.isDrugStore;
    }

    public void setIsDrugStore(Boolean isDrugStore) {
        this.isDrugStore = isDrugStore;
        this.setUpdated();
    }

    public String getPhonenumber1() {
        return this.phonenumber1;
    }

    public void setPhonenumber1(String phonenumber1) {
        this.phonenumber1 = phonenumber1;
        this.setUpdated();
    }

    public String getPhonenumber2() {
        return this.phonenumber2;
    }

    public void setPhonenumber2(String phonenumber2) {
        this.phonenumber2 = phonenumber2;
        this.setUpdated();
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
        this.setUpdated();
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
        this.setUpdated();
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
        this.setUpdated();
    }

    public String getFaxAccount() {
        return this.faxAccount;
    }

    public void setFaxAccount(String faxAccount) {
        this.faxAccount = faxAccount;
        this.setUpdated();
    }

    public String getFaxUser() {
        return this.faxUser;
    }

    public void setFaxUser(String faxUser) {
        this.faxUser = faxUser;
        this.setUpdated();
    }

    public String getFaxPasswd() {
        return this.faxPasswd;
    }

    public void setFaxPasswd(String faxPasswd) {
        this.faxPasswd = faxPasswd;
        this.setUpdated();
    }

    public String getFaxNumber() {
        return this.faxNumber;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
        this.setUpdated();
    }

    public XCountry getCountry() {
        return this.country;
    }

    public void setCountry(XCountry country) {
        this.country = country;
        this.setUpdated();
    }

    public XCity getCity() {
        return this.city;
    }

    public void setCity(XCity city) {
        this.city = city;
        this.setUpdated();
    }

    public XProvince getProvince() {
        return this.province;
    }

    public void setProvince(XProvince province) {
        this.province = province;
        this.setUpdated();
    }

    @Override
    public XSite clone() {
        XSite c = (XSite)super.clone();
        c.id = this.id;
        c.code = this.code;
        c.isDrugStore = this.isDrugStore;
        c.isWorkSite = this.isWorkSite;
        c.phonenumber1 = this.phonenumber1;
        c.phonenumber2 = this.phonenumber2;
        c.faxAccount = this.faxAccount;
        c.faxUser = this.faxUser;
        c.faxPasswd = this.faxPasswd;
        c.faxNumber = this.faxNumber;
        c.street = this.street;
        c.postalCode = this.postalCode;
        c.note = this.note;
        c.isDeleted = this.isDeleted;
        c.nameCommon = this.nameCommon;
        c.nameOfficial = this.nameOfficial;
        int[] nArray = c.color = this.color == null ? null : Arrays.copyOf(this.color, this.color.length);
        if (this.country != null) {
            c.country = this.country.clone();
        }
        if (this.city != null) {
            c.city = this.city.clone();
        }
        if (this.province != null) {
            c.province = this.province.clone();
        }
        c.dsqNiu = this.dsqNiu;
        c.rrssNiu = this.rrssNiu;
        if (this.b2bInformations != null) {
            c.b2bInformations = (XSiteB2b)this.b2bInformations.clone();
        }
        c.patientCanCancelAppointment = this.patientCanCancelAppointment;
        c.patientCanSetArrived = this.patientCanSetArrived;
        c.survey2Q = this.survey2Q;
        c.aptMsgFr = this.aptMsgFr;
        c.aptMsgEn = this.aptMsgEn;
        return c;
    }

    public String getDsqNiu() {
        return this.dsqNiu;
    }

    public void setDsqNiu(String dsqNiu) {
        this.dsqNiu = dsqNiu;
        this.setUpdated();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public String getNameOfficial() {
        return this.nameOfficial;
    }

    public void setNameOfficial(String nameOfficial) {
        this.nameOfficial = nameOfficial;
        this.setUpdated();
    }

    public String getNameCommon() {
        return this.nameCommon;
    }

    public void setNameCommon(String nameCommon) {
        this.nameCommon = nameCommon;
        this.setUpdated();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
        this.setUpdated();
    }

    public int[] getColor() {
        return this.color;
    }

    public void setColor(int[] color) {
        this.color = color;
        this.setUpdated();
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        this.setUpdated();
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public String getText() {
        return this.getNameCommon();
    }

    @Override
    public boolean isActive() {
        return !Boolean.TRUE.equals(this.getIsDeleted());
    }

    @Override
    public String toString() {
        return String.format("XSite [id=%s, nameOfficial=%s, nameCommon=%s, code=%s, color=%s, isDeleted=%s, isDrugStore=%s, phonenumber1=%s, phonenumber2=%s, street=%s, postalCode=%s, note=%s, country=%s, city=%s, province=%s, dsqNiu=%s]", this.id, this.nameOfficial, this.nameCommon, this.code, Arrays.toString(this.color), this.isDeleted, this.isDrugStore, this.phonenumber1, this.phonenumber2, this.street, this.postalCode, this.note, this.country, this.city, this.province, this.dsqNiu);
    }

    public XSiteB2b getB2bInformations() {
        return this.b2bInformations;
    }

    public void setB2bInformations(XSiteB2b b2bInformations) {
        this.b2bInformations = b2bInformations;
        this.setUpdated();
    }

    public Boolean getIsWorkSite() {
        return this.isWorkSite;
    }

    public void setIsWorkSite(Boolean isWorkSite) {
        this.isWorkSite = isWorkSite;
        this.setUpdated();
    }

    public String getRrssNiu() {
        return this.rrssNiu;
    }

    public void setRrssNiu(String rrssNiu) {
        this.rrssNiu = rrssNiu;
        this.setUpdated();
    }

    public Boolean getPatientCanSetArrived() {
        return this.patientCanSetArrived;
    }

    public void setPatientCanSetArrived(Boolean b) {
        this.patientCanSetArrived = b;
        this.setUpdated();
    }

    public Boolean getPatientCanCancelAppointment() {
        return this.patientCanCancelAppointment;
    }

    public void setPatientCanCancelAppointment(Boolean b) {
        this.patientCanCancelAppointment = b;
        this.setUpdated();
    }

    public Integer getSurvey2Q() {
        return this.survey2Q;
    }

    public void setSurvey2Q(Integer survey2q) {
        this.survey2Q = survey2q;
        this.setUpdated();
    }

    public String getAptMsgFr() {
        return this.aptMsgFr;
    }

    public void setAptMsgFr(String aptMsgFr) {
        this.aptMsgFr = aptMsgFr;
        this.setUpdated();
    }

    public String getAptMsgEn() {
        return this.aptMsgEn;
    }

    public void setAptMsgEn(String aptMsgEn) {
        this.aptMsgEn = aptMsgEn;
        this.setUpdated();
    }

    public void hideFaxCredentials() {
        this.faxAccount = null;
        this.faxUser = null;
        this.faxPasswd = null;
        this.faxNumber = null;
    }
}

