/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PdfUtil {
    public static byte[] addPrintedByToPdf(byte[] pdf, String printedBy) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            PdfReader reader = new PdfReader(pdf);
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)output);
            for (int p = 1; p <= reader.getNumberOfPages(); ++p) {
                PdfContentByte overContent = stamper.getOverContent(p);
                BaseFont font = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
                overContent.setFontAndSize(font, 10.0f);
                overContent.beginText();
                float x = overContent.getPdfDocument().getPageSize().getWidth() / 2.0f;
                float y = overContent.getPdfDocument().getPageSize().getBorderWidthBottom() + 5.0f;
                overContent.showTextAligned(1, printedBy, x, y, 0.0f);
                overContent.endText();
                overContent.stroke();
            }
            stamper.close();
        }
        catch (Exception e) {
            return pdf;
        }
        return output.toByteArray();
    }

    public static byte[] joinPdfs(byte[] ... pdfs) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document();
        PdfCopy pdfCopy = new PdfCopy(document, (OutputStream)outputStream);
        document.open();
        for (byte[] pdf : pdfs) {
            if (pdf == null) continue;
            PdfReader pdfReader = new PdfReader(pdf);
            int n = pdfReader.getNumberOfPages();
            for (int page = 0; page < n; ++page) {
                pdfCopy.addPage(pdfCopy.getImportedPage(pdfReader, ++page));
            }
            pdfCopy.freeReader(pdfReader);
            pdfReader.close();
        }
        document.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }

    public static byte[] newPdfFromText(String title, String text, boolean landscape) throws Exception {
        return PdfUtil.newPdfFromText(title, text, landscape ? PageSize.LETTER.rotate() : PageSize.LETTER);
    }

    public static byte[] newPdfFromText(String title, String text, Rectangle pageSize) throws Exception {
        Paragraph paragraph;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document(pageSize);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        writer.setCompressionLevel(5);
        writer.open();
        document.open();
        if (title != null && title.trim().length() > 0) {
            document.addTitle(title);
            paragraph = new Paragraph(title + "\n\n", new Font(0, 12.0f, 1));
            paragraph.setAlignment(1);
            document.add((Element)paragraph);
        }
        paragraph = new Paragraph(text, new Font(0, 12.0f, 0));
        paragraph.setAlignment(0);
        paragraph.setKeepTogether(true);
        document.add((Element)paragraph);
        writer.flush();
        document.close();
        writer.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileAsByteArray(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int readNum;
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
        }
        finally {
            fis.close();
        }
        byte[] bytes = bos.toByteArray();
        return bytes;
    }
}

