/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.interfaces;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.OrderedDataObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

public class OrderedDataObjectList<E extends OrderedDataObject>
extends EditableDataObjectList<E> {
    private static final Logger logger = Logger.getLogger(OrderedDataObjectList.class.getName());
    private static final long serialVersionUID = 1716418658035727859L;
    public static Comparator<? super OrderedDataObject> firstComparator = new Comparator<OrderedDataObject>(){

        @Override
        public int compare(OrderedDataObject o1, OrderedDataObject o2) {
            if (o1.getIsFirst().booleanValue()) {
                return -100;
            }
            if (o2.getNext() == null) {
                return 100;
            }
            return 0;
        }
    };

    public static <E extends OrderedDataObject> void doNextMapping(OrderedDataObjectList<E> list) {
        if (list == null || list.size() <= 1) {
            return;
        }
        ArrayList<E> list2 = new ArrayList<E>(list);
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap(list.size());
        for (OrderedDataObject e : list2) {
            map.put(e.getId() == null ? -1 : e.getId(), (Object)e);
        }
        Collections.sort(list, firstComparator);
        for (OrderedDataObject e : list2) {
            int idNext = e.getIdNext() == null ? -1 : e.getIdNext();
            OrderedDataObject next = idNext == -1 ? null : (OrderedDataObject)map.get(idNext);
            e.setNextNoDirty(next);
        }
    }

    public void addAsLast(E e) {
        this.addAsLast(e, false);
    }

    public void addAsLast(E e, boolean updateOrder) {
        Object object = this.getFirst();
        if (object != null) {
            E prevObject = object;
            while (((OrderedDataObject)object).getNext() != null) {
                if (((EditableDataObject)prevObject).equals(object = ((OrderedDataObject)object).getNext())) {
                    logger.severe("should never pass here 'item is next item in an OrderedDataObjectList'. Class=" + object.getClass().getName() + ", id=" + object.getId());
                    break;
                }
                prevObject = object;
            }
            if (updateOrder) {
                ((OrderedDataObject)e).setIsFirst(false);
                ((OrderedDataObject)object).setNext((OrderedDataObject)e);
            } else {
                ((OrderedDataObject)e).setIsFirstNoDirty(false);
                ((OrderedDataObject)object).setNextNoDirty((OrderedDataObject)e);
            }
            this.list.add(e);
        } else {
            if (updateOrder) {
                ((OrderedDataObject)e).setIsFirst(true);
            } else {
                ((OrderedDataObject)e).setIsFirstNoDirty(true);
            }
            this.list.add(e);
        }
    }

    @Override
    public OrderedDataObjectList<E> deepClone() {
        OrderedDataObjectList<Object> clone = new OrderedDataObjectList<Object>();
        Object item = this.getFirst();
        OrderedDataObject previousItem = null;
        clone.clear();
        while (item != null) {
            item = (OrderedDataObject)((EditableDataObject)item).clone();
            if (previousItem != null) {
                previousItem.setNextNoDirty((OrderedDataObject)item);
            }
            clone.add(item);
            previousItem = item;
            if (!previousItem.equals(item = ((OrderedDataObject)item).getNext())) continue;
            logger.severe("should never pass here 'item is next item in an OrderedDataObjectList'. Class=" + item.getClass().getName() + ", id=" + item.getId());
            break;
        }
        return clone;
    }

    @Override
    public E getFirst() {
        List lst = this.getList();
        OrderedDataObject item = null;
        for (OrderedDataObject e : lst) {
            if (e == null || !Boolean.TRUE.equals(e.getIsFirst())) continue;
            item = e;
            break;
        }
        return (E)item;
    }

    @Override
    public OrderedDataObjectList<E> clone() {
        return (OrderedDataObjectList)super.clone();
    }

    public E getFirstSortedItem() {
        return this.getFirst();
    }
}

