/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.service.keyset;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XClient;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import java.util.Map;

public class KeysetAccessorClient {
    private static KeysetAccessorClient instance;

    public static KeysetAccessorClient getInstance() {
        if (instance == null) {
            throw new IllegalStateException("no KeysetAccessorClient instance has been configured");
        }
        return instance;
    }

    public static void setInstance(KeysetAccessorClient i) {
        instance = i;
    }

    private String getClientCode() {
        XClient client;
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null && (client = session.getClient()) != null) {
            return client.getClientCode();
        }
        return "unknown";
    }

    public String get(String key) {
        return Application.get().getDataAccessors().getKeysetAccessor().get(this.getClientCode(), key);
    }

    public void put(String key, String value) {
        Application.get().getDataAccessors().getKeysetAccessor().put(this.getClientCode(), key, value);
    }

    public void delete(String key) {
        Application.get().getDataAccessors().getKeysetAccessor().delete(this.getClientCode(), key);
    }

    public Map<String, String> list() {
        return Application.get().getDataAccessors().getKeysetAccessor().list(this.getClientCode());
    }
}

