/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IMessageQueueConnectionInfo;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageQueueConnectionInfo
implements IMessageQueueConnectionInfo {
    private static final Logger logger = Logger.getLogger(MessageQueueConnectionInfo.class.getName());
    public static IMessageQueueConnectionInfo shamMqConnection;
    private final String address;
    private final int mqPort;
    private final boolean mqSSL;
    private IConsumer consumer = null;

    public MessageQueueConnectionInfo(String address, int port, boolean useSSL, String mqClass) {
        if (address == null) {
            throw new IllegalArgumentException("address can't be null");
        }
        if (mqClass == null) {
            throw new IllegalArgumentException("mqClass can't be null");
        }
        if (port < 1 && !mqClass.endsWith("ShamConsumer")) {
            throw new IllegalArgumentException("port can't be < 1");
        }
        this.address = address;
        this.mqPort = port;
        this.mqSSL = useSSL;
        try {
            Class<?> classRef = Class.forName(mqClass);
            this.consumer = (IConsumer)classRef.newInstance();
            logger.info("IConsumer '" + this.consumer + "' created successfully");
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "ClassNotFoundException: Could not create IConsumer: " + mqClass, e);
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, "InstantiationException: Could not create IConsumer: " + mqClass, e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "IllegalAccessException: Could not create IConsumer: " + mqClass, e);
        }
    }

    public IConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(IConsumer consumer) {
        this.consumer = consumer;
    }

    public String getAddress() {
        return this.address;
    }

    public int getMqPort() {
        return this.mqPort;
    }

    public boolean isMqSSL() {
        return this.mqSSL;
    }

    public String toString() {
        return String.format("MessageQueueConnectionInfo [address:%s]", this.address);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IConnectionInfo)) {
            return false;
        }
        MessageQueueConnectionInfo other = (MessageQueueConnectionInfo)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        return this.mqPort == other.mqPort;
    }

    public boolean isAccessible() {
        return true;
    }

    public void close() {
        if (this.consumer != null) {
            this.consumer.close();
        }
    }
}

