/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.client.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.ILogAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.log.XNewLog;
import ca.infodata.ofys.data.middle.dataobjects.log.XSearchLogCriteria;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogAccessorClient
extends BaseAccessorClient {
    private static final Logger logger = Logger.getLogger(LogAccessorClient.class.getName());
    private static LogAccessorClient instance;
    private final ILogAccessor accessor;

    public static LogAccessorClient getInstance() throws CannotConnectToServerException {
        return LogAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static LogAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new LogAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private LogAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getLogAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    public void find(int uniqueKey, XSession session, final ICallback callback, final XSearchLogCriteria criteria) {
        final String function = "LogAccessorClient.find" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.find(criteria));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Error finding with " + criteria, e);
                            LogAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LogAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void load(int uniqueKey, XSession session, final ICallback callback, final List<Integer> ids) {
        final String function = "LogAccessorClient.load" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.load(ids));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Error finding with " + ids, e);
                            LogAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LogAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void log(XSession session, final ICallback callback, final XNewLog log) {
        final String function = "LogAccessorClient.log" + log.hashCode();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.log(log));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Error trying to log " + log, e);
                            LogAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LogAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    protected ILogAccessor getAccessor() {
        return this.accessor;
    }
}

