/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.service.odslds;

import ca.infodata.dsq.domain.Address;
import java.io.Serializable;

public final class ServiceDeliveryLocationCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String mission;
    private String nameContains;
    private String facilityNumberRamq;
    private String facilityNumberMsss;
    private String communityDrugStoreBillingNumberRamq;
    private Address address;

    public String getMission() {
        return this.mission;
    }

    public void setMission(String mission) {
        this.mission = mission;
    }

    public String getNameContains() {
        return this.nameContains;
    }

    public void setNameContains(String nameContains) {
        this.nameContains = nameContains;
    }

    public String getFacilityNumberRamq() {
        return this.facilityNumberRamq;
    }

    public void setFacilityNumberRamq(String facilityNumberRamq) {
        if (!(facilityNumberRamq == null || facilityNumberRamq.length() == 5 && facilityNumberRamq.matches("[0-9]{5}"))) {
            throw new IllegalArgumentException("facilityNumberRamq must be a 5 digits long String");
        }
        if (this.facilityNumberMsss != null || this.communityDrugStoreBillingNumberRamq != null) {
            throw new IllegalArgumentException("User should not specify more than 1 criteria among [ facilityNumberRamq, facilityNumberMsss, communityDrugStoreBillingNumberRamq ]");
        }
        this.facilityNumberRamq = facilityNumberRamq;
    }

    public String getFacilityNumberMsss() {
        return this.facilityNumberMsss;
    }

    public void setFacilityNumberMsss(String facilityNumberMsss) {
        if (!(facilityNumberMsss == null || facilityNumberMsss.length() == 8 && facilityNumberMsss.matches("[0-9]{8}"))) {
            throw new IllegalArgumentException("facilityNumberMsss must be a 8 digits long String");
        }
        if (this.facilityNumberRamq != null || this.communityDrugStoreBillingNumberRamq != null) {
            throw new IllegalArgumentException("User should not specify more than 1 criteria among [ facilityNumberRamq, facilityNumberMsss, communityDrugStoreBillingNumberRamq ]");
        }
        this.facilityNumberMsss = facilityNumberMsss;
    }

    public String getCommunityDrugStoreBillingNumberRamq() {
        return this.communityDrugStoreBillingNumberRamq;
    }

    public void setCommunityDrugStoreBillingNumberRamq(String communityDrugStoreBillingNumberRamq) {
        if (!(communityDrugStoreBillingNumberRamq == null || communityDrugStoreBillingNumberRamq.length() == 6 && communityDrugStoreBillingNumberRamq.matches("[0-9]{6}"))) {
            throw new IllegalArgumentException("communityDrugStoreBillingNumber must be a 6 digits long String");
        }
        if (this.facilityNumberRamq != null || this.facilityNumberMsss != null) {
            throw new IllegalArgumentException("User should not specify more than 1 criteria among [ facilityNumberRamq, facilityNumberMsss, communityDrugStoreBillingNumberRamq ]");
        }
        this.communityDrugStoreBillingNumberRamq = communityDrugStoreBillingNumberRamq;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public String toString() {
        return String.format("ServiceDeliveryLocationCriteria [address=%s, communityDrugStoreBillingNumberRamq=%s, facilityNumberMsss=%s, facilityNumberRamq=%s, mission=%s, nameContains=%s]", this.address, this.communityDrugStoreBillingNumberRamq, this.facilityNumberMsss, this.facilityNumberRamq, this.mission, this.nameContains);
    }
}

