/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.service.dm.DMC0111Svc;

import ca.infodata.dsq.domain.ICandidate;
import ca.infodata.dsq.domain.fco.CandidateConsentDirective;
import java.io.Serializable;

public final class GetPrescriptionOrderDetailCriteriaDM
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ICandidate candidate;
    private final CandidateConsentDirective consentDirective;
    private final String prescriptionNumber;
    private final String prescriptionVersion;
    private final boolean includeLastDisp;
    private boolean includeIssuesIndicator;
    private boolean includeNotesIndicator;
    private boolean includeEventHistoryIndicator;

    public GetPrescriptionOrderDetailCriteriaDM(ICandidate candidate, CandidateConsentDirective consentDirective, String prescriptionNumber, String prescriptionVersion, boolean includeLastDisp) {
        if (candidate == null) {
            throw new NullPointerException("candidate");
        }
        if (prescriptionNumber == null) {
            throw new NullPointerException("prescriptionNumber");
        }
        if (prescriptionVersion == null) {
            throw new NullPointerException("prescriptionVersion");
        }
        if (consentDirective == null) {
            throw new NullPointerException("consentDirective");
        }
        if (!consentDirective.hasAccepted()) {
            throw new IllegalArgumentException("candidate has refused consent to his data");
        }
        this.candidate = candidate;
        this.prescriptionNumber = prescriptionNumber;
        this.prescriptionVersion = prescriptionVersion;
        this.includeLastDisp = includeLastDisp;
        this.consentDirective = consentDirective;
    }

    public ICandidate getCandidate() {
        return this.candidate;
    }

    public String getPrescriptionNumber() {
        return this.prescriptionNumber;
    }

    public String getPrescriptionVersion() {
        return this.prescriptionVersion;
    }

    public boolean getIncludeIssuesIndicator() {
        return this.includeIssuesIndicator;
    }

    public void setIncludeIssuesIndicator(boolean includeIssuesIndicator) {
        this.includeIssuesIndicator = includeIssuesIndicator;
    }

    public boolean getIncludeEventHistoryIndicator() {
        return this.includeEventHistoryIndicator;
    }

    public void setIncludeEventHistoryIndicator(boolean includeEventHistoryIndicator) {
        this.includeEventHistoryIndicator = includeEventHistoryIndicator;
    }

    public boolean getIncludeLastDisp() {
        return this.includeLastDisp;
    }

    public CandidateConsentDirective getConsentDirective() {
        return this.consentDirective;
    }

    public String toString() {
        return String.format("GetPrescriptionOrderDetailCriteriaDM [candidate=%s, consentDirective=%s, prescriptionNumber=%s, prescriptionVersion=%s, includeLastDisp=%s, includeIssuesIndicator=%s, includeEventHistoryIndicator=%s]", this.candidate, this.consentDirective, this.prescriptionNumber, this.prescriptionVersion, this.includeLastDisp, this.includeIssuesIndicator, this.includeEventHistoryIndicator);
    }

    public boolean getIncludeNotesIndicator() {
        return this.includeNotesIndicator;
    }

    public void setIncludeNotesIndicator(boolean includeNotesIndicator) {
        this.includeNotesIndicator = includeNotesIndicator;
    }
}

