/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain.labo.getreport;

import ca.infodata.dsq.domain.BinaryDataEncoding;
import ca.infodata.dsq.domain.Code;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.bind.DatatypeConverter;

public class LaboReportDocument
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Code language;
    public String title;
    public String text;
    public String mediaType;
    public BinaryDataEncoding representation;
    public static final String mediaTypeMSWord = "application/msword";
    public static final String mediaTypePdf = "application/PDF";
    public static final String mediaTypeXml = "application/xml";
    public static final String mediaTypeText = "text/plain";
    public static final String mediaTypeRtf = "text/rtf";
    public static final String mediaTypeHtml = "text/html";
    public static final String mediaTypeJpg = "image/jpeg";
    public static final String mediaTypePng = "image/png";
    public static final String mediaTypeGif = "image/gif";
    public static final String mediaTypeTiff = "image/tiff";

    public String toString() {
        return "LaboReportDocument [language=" + this.language + ", title=" + this.title + ", mediatype=" + this.mediaType + ", representation=" + (Object)((Object)this.representation) + "]";
    }

    private byte[] getDecodedBytes() {
        byte[] decodedBytes = null;
        if (this.mediaType != null) {
            if (this.mediaType.equalsIgnoreCase(mediaTypeHtml)) {
                decodedBytes = DatatypeConverter.parseBase64Binary((String)this.text);
            } else if (this.mediaType.equalsIgnoreCase(mediaTypeMSWord)) {
                decodedBytes = DatatypeConverter.parseBase64Binary((String)this.text);
            } else if (this.mediaType.equalsIgnoreCase(mediaTypeText)) {
                decodedBytes = this.text.getBytes();
            } else if (this.mediaType.equalsIgnoreCase(mediaTypeRtf)) {
                decodedBytes = this.text.getBytes();
            } else if (this.mediaType.equalsIgnoreCase(mediaTypePdf)) {
                decodedBytes = DatatypeConverter.parseBase64Binary((String)this.text);
            } else if (this.mediaType.equalsIgnoreCase(mediaTypeJpg)) {
                decodedBytes = DatatypeConverter.parseBase64Binary((String)this.text);
            } else if (this.mediaType.equalsIgnoreCase(mediaTypePng)) {
                decodedBytes = DatatypeConverter.parseBase64Binary((String)this.text);
            } else if (this.mediaType.equalsIgnoreCase(mediaTypeGif)) {
                decodedBytes = DatatypeConverter.parseBase64Binary((String)this.text);
            } else if (this.mediaType.equalsIgnoreCase(mediaTypeTiff)) {
                decodedBytes = DatatypeConverter.parseBase64Binary((String)this.text);
            }
        }
        return decodedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createFile(File parent, String prefix) throws IOException {
        File file = new File(parent, prefix + "_" + this.title + this.getFileExtension());
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            fos.write(this.getDecodedBytes());
            fos.flush();
        }
        return file;
    }

    private String getFileExtension() {
        String extension = ".txt";
        if (this.mediaType != null) {
            if (this.mediaType.equalsIgnoreCase(mediaTypeHtml)) {
                extension = ".html";
            } else if (this.mediaType.equalsIgnoreCase(mediaTypeMSWord)) {
                extension = ".doc";
            } else if (this.mediaType.equalsIgnoreCase(mediaTypeText)) {
                extension = ".txt";
            } else if (this.mediaType.equalsIgnoreCase(mediaTypeRtf)) {
                extension = ".rtf";
            } else if (this.mediaType.equalsIgnoreCase(mediaTypePdf)) {
                extension = ".pdf";
            } else if (this.mediaType.equalsIgnoreCase(mediaTypeJpg)) {
                extension = ".jpg";
            } else if (this.mediaType.equalsIgnoreCase(mediaTypePng)) {
                extension = ".png";
            } else if (this.mediaType.equalsIgnoreCase(mediaTypeGif)) {
                extension = ".gif";
            } else if (this.mediaType.equalsIgnoreCase(mediaTypeTiff)) {
                extension = ".tiff";
            }
        }
        return extension;
    }
}

