/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.ILocation;
import ca.infodata.dsq.domain.IPrescriptionDetails;
import ca.infodata.dsq.domain.IPrescriptionSummary;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.Medication;
import ca.infodata.dsq.domain.Quantity;
import ca.infodata.dsq.domain.Refusal;
import ca.infodata.dsq.domain.SupplyEventSummary;
import ca.infodata.dsq.domain.TherapeuticIntent;
import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;
import java.util.ArrayList;

public final class PrescriptionDrugSummary
implements Serializable,
IPrescriptionSummary {
    private static final long serialVersionUID = 1L;
    public int sequence;
    public String id;
    public String version;
    public Code status;
    public Code code;
    public Long datetime;
    public IProvider prescriber;
    public Medication medication;
    public ArrayList<TherapeuticIntent> reasons;
    public Boolean electronicVersionHasAuthority;
    public String dosageText;
    public Code dosageCode;
    public Quantity supplyRequestQuantity;
    public Code supplyRequestStatusCode;
    public ILocation supplyRequestLocation;
    public Code supplyRequestSubstitutionConditionCode;
    public ArrayList<Refusal> refusalsToFill;
    public Code treatmentTypeCode;
    public Boolean hasIssues;
    public Boolean hasAnnotations;
    public SupplyEventSummary supplyEventSummary;
    public IPrescriptionDetails detail;

    @Override
    public IPrescriptionDetails getDetail() {
        return this.detail;
    }

    @Override
    public void setDetail(IPrescriptionDetails detail) {
        this.detail = detail;
    }

    public PrescriptionDrugSummary(String id, String version, Code code, Code status, Long datetime, IProvider prescriber, Medication medication, ArrayList<TherapeuticIntent> reasons, Boolean electronicVersionHasAuthority, String dosageText, Code dosageCode, Quantity supplyRequestQuantity, Code supplyRequestStatusCode, ILocation supplyRequestLocation, Code supplyRequestSubstitutionConditionCode, ArrayList<Refusal> refusalsToFill, Code treatmentTypeCode, Boolean hasIssues, Boolean hasAnnotations) {
        this.id = id;
        this.version = version;
        this.code = code;
        this.status = status;
        this.datetime = datetime;
        this.prescriber = prescriber;
        this.medication = medication;
        this.reasons = reasons;
        this.electronicVersionHasAuthority = electronicVersionHasAuthority;
        this.dosageText = dosageText;
        this.dosageCode = dosageCode;
        this.supplyRequestQuantity = supplyRequestQuantity;
        this.supplyRequestStatusCode = supplyRequestStatusCode;
        this.supplyRequestLocation = supplyRequestLocation;
        this.supplyRequestSubstitutionConditionCode = supplyRequestSubstitutionConditionCode;
        this.refusalsToFill = refusalsToFill;
        this.treatmentTypeCode = treatmentTypeCode;
        this.hasIssues = hasIssues;
        this.hasAnnotations = hasAnnotations;
    }

    public String toString() {
        return String.format("PrescriptionDrugSummary [id=%s, version=%s, code=%s, status=%s, date=%s(%s), \nReasons %s\nMedication %s\nElectronic Version Has Authority %s,\nDosage code=%s, text=%s\nSupplyRequest value=%s, quantity=%s\n    Location %s\n    SubstitutionCondition value=%s,\nSupplyEventSummary\n %s\nRefusalToFill %s\nPrescriber %s\nHasIssues=%s, HasAnnotations=%s]", this.id, this.version, this.code, this.status, this.datetime, Helper.formatFULLDATETIME(this.datetime), this.reasons, this.medication, this.electronicVersionHasAuthority, this.dosageCode, this.dosageText, this.supplyRequestStatusCode, this.supplyRequestQuantity, this.supplyRequestLocation, this.supplyRequestSubstitutionConditionCode, this.supplyEventSummary, this.refusalsToFill, this.prescriber, this.hasIssues, this.hasAnnotations);
    }

    @Override
    public Long getDatetime() {
        return this.datetime;
    }

    @Override
    public Boolean getElectronicVersionHasAuthority() {
        return this.electronicVersionHasAuthority;
    }

    @Override
    public Boolean getHasAnnotations() {
        return this.hasAnnotations;
    }

    @Override
    public Boolean getHasIssues() {
        return this.hasIssues;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IProvider getPrescriber() {
        return this.prescriber;
    }

    @Override
    public ArrayList<TherapeuticIntent> getReasons() {
        return this.reasons;
    }

    @Override
    public ArrayList<Refusal> getRefusalsToFill() {
        return this.refusalsToFill;
    }

    @Override
    public Code getStatus() {
        return this.status;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public ILocation getSupplyRequestLocation() {
        return this.supplyRequestLocation;
    }
}

