/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import ca.infodata.dsq.domain.Annotation;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.DetectedIssueEvent;
import ca.infodata.dsq.domain.DispenseStatusChange;
import ca.infodata.dsq.domain.DosageInstruction;
import ca.infodata.dsq.domain.Duration;
import ca.infodata.dsq.domain.ILocation;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.Medication;
import ca.infodata.dsq.domain.Quantity;
import ca.infodata.dsq.domain.SubstitutionMade;
import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;
import java.util.ArrayList;

public final class DispenseDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String id;
    public Long date;
    public String status;
    public Code type;
    public IProvider performer;
    public ILocation location;
    public Duration expectedUseTime;
    public Quantity quantity;
    public Medication medication;
    public String prescriptionId;
    public String prescriptionVersion;
    public Long prescriptionDate;
    public String prescriptionStatus;
    public Code prescriptionCode;
    public IProvider prescriptionPrescriber;
    public ArrayList<Annotation> annotations;
    public ArrayList<DetectedIssueEvent> detectedIssueEvents;
    public ArrayList<DispenseStatusChange> dispenseStatusChanges;
    public ArrayList<DosageInstruction> dosageInstructions;
    public SubstitutionMade substitutionMade;

    public DispenseDetails() {
    }

    public DispenseDetails(String id, Long date, String status, Code dispenseType, IProvider performer, ILocation location, IProvider prescriber, Duration expectedUseTime, Quantity quantity, Medication medication, String prescriptionId, String prescriptionVersion, Long prescriptionDate, String prescriptionStatus, Code prescriptionCode, ArrayList<Annotation> annotations, ArrayList<DetectedIssueEvent> detectedIssueEvents, ArrayList<DispenseStatusChange> dispenseStatusChanges, ArrayList<DosageInstruction> dosageInstructions, SubstitutionMade substitutionMade) {
        this.id = id;
        this.date = date;
        this.status = status;
        this.performer = performer;
        this.location = location;
        this.prescriptionPrescriber = prescriber;
        this.expectedUseTime = expectedUseTime;
        this.quantity = quantity;
        this.medication = medication;
        this.prescriptionId = prescriptionId;
        this.prescriptionVersion = prescriptionVersion;
        this.prescriptionDate = prescriptionDate;
        this.prescriptionStatus = prescriptionStatus;
        this.prescriptionCode = prescriptionCode;
        this.annotations = annotations;
        this.detectedIssueEvents = detectedIssueEvents;
        this.dispenseStatusChanges = dispenseStatusChanges;
        this.dosageInstructions = dosageInstructions;
        this.substitutionMade = substitutionMade;
        this.type = dispenseType;
    }

    public String toString() {
        return String.format("DispenseDetail [id=%s, value=%s, date=%s(%s), %s\nPerformer %s\nLocation %s\n%s\nquantity=%s, expectedUseTime=%s\n%s\nPrescription [id=%s, ver=%s, value=%s, date=%s(%s), code=%s]\nPrescriber %s\nAnnotations %s\nDetectedIssueEvents %s\nDispenseStatusChange %s\nsubstitutionMade=%s]", this.id, this.status, this.date, Helper.formatFULLDATETIME(this.date), this.type, this.performer, this.location, this.medication, this.quantity, this.expectedUseTime, this.dosageInstructions, this.prescriptionId, this.prescriptionVersion, this.prescriptionStatus, this.prescriptionDate, Helper.formatFULLDATETIME(this.prescriptionDate), this.prescriptionCode, this.prescriptionPrescriber, this.annotations, this.detectedIssueEvents, this.dispenseStatusChanges, this.substitutionMade);
    }
}

