/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.metric.MiscOps;
import georegression.metric.alg.DistancePointTriangle3D_F32;
import georegression.struct.line.LineParametric3D_F32;
import georegression.struct.line.LineSegment3D_F32;
import georegression.struct.plane.PlaneGeneral3D_F32;
import georegression.struct.plane.PlaneNormal3D_F32;
import georegression.struct.point.Point3D_F32;

public class ClosestPoint3D_F32 {
    public static Point3D_F32 closestPoint(LineParametric3D_F32 l0, LineParametric3D_F32 l1, Point3D_F32 ret) {
        if (ret == null) {
            ret = new Point3D_F32();
        }
        ret.x = l0.p.x - l1.p.x;
        ret.y = l0.p.y - l1.p.y;
        ret.z = l0.p.z - l1.p.z;
        float dv01v1 = MiscOps.dot(ret, l1.slope);
        float dv1v0 = MiscOps.dot(l1.slope, l0.slope);
        float dv1v1 = MiscOps.dot(l1.slope, l1.slope);
        float t0 = dv01v1 * dv1v0 - MiscOps.dot(ret, l0.slope) * dv1v1;
        float bottom = MiscOps.dot(l0.slope, l0.slope) * dv1v1 - dv1v0 * dv1v0;
        if (bottom == 0.0f) {
            return null;
        }
        float t1 = (dv01v1 + (t0 /= bottom) * dv1v0) / dv1v1;
        ret.x = 0.5f * (l0.p.x + t0 * l0.slope.x + (l1.p.x + t1 * l1.slope.x));
        ret.y = 0.5f * (l0.p.y + t0 * l0.slope.y + (l1.p.y + t1 * l1.slope.y));
        ret.z = 0.5f * (l0.p.z + t0 * l0.slope.z + (l1.p.z + t1 * l1.slope.z));
        return ret;
    }

    public static boolean closestPoints(LineParametric3D_F32 l0, LineParametric3D_F32 l1, float[] param) {
        float dX = l0.p.x - l1.p.x;
        float dY = l0.p.y - l1.p.y;
        float dZ = l0.p.z - l1.p.z;
        float dv01v1 = MiscOps.dot(dX, dY, dZ, l1.slope);
        float dv1v0 = MiscOps.dot(l1.slope, l0.slope);
        float dv1v1 = MiscOps.dot(l1.slope, l1.slope);
        float t0 = dv01v1 * dv1v0 - MiscOps.dot(dX, dY, dZ, l0.slope) * dv1v1;
        float bottom = MiscOps.dot(l0.slope, l0.slope) * dv1v1 - dv1v0 * dv1v0;
        if (bottom == 0.0f) {
            return false;
        }
        float t1 = (dv01v1 + (t0 /= bottom) * dv1v0) / dv1v1;
        param[0] = t0;
        param[1] = t1;
        return true;
    }

    public static Point3D_F32 closestPoint(LineParametric3D_F32 line, Point3D_F32 pt, Point3D_F32 ret) {
        if (ret == null) {
            ret = new Point3D_F32();
        }
        float dx = pt.x - line.p.x;
        float dy = pt.y - line.p.y;
        float dz = pt.z - line.p.z;
        float n2 = line.slope.normSq();
        float d = line.slope.x * dx + line.slope.y * dy + line.slope.z * dz;
        ret.x = line.p.x + d * line.slope.x / n2;
        ret.y = line.p.y + d * line.slope.y / n2;
        ret.z = line.p.z + d * line.slope.z / n2;
        return ret;
    }

    public static float closestPoint(LineParametric3D_F32 line, Point3D_F32 pt) {
        float dx = pt.x - line.p.x;
        float dy = pt.y - line.p.y;
        float dz = pt.z - line.p.z;
        return (line.slope.x * dx + line.slope.y * dy + line.slope.z * dz) / line.slope.normSq();
    }

    public static Point3D_F32 closestPoint(PlaneNormal3D_F32 plane, Point3D_F32 point, Point3D_F32 found) {
        if (found == null) {
            found = new Point3D_F32();
        }
        float A = plane.n.x;
        float B = plane.n.y;
        float C = plane.n.z;
        float D2 = plane.n.x * plane.p.x + plane.n.y * plane.p.y + plane.n.z * plane.p.z;
        float top = A * point.x + B * point.y + C * point.z - D2;
        float n2 = A * A + B * B + C * C;
        found.x = point.x - A * top / n2;
        found.y = point.y - B * top / n2;
        found.z = point.z - C * top / n2;
        return found;
    }

    public static Point3D_F32 closestPoint(PlaneGeneral3D_F32 plane, Point3D_F32 point, Point3D_F32 found) {
        if (found == null) {
            found = new Point3D_F32();
        }
        float top = plane.A * point.x + plane.B * point.y + plane.C * point.z - plane.D;
        float n2 = plane.A * plane.A + plane.B * plane.B + plane.C * plane.C;
        found.x = point.x - plane.A * top / n2;
        found.y = point.y - plane.B * top / n2;
        found.z = point.z - plane.C * top / n2;
        return found;
    }

    public static Point3D_F32 closestPointOrigin(PlaneGeneral3D_F32 plane, Point3D_F32 found) {
        if (found == null) {
            found = new Point3D_F32();
        }
        float n2 = plane.A * plane.A + plane.B * plane.B + plane.C * plane.C;
        found.x = plane.A * plane.D / n2;
        found.y = plane.B * plane.D / n2;
        found.z = plane.C * plane.D / n2;
        return found;
    }

    public static Point3D_F32 closestPoint(LineSegment3D_F32 line, Point3D_F32 pt, Point3D_F32 ret) {
        float n;
        float dz;
        float slope_z;
        float dy;
        float slope_y;
        float dx;
        float slope_x;
        float d;
        if (ret == null) {
            ret = new Point3D_F32();
        }
        if ((d = ((slope_x = line.b.x - line.a.x) * (dx = pt.x - line.a.x) + (slope_y = line.b.y - line.a.y) * (dy = pt.y - line.a.y) + (slope_z = line.b.z - line.a.z) * (dz = pt.z - line.a.z)) / (n = (float)Math.sqrt(slope_x * slope_x + slope_y * slope_y + slope_z * slope_z))) <= 0.0f) {
            ret.set(line.a);
        } else if (d >= n) {
            ret.set(line.b);
        } else {
            ret.x = line.a.x + d * slope_x / n;
            ret.y = line.a.y + d * slope_y / n;
            ret.z = line.a.z + d * slope_z / n;
        }
        return ret;
    }

    public static Point3D_F32 closestPoint(LineSegment3D_F32 l0, LineSegment3D_F32 l1, Point3D_F32 ret) {
        if (ret == null) {
            ret = new Point3D_F32();
        }
        ret.x = l0.a.x - l1.a.x;
        ret.y = l0.a.y - l1.a.y;
        ret.z = l0.a.z - l1.a.z;
        float slope0_x = l0.b.x - l0.a.x;
        float slope0_y = l0.b.y - l0.a.y;
        float slope0_z = l0.b.z - l0.a.z;
        float slope1_x = l1.b.x - l1.a.x;
        float slope1_y = l1.b.y - l1.a.y;
        float slope1_z = l1.b.z - l1.a.z;
        float n0 = (float)Math.sqrt(slope0_x * slope0_x + slope0_y * slope0_y + slope0_z * slope0_z);
        float n1 = (float)Math.sqrt(slope1_x * slope1_x + slope1_y * slope1_y + slope1_z * slope1_z);
        float dv01v1 = ret.x * (slope1_x /= n1) + ret.y * (slope1_y /= n1) + ret.z * (slope1_z /= n1);
        float dv01v0 = ret.x * (slope0_x /= n0) + ret.y * (slope0_y /= n0) + ret.z * (slope0_z /= n0);
        float dv1v0 = slope1_x * slope0_x + slope1_y * slope0_y + slope1_z * slope0_z;
        float t0 = dv01v1 * dv1v0 - dv01v0;
        float bottom = 1.0f - dv1v0 * dv1v0;
        if (bottom == 0.0f) {
            return null;
        }
        if ((t0 /= bottom) < 0.0f) {
            return ClosestPoint3D_F32.closestPoint(l1, l0.a, ret);
        }
        if (t0 > 1.0f) {
            return ClosestPoint3D_F32.closestPoint(l1, l0.b, ret);
        }
        float t1 = dv01v1 + t0 * dv1v0;
        if (t1 < 0.0f) {
            return ClosestPoint3D_F32.closestPoint(l0, l1.a, ret);
        }
        if (t1 > 1.0f) {
            return ClosestPoint3D_F32.closestPoint(l0, l1.b, ret);
        }
        ret.x = 0.5f * (l0.a.x + t0 * slope0_x + (l1.a.x + t1 * slope1_x));
        ret.y = 0.5f * (l0.a.y + t0 * slope0_y + (l1.a.y + t1 * slope1_y));
        ret.z = 0.5f * (l0.a.z + t0 * slope0_z + (l1.a.z + t1 * slope1_z));
        return ret;
    }

    public static Point3D_F32 closestPoint(Point3D_F32 vertexA, Point3D_F32 vertexB, Point3D_F32 vertexC, Point3D_F32 point, Point3D_F32 ret) {
        if (ret == null) {
            ret = new Point3D_F32();
        }
        DistancePointTriangle3D_F32 alg = new DistancePointTriangle3D_F32();
        alg.setTriangle(vertexA, vertexB, vertexC);
        alg.closestPoint(point, ret);
        return ret;
    }

    public static float closestPointT(LineParametric3D_F32 line, PlaneNormal3D_F32 plane) {
        float dx = plane.p.x - line.p.x;
        float dy = plane.p.y - line.p.y;
        float dz = plane.p.z - line.p.z;
        float top = dx * plane.n.x + dy * plane.n.y + dz * plane.n.z;
        float bottom = line.slope.dot(plane.n);
        if (bottom == 0.0f) {
            return Float.NaN;
        }
        return top / bottom;
    }
}

