/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Rectangle2D_F64;
import georegression.struct.shapes.RectangleLength2D_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import org.ddogleg.sorting.QuickSort_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.ReshapeMatrix;

public class UtilPoint2D_F64 {
    public static List<Point2D_F64> copy(List<Point2D_F64> pts) {
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        for (Point2D_F64 p : pts) {
            ret.add(p.copy());
        }
        return ret;
    }

    public static void noiseNormal(List<Point2D_F64> pts, double sigma, Random rand) {
        for (Point2D_F64 p : pts) {
            p.x += rand.nextGaussian() * sigma;
            p.y += rand.nextGaussian() * sigma;
        }
    }

    public static Point2D_F64 noiseNormal(Point2D_F64 mean, double sigmaX, double sigmaY, Random rand, @Nullable Point2D_F64 output) {
        if (output == null) {
            output = new Point2D_F64();
        }
        output.x = mean.x + rand.nextGaussian() * sigmaX;
        output.y = mean.y + rand.nextGaussian() * sigmaY;
        return output;
    }

    public static double distance(double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double distanceSq(double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        return dx * dx + dy * dy;
    }

    public static Point2D_F64 mean(List<Point2D_F64> list, Point2D_F64 mean) {
        if (mean == null) {
            mean = new Point2D_F64();
        }
        double x = 0.0;
        double y = 0.0;
        for (Point2D_F64 p : list) {
            x += p.getX();
            y += p.getY();
        }
        mean.set(x /= (double)list.size(), y /= (double)list.size());
        return mean;
    }

    public static Point2D_F64 mean(Point2D_F64[] list, int offset, int length, Point2D_F64 mean) {
        if (mean == null) {
            mean = new Point2D_F64();
        }
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < length; ++i) {
            Point2D_F64 p = list[offset + i];
            x += p.getX();
            y += p.getY();
        }
        mean.set(x /= (double)length, y /= (double)length);
        return mean;
    }

    public static Point2D_F64 mean(Point2D_F64 a, Point2D_F64 b, Point2D_F64 mean) {
        if (mean == null) {
            mean = new Point2D_F64();
        }
        mean.x = (a.x + b.x) / 2.0;
        mean.y = (a.y + b.y) / 2.0;
        return mean;
    }

    public static List<Point2D_F64> random(double min, double max, int num, Random rand) {
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        double d = max - min;
        for (int i = 0; i < num; ++i) {
            Point2D_F64 p = new Point2D_F64();
            p.x = rand.nextDouble() * d + min;
            p.y = rand.nextDouble() * d + min;
            ret.add(p);
        }
        return ret;
    }

    public static boolean isEquals(GeoTuple2D_F64 a, GeoTuple2D_F64 b, double tol) {
        return Math.abs(a.x - b.x) <= tol && Math.abs(a.x - b.x) <= tol;
    }

    public static RectangleLength2D_F64 bounding(List<Point2D_F64> points, RectangleLength2D_F64 bounding) {
        if (bounding == null) {
            bounding = new RectangleLength2D_F64();
        }
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 p = points.get(i);
            if (p.x < minX) {
                minX = p.x;
            }
            if (p.x > maxX) {
                maxX = p.x;
            }
            if (p.y < minY) {
                minY = p.y;
            }
            if (!(p.y > maxY)) continue;
            maxY = p.y;
        }
        bounding.x0 = minX;
        bounding.y0 = minY;
        bounding.width = maxX - minX;
        bounding.height = maxY - minY;
        bounding.width += Math.max(0.0, (maxX - (bounding.x0 + bounding.width)) * 10.0);
        bounding.height += Math.max(0.0, (maxY - (bounding.y0 + bounding.height)) * 10.0);
        return bounding;
    }

    public static Rectangle2D_F64 bounding(List<Point2D_F64> points, Rectangle2D_F64 bounding) {
        if (bounding == null) {
            bounding = new Rectangle2D_F64();
        }
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 p = points.get(i);
            if (p.x < minX) {
                minX = p.x;
            }
            if (p.x > maxX) {
                maxX = p.x;
            }
            if (p.y < minY) {
                minY = p.y;
            }
            if (!(p.y > maxY)) continue;
            maxY = p.y;
        }
        bounding.set(minX, minY, maxX, maxY);
        return bounding;
    }

    public static List<Point2D_F64> orderCCW(List<Point2D_F64> points) {
        Point2D_F64 center = UtilPoint2D_F64.mean(points, null);
        double[] angles = new double[points.size()];
        for (int i = 0; i < angles.length; ++i) {
            Point2D_F64 p = points.get(i);
            double dx = p.x - center.x;
            double dy = p.y - center.y;
            angles[i] = Math.atan2(dy, dx);
        }
        int[] order = new int[points.size()];
        QuickSort_F64 sorter = new QuickSort_F64();
        sorter.sort(angles, 0, points.size(), order);
        ArrayList<Point2D_F64> out = new ArrayList<Point2D_F64>(points.size());
        for (int i = 0; i < points.size(); ++i) {
            out.add(points.get(order[i]));
        }
        return out;
    }

    public static void computeNormal(List<Point2D_F64> points, Point2D_F64 mean, DMatrix covariance) {
        if (covariance.getNumCols() != 2 || covariance.getNumRows() != 2) {
            if (covariance instanceof ReshapeMatrix) {
                ((ReshapeMatrix)((Object)covariance)).reshape(2, 2);
            } else {
                throw new IllegalArgumentException("Must be a 2x2 matrix");
            }
        }
        UtilPoint2D_F64.mean(points, mean);
        double xx = 0.0;
        double xy = 0.0;
        double yy = 0.0;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 p = points.get(i);
            double dx = p.x - mean.x;
            double dy = p.y - mean.y;
            xx += dx * dx;
            xy += dx * dy;
            yy += dy * dy;
        }
        covariance.unsafe_set(0, 0, xx /= (double)points.size());
        covariance.unsafe_set(0, 1, xy /= (double)points.size());
        covariance.unsafe_set(1, 0, xy);
        covariance.unsafe_set(1, 1, yy /= (double)points.size());
    }

    public static List<Point2D_F64> randomNorm(Point2D_F64 mean, DMatrix covariance, int count, Random rand, @Nullable List<Point2D_F64> output) {
        if (output == null) {
            output = new ArrayList<Point2D_F64>();
        }
        double cxx = covariance.get(0, 0);
        double cxy = covariance.get(0, 1);
        double cyy = covariance.get(1, 1);
        double sxx = Math.sqrt(cxx);
        double sxy = cxy / cxx;
        double syy = Math.sqrt(cyy - sxy * sxy);
        for (int i = 0; i < count; ++i) {
            Point2D_F64 p = new Point2D_F64();
            double x = rand.nextGaussian();
            double y = rand.nextGaussian();
            p.x = mean.x + sxx * x + sxy * y;
            p.y = mean.y + sxy * x + syy * y;
            output.add(p);
        }
        return output;
    }
}

