/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.calib;

import boofcv.struct.calib.CameraModel;

public class CameraPinhole
extends CameraModel {
    public static final long serialVersionUID = 1L;
    public double fx;
    public double fy;
    public double skew;
    public double cx;
    public double cy;

    public CameraPinhole() {
    }

    public CameraPinhole(CameraPinhole param) {
        this.set(param);
    }

    public CameraPinhole(double fx, double fy, double skew, double cx, double cy, int width, int height) {
        this.fsetK(fx, fy, skew, cx, cy, width, height);
    }

    public CameraPinhole fsetK(double fx, double fy, double skew, double cx, double cy, int width, int height) {
        this.fx = fx;
        this.fy = fy;
        this.skew = skew;
        this.cx = cx;
        this.cy = cy;
        this.width = width;
        this.height = height;
        return this;
    }

    public void set(CameraPinhole param) {
        this.fx = param.fx;
        this.fy = param.fy;
        this.skew = param.skew;
        this.cx = param.cx;
        this.cy = param.cy;
        this.width = param.width;
        this.height = param.height;
    }

    public boolean inside(double x, double y) {
        return x >= 0.0 && y >= 0.0 && x < (double)(this.width - 1) && y <= (double)(this.height - 1);
    }

    public double getCx() {
        return this.cx;
    }

    public void setCx(double cx) {
        this.cx = cx;
    }

    public double getCy() {
        return this.cy;
    }

    public void setCy(double cy) {
        this.cy = cy;
    }

    public double getFx() {
        return this.fx;
    }

    public void setFx(double fx) {
        this.fx = fx;
    }

    public double getFy() {
        return this.fy;
    }

    public void setFy(double fy) {
        this.fy = fy;
    }

    public double getSkew() {
        return this.skew;
    }

    public void setSkew(double skew) {
        this.skew = skew;
    }

    public void print() {
        System.out.println("Shape " + this.width + " " + this.height);
        System.out.printf("center %7.2f %7.2f\n", this.cx, this.cy);
        System.out.println("fx = " + this.fx);
        System.out.println("fy = " + this.fy);
        System.out.println("skew = " + this.skew);
    }

    @Override
    public <T extends CameraModel> T createLike() {
        return (T)new CameraPinhole();
    }

    public String toString() {
        return "CameraPinhole{fx=" + this.fx + ", fy=" + this.fy + ", skew=" + this.skew + ", cx=" + this.cx + ", cy=" + this.cy + ", width=" + this.width + ", height=" + this.height + '}';
    }

    public boolean isEquals(CameraPinhole param, double tol) {
        if (Math.abs(this.fx - param.fx) > tol) {
            return false;
        }
        if (Math.abs(this.fy - param.fy) > tol) {
            return false;
        }
        if (Math.abs(this.skew - param.skew) > tol) {
            return false;
        }
        if (Math.abs(this.cx - param.cx) > tol) {
            return false;
        }
        if (Math.abs(this.cy - param.cy) > tol) {
            return false;
        }
        if (this.width != param.width) {
            return false;
        }
        return this.height == param.height;
    }
}

