/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.distort;

import boofcv.abst.distort.ConfigDeformPointMLS;
import boofcv.abst.distort.PointDeformKeyPoints;
import boofcv.abst.distort.PointDeform_MLS;
import boofcv.alg.distort.AssignPixelValue_MB;
import boofcv.alg.distort.AssignPixelValue_SB;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.ImageDistortBasic_IL;
import boofcv.alg.distort.ImageDistortBasic_IL_MT;
import boofcv.alg.distort.ImageDistortBasic_SB;
import boofcv.alg.distort.ImageDistortBasic_SB_MT;
import boofcv.alg.distort.ImageDistortCache_SB;
import boofcv.alg.distort.ImageDistortCache_SB_MT;
import boofcv.alg.distort.impl.ImplImageDistort_PL;
import boofcv.alg.distort.mls.ImageDeformPointMLS_F32;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.Planar;

public class FactoryDistort {
    public static <Input extends ImageBase<Input>, Output extends ImageBase<Output>> ImageDistort<Input, Output> distort(boolean cached, InterpolationType interpolationType, BorderType borderType, ImageType<Input> inputType, ImageType<Output> outputType) {
        InterpolatePixel<Input> interp = FactoryInterpolation.createPixel(0.0, 255.0, interpolationType, borderType, inputType);
        return FactoryDistort.distort(cached, interp, outputType);
    }

    public static <Input extends ImageBase<Input>, Output extends ImageBase<Output>> ImageDistort<Input, Output> distort(boolean cached, InterpolatePixel<Input> interp, ImageType<Output> outputType) {
        switch (outputType.getFamily()) {
            case GRAY: {
                return FactoryDistort.distortSB(cached, (InterpolatePixelS)interp, outputType.getImageClass());
            }
            case PLANAR: {
                return FactoryDistort.distortPL(cached, (InterpolatePixelS)interp, outputType.getImageClass());
            }
            case INTERLEAVED: {
                if (interp instanceof InterpolatePixelS) {
                    throw new IllegalArgumentException("Interpolation function for single band images was passed in for an interleaved image");
                }
                return FactoryDistort.distortIL(cached, (InterpolatePixelMB)interp, outputType);
            }
        }
        throw new IllegalArgumentException("Unknown image family " + (Object)((Object)outputType.getFamily()));
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> ImageDistort<Input, Output> distortSB(boolean cached, InterpolatePixelS<Input> interp, Class<Output> outputType) {
        AssignPixelValue_SB<GrayF32> assigner;
        if (outputType == GrayF32.class) {
            assigner = new AssignPixelValue_SB.F32();
        } else if (GrayS32.class.isAssignableFrom(outputType)) {
            assigner = new AssignPixelValue_SB.S32();
        } else if (GrayI16.class.isAssignableFrom(outputType)) {
            assigner = new AssignPixelValue_SB.I16();
        } else if (GrayI8.class.isAssignableFrom(outputType)) {
            assigner = new AssignPixelValue_SB.I8();
        } else {
            throw new IllegalArgumentException("Output type not supported: " + outputType.getSimpleName());
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            if (cached) {
                return new ImageDistortCache_SB_MT<Input, GrayF32>(assigner, interp);
            }
            return new ImageDistortBasic_SB_MT<Input, GrayF32>(assigner, interp);
        }
        if (cached) {
            return new ImageDistortCache_SB<Input, GrayF32>(assigner, interp);
        }
        return new ImageDistortBasic_SB<Input, GrayF32>(assigner, interp);
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> ImageDistort<Planar<Input>, Planar<Output>> distortPL(boolean cached, InterpolatePixelS<Input> interp, Class<Output> outputType) {
        ImageDistort<Input, Output> distortSingle = FactoryDistort.distortSB(cached, interp, outputType);
        return new ImplImageDistort_PL<Input, Output>(distortSingle);
    }

    public static <Input extends ImageInterleaved<Input>, Output extends ImageInterleaved<Output>> ImageDistort<Input, Output> distortIL(boolean cached, InterpolatePixelMB<Input> interp, ImageType<Output> outputType) {
        AssignPixelValue_MB<InterleavedF32> assigner;
        if (cached) {
            throw new IllegalArgumentException("Cached not supported yet");
        }
        switch (outputType.getDataType()) {
            case F32: {
                assigner = new AssignPixelValue_MB.F32();
                break;
            }
            case S32: {
                assigner = new AssignPixelValue_MB.S32();
                break;
            }
            case U16: 
            case S16: 
            case I16: {
                assigner = new AssignPixelValue_MB.I16();
                break;
            }
            case U8: 
            case S8: 
            case I8: {
                assigner = new AssignPixelValue_MB.I8();
                break;
            }
            default: {
                throw new RuntimeException("Not yet supported " + outputType);
            }
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            return new ImageDistortBasic_IL_MT<Input, InterleavedF32>(assigner, interp);
        }
        return new ImageDistortBasic_IL<Input, InterleavedF32>(assigner, interp);
    }

    public static PointDeformKeyPoints deformMls(ConfigDeformPointMLS config) {
        if (config == null) {
            config = new ConfigDeformPointMLS();
        }
        ImageDeformPointMLS_F32 alg = new ImageDeformPointMLS_F32(config.type);
        alg.setAlpha(config.alpha);
        return new PointDeform_MLS(alg, config.rows, config.cols);
    }
}

