/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polyline.splitmerge;

import boofcv.alg.shapes.polyline.splitmerge.MaximumLineDistance;
import boofcv.alg.shapes.polyline.splitmerge.SplitSelector;
import boofcv.misc.CircularIndex;
import boofcv.struct.ConfigLength;
import georegression.geometry.UtilPolygons2D_I32;
import georegression.metric.Distance2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;
import org.ddogleg.struct.GrowQueue_I32;
import org.ddogleg.struct.LinkedList;

public class PolylineSplitMerge {
    private boolean loops = true;
    private boolean convex = false;
    private int maxSides = Integer.MAX_VALUE;
    private int minSides = 3;
    private int minimumSideLength = 10;
    private ConfigLength extraConsider = ConfigLength.relative(1.0, 0);
    private double cornerScorePenalty = 0.25;
    private double thresholdSideSplitScore = 0.0;
    int maxNumberOfSideSamples = 50;
    double convexTest = 2.5;
    ConfigLength maxSideError = ConfigLength.relative(0.1, 3);
    private LineSegment2D_F64 line = new LineSegment2D_F64();
    LinkedList<Corner> list = new LinkedList();
    FastQueue<Corner> corners = new FastQueue<Corner>(Corner.class, true);
    private SplitSelector splitter = new MaximumLineDistance();
    private SplitResults resultsA = new SplitResults();
    private SplitResults resultsB = new SplitResults();
    private FastQueue<CandidatePolyline> polylines = new FastQueue<CandidatePolyline>(CandidatePolyline.class, true);
    private CandidatePolyline bestPolyline;
    private boolean fatalError;
    ErrorValue sideError = new ErrorValue();

    public boolean process(List<Point2D_I32> contour) {
        int i;
        this.reset();
        if (this.loops) {
            if (contour.size() < 3) {
                return false;
            }
            if (!this.findInitialTriangle(contour)) {
                return false;
            }
        } else {
            if (contour.size() < 2) {
                return false;
            }
            this.addCorner(0);
            this.addCorner(contour.size() - 1);
            this.initializeScore(contour, false);
        }
        this.savePolyline();
        this.sequentialSideFit(contour, this.loops);
        if (this.fatalError) {
            return false;
        }
        int MIN_SIZE = this.loops ? 3 : 2;
        double bestScore = Double.MAX_VALUE;
        int bestSize = -1;
        for (i = 0; i < Math.min(this.maxSides - (MIN_SIZE - 1), this.polylines.size); ++i) {
            if (!(this.polylines.get((int)i).score < bestScore)) continue;
            this.bestPolyline = this.polylines.get(i);
            bestScore = this.bestPolyline.score;
            bestSize = i + MIN_SIZE;
        }
        if (bestSize < this.minSides) {
            return false;
        }
        i = 0;
        int j = bestSize - 1;
        while (i < bestSize) {
            Point2D_I32 a = contour.get(this.bestPolyline.splits.get(i));
            Point2D_I32 b = contour.get(this.bestPolyline.splits.get(j));
            double length = a.distance(b);
            double thresholdSideError = this.maxSideError.compute(length);
            if (this.bestPolyline.sideErrors.get(i) >= thresholdSideError * thresholdSideError) {
                this.bestPolyline = null;
                return false;
            }
            j = i++;
        }
        return true;
    }

    private void sequentialSideFit(List<Point2D_I32> contour, boolean loops) {
        LinkedList.Element<Corner> c;
        int limit = this.maxSides + this.extraConsider.computeI(this.maxSides);
        if (limit <= 0) {
            limit = contour.size();
        }
        while (this.list.size() < limit && !this.fatalError && this.increaseNumberOfSidesByOne(contour, loops)) {
        }
        while (!this.fatalError && (c = this.selectCornerToRemove(contour, this.sideError, loops)) != null) {
            this.removeCornerAndSavePolyline(c, this.sideError.value);
        }
    }

    private void reset() {
        this.list.reset();
        this.corners.reset();
        this.polylines.reset();
        this.bestPolyline = null;
        this.fatalError = false;
    }

    private void printCurrent(List<Point2D_I32> contour) {
        System.out.print(this.list.size() + "  Indexes[");
        LinkedList.Element<Corner> e = this.list.getHead();
        while (e != null) {
            System.out.print(" " + ((Corner)e.object).index);
            e = e.next;
        }
        System.out.println(" ]");
        System.out.print("   Errors[");
        e = this.list.getHead();
        while (e != null) {
            String split = ((Corner)e.object).splitable ? "T" : "F";
            System.out.print(String.format(" %6.1f %1s", ((Corner)e.object).sideError, split));
            e = e.next;
        }
        System.out.println(" ]");
        System.out.print("      Pos[");
        e = this.list.getHead();
        while (e != null) {
            Point2D_I32 p = contour.get(((Corner)e.object).index);
            System.out.print(String.format(" %3d %3d,", p.x, p.y));
            e = e.next;
        }
        System.out.println(" ]");
    }

    boolean savePolyline() {
        double foundScore;
        CandidatePolyline c;
        int N;
        int n = N = this.loops ? 3 : 2;
        if (this.list.size() <= this.polylines.size + N - 1) {
            c = this.polylines.get(this.list.size() - N);
            if (c.splits.size != this.list.size()) {
                throw new RuntimeException("Egads saved polylines aren't in the expected order");
            }
        } else {
            c = this.polylines.grow();
            c.reset();
            c.score = Double.MAX_VALUE;
        }
        if (c.score > (foundScore = PolylineSplitMerge.computeScore(this.list, this.cornerScorePenalty, this.loops))) {
            c.score = foundScore;
            c.splits.reset();
            c.sideErrors.reset();
            LinkedList.Element<Corner> e = this.list.getHead();
            double maxSideError = 0.0;
            while (e != null) {
                maxSideError = Math.max(maxSideError, ((Corner)e.object).sideError);
                c.splits.add(((Corner)e.object).index);
                c.sideErrors.add(((Corner)e.object).sideError);
                e = e.next;
            }
            c.maxSideError = maxSideError;
            return true;
        }
        return false;
    }

    static double computeScore(LinkedList<Corner> list, double cornerPenalty, boolean loops) {
        LinkedList.Element<Corner> end;
        double sumSides = 0.0;
        LinkedList.Element<Corner> e = list.getHead();
        LinkedList.Element<Corner> element = end = loops ? null : list.getTail();
        while (e != end) {
            sumSides += ((Corner)e.object).sideError;
            e = e.next;
        }
        int numSides = loops ? list.size() : list.size() - 1;
        return sumSides / (double)numSides + cornerPenalty * (double)numSides;
    }

    boolean findInitialTriangle(List<Point2D_I32> contour) {
        int cornerSeed = PolylineSplitMerge.findCornerSeed(contour);
        if (this.convex && !PolylineSplitMerge.isConvexUsingMaxDistantPoints(contour, 0, cornerSeed)) {
            return false;
        }
        this.splitter.selectSplitPoint(contour, 0, cornerSeed, this.resultsA);
        this.splitter.selectSplitPoint(contour, cornerSeed, 0, this.resultsB);
        if (this.splitter.compareScore(this.resultsA.score, this.resultsB.score) >= 0) {
            this.addCorner(this.resultsA.index);
            this.addCorner(cornerSeed);
        } else {
            this.addCorner(cornerSeed);
            this.addCorner(this.resultsB.index);
        }
        int index0 = ((Corner)this.list.getHead().object).index;
        int index1 = ((Corner)this.list.getHead().next.object).index;
        int index2 = PolylineSplitMerge.maximumDistance(contour, index0, index1);
        this.addCorner(index2);
        this.ensureTriangleOrder(contour);
        return this.initializeScore(contour, true);
    }

    private boolean initializeScore(List<Point2D_I32> contour, boolean loops) {
        LinkedList.Element<Corner> end;
        LinkedList.Element<Corner> e = this.list.getHead();
        LinkedList.Element<Corner> element = end = loops ? null : this.list.getTail();
        while (e != end) {
            if (this.convex && !this.isSideConvex(contour, e)) {
                return false;
            }
            LinkedList.Element n = e.next;
            double error = n == null ? this.computeSideError(contour, ((Corner)e.object).index, ((Corner)this.list.getHead().object).index) : this.computeSideError(contour, ((Corner)e.object).index, ((Corner)n.object).index);
            ((Corner)e.object).sideError = error;
            e = n;
        }
        e = this.list.getHead();
        while (e != end) {
            this.computePotentialSplitScore(contour, e, this.list.size() < this.minSides);
            e = e.next;
        }
        return true;
    }

    void ensureTriangleOrder(List<Point2D_I32> contour) {
        int distC;
        LinkedList.Element<Corner> e = this.list.getHead();
        Corner a = (Corner)e.object;
        e = e.next;
        Corner b = (Corner)e.object;
        e = e.next;
        Corner c = (Corner)e.object;
        int distB = CircularIndex.distanceP(a.index, b.index, contour.size());
        if (distB > (distC = CircularIndex.distanceP(a.index, c.index, contour.size()))) {
            this.list.reset();
            this.list.pushTail(a);
            this.list.pushTail(c);
            this.list.pushTail(b);
        }
    }

    LinkedList.Element<Corner> addCorner(int where) {
        Corner c = this.corners.grow();
        c.reset();
        c.index = where;
        this.list.pushTail(c);
        return this.list.getTail();
    }

    boolean increaseNumberOfSidesByOne(List<Point2D_I32> contour, boolean loops) {
        LinkedList.Element<Corner> selected = this.selectCornerToSplit(loops);
        if (selected == null) {
            return false;
        }
        ((Corner)selected.object).sideError = ((Corner)selected.object).splitError0;
        Corner c = this.corners.grow();
        c.reset();
        c.index = ((Corner)selected.object).splitLocation;
        c.sideError = ((Corner)selected.object).splitError1;
        LinkedList.Element<Corner> cornerE = this.list.insertAfter(selected, c);
        if (this.convex && !this.isSideConvex(contour, selected)) {
            return false;
        }
        this.computePotentialSplitScore(contour, cornerE, this.list.size() < this.minSides);
        this.computePotentialSplitScore(contour, selected, this.list.size() < this.minSides);
        this.savePolyline();
        return true;
    }

    boolean isSideConvex(List<Point2D_I32> contour, LinkedList.Element<Corner> e1) {
        Point2D_I32 p1;
        Point2D_I32 p0;
        double d;
        LinkedList.Element<Corner> e2 = this.next(e1);
        int length = CircularIndex.distanceP(((Corner)e1.object).index, ((Corner)e2.object).index, contour.size());
        return !((double)length >= (d = (p0 = contour.get(((Corner)e1.object).index)).distance(p1 = contour.get(((Corner)e2.object).index))) * this.convexTest);
    }

    LinkedList.Element<Corner> selectCornerToSplit(boolean loops) {
        LinkedList.Element<Corner> end;
        LinkedList.Element<Corner> selected = null;
        double bestChange = this.convex ? 0.0 : -1.7976931348623157E308;
        LinkedList.Element<Corner> e = this.list.getHead();
        LinkedList.Element<Corner> element = end = loops ? null : this.list.getTail();
        while (e != end) {
            Corner c = (Corner)e.object;
            if (!c.splitable) {
                e = e.next;
                continue;
            }
            double change = c.sideError * 2.0 - c.splitError0 - c.splitError1;
            if (change < 0.0) {
                change = -change;
            }
            if (change > bestChange) {
                bestChange = change;
                selected = e;
            }
            e = e.next;
        }
        return selected;
    }

    LinkedList.Element<Corner> selectCornerToRemove(List<Point2D_I32> contour, ErrorValue sideError, boolean loops) {
        LinkedList.Element<Corner> end;
        LinkedList.Element<Corner> target;
        if (this.list.size() <= 3) {
            return null;
        }
        if (loops) {
            target = this.list.getHead();
            end = null;
        } else {
            target = this.list.getHead().next;
            end = this.list.getTail();
        }
        LinkedList.Element<Corner> best = null;
        double bestScore = -1.7976931348623157E308;
        while (target != end) {
            LinkedList.Element<Corner> p = this.previous(target);
            LinkedList.Element<Corner> n = this.next(target);
            double before = (((Corner)p.object).sideError + ((Corner)target.object).sideError) / 2.0 + this.cornerScorePenalty;
            double after = this.computeSideError(contour, ((Corner)p.object).index, ((Corner)n.object).index);
            if (before - after > bestScore) {
                bestScore = before - after;
                best = target;
                sideError.value = after;
            }
            target = target.next;
        }
        return best;
    }

    boolean removeCornerAndSavePolyline(LinkedList.Element<Corner> corner, double sideErrorAfterRemoved) {
        LinkedList.Element<Corner> p = this.previous(corner);
        ((Corner)p.object).sideError = sideErrorAfterRemoved;
        this.list.remove(corner);
        return this.savePolyline();
    }

    static int findCornerSeed(List<Point2D_I32> contour) {
        Point2D_I32 a = contour.get(0);
        int best = -1;
        double bestDistance = -1.7976931348623157E308;
        for (int i = 1; i < contour.size(); ++i) {
            Point2D_I32 b = contour.get(i);
            double d = PolylineSplitMerge.distanceSq(a, b);
            if (!(d > bestDistance)) continue;
            bestDistance = d;
            best = i;
        }
        return best;
    }

    static int maximumDistance(List<Point2D_I32> contour, int indexA, int indexB) {
        Point2D_I32 a = contour.get(indexA);
        Point2D_I32 b = contour.get(indexB);
        int best = -1;
        double bestDistance = -1.7976931348623157E308;
        for (int i = 0; i < contour.size(); ++i) {
            Point2D_I32 c = contour.get(i);
            double d = PolylineSplitMerge.distanceAbs(a, c) + PolylineSplitMerge.distanceAbs(b, c);
            if (!(d > bestDistance)) continue;
            bestDistance = d;
            best = i;
        }
        return best;
    }

    double computeSideError(List<Point2D_I32> contour, int indexA, int indexB) {
        int numSamples;
        PolylineSplitMerge.assignLine(contour, indexA, indexB, this.line);
        double sumOfDistances = 0.0;
        if (indexB >= indexA) {
            int length = indexB - indexA - 1;
            numSamples = Math.min(length, this.maxNumberOfSideSamples);
            for (int i = 0; i < numSamples; ++i) {
                int index = indexA + 1 + length * i / numSamples;
                Point2D_I32 p = contour.get(index);
                sumOfDistances += Distance2D_F64.distanceSq(this.line, (double)p.x, (double)p.y);
            }
            sumOfDistances /= (double)numSamples;
        } else {
            int length = contour.size() - indexA - 1 + indexB;
            numSamples = Math.min(length, this.maxNumberOfSideSamples);
            for (int i = 0; i < numSamples; ++i) {
                int where = length * i / numSamples;
                int index = (indexA + 1 + where) % contour.size();
                Point2D_I32 p = contour.get(index);
                sumOfDistances += Distance2D_F64.distanceSq(this.line, (double)p.x, (double)p.y);
            }
            sumOfDistances /= (double)numSamples;
        }
        if (numSamples > 0) {
            return sumOfDistances;
        }
        return 0.0;
    }

    void computePotentialSplitScore(List<Point2D_I32> contour, LinkedList.Element<Corner> e0, boolean mustSplit) {
        LinkedList.Element<Corner> e1 = this.next(e0);
        ((Corner)e0.object).splitable = this.canBeSplit(contour, e0, mustSplit);
        if (((Corner)e0.object).splitable) {
            this.setSplitVariables(contour, e0, e1);
        }
    }

    void setSplitVariables(List<Point2D_I32> contour, LinkedList.Element<Corner> e0, LinkedList.Element<Corner> e1) {
        Point2D_I32 c;
        Point2D_I32 b;
        Point2D_I32 a;
        int distance0 = CircularIndex.distanceP(((Corner)e0.object).index, ((Corner)e1.object).index, contour.size());
        int index0 = CircularIndex.plusPOffset(((Corner)e0.object).index, this.minimumSideLength, contour.size());
        int index1 = CircularIndex.minusPOffset(((Corner)e1.object).index, this.minimumSideLength, contour.size());
        this.splitter.selectSplitPoint(contour, index0, index1, this.resultsA);
        if (this.convex && UtilPolygons2D_I32.isPositiveZ(a = contour.get(((Corner)e0.object).index), b = contour.get(this.resultsA.index), c = contour.get(((Corner)this.next(e0).object).index))) {
            ((Corner)e0.object).splitable = false;
            return;
        }
        int dist0 = CircularIndex.distanceP(((Corner)e0.object).index, this.resultsA.index, contour.size());
        if (dist0 < this.minimumSideLength || contour.size() - dist0 < this.minimumSideLength) {
            throw new RuntimeException("Should be impossible");
        }
        ((Corner)e0.object).splitLocation = this.resultsA.index;
        ((Corner)e0.object).splitError0 = this.computeSideError(contour, ((Corner)e0.object).index, this.resultsA.index);
        ((Corner)e0.object).splitError1 = this.computeSideError(contour, this.resultsA.index, ((Corner)e1.object).index);
        if (((Corner)e0.object).splitLocation >= contour.size()) {
            throw new RuntimeException("Egads");
        }
    }

    boolean canBeSplit(List<Point2D_I32> contour, LinkedList.Element<Corner> e0, boolean mustSplit) {
        LinkedList.Element<Corner> e1 = this.next(e0);
        int length = CircularIndex.distanceP(((Corner)e0.object).index, ((Corner)e1.object).index, contour.size());
        if (length <= 2 * this.minimumSideLength) {
            return false;
        }
        return mustSplit || ((Corner)e0.object).sideError > this.thresholdSideSplitScore;
    }

    LinkedList.Element<Corner> next(LinkedList.Element<Corner> e) {
        if (e.next == null) {
            return this.list.getHead();
        }
        return e.next;
    }

    LinkedList.Element<Corner> previous(LinkedList.Element<Corner> e) {
        if (e.previous == null) {
            return this.list.getTail();
        }
        return e.previous;
    }

    static boolean isConvexUsingMaxDistantPoints(List<Point2D_I32> contour, int indexA, int indexB) {
        double d = Math.sqrt(PolylineSplitMerge.distanceSq(contour.get(indexA), contour.get(indexB)));
        int maxAllowed = (int)(4.141592653589793 * d + 0.5);
        int length0 = CircularIndex.distanceP(indexA, indexB, contour.size());
        int length1 = CircularIndex.distanceP(indexB, indexA, contour.size());
        return length0 <= maxAllowed && length1 <= maxAllowed;
    }

    static double distanceSq(Point2D_I32 a, Point2D_I32 b) {
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        return dx * dx + dy * dy;
    }

    static double distanceAbs(Point2D_I32 a, Point2D_I32 b) {
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        return Math.abs(dx) + Math.abs(dy);
    }

    public static void assignLine(List<Point2D_I32> contour, int indexA, int indexB, LineParametric2D_F64 line) {
        Point2D_I32 endA = contour.get(indexA);
        Point2D_I32 endB = contour.get(indexB);
        line.p.x = endA.x;
        line.p.y = endA.y;
        line.slope.x = endB.x - endA.x;
        line.slope.y = endB.y - endA.y;
    }

    public static void assignLine(List<Point2D_I32> contour, int indexA, int indexB, LineSegment2D_F64 line) {
        Point2D_I32 endA = contour.get(indexA);
        Point2D_I32 endB = contour.get(indexB);
        line.a.set(endA.x, endA.y);
        line.b.set(endB.x, endB.y);
    }

    public FastQueue<CandidatePolyline> getPolylines() {
        return this.polylines;
    }

    public CandidatePolyline getBestPolyline() {
        return this.bestPolyline;
    }

    public void setLoops(boolean loops) {
        this.loops = loops;
    }

    public boolean isLoops() {
        return this.loops;
    }

    public boolean isConvex() {
        return this.convex;
    }

    public void setConvex(boolean convex) {
        this.convex = convex;
    }

    public int getMaxSides() {
        return this.maxSides;
    }

    public void setMaxSides(int maxSides) {
        this.maxSides = maxSides;
    }

    public int getMinimumSideLength() {
        return this.minimumSideLength;
    }

    public void setMinimumSideLength(int minimumSideLength) {
        if (minimumSideLength <= 0) {
            throw new IllegalArgumentException("Minimum length must be at least 1");
        }
        this.minimumSideLength = minimumSideLength;
    }

    public double getCornerScorePenalty() {
        return this.cornerScorePenalty;
    }

    public void setCornerScorePenalty(double cornerScorePenalty) {
        this.cornerScorePenalty = cornerScorePenalty;
    }

    public double getThresholdSideSplitScore() {
        return this.thresholdSideSplitScore;
    }

    public void setThresholdSideSplitScore(double thresholdSideSplitScore) {
        this.thresholdSideSplitScore = thresholdSideSplitScore;
    }

    public int getMaxNumberOfSideSamples() {
        return this.maxNumberOfSideSamples;
    }

    public void setMaxNumberOfSideSamples(int maxNumberOfSideSamples) {
        this.maxNumberOfSideSamples = maxNumberOfSideSamples;
    }

    public void setSplitter(SplitSelector splitter) {
        this.splitter = splitter;
    }

    public int getMinSides() {
        return this.minSides;
    }

    public void setMinSides(int minSides) {
        this.minSides = minSides;
    }

    public ConfigLength getExtraConsider() {
        return this.extraConsider;
    }

    public void setExtraConsider(ConfigLength extraConsider) {
        this.extraConsider = extraConsider;
    }

    public double getConvexTest() {
        return this.convexTest;
    }

    public void setConvexTest(double convexTest) {
        this.convexTest = convexTest;
    }

    public ConfigLength getMaxSideError() {
        return this.maxSideError;
    }

    public void setMaxSideError(ConfigLength maxSideError) {
        this.maxSideError = maxSideError;
    }

    static class ErrorValue {
        public double value;

        ErrorValue() {
        }
    }

    public static class CandidatePolyline {
        public GrowQueue_I32 splits = new GrowQueue_I32();
        public double score;
        public double maxSideError;
        public GrowQueue_F64 sideErrors = new GrowQueue_F64();

        public void reset() {
            this.splits.reset();
            this.sideErrors.reset();
            this.score = Double.NaN;
            this.maxSideError = Double.NaN;
        }
    }

    public static class Corner {
        public int index;
        public double sideError;
        public int splitLocation;
        public double splitError0;
        public double splitError1;
        public boolean splitable;

        public void reset() {
            this.index = -1;
            this.sideError = -1.0;
            this.splitLocation = -1;
            this.splitError1 = -1.0;
            this.splitError0 = -1.0;
            this.splitable = true;
        }
    }

    static class SplitResults {
        public int index;
        public double score;

        SplitResults() {
        }
    }
}

