/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure2;

import boofcv.alg.sfm.structure2.LookupSimilarImages;
import boofcv.alg.sfm.structure2.PairwiseImageGraph2;
import boofcv.alg.sfm.structure2.ProjectiveExpandToNeighbors;
import boofcv.alg.sfm.structure2.ProjectiveInitializeAllCommon;
import boofcv.struct.ScoreIndex;
import boofcv.struct.feature.AssociatedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class DoStuffFromPairwiseGraph {
    List<SeedInfo> scoresNodes = new ArrayList<SeedInfo>();
    FastQueue<ScoreIndex> scoresMotions = new FastQueue<ScoreIndex>(ScoreIndex.class, true);
    ProjectiveInitializeAllCommon initProjective = new ProjectiveInitializeAllCommon();
    ProjectiveExpandToNeighbors expandProjective = new ProjectiveExpandToNeighbors();

    public void process(LookupSimilarImages db, PairwiseImageGraph2 graph) {
        int i;
        Map<Integer, SeedInfo> mapScores = this.scoreNodesAsSeeds(graph);
        List<SeedInfo> seeds = this.selectSeeds(graph, mapScores);
        for (i = 0; i < seeds.size(); ++i) {
            SeedInfo seed = seeds.get(i);
            GrowQueue_I32 common = this.findCommonTracks(seed);
            this.initProjective.projectiveSceneN(db, seeds.get((int)i).seed, common, seed.motions);
        }
        for (i = 0; i < seeds.size(); ++i) {
        }
    }

    private GrowQueue_I32 findCommonTracks(SeedInfo target) {
        boolean[] visibleAll = new boolean[target.seed.totalFeatures];
        Arrays.fill(visibleAll, true);
        boolean[] visibleMotion = new boolean[target.seed.totalFeatures];
        for (int idxMotion = 0; idxMotion < target.motions.size; ++idxMotion) {
            int i;
            PairwiseImageGraph2.Motion m = target.seed.connections.get(target.motions.get(idxMotion));
            boolean seedIsSrc = m.src == target.seed;
            Arrays.fill(visibleMotion, false);
            for (i = 0; i < m.inliers.size; ++i) {
                AssociatedIndex a = m.inliers.get(i);
                visibleMotion[seedIsSrc ? a.src : a.dst] = true;
            }
            for (i = 0; i < target.seed.totalFeatures; ++i) {
                int n = i;
                visibleAll[n] = visibleAll[n] & visibleMotion[i];
            }
        }
        GrowQueue_I32 common = new GrowQueue_I32(target.seed.totalFeatures / 10 + 1);
        for (int i = 0; i < target.seed.totalFeatures; ++i) {
            if (!visibleAll[i]) continue;
            common.add(i);
        }
        return common;
    }

    private Map<Integer, SeedInfo> scoreNodesAsSeeds(PairwiseImageGraph2 graph) {
        this.scoresNodes.clear();
        HashMap<Integer, SeedInfo> mapScores = new HashMap<Integer, SeedInfo>();
        for (int idxView = 0; idxView < graph.nodes.size; ++idxView) {
            PairwiseImageGraph2.View v = graph.nodes.get(idxView);
            SeedInfo info = this.score(v);
            this.scoresNodes.add(info);
            mapScores.put(idxView, info);
        }
        return mapScores;
    }

    private List<SeedInfo> selectSeeds(PairwiseImageGraph2 graph, Map<Integer, SeedInfo> mapScores) {
        int maxSeeds = Math.max(1, graph.nodes.size / 5);
        ArrayList<SeedInfo> seeds = new ArrayList<SeedInfo>();
        Collections.sort(this.scoresNodes);
        double minScore = this.scoresNodes.get((int)(this.scoresNodes.size() - 1)).score * 0.2;
        for (int i = this.scoresNodes.size() - 1; i >= 0 && seeds.size() < maxSeeds; --i) {
            SeedInfo s = this.scoresNodes.get(i);
            if (s.score <= minScore) continue;
            seeds.add(s);
            for (int j = 0; j < s.seed.connections.size; ++j) {
                mapScores.get((Object)Integer.valueOf((int)s.seed.connections.get((int)j).index)).score = 0.0;
            }
        }
        return seeds;
    }

    private SeedInfo score(PairwiseImageGraph2.View target) {
        int i;
        SeedInfo output = new SeedInfo();
        output.seed = target;
        this.scoresMotions.reset();
        for (i = 0; i < target.connections.size; ++i) {
            PairwiseImageGraph2.Motion m = target.connections.get(i);
            if (!m.is3D) continue;
            this.scoresMotions.grow().set(DoStuffFromPairwiseGraph.score(m), i);
        }
        Collections.sort(this.scoresMotions.toList());
        for (i = Math.min(2, this.scoresMotions.size); i >= 0; --i) {
            output.motions.add(this.scoresMotions.get((int)i).index);
            output.score += this.scoresMotions.get((int)i).score;
        }
        return output;
    }

    public static double score(PairwiseImageGraph2.Motion m) {
        double score = Math.min(5.0, (double)m.countF / (double)(m.countH + 1));
        return score *= (double)m.countF;
    }

    private static class SeedInfo
    implements Comparable<SeedInfo> {
        PairwiseImageGraph2.View seed;
        double score;
        GrowQueue_I32 motions = new GrowQueue_I32();

        private SeedInfo() {
        }

        @Override
        public int compareTo(SeedInfo o) {
            return Double.compare(this.score, o.score);
        }
    }
}

