/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.abst.geo.RefineEpipolar;
import boofcv.abst.geo.Triangulate2ViewsProjective;
import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.sfm.EstimateSceneStructure;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.EpipolarError;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point4D_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;
import org.ddogleg.struct.GrowQueue_I32;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class EstimateSceneUncalibrated
implements EstimateSceneStructure<SceneStructureProjective> {
    BundleAdjustment<SceneStructureProjective> sba = FactoryMultiView.bundleSparseProjective(null);
    FastQueue<ProjectiveView> views = new FastQueue<ProjectiveView>(ProjectiveView.class, true);
    FastQueue<Feature3D> features = new FastQueue<Feature3D>(Feature3D.class, true);
    GrowQueue_F64 scores = new GrowQueue_F64();
    PairwiseImageGraph graph;
    Estimate1ofEpipolar computeH = FactoryMultiView.homographyDLT(true);
    RefineEpipolar refineH = FactoryMultiView.homographyRefine(1.0E-6, 5, EpipolarError.SAMPSON);
    FastQueue<AssociatedPair> pairs = new FastQueue<AssociatedPair>(AssociatedPair.class, true);
    GrowQueue_F64 errors = new GrowQueue_F64();
    Triangulate2ViewsProjective triangulator = FactoryMultiView.triangulate2ViewProjective(ConfigTriangulation.GEOMETRIC);
    PrintStream verbose;
    boolean stopRequested;

    @Override
    public boolean process(PairwiseImageGraph graph) {
        this.graph = graph;
        this.stopRequested = false;
        this.views.reset();
        this.features.reset();
        for (int i = 0; i < graph.nodes.size(); ++i) {
            PairwiseImageGraph.View v = graph.nodes.get(i);
            this.views.grow().initialize(v);
        }
        for (String cameraName : graph.cameras.keySet()) {
            PairwiseImageGraph.Motion next;
            PairwiseImageGraph.Camera camera = graph.cameras.get(cameraName);
            List<PairwiseImageGraph.Motion> open = graph.findCameraMotions(camera, null);
            if (open.isEmpty()) continue;
            this.scores.resize(open.size());
            for (int i = 0; i < open.size(); ++i) {
                this.scores.data[i] = this.scoreForTriangulation(open.get(i));
            }
            int bestIndex = this.scores.indexOfGreatest();
            if (!this.initializeStructure(open.get(bestIndex))) {
                throw new RuntimeException("Failed?!?");
            }
            this.scores.data[bestIndex] = -1.0;
            while (open.size() > 0 && (next = this.selectNextMotion(open)) != null) {
                this.scores.data[next.index] = -1.0;
            }
        }
        return true;
    }

    @Override
    public SceneStructureProjective getSceneStructure() {
        return null;
    }

    @Override
    public SceneObservations getObservations() {
        return null;
    }

    @Override
    public void reset() {
    }

    PairwiseImageGraph.Motion selectNextMotion(List<PairwiseImageGraph.Motion> motions) {
        double best = 0.0;
        PairwiseImageGraph.Motion selected = null;
        for (int i = 0; i < motions.size(); ++i) {
            if (this.scores.data[i] <= 0.0) continue;
            PairwiseImageGraph.Motion v = motions.get(i);
            ProjectiveView viewA = this.views.get(v.viewSrc.index);
            ProjectiveView viewB = this.views.get(v.viewDst.index);
            if (!viewA.estimated && !viewB.estimated || !(this.scores.data[i] > best)) continue;
            best = this.scores.data[i];
            selected = v;
        }
        return selected;
    }

    boolean initializeStructure(PairwiseImageGraph.Motion selected) {
        ProjectiveView viewA = this.views.get(selected.viewSrc.index);
        ProjectiveView viewB = this.views.get(selected.viewDst.index);
        CommonOps_DDRM.setIdentity(viewA.P);
        viewB.P.set(MultiViewOps.fundamentalToProjective(selected.F));
        viewA.estimated = true;
        viewB.estimated = true;
        selected.viewDst = null;
        selected.viewSrc = null;
        Point4D_F64 X2 = new Point4D_F64();
        for (int i = 0; i < selected.associated.size(); ++i) {
            AssociatedIndex ai = selected.associated.get(i);
            if (!this.triangulator.triangulate(viewA.view.observationPixels.get(ai.src), viewB.view.observationPixels.get(ai.dst), viewA.P, viewB.P, X2)) continue;
            Feature3D f3 = new Feature3D();
            f3.obsIdx.add(ai.src);
            f3.obsIdx.add(ai.dst);
            f3.views.add(viewA);
            f3.views.add(viewB);
            f3.worldPt.set(X2);
            this.features.add(f3);
        }
        return true;
    }

    double scoreForTriangulation(PairwiseImageGraph.Motion motion) {
        DMatrixRMaj H = new DMatrixRMaj(3, 3);
        PairwiseImageGraph.View viewA = motion.viewSrc;
        PairwiseImageGraph.View viewB = motion.viewDst;
        this.pairs.reset();
        for (int i = 0; i < motion.associated.size(); ++i) {
            AssociatedIndex ai = motion.associated.get(i);
            this.pairs.grow().set(viewA.observationPixels.get(ai.src), viewB.observationPixels.get(ai.dst));
        }
        if (!this.computeH.process(this.pairs.toList(), H)) {
            return -1.0;
        }
        if (!this.refineH.fitModel(this.pairs.toList(), H, H)) {
            return -1.0;
        }
        MultiViewOps.errorsHomographySymm(this.pairs.toList(), H, null, this.errors);
        this.errors.sort();
        return this.errors.getFraction(0.5) * (double)Math.max(5, this.pairs.size - 20);
    }

    @Override
    public void requestStop() {
        this.stopRequested = true;
    }

    @Override
    public boolean isStopRequested() {
        return this.stopRequested;
    }

    public void setVerbose(PrintStream verbose) {
        this.verbose = verbose;
    }

    static class Feature3D {
        public Point4D_F64 worldPt = new Point4D_F64();
        public GrowQueue_I32 obsIdx = new GrowQueue_I32();
        public List<ProjectiveView> views = new ArrayList<ProjectiveView>();

        Feature3D() {
        }
    }

    static class ProjectiveView {
        public DMatrixRMaj P = new DMatrixRMaj(3, 4);
        public PairwiseImageGraph.View view;
        public boolean estimated;

        ProjectiveView() {
        }

        public void initialize(PairwiseImageGraph.View view) {
            CommonOps_DDRM.setIdentity(this.P);
            this.view = view;
            this.estimated = false;
        }
    }
}

