/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.triangulate;

import boofcv.alg.geo.GeometricResult;
import boofcv.alg.geo.NormalizationPoint2D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.Arrays;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;

public class TriangulateMetricLinearDLT {
    private SolveNullSpaceSvd_DDRM solverNull = new SolveNullSpaceSvd_DDRM();
    private DMatrixRMaj nullspace = new DMatrixRMaj(4, 1);
    private DMatrixRMaj A = new DMatrixRMaj(4, 4);
    public double singularThreshold = 1.0;
    NormalizationPoint2D stats = new NormalizationPoint2D();

    public GeometricResult triangulate(List<Point2D_F64> observations, List<Se3_F64> worldToView, Point4D_F64 found) {
        if (observations.size() != worldToView.size()) {
            throw new IllegalArgumentException("Number of observations must match the number of motions");
        }
        int N = worldToView.size();
        this.A.reshape(2 * N, 4, false);
        int index = 0;
        for (int i = 0; i < N; ++i) {
            index = this.addView(worldToView.get(i), observations.get(i), index);
        }
        return this.finishSolving(found);
    }

    public GeometricResult triangulate(Point2D_F64 a, Point2D_F64 b, Se3_F64 fromAtoB, Point4D_F64 foundInA) {
        this.A.reshape(4, 4);
        int index = this.addView(fromAtoB, b, 0);
        this.A.data[index++] = -1.0;
        this.A.data[index++] = 0.0;
        this.A.data[index++] = a.x;
        this.A.data[index++] = 0.0;
        this.A.data[index++] = 0.0;
        this.A.data[index++] = -1.0;
        this.A.data[index++] = a.y;
        this.A.data[index] = 0.0;
        return this.finishSolving(foundInA);
    }

    private GeometricResult finishSolving(Point4D_F64 foundInA) {
        if (!this.solverNull.process(this.A, 1, this.nullspace)) {
            return GeometricResult.SOLVE_FAILED;
        }
        double[] sv = this.solverNull.getSingularValues();
        Arrays.sort(sv);
        if (sv[1] * this.singularThreshold <= sv[0]) {
            return GeometricResult.GEOMETRY_POOR;
        }
        foundInA.x = this.nullspace.get(0);
        foundInA.y = this.nullspace.get(1);
        foundInA.z = this.nullspace.get(2);
        foundInA.w = this.nullspace.get(3);
        return GeometricResult.SUCCESS;
    }

    private int addView(Se3_F64 motion, Point2D_F64 a, int index) {
        double sx = this.stats.stdX;
        double sy = this.stats.stdY;
        DMatrixRMaj R = motion.getR();
        Vector3D_F64 T = motion.getT();
        double r11 = R.data[0];
        double r12 = R.data[1];
        double r13 = R.data[2];
        double r21 = R.data[3];
        double r22 = R.data[4];
        double r23 = R.data[5];
        double r31 = R.data[6];
        double r32 = R.data[7];
        double r33 = R.data[8];
        this.A.data[index++] = (a.x * r31 - r11) / sx;
        this.A.data[index++] = (a.x * r32 - r12) / sx;
        this.A.data[index++] = (a.x * r33 - r13) / sx;
        this.A.data[index++] = (a.x * T.z - T.x) / sx;
        this.A.data[index++] = (a.y * r31 - r21) / sy;
        this.A.data[index++] = (a.y * r32 - r22) / sy;
        this.A.data[index++] = (a.y * r33 - r23) / sy;
        this.A.data[index++] = (a.y * T.z - T.y) / sy;
        return index;
    }

    public double getSingularThreshold() {
        return this.singularThreshold;
    }

    public void setSingularThreshold(double singularThreshold) {
        this.singularThreshold = singularThreshold;
    }
}

