/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentSchur;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.bundle.CodecSceneStructureMetric;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.transform.se.SePointOps_F64;

public class BundleAdjustmentMetricResidualFunction
implements BundleAdjustmentSchur.FunctionResiduals<SceneStructureMetric> {
    private SceneStructureMetric structure;
    private SceneObservations observations;
    private Point3D_F64 worldPt = new Point3D_F64();
    private int numParameters;
    private int numObservations;
    private Point3D_F64 cameraPt = new Point3D_F64();
    private Point2D_F64 predictedPixel = new Point2D_F64();
    private PointIndex2D_F64 observedPixel = new PointIndex2D_F64();
    CodecSceneStructureMetric codec = new CodecSceneStructureMetric();
    Point3D_F64 p3 = new Point3D_F64();
    Point4D_F64 p4 = new Point4D_F64();

    @Override
    public void configure(SceneStructureMetric structure, SceneObservations observations) {
        this.structure = structure;
        this.observations = observations;
        this.numObservations = observations.getObservationCount();
        this.numParameters = structure.getParameterCount();
        structure.assignIDsToRigidPoints();
    }

    @Override
    public int getNumOfInputsN() {
        return this.numParameters;
    }

    @Override
    public int getNumOfOutputsM() {
        return this.numObservations * 2;
    }

    @Override
    public void process(double[] input, double[] output) {
        this.codec.decode(input, this.structure);
        if (this.structure.homogenous) {
            this.project4(output);
        } else {
            this.project3(output);
        }
    }

    private void project3(double[] output) {
        int observationIndex = 0;
        for (int viewIndex = 0; viewIndex < this.structure.views.size; ++viewIndex) {
            int i;
            SceneStructureMetric.View view = this.structure.views.get(viewIndex);
            SceneStructureCommon.Camera camera = (SceneStructureCommon.Camera)this.structure.cameras.get(view.camera);
            SceneObservations.View obsView = this.observations.views.get(viewIndex);
            for (i = 0; i < obsView.size(); ++i) {
                obsView.get(i, this.observedPixel);
                SceneStructureCommon.Point worldPt = ((SceneStructureCommon.Point[])this.structure.points.data)[this.observedPixel.index];
                worldPt.get(this.p3);
                SePointOps_F64.transform(view.worldToView, this.p3, this.cameraPt);
                camera.model.project(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.predictedPixel);
                int outputIndex = observationIndex * 2;
                output[outputIndex] = this.predictedPixel.x - this.observedPixel.x;
                output[outputIndex + 1] = this.predictedPixel.y - this.observedPixel.y;
                ++observationIndex;
            }
            if (!this.observations.hasRigid()) continue;
            obsView = this.observations.viewsRigid.get(viewIndex);
            for (i = 0; i < obsView.size(); ++i) {
                obsView.get(i, this.observedPixel);
                int rigidIndex = this.structure.lookupRigid[this.observedPixel.index];
                SceneStructureMetric.Rigid rigid = this.structure.rigids.get(rigidIndex);
                int pointIndex = this.observedPixel.index - rigid.indexFirst;
                SceneStructureCommon.Point objectPt = rigid.points[pointIndex];
                objectPt.get(this.p3);
                SePointOps_F64.transform(rigid.objectToWorld, this.p3, this.worldPt);
                SePointOps_F64.transform(view.worldToView, this.worldPt, this.cameraPt);
                camera.model.project(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.predictedPixel);
                int outputIndex = observationIndex * 2;
                output[outputIndex] = this.predictedPixel.x - this.observedPixel.x;
                output[outputIndex + 1] = this.predictedPixel.y - this.observedPixel.y;
                ++observationIndex;
            }
        }
    }

    private void project4(double[] output) {
        int observationIndex = 0;
        for (int viewIndex = 0; viewIndex < this.structure.views.size; ++viewIndex) {
            int i;
            SceneStructureMetric.View view = this.structure.views.get(viewIndex);
            SceneStructureCommon.Camera camera = (SceneStructureCommon.Camera)this.structure.cameras.get(view.camera);
            SceneObservations.View obsView = this.observations.views.get(viewIndex);
            for (i = 0; i < obsView.size(); ++i) {
                obsView.get(i, this.observedPixel);
                SceneStructureCommon.Point worldPt = ((SceneStructureCommon.Point[])this.structure.points.data)[this.observedPixel.index];
                worldPt.get(this.p4);
                SePointOps_F64.transform(view.worldToView, this.p4, this.cameraPt);
                camera.model.project(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.predictedPixel);
                int outputIndex = observationIndex * 2;
                output[outputIndex] = this.predictedPixel.x - this.observedPixel.x;
                output[outputIndex + 1] = this.predictedPixel.y - this.observedPixel.y;
                ++observationIndex;
            }
            if (!this.observations.hasRigid()) continue;
            obsView = this.observations.viewsRigid.get(viewIndex);
            for (i = 0; i < obsView.size(); ++i) {
                obsView.get(i, this.observedPixel);
                int rigidIndex = this.structure.lookupRigid[this.observedPixel.index];
                SceneStructureMetric.Rigid rigid = this.structure.rigids.get(rigidIndex);
                int pointIndex = this.observedPixel.index - rigid.indexFirst;
                SceneStructureCommon.Point objectPt = rigid.points[pointIndex];
                objectPt.get(this.p4);
                SePointOps_F64.transform(rigid.objectToWorld, this.p4, this.worldPt);
                SePointOps_F64.transform(view.worldToView, this.worldPt, this.cameraPt);
                camera.model.project(this.cameraPt.x, this.cameraPt.y, this.cameraPt.z, this.predictedPixel);
                int outputIndex = observationIndex * 2;
                output[outputIndex] = this.predictedPixel.x - this.observedPixel.x;
                output[outputIndex + 1] = this.predictedPixel.y - this.observedPixel.y;
                ++observationIndex;
            }
        }
    }
}

