/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.feature.detect.intensity.impl.ImplSsdCornerBase;
import boofcv.alg.filter.convolve.ConvolveImageNormalized;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;

public class ImplSsdCornerWeighted_S16_MT
extends ImplSsdCornerBase<GrayS16, GrayS32>
implements GradientCornerIntensity<GrayS16> {
    ImplSsdCornerBase.CornerIntensity_S32 intensity;
    Kernel1D_S32 kernel;
    GrayS32 temp = new GrayS32(1, 1);

    public ImplSsdCornerWeighted_S16_MT(int radius, ImplSsdCornerBase.CornerIntensity_S32 intensity) {
        super(radius, GrayS32.class);
        this.intensity = intensity;
        this.kernel = FactoryKernelGaussian.gaussian(Kernel1D_S32.class, -1.0, radius);
    }

    @Override
    public void process(GrayS16 derivX, GrayS16 derivY, GrayF32 intensity) {
        InputSanityCheck.checkSameShape(derivX, derivY);
        intensity.reshape(derivX.width, derivX.height);
        int w = derivX.width;
        int h = derivX.height;
        ((GrayS32)this.horizXX).reshape(w, h);
        ((GrayS32)this.horizXY).reshape(w, h);
        ((GrayS32)this.horizYY).reshape(w, h);
        this.temp.reshape(w, h);
        intensity.reshape(w, h);
        BoofConcurrency.loopFor(0, h, y -> {
            int indexX = derivX.startIndex + derivX.stride * y;
            int indexY = derivY.startIndex + derivY.stride * y;
            int index = ((GrayS32)this.horizXX).stride * y;
            int x = 0;
            while (x < w) {
                short dx = derivX.data[indexX++];
                short dy = derivY.data[indexY++];
                ((GrayS32)this.horizXX).data[index] = dx * dx;
                ((GrayS32)this.horizXY).data[index] = dx * dy;
                ((GrayS32)this.horizYY).data[index] = dy * dy;
                ++x;
                ++index;
            }
        });
        this.blur((GrayS32)this.horizXX, this.temp);
        this.blur((GrayS32)this.horizXY, this.temp);
        this.blur((GrayS32)this.horizYY, this.temp);
        BoofConcurrency.loopFor(0, h, y -> {
            int index = ((GrayS32)this.horizXX).stride * y;
            int x = 0;
            while (x < w) {
                int totalXX = ((GrayS32)this.horizXX).data[index];
                int totalXY = ((GrayS32)this.horizXY).data[index];
                int totalYY = ((GrayS32)this.horizYY).data[index];
                intensity.data[index] = this.intensity.compute(totalXX, totalXY, totalYY);
                ++x;
                ++index;
            }
        });
    }

    private void blur(GrayS32 image, GrayS32 temp) {
        ConvolveImageNormalized.horizontal(this.kernel, image, temp);
        ConvolveImageNormalized.vertical(this.kernel, temp, image);
    }

    @Override
    public int getIgnoreBorder() {
        return 0;
    }
}

