/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe.brief;

import boofcv.alg.feature.describe.brief.BinaryCompareDefinition_I32;
import georegression.struct.point.Point2D_I32;
import java.util.Random;

public class FactoryBriefDefinition {
    public static BinaryCompareDefinition_I32 gaussian(Random rand, int radius, int numPairs) {
        BinaryCompareDefinition_I32 ret = new BinaryCompareDefinition_I32(radius, numPairs * 2, numPairs);
        double sigma = (2.0 * (double)radius + 1.0) / 5.0;
        for (int i = 0; i < numPairs; ++i) {
            FactoryBriefDefinition.randomGaussian(rand, sigma, radius, ret.samplePoints[i]);
            FactoryBriefDefinition.randomGaussian(rand, sigma, radius, ret.samplePoints[i + numPairs]);
            ret.compare[i].set(i, i + numPairs);
        }
        return ret;
    }

    public static BinaryCompareDefinition_I32 gaussian2(Random rand, int radius, int numPairs) {
        BinaryCompareDefinition_I32 ret = new BinaryCompareDefinition_I32(radius, numPairs, numPairs);
        double sigma = (2.0 * (double)radius + 1.0) / 5.0;
        for (int i = 0; i < numPairs; ++i) {
            FactoryBriefDefinition.randomGaussian(rand, sigma, radius, ret.samplePoints[i]);
            ret.compare[i].set(i, rand.nextInt(numPairs));
        }
        return ret;
    }

    private static void randomGaussian(Random rand, double sigma, int radius, Point2D_I32 pt) {
        int y;
        int x;
        while (!(Math.sqrt((x = (int)(rand.nextGaussian() * sigma)) * x + (y = (int)(rand.nextGaussian() * sigma)) * y) < (double)radius)) {
        }
        pt.set(x, y);
    }
}

