/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.enhance.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayU8;

public class ImplEnhanceFilter_MT {
    public static void sharpenInner4(GrayU8 input, GrayU8 output, int minValue, int maxValue) {
        BoofConcurrency.loopFor(1, input.height - 1, y -> {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int x = 1;
            while (x < input.width - 1) {
                int a = 5 * (input.data[indexIn] & 0xFF) - ((input.data[indexIn - 1] & 0xFF) + (input.data[indexIn + 1] & 0xFF) + (input.data[indexIn - input.stride] & 0xFF) + (input.data[indexIn + input.stride] & 0xFF));
                if (a > maxValue) {
                    a = maxValue;
                } else if (a < minValue) {
                    a = minValue;
                }
                output.data[indexOut] = (byte)a;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        });
    }

    public static void sharpenBorder4(GrayU8 input, GrayU8 output, int minValue, int maxValue) {
        int b = input.height - 1;
        int c = input.width - 1;
        BoofConcurrency.loopFor(0, input.width, x -> {
            int indexTop = input.startIndex + x;
            int indexBottom = input.startIndex + b * input.stride + x;
            int value = 4 * ImplEnhanceFilter_MT.safeGet(input, x, 0) - (ImplEnhanceFilter_MT.safeGet(input, x - 1, 0) + ImplEnhanceFilter_MT.safeGet(input, x + 1, 0) + ImplEnhanceFilter_MT.safeGet(input, x, 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexTop++] = (byte)value;
            value = 4 * ImplEnhanceFilter_MT.safeGet(input, x, b) - (ImplEnhanceFilter_MT.safeGet(input, x - 1, b) + ImplEnhanceFilter_MT.safeGet(input, x + 1, b) + ImplEnhanceFilter_MT.safeGet(input, x, b - 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexBottom++] = (byte)value;
        });
        BoofConcurrency.loopFor(1, input.height - 1, y -> {
            int indexLeft = input.startIndex + input.stride * y;
            int indexRight = input.startIndex + input.stride * y + c;
            int value = 4 * ImplEnhanceFilter_MT.safeGet(input, 0, y) - (ImplEnhanceFilter_MT.safeGet(input, 1, y) + ImplEnhanceFilter_MT.safeGet(input, 0, y - 1) + ImplEnhanceFilter_MT.safeGet(input, 0, y + 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexLeft] = (byte)value;
            value = 4 * ImplEnhanceFilter_MT.safeGet(input, c, y) - (ImplEnhanceFilter_MT.safeGet(input, c - 1, y) + ImplEnhanceFilter_MT.safeGet(input, c, y - 1) + ImplEnhanceFilter_MT.safeGet(input, c, y + 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexRight] = (byte)value;
        });
    }

    public static void sharpenInner4(GrayF32 input, GrayF32 output, float minValue, float maxValue) {
        BoofConcurrency.loopFor(1, input.height - 1, y -> {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int x = 1;
            while (x < input.width - 1) {
                float a = 5.0f * input.data[indexIn] - (input.data[indexIn - 1] + input.data[indexIn + 1] + input.data[indexIn - input.stride] + input.data[indexIn + input.stride]);
                if (a > maxValue) {
                    a = maxValue;
                } else if (a < minValue) {
                    a = minValue;
                }
                output.data[indexOut] = a;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        });
    }

    public static void sharpenBorder4(GrayF32 input, GrayF32 output, float minValue, float maxValue) {
        int b = input.height - 1;
        int c = input.width - 1;
        BoofConcurrency.loopFor(0, input.width, x -> {
            int indexTop = input.startIndex + x;
            int indexBottom = input.startIndex + b * input.stride + x;
            float value = 4.0f * ImplEnhanceFilter_MT.safeGet(input, x, 0) - (ImplEnhanceFilter_MT.safeGet(input, x - 1, 0) + ImplEnhanceFilter_MT.safeGet(input, x + 1, 0) + ImplEnhanceFilter_MT.safeGet(input, x, 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexTop++] = value;
            value = 4.0f * ImplEnhanceFilter_MT.safeGet(input, x, b) - (ImplEnhanceFilter_MT.safeGet(input, x - 1, b) + ImplEnhanceFilter_MT.safeGet(input, x + 1, b) + ImplEnhanceFilter_MT.safeGet(input, x, b - 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexBottom++] = value;
        });
        BoofConcurrency.loopFor(1, input.height - 1, y -> {
            int indexLeft = input.startIndex + input.stride * y;
            int indexRight = input.startIndex + input.stride * y + c;
            float value = 4.0f * ImplEnhanceFilter_MT.safeGet(input, 0, y) - (ImplEnhanceFilter_MT.safeGet(input, 1, y) + ImplEnhanceFilter_MT.safeGet(input, 0, y - 1) + ImplEnhanceFilter_MT.safeGet(input, 0, y + 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexLeft] = value;
            value = 4.0f * ImplEnhanceFilter_MT.safeGet(input, c, y) - (ImplEnhanceFilter_MT.safeGet(input, c - 1, y) + ImplEnhanceFilter_MT.safeGet(input, c, y - 1) + ImplEnhanceFilter_MT.safeGet(input, c, y + 1));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexRight] = value;
        });
    }

    public static void sharpenInner8(GrayU8 input, GrayU8 output, int minValue, int maxValue) {
        BoofConcurrency.loopFor(1, input.height - 1, y -> {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int x = 1;
            while (x < input.width - 1) {
                int a22 = input.data[indexIn] & 0xFF;
                int a11 = input.data[indexIn - input.stride - 1] & 0xFF;
                int a12 = input.data[indexIn - input.stride] & 0xFF;
                int a13 = input.data[indexIn - input.stride + 1] & 0xFF;
                int a21 = input.data[indexIn - 1] & 0xFF;
                int a23 = input.data[indexIn + 1] & 0xFF;
                int a31 = input.data[indexIn + input.stride - 1] & 0xFF;
                int a32 = input.data[indexIn + input.stride] & 0xFF;
                int a33 = input.data[indexIn + input.stride + 1] & 0xFF;
                int result = 9 * a22 - (a11 + a12 + a13 + a21 + a23 + a31 + a32 + a33);
                if (result > maxValue) {
                    result = maxValue;
                } else if (result < minValue) {
                    result = minValue;
                }
                output.data[indexOut] = (byte)result;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        });
    }

    public static void sharpenBorder8(GrayU8 input, GrayU8 output, int minValue, int maxValue) {
        int b = input.height - 1;
        int c = input.width - 1;
        BoofConcurrency.loopFor(0, input.width, x -> {
            int a33;
            int a32;
            int a31;
            int a23;
            int indexTop = input.startIndex + x;
            int indexBottom = input.startIndex + x + b * input.stride;
            int a11 = ImplEnhanceFilter_MT.safeGet(input, x - 1, -1);
            int a12 = ImplEnhanceFilter_MT.safeGet(input, x, -1);
            int a13 = ImplEnhanceFilter_MT.safeGet(input, x + 1, -1);
            int a21 = ImplEnhanceFilter_MT.safeGet(input, x - 1, 0);
            int a22 = ImplEnhanceFilter_MT.safeGet(input, x, 0);
            int value = 9 * a22 - (a11 + a12 + a13 + a21 + (a23 = ImplEnhanceFilter_MT.safeGet(input, x + 1, 0)) + (a31 = ImplEnhanceFilter_MT.safeGet(input, x - 1, 1)) + (a32 = ImplEnhanceFilter_MT.safeGet(input, x, 1)) + (a33 = ImplEnhanceFilter_MT.safeGet(input, x + 1, 1)));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexTop++] = (byte)value;
            a11 = ImplEnhanceFilter_MT.safeGet(input, x - 1, b - 1);
            a12 = ImplEnhanceFilter_MT.safeGet(input, x, b - 1);
            a13 = ImplEnhanceFilter_MT.safeGet(input, x + 1, b - 1);
            a21 = ImplEnhanceFilter_MT.safeGet(input, x - 1, b);
            a22 = ImplEnhanceFilter_MT.safeGet(input, x, b);
            a23 = ImplEnhanceFilter_MT.safeGet(input, x + 1, b);
            a31 = ImplEnhanceFilter_MT.safeGet(input, x - 1, b + 1);
            a32 = ImplEnhanceFilter_MT.safeGet(input, x, b + 1);
            a33 = ImplEnhanceFilter_MT.safeGet(input, x + 1, b + 1);
            value = 9 * a22 - (a11 + a12 + a13 + a21 + a23 + a31 + a32 + a33);
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexBottom++] = (byte)value;
        });
        BoofConcurrency.loopFor(1, input.height - 1, y -> {
            int a33;
            int a32;
            int a31;
            int a23;
            int indexLeft = input.startIndex + input.stride * y;
            int indexRight = input.startIndex + input.stride * y + c;
            int a11 = ImplEnhanceFilter_MT.safeGet(input, -1, y - 1);
            int a12 = ImplEnhanceFilter_MT.safeGet(input, 0, y - 1);
            int a13 = ImplEnhanceFilter_MT.safeGet(input, 1, y - 1);
            int a21 = ImplEnhanceFilter_MT.safeGet(input, -1, y);
            int a22 = ImplEnhanceFilter_MT.safeGet(input, 0, y);
            int value = 9 * a22 - (a11 + a12 + a13 + a21 + (a23 = ImplEnhanceFilter_MT.safeGet(input, 1, y)) + (a31 = ImplEnhanceFilter_MT.safeGet(input, -1, y + 1)) + (a32 = ImplEnhanceFilter_MT.safeGet(input, 0, y + 1)) + (a33 = ImplEnhanceFilter_MT.safeGet(input, 1, y + 1)));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexLeft] = (byte)value;
            a11 = ImplEnhanceFilter_MT.safeGet(input, c - 1, y - 1);
            a12 = ImplEnhanceFilter_MT.safeGet(input, c, y - 1);
            a13 = ImplEnhanceFilter_MT.safeGet(input, c + 1, y - 1);
            a21 = ImplEnhanceFilter_MT.safeGet(input, c - 1, y);
            a22 = ImplEnhanceFilter_MT.safeGet(input, c, y);
            a23 = ImplEnhanceFilter_MT.safeGet(input, c + 1, y);
            a31 = ImplEnhanceFilter_MT.safeGet(input, c - 1, y + 1);
            a32 = ImplEnhanceFilter_MT.safeGet(input, c, y + 1);
            a33 = ImplEnhanceFilter_MT.safeGet(input, c + 1, y + 1);
            value = 9 * a22 - (a11 + a12 + a13 + a21 + a23 + a31 + a32 + a33);
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexRight] = (byte)value;
        });
    }

    public static void sharpenInner8(GrayF32 input, GrayF32 output, float minValue, float maxValue) {
        BoofConcurrency.loopFor(1, input.height - 1, y -> {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int x = 1;
            while (x < input.width - 1) {
                float a22 = input.data[indexIn];
                float a11 = input.data[indexIn - input.stride - 1];
                float a12 = input.data[indexIn - input.stride];
                float a13 = input.data[indexIn - input.stride + 1];
                float a21 = input.data[indexIn - 1];
                float a23 = input.data[indexIn + 1];
                float a31 = input.data[indexIn + input.stride - 1];
                float a32 = input.data[indexIn + input.stride];
                float a33 = input.data[indexIn + input.stride + 1];
                float result = 9.0f * a22 - (a11 + a12 + a13 + a21 + a23 + a31 + a32 + a33);
                if (result > maxValue) {
                    result = maxValue;
                } else if (result < minValue) {
                    result = minValue;
                }
                output.data[indexOut] = result;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        });
    }

    public static void sharpenBorder8(GrayF32 input, GrayF32 output, float minValue, float maxValue) {
        int b = input.height - 1;
        int c = input.width - 1;
        BoofConcurrency.loopFor(0, input.width, x -> {
            float a33;
            float a32;
            float a31;
            float a23;
            int indexTop = input.startIndex + x;
            int indexBottom = input.startIndex + x + b * input.stride;
            float a11 = ImplEnhanceFilter_MT.safeGet(input, x - 1, -1);
            float a12 = ImplEnhanceFilter_MT.safeGet(input, x, -1);
            float a13 = ImplEnhanceFilter_MT.safeGet(input, x + 1, -1);
            float a21 = ImplEnhanceFilter_MT.safeGet(input, x - 1, 0);
            float a22 = ImplEnhanceFilter_MT.safeGet(input, x, 0);
            float value = 9.0f * a22 - (a11 + a12 + a13 + a21 + (a23 = ImplEnhanceFilter_MT.safeGet(input, x + 1, 0)) + (a31 = ImplEnhanceFilter_MT.safeGet(input, x - 1, 1)) + (a32 = ImplEnhanceFilter_MT.safeGet(input, x, 1)) + (a33 = ImplEnhanceFilter_MT.safeGet(input, x + 1, 1)));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexTop++] = value;
            a11 = ImplEnhanceFilter_MT.safeGet(input, x - 1, b - 1);
            a12 = ImplEnhanceFilter_MT.safeGet(input, x, b - 1);
            a13 = ImplEnhanceFilter_MT.safeGet(input, x + 1, b - 1);
            a21 = ImplEnhanceFilter_MT.safeGet(input, x - 1, b);
            a22 = ImplEnhanceFilter_MT.safeGet(input, x, b);
            a23 = ImplEnhanceFilter_MT.safeGet(input, x + 1, b);
            a31 = ImplEnhanceFilter_MT.safeGet(input, x - 1, b + 1);
            a32 = ImplEnhanceFilter_MT.safeGet(input, x, b + 1);
            a33 = ImplEnhanceFilter_MT.safeGet(input, x + 1, b + 1);
            value = 9.0f * a22 - (a11 + a12 + a13 + a21 + a23 + a31 + a32 + a33);
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexBottom++] = value;
        });
        BoofConcurrency.loopFor(1, input.height - 1, y -> {
            float a33;
            float a32;
            float a31;
            float a23;
            int indexLeft = input.startIndex + input.stride * y;
            int indexRight = input.startIndex + input.stride * y + c;
            float a11 = ImplEnhanceFilter_MT.safeGet(input, -1, y - 1);
            float a12 = ImplEnhanceFilter_MT.safeGet(input, 0, y - 1);
            float a13 = ImplEnhanceFilter_MT.safeGet(input, 1, y - 1);
            float a21 = ImplEnhanceFilter_MT.safeGet(input, -1, y);
            float a22 = ImplEnhanceFilter_MT.safeGet(input, 0, y);
            float value = 9.0f * a22 - (a11 + a12 + a13 + a21 + (a23 = ImplEnhanceFilter_MT.safeGet(input, 1, y)) + (a31 = ImplEnhanceFilter_MT.safeGet(input, -1, y + 1)) + (a32 = ImplEnhanceFilter_MT.safeGet(input, 0, y + 1)) + (a33 = ImplEnhanceFilter_MT.safeGet(input, 1, y + 1)));
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexLeft] = value;
            a11 = ImplEnhanceFilter_MT.safeGet(input, c - 1, y - 1);
            a12 = ImplEnhanceFilter_MT.safeGet(input, c, y - 1);
            a13 = ImplEnhanceFilter_MT.safeGet(input, c + 1, y - 1);
            a21 = ImplEnhanceFilter_MT.safeGet(input, c - 1, y);
            a22 = ImplEnhanceFilter_MT.safeGet(input, c, y);
            a23 = ImplEnhanceFilter_MT.safeGet(input, c + 1, y);
            a31 = ImplEnhanceFilter_MT.safeGet(input, c - 1, y + 1);
            a32 = ImplEnhanceFilter_MT.safeGet(input, c, y + 1);
            a33 = ImplEnhanceFilter_MT.safeGet(input, c + 1, y + 1);
            value = 9.0f * a22 - (a11 + a12 + a13 + a21 + a23 + a31 + a32 + a33);
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            output.data[indexRight] = value;
        });
    }

    public static int safeGet(GrayI input, int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= input.width) {
            x = input.width - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= input.height) {
            y = input.height - 1;
        }
        return input.unsafe_get(x, y);
    }

    public static float safeGet(GrayF32 input, int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= input.width) {
            x = input.width - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= input.height) {
            y = input.height - 1;
        }
        return input.unsafe_get(x, y);
    }
}

