/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.autolog.client;

import ca.infodata.autolog.client.ADManager;
import ca.infodata.autolog.client.AutologConnexionRespond;
import ca.infodata.autolog.client.AutologConnexionRespondAccessorClient;
import ca.infodata.util1.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ADManagement {
    public static final Logger logger = Logger.getLogger(ADManagement.class.getName());
    private int state = 0;
    private Date requestStart = null;
    private Date requestResponse = null;
    private String url;
    private static final String DEFAULT_URL = "http://192.168.1.205:8080/";
    public static final int S_INITIATE = 0;
    public static final int S_ASK_CON = 1;
    public static final int S_CON_POS = 2;
    public static final int S_CON_NEG = 3;
    public static final int S_ASK_ADD = 4;
    public static final int S_ADD_POS = 5;
    public static final int S_ADD_NEG = 6;
    public static final int S_ASK_DEL = 7;
    public static final int S_DEL_POS = 8;
    public static final int S_DEL_NEG = 9;

    public ADManagement() {
        this.url = DEFAULT_URL;
    }

    public ADManagement(String url) {
        this.url = url;
    }

    public String askForConnexionString(String client) {
        AutologConnexionRespond acr = this.askForConnexion(client);
        return acr == null ? null : acr.getUsername();
    }

    public AutologConnexionRespond askForConnexion(String client) {
        String sid = null;
        try {
            sid = ADManager.getUID();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "SID not found", e);
        }
        return this.askForConnexion(client, sid);
    }

    public String askForConnexionString(String client, String sid) {
        AutologConnexionRespond acr = this.askForConnexion(client, sid);
        return acr == null ? null : acr.getUsername();
    }

    public AutologConnexionRespond askForConnexion(String client, String sid) {
        AutologConnexionRespond racr = null;
        this.state = 1;
        if (!StringUtils.isBlank((CharSequence)sid)) {
            this.requestStart = new Date();
            this.requestResponse = null;
            try {
                URL urlObj = new URL(this.url);
                AutologConnexionRespondAccessorClient acrac = new AutologConnexionRespondAccessorClient(urlObj);
                AutologConnexionRespond acr = acrac.get(sid, client);
                this.requestResponse = new Date();
                if (acr != null && !StringUtils.isBlank((CharSequence)acr.getUsername())) {
                    racr = acr;
                    this.state = 2;
                } else {
                    this.state = 3;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error on asking", e);
            }
        }
        return racr;
    }

    public String askForPassword(String client, String sid) {
        try {
            URL urlObj = new URL(this.url);
            AutologConnexionRespondAccessorClient acrac = new AutologConnexionRespondAccessorClient(urlObj);
            return acrac.getPsw(sid, client);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String askForPassword(String client) {
        String sid = null;
        try {
            sid = ADManager.getUID();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "SID not found", e);
        }
        return this.askForPassword(client, sid);
    }

    public Boolean askForValidatePassword(String username, String password, String client) {
        try {
            URL urlObj = new URL(this.url);
            AutologConnexionRespondAccessorClient acrac = new AutologConnexionRespondAccessorClient(urlObj);
            return acrac.validatePassword(username, password, client);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return new Boolean(false);
        }
    }

    public boolean askForAdding(String userName, String client) {
        return this.askForAdding(userName, client, false);
    }

    public boolean askForAdding(String userName, String client, boolean force) {
        this.state = 4;
        String sid = null;
        try {
            sid = ADManager.getUID();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "SID not found for username : " + userName, e);
        }
        return this.askForAdding(userName, client, sid, force);
    }

    public boolean askForAdding(String userName, String client, String sid) {
        return this.askForAdding(userName, client, sid, false);
    }

    public boolean askForAdding(String userName, String client, String sid, boolean force) {
        boolean haveAdd = false;
        this.state = 4;
        if (!(StringUtils.isBlank((CharSequence)sid) || StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)client))) {
            this.requestStart = new Date();
            this.requestResponse = null;
            try {
                URL urlObj = new URL(this.url);
                AutologConnexionRespondAccessorClient acrac = new AutologConnexionRespondAccessorClient(urlObj);
                AutologConnexionRespond autolog = new AutologConnexionRespond();
                autolog.setSid(sid);
                autolog.setUsername(userName);
                autolog.setClient(client);
                autolog.setIsForced(force ? 1 : 0);
                acrac.create(autolog);
                this.requestResponse = new Date();
                this.state = 5;
                haveAdd = true;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error in adding", e);
            }
        }
        return haveAdd;
    }

    public boolean askForDeleting(String client) {
        this.state = 7;
        String sid = null;
        try {
            sid = ADManager.getUID();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "SID not found", e);
        }
        return this.askForDeleting(client, sid);
    }

    public boolean askForDeleting(String client, String sid) {
        boolean haveDel = false;
        this.state = 7;
        if (!StringUtils.isBlank((CharSequence)sid) && !StringUtils.isBlank((CharSequence)client)) {
            this.requestStart = new Date();
            this.requestResponse = null;
            try {
                URL urlObj = new URL(this.url);
                AutologConnexionRespondAccessorClient acrac = new AutologConnexionRespondAccessorClient(urlObj);
                int newId = acrac.delete(sid, client);
                this.requestResponse = new Date();
                if (newId > 0) {
                    this.state = 8;
                    haveDel = true;
                } else {
                    this.state = 9;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error in deleting", e);
            }
        }
        return haveDel;
    }

    public boolean hasResponse() {
        return this.requestStart != null && this.requestResponse != null || this.requestStart == null && this.requestResponse == null;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    static {
        logger.setLevel(Level.OFF);
    }
}

