/*
 * Decompiled with CFR 0.152.
 */
package apple.finder.search.ui;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TouchEvent;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class UI {
    private static final Logger logger = Logger.getLogger(UI.class.getName());
    public static final boolean OS_COCOA = "cocoa".equals(SWT.getPlatform());
    public static final boolean OS_CARBON = "carbon".equals(SWT.getPlatform()) || OS_COCOA;
    public static final boolean OS_GTK = "gtk".equals(SWT.getPlatform());
    public static final boolean OS_WINDOWS = "win32".equals(SWT.getPlatform());
    public static final String DISABLED_BACKGROUND_COLOR = "DISABLED_BACKGROUND_COLOR";
    public static int STANDARD_BUTTON_WIDTH = OS_CARBON ? 130 : 100;
    public static int STANDARD_TEXT_WIDTH = OS_CARBON ? 130 : 100;
    public static final int CTRL_CMD = OS_CARBON ? 0x400000 : 262144;
    private static Timer loopExecTimer = new Timer("loopExecTimer", true);

    private UI() {
        throw new UnsupportedOperationException();
    }

    public static Event toEvent(TouchEvent e) {
        Event ev = new Event();
        ev.x = e.x;
        ev.y = e.y;
        ev.widget = e.widget;
        return ev;
    }

    public static boolean containsStyle(int constant, int style) {
        return (style | constant) == style;
    }

    public static boolean SHIFT(KeyEvent e) {
        return (e.stateMask | 0x20000) == e.stateMask;
    }

    public static boolean SHIFT_TAB(KeyEvent e) {
        return UI.SHIFT(e) && (e.keyCode | 9) == e.keyCode;
    }

    public static boolean CTRL(KeyEvent e) {
        return (e.stateMask | CTRL_CMD) == e.stateMask;
    }

    public static boolean CTRL(MouseEvent e) {
        return (e.stateMask | CTRL_CMD) == e.stateMask;
    }

    public static boolean CTRL(Event e) {
        return (e.stateMask | CTRL_CMD) == e.stateMask;
    }

    public static boolean CR(KeyEvent e) {
        return e.keyCode == 13 || e.keyCode == 0x1000050;
    }

    public static boolean CR(Event e) {
        return e.keyCode == 13 || e.keyCode == 0x1000050;
    }

    public static boolean ESC(KeyEvent e) {
        return e.keyCode == 27;
    }

    public static boolean ESC(Event e) {
        return e.keyCode == 27;
    }

    public static boolean leftClick(MouseEvent e) {
        if (OS_CARBON) {
            return e.button == 1 && (e.stateMask & 0x400000) == e.stateMask;
        }
        return e.button == 1;
    }

    public static boolean rightClick(MouseEvent e) {
        if (OS_CARBON) {
            return e.button == 3 || e.button == 1 && e.stateMask == CTRL_CMD;
        }
        return e.button == 3;
    }

    public static boolean rightClick(Event e) {
        if (OS_CARBON) {
            return e.button == 3 || e.button == 1 && e.stateMask == CTRL_CMD;
        }
        return e.button == 3;
    }

    public static int getAjustedPosition() {
        return OS_CARBON ? -2 : 0;
    }

    public static boolean hasFocus(Control control) {
        if (control == null) {
            throw new NullPointerException("control");
        }
        if (control.isFocusControl()) {
            return true;
        }
        if (control instanceof Composite) {
            boolean hasfocus = false;
            Control[] children = ((Composite)control).getChildren();
            for (int i = 0; i < children.length && !hasfocus; ++i) {
                hasfocus = UI.hasFocus(children[i]);
            }
            return hasfocus;
        }
        return false;
    }

    public static boolean superForceFocus(Control control) {
        System.out.println("UI.superForceFocus()");
        if (control == null) {
            throw new NullPointerException("control");
        }
        if (control.isFocusControl()) {
            System.out.println("control already has focus");
            return true;
        }
        boolean focused = control.setFocus();
        if (focused) {
            System.out.println("simple setFocus worked");
            return true;
        }
        focused = control.forceFocus();
        if (focused) {
            System.out.println("simple forceFocus worked");
            return true;
        }
        return false;
    }

    public static Control getFocusedControl(Composite parent) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (parent.isFocusControl()) {
            return parent;
        }
        Control focusedControl = null;
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length && focusedControl == null; ++i) {
            if (children[i].isFocusControl()) {
                focusedControl = children[i];
                continue;
            }
            if (!(children[i] instanceof Composite)) continue;
            focusedControl = UI.getFocusedControl((Composite)children[i]);
        }
        return focusedControl;
    }

    public static void centerComposite(Composite target, Composite base) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (base.isDisposed()) {
            throw new IllegalArgumentException("base composite is disposed");
        }
        if (target.isDisposed()) {
            throw new IllegalArgumentException("target composite is disposed");
        }
        if (target == base) {
            return;
        }
        Point location = base.getLocation();
        Point size = base.getSize();
        Point targetSize = target.getSize();
        int x = location.x + size.x / 2 - targetSize.x / 2;
        int y = location.y + size.y / 2 - targetSize.y / 2;
        target.setLocation(x, y);
    }

    public static void packAsParentDialog(Shell shell) {
        UI.packAsParentDialog(shell, shell == null ? null : shell.getParent());
    }

    public static void packAsParentDialog(Shell shell, Composite parent) {
        if (shell == null) {
            throw new NullPointerException("shell");
        }
        if (shell.isDisposed()) {
            throw new IllegalArgumentException("shell is disposed");
        }
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (parent.isDisposed()) {
            throw new IllegalArgumentException("parent is disposed");
        }
        shell.pack(true);
        Point size = shell.getSize();
        Point parentSize = parent.getSize();
        int w = (int)((float)Math.max(size.x, parentSize.x) * 0.9f);
        int h = (int)((float)Math.max(size.y, parentSize.y) * 0.9f);
        shell.setSize(w, h);
    }

    public static void printEventType(Event e) {
        switch (e.type) {
            case 13: {
                System.out.println("selection");
                break;
            }
            case 24: {
                System.out.println("modify");
                break;
            }
        }
    }

    public static void waitForWindowToClose(Shell shell) {
        if (shell == null) {
            throw new NullPointerException("shell");
        }
        if (shell.isDisposed()) {
            throw new IllegalArgumentException("shell is disposed");
        }
        Display display = shell.getDisplay();
        while (!shell.isDisposed() && shell.isVisible()) {
            if (display.isDisposed() || display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static void disableForXMillisecond(final Control control, int timeInMillisecond) {
        control.setEnabled(false);
        int timeToWait = timeInMillisecond;
        control.getDisplay().timerExec(timeToWait, new Runnable(){

            @Override
            public void run() {
                if (!control.isDisposed()) {
                    control.setEnabled(true);
                }
            }
        });
    }

    public static void decorateTreeWithAutoAdjustColumnWidthToContent(final Tree tree) {
        tree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                ((TreeItem)e.item).setExpanded(true);
                UI.autoAdjustColumnWidthToContent(tree);
            }

            public void treeCollapsed(TreeEvent e) {
                ((TreeItem)e.item).setExpanded(false);
                UI.autoAdjustColumnWidthToContent(tree);
            }
        });
    }

    public static void autoAdjustColumnWidthToContent(Tree tree) {
        int linesCount = tree.getItemCount();
        if (linesCount > 0) {
            TreeColumn column;
            int i;
            GC gc = new GC((Drawable)tree);
            int columnCount = tree.getColumnCount();
            int[] columnSizes = new int[columnCount];
            for (i = 0; i < linesCount; ++i) {
                TreeItem item = tree.getItem(i);
                for (int j = 0; j < columnCount; ++j) {
                    columnSizes[j] = Math.max(UI.itemWidth(gc, item, j), columnSizes[j]);
                }
            }
            for (i = 0; i < columnCount; ++i) {
                column = tree.getColumn(i);
                Integer w = (Integer)column.getData("minWidth");
                if (w == null) continue;
                columnSizes[i] = Math.max(w, columnSizes[i]);
            }
            for (i = 0; i < columnCount; ++i) {
                column = tree.getColumn(i);
                Integer w = (Integer)column.getData("maxWidth");
                if (w == null) continue;
                columnSizes[i] = Math.min(w, columnSizes[i]);
            }
            gc.dispose();
            int compensation = UI.containsStyle(32, tree.getStyle()) ? 50 : 35;
            for (int i2 = 0; i2 < columnCount; ++i2) {
                tree.getColumn(i2).setWidth(columnSizes[i2] + compensation);
            }
        }
    }

    private static int itemWidth(GC gc, TreeItem item, int column) {
        int itemCount;
        gc.setFont(item.getFont());
        Point extent = gc.stringExtent(item.getText(column));
        Image image = item.getImage(column);
        int w = extent.x;
        if (image != null) {
            w += image.getBounds().width;
        }
        if (item.getExpanded() && (itemCount = item.getItemCount()) > 0) {
            TreeItem[] items = item.getItems();
            for (int i = 0; i < items.length; ++i) {
                w = Math.max(w, UI.itemWidth(gc, items[i], column) + 10);
            }
        }
        return w;
    }

    private static int itemWidth(GC gc, TableColumn column) {
        gc.setFont(column.getParent().getFont());
        Point extent = gc.stringExtent(column.getText());
        Image image = column.getImage();
        int w = extent.x;
        if (image != null) {
            w += image.getBounds().width;
        }
        return w + 15;
    }

    public static void autoAdjustColumnWidthToContent(Table table) {
        int linesCount = table.getItemCount();
        if (linesCount > 0 || table.getHeaderVisible()) {
            TableColumn column;
            int i;
            GC gc = new GC((Drawable)table);
            int columnCount = table.getColumnCount();
            int[] columnSizes = new int[columnCount];
            if (table.getHeaderVisible()) {
                for (i = 0; i < columnCount; ++i) {
                    column = table.getColumn(i);
                    columnSizes[i] = UI.itemWidth(gc, column);
                }
            }
            for (i = 0; i < linesCount; ++i) {
                TableItem item = table.getItem(i);
                for (int j = 0; j < columnCount; ++j) {
                    columnSizes[j] = Math.max(UI.itemWidth(gc, item, j), columnSizes[j]);
                }
            }
            for (i = 0; i < columnCount; ++i) {
                column = table.getColumn(i);
                Integer w = (Integer)column.getData("minWidth");
                if (w == null) continue;
                columnSizes[i] = Math.max(w, columnSizes[i]);
            }
            for (i = 0; i < columnCount; ++i) {
                column = table.getColumn(i);
                Integer w = (Integer)column.getData("maxWidth");
                if (w == null) continue;
                columnSizes[i] = Math.min(w, columnSizes[i]);
            }
            gc.dispose();
            for (i = 0; i < columnCount; ++i) {
                table.getColumn(i).setWidth(columnSizes[i]);
            }
        }
    }

    private static int itemWidth(GC gc, TableItem item, int column) {
        gc.setFont(item.getFont());
        Point extent = gc.stringExtent(item.getText(column));
        Image image = item.getImage(column);
        int w = extent.x;
        if (image != null) {
            w += image.getBounds().width;
        }
        return w + 15;
    }

    public static boolean isCurrentThreadIsUIThread() {
        Thread thread = (Display.getCurrent() == null ? Display.getDefault() : Display.getCurrent()).getThread();
        return thread == Thread.currentThread() || thread.getId() == Thread.currentThread().getId();
    }

    public static void loopExecForWidget(long delay, long period, final int iteration, final boolean async, final Widget widget, final Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable");
        }
        if (widget == null) {
            throw new NullPointerException("widget");
        }
        final TimerTask timerTask = new TimerTask(){
            int count = 0;

            @Override
            public void run() {
                ++this.count;
                try {
                    if (widget.isDisposed()) {
                        this.cancel();
                    } else if (async) {
                        widget.getDisplay().asyncExec(runnable);
                    } else {
                        widget.getDisplay().syncExec(runnable);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception in loopExec", e);
                }
                if (iteration != -1 && this.count >= iteration) {
                    this.cancel();
                }
            }
        };
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                timerTask.cancel();
            }
        });
        loopExecTimer.schedule(timerTask, delay, period);
    }

    public static FormData newFillFormData() {
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        return data;
    }

    public static FormData newVCenterFormData(Control source) {
        FormData data = new FormData();
        data.top = new FormAttachment(50, -source.computeSize((int)-1, (int)-1).y / 2);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        return data;
    }

    public static FormData newFormDataLabeledControlLayout(Control topControl, Control label, Control control) {
        FormData data = new FormData();
        data.top = new FormAttachment(control, 0, 0x1000000);
        data.left = new FormAttachment(0);
        label.setLayoutData((Object)data);
        data = new FormData();
        data.top = topControl == null ? new FormAttachment(0) : new FormAttachment(topControl);
        data.left = new FormAttachment(label);
        data.right = new FormAttachment(100);
        control.setLayoutData((Object)data);
        return data;
    }

    public static Font newFont(Font source, String name, Integer height, Integer style) {
        FontData fontData = source.getFontData()[0];
        FontData fontData2 = new FontData(name == null ? fontData.getName() : name, height == null ? fontData.getHeight() : height.intValue(), style == null ? fontData.getStyle() : style.intValue());
        Font font = new Font(source.getDevice(), fontData2);
        return font;
    }
}

