/*
 * Decompiled with CFR 0.152.
 */
package apple.finder.search.ui;

import apple.finder.search.ui.AbstractRow;
import apple.finder.search.ui.UI;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GroupRow
extends AbstractRow {
    private String[] comboText = new String[]{"Toutes les", "Certaines des", "Aucune des"};
    private String[] labelText = new String[]{"  Conditions suivantes sont vraies", "  Conditions suivantes sont vraies", "  Conditions suivantes n'est vraie"};
    private Label label;

    public GroupRow(Composite parent, int style) {
        super(parent, style);
        this.combo.setItems(this.comboText);
        this.middle.setLayout((Layout)new FormLayout());
        this.label = new Label(this.middle, 16384);
        this.label.setLayoutData((Object)UI.newVCenterFormData((Control)this.label));
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupRow.this.selected();
            }
        });
        this.combo.select(0);
        this.selected();
    }

    protected void selected() {
        this.label.setText(this.labelText[this.combo.getSelectionIndex()]);
    }

    public boolean isSameType(GroupRow row) {
        return row != null && row.combo.getSelectionIndex() == this.combo.getSelectionIndex();
    }

    public boolean isAnd() {
        return this.combo.getSelectionIndex() == 0;
    }

    public boolean isOr() {
        return this.combo.getSelectionIndex() == 1;
    }

    public boolean isNot() {
        return this.combo.getSelectionIndex() == 2;
    }

    public void setAnd() {
        this.combo.select(0);
    }

    public void setOr() {
        this.combo.select(1);
    }

    public void setNot() {
        this.combo.select(2);
    }

    @Override
    protected Image getDragEffectImage() {
        List<AbstractRow> list = this.getController().getChildren(this);
        list.add(0, this);
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        for (AbstractRow c : list) {
            rect.width = Math.max(rect.width, c.getBounds().width);
            rect.height += c.getBounds().height;
        }
        Image image = new Image((Device)Display.getDefault(), rect);
        GC gc = new GC((Drawable)image);
        int x = 0;
        int y = 0;
        for (AbstractRow c : list) {
            int xmargin = this.getBounds().width - c.getBounds().width;
            GC gc2 = new GC((Drawable)c);
            int h = c.getBounds().height;
            int w = c.getBounds().width + xmargin;
            Image screen = new Image((Device)Display.getDefault(), w, h);
            gc2.copyArea(screen, -xmargin, 0);
            gc2.dispose();
            gc.drawImage(screen, x, y);
            y += c.getBounds().height;
        }
        gc.dispose();
        return image;
    }
}

