/*
 * Decompiled with CFR 0.152.
 */
package apple.finder.search.ui;

import apple.finder.search.ui.AbstractRow;
import apple.finder.search.ui.IAppleFinderGridFactory;
import apple.finder.search.ui.ICriteriaField;
import apple.finder.search.ui.ICriteriaOperator;
import apple.finder.search.ui.ICriteriaRowFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CriteriaRow
extends AbstractRow {
    private List<ICriteriaField> fieldList;
    private IAppleFinderGridFactory factory;
    private ICriteriaField selectedField;
    private ICriteriaOperator selectedOperator;
    private Object valueReference;
    private Combo cmbOperator;
    private List<? extends ICriteriaOperator> cmbOperators;
    private ICriteriaOperator defaultOperator;
    private Label lblOperatorPrefix;
    private Composite compValue;

    public CriteriaRow(Composite parent, int style, IAppleFinderGridFactory factory) {
        super(parent, style);
        this.factory = factory;
        this.lblOperatorPrefix = new Label(this.middle, 0x1000000);
        this.cmbOperator = new Combo(this.middle, 8);
        this.cmbOperators = new ArrayList<ICriteriaOperator>();
        this.compValue = new Composite(this.middle, 0);
        this.middle.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.cmbOperator, 0, 0x1000000);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0);
        this.lblOperatorPrefix.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment((Control)this.lblOperatorPrefix);
        this.cmbOperator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment((Control)this.cmbOperator);
        data.right = new FormAttachment(100);
        this.compValue.setLayoutData((Object)data);
        this.cmbOperator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = CriteriaRow.this.cmbOperator.getSelectionIndex();
                ICriteriaOperator operator = selectionIndex == -1 ? CriteriaRow.this.defaultOperator : (ICriteriaOperator)CriteriaRow.this.cmbOperators.get(selectionIndex);
                CriteriaRow.this.selectedOperator(operator);
            }
        });
        this.fieldList = new ArrayList<ICriteriaField>();
        ArrayList<String> texts = new ArrayList<String>();
        for (ICriteriaField e : factory.getFields()) {
            this.fieldList.add(e);
            texts.add(e.getText());
        }
        String[] items = texts.toArray(new String[texts.size()]);
        this.combo.setItems(items);
        this.combo.select(0);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CriteriaRow.this.selected((ICriteriaField)CriteriaRow.this.fieldList.get(CriteriaRow.this.combo.getSelectionIndex()));
            }
        });
        int selectionIndex = this.combo.getSelectionIndex();
        if (selectionIndex != -1) {
            this.selected(this.fieldList.get(selectionIndex));
        }
    }

    protected void selectedOperator(ICriteriaOperator operator) {
        this.selectedOperator = operator == null ? this.defaultOperator : operator;
        int indexOf = this.cmbOperators.indexOf(this.selectedOperator);
        this.cmbOperator.select(indexOf);
        this.createValueControl(this.valueReference);
    }

    private void createValueControl(Object valueReference) {
        for (Control c : this.compValue.getChildren()) {
            c.dispose();
        }
        this.compValue.setLayout((Layout)new FillLayout());
        ICriteriaRowFactory factory = this.factory.get(this.selectedField);
        this.valueReference = factory.createValueControl(this.compValue, this.selectedOperator, valueReference);
        this.layout(true, true);
    }

    protected void selected(ICriteriaField e) {
        this.selectedField = e;
        this.combo.select(this.fieldList.indexOf(e));
        ICriteriaRowFactory factory = this.factory.get(e);
        String operatorPrefix = factory.getOperatorPrefix();
        this.lblOperatorPrefix.setText(operatorPrefix == null ? "" : operatorPrefix);
        List<? extends ICriteriaOperator> operators = factory.getOperators();
        ArrayList<String> texts = new ArrayList<String>();
        for (ICriteriaOperator iCriteriaOperator : operators) {
            texts.add(iCriteriaOperator.getText());
        }
        String[] items = texts.toArray(new String[texts.size()]);
        this.cmbOperator.setItems(items);
        this.cmbOperators = operators;
        this.defaultOperator = factory.getDefaultOperator();
        this.valueReference = null;
        this.selectedOperator(this.defaultOperator);
    }

    public ICriteriaField getSelectedField() {
        return this.selectedField;
    }

    public ICriteriaOperator getSelectedOperator() {
        return this.selectedOperator;
    }

    public Object getValueReference() {
        return this.valueReference;
    }

    public void setValueReference(Object value) {
        this.createValueControl(value);
    }

    @Override
    protected Image getDragEffectImage() {
        GC gc = new GC((Drawable)this);
        Image screen = new Image((Device)Display.getDefault(), this.getBounds());
        gc.copyArea(screen, 0, 0);
        gc.dispose();
        Image image = new Image((Device)Display.getDefault(), this.getBounds());
        gc = new GC((Drawable)image);
        gc.drawImage(screen, 0, 0);
        gc.dispose();
        return image;
    }
}

