(function(){
	var pref = angular.module('pref');
	
	pref.directive('personGroupList', ['$filter', 'model', 'PrefAccessor', 'UserAccessor', 'FlView', 'PatientFormService', 'QConfirm', '$q',
	                            function($filter , model, prefAccessor, UserAccessor, FlView, PatientFormService, QConfirm, $q) {
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/settings/person_group.html?v=ay',
			scope: {},
			link: function(scope, element, attrs){
				scope.isReady = false;
				scope.isAdmin = model.user().isAdmin;
				
				function init(){
					prefAccessor.getPersonGroups(function(res){
						scope.personGroupList = res.sort((a,b) => {
							if(a.name.toLowerCase()>b.name.toLowerCase()){
								return 1;
							}else if(a.name.toLowerCase()<b.name.toLowerCase()){
								return -1;
							}else{
								return 0;
							}
						});
					}).then(function(){
						UserAccessor.listUsersForSelection(function(res){
							scope.userListOrig = UserAccessor.cleanAndSortUsers(res.data);
							scope.isReady = true;
							model.actUpdated(true);
						});
					})
				}
				
				scope.inactiveFilter = {
					actif: {val:true, name:'profActives', code: "actif"},
					inactif: {val:false, name:'profInactives', code: "inactif"},
					all: {val:false, name:'All', code: "all"}
				}
				
				scope.activeFilterPersonGroup = scope.inactiveFilter["actif"];
				
				scope.updateList = function(){
					model.actUpdated(true);
				}
				
				scope.showItem = function(item){
					let show = true;
					if(scope.activeFilterPersonGroup.code === "actif"){
						show = !item.isDeleted
					}else if(scope.activeFilterPersonGroup.code === "inactif"){
						show = item.isDeleted
					}
					return show;
				}
				
				scope.newPersonGroup = function(){
					let newPersonGroup = {
						className: "CPersonGroup",
						isDeleted: false,
						name: "",
						persons: []
					}
					scope.openPersonGroup(newPersonGroup)
				}
				
				scope.openPersonGroup = function(personGroup){
					if(!personGroup.persons)personGroup.persons = [];
					let userAddedList = scope.userListOrig.reduce((p,c) => (personGroup.persons.some(e2 => e2.idPerson === c.personId) && p.push(c), p), []);
					let userList = scope.userListOrig.reduce((p,c) => (!userAddedList.includes(c) && p.push(c), p),[]);
					var viewOptions = {
						templateUrl: "/dashboard/resources/ofys/settings/person_group_edit.html?v=ay",
						personGroup: personGroup,
						listOfUser : {
							userSelectedList: [],
							userList: userList,
							userAddedSelectedList: [],
							userAddedList: userAddedList
						},
						itemAddedSelected : function(person){
							return this.listOfUser.userAddedSelectedList.indexOf(person) !== -1;
						},
						itemSelected : function(person){
							return this.listOfUser.userSelectedList.indexOf(person) !== -1;
						},
						selectItemToAdd : function(person){
							if(this.listOfUser.userSelectedList.includes(person)){
								this.listOfUser.userSelectedList = this.listOfUser.userSelectedList.filter(e => e !== person)
							}else{
								this.listOfUser.userSelectedList.push(person)
							}
						},
						addItems : function(){
							if(this.listOfUser.userSelectedList.length > 0){
								this.listOfUser.userAddedList.unshift(...this.listOfUser.userSelectedList);
								this.listOfUser.userList = this.listOfUser.userList.filter(e => this.listOfUser.userSelectedList.indexOf(e) === -1);
								this.listOfUser.userSelectedList = [];
							}else{
								model.notice().info($filter('translate')('selectProfToAdd'));
							}
						},
						addItem : function(person){
							this.listOfUser.userAddedList.unshift(person);
							this.listOfUser.userList = this.listOfUser.userList.filter(e => e !== person);
							this.listOfUser.userSelectedList = this.listOfUser.userSelectedList.filter(e => e !== person);
						},
						selectItemToRemove : function(person){
							if(this.listOfUser.userAddedSelectedList.includes(person)){
								this.listOfUser.userAddedSelectedList = this.listOfUser.userAddedSelectedList.filter(e => e !== person)
							}else{
								this.listOfUser.userAddedSelectedList.push(person)
							}
						},
						removeItems : function(){
							if(this.listOfUser.userAddedSelectedList.length > 0){
								this.listOfUser.userList.unshift(...this.listOfUser.userAddedSelectedList);
								this.listOfUser.userAddedList = this.listOfUser.userAddedList.filter(e => this.listOfUser.userAddedSelectedList.indexOf(e) === -1);
								this.listOfUser.userAddedSelectedList = [];
							}else{
								model.notice().info($filter('translate')('selectProfToRemove'));
							}
						},
						removeItem : function(person){
							this.listOfUser.userList.unshift(person);
							this.listOfUser.userAddedList = this.listOfUser.userAddedList.filter(e => e !== person);
							this.listOfUser.userAddedSelectedList = this.listOfUser.userAddedSelectedList.filter(e => e !== person);
						},
						ok: function(){
							if(this.fl.frm && this.fl.frm.$valid){
								scope.cancelFlView = this.fl.minimize;
								this.personGroup.persons = userSelectionToBaseUser(this.listOfUser.userAddedList);
								if(this.personGroup.persons && this.personGroup.persons.length > 0){
									prefAccessor.savePersonGroups(this.personGroup, function(res){
										let index = scope.personGroupList.findIndex(e => e.id == res.id)
										if(index != -1){
											scope.personGroupList.splice(index, 1, res);
										}else{
											scope.personGroupList.push(res);
										}
										model.actUpdated(true);
										model.notice().success($filter('translate')("SaveSuccess"));
										scope.cancelFlView();
									});
								}else{
									this.fl.frm.errorMsgs  = [{
									    msg: $filter('translate')('errorNoUserInGroup'),
									    type: "error",
									}]
								}
							}else{
								this.fl.frm.errorMsgs = PatientFormService.getFormErrors(this.personGroupFrm)
								model.actUpdated(true);
							}
						},
						beforeCancel: function(){
							let qconfirmOption = {
								title: $filter('translate')('UnsavedChanges')
							}
							return QConfirm.open(qconfirmOption, {windowClass:'top-modal'}).then(function(save){
								if(save){
									this.ok();
									return false;
								}else{
									return true;
								}
							}.bind(this))
						},
						fl: {},
					}
					FlView.open(viewOptions, {windowClass:'top-modal1', backdrop:'static'}).then(function(){});
				}
				
				function userSelectionToBaseUser(userSelection){
					let baseUser = [];
					for(i = 0; userSelection.length > i; i++){
						baseUser.push({
							id: userSelection[i].userId,
							idPerson: userSelection[i].personId,
							personName: userSelection[i].personName
						})
					}
					return baseUser;
				}
				
				init();
			}
		}
	}]);
})();