(function(){
	var finance = angular.module('financialReport', ['widgets'])
	
	finance.factory('financialReportPrintService', ['model', '$filter', '$translate',
							function(model, $filter, $translate){
		
		var accessor = {
			printReport : function(name, items, dateString, prof){
				var content = getReportStruct(name, items, dateString, prof)
				pdfMake.createPdf(content).open();
			}
		}						
		
		
		function getReportStruct(name, items, dateString, prof){
			return {
				info: {
					title: $filter('translate')("financialReportHeader_" + name) + " " + dateString,
				},
				content: [
					getTable(name, items)
				],
				header: function(currentPage, pageCount, pageSize){
                    return getHeader(name, dateString, prof);
                },
                footer: function(currentPage, pageCount, pageSize){
                    return {
                        columns: [
                            { text: 'Date d’impression : '+ moment().format("YYYY-MM-DD HH:mm"), alignment: 'right' },
                            { text: 'Page '+ currentPage + " sur "+ pageCount, alignment: 'right', margin: [0, 0, 40, 0] }
                        ]
                    };
                },
                pageMargins: [ 40, 80, 40, 60 ],
			}
		}
		
		function getHeader(name, dateString, prof){
			return {
				layout:"noBorders",
                background: "#578be2",
                table: {
                    headerRows: 3,
                    widths: ["100%"],
                    body: [
						[{ 
                            text: model.user().session.workSite.nameOfficial,
                            alignment: "center",
//                            margin: 8,
                            color: "white",
                            fillColor: "#578be2",
                        }],
                        [{ 
                            text: $filter('translate')("financialReportHeader_" + name) + prof,
                            alignment: "center",
//                            margin: 8,
                            color: "white",
                            fillColor: "#578be2",
                        }],
                        [{ 
                            text: dateString,
                            alignment: "center",
                            marginBottom: 8,
                            color: "white",
                            fillColor: "#578be2",
                        }],
                    ],
                },
			}
		}
		
		function getTable(name, items){
			var t = {
				table: {
					headerRows: 1,
                    widths: [],
                    body: []
				}
			}
			if(name == "billed"){
				t.table.widths = ["16.66%", "16.66%", "16.66%", "16.66%", "16.66%", "16.66%"]
				t.table.body.push([
					$filter('translate')("date"),
					$filter('translate')("invoice_number"),
					$filter('translate')("recordNumber"),
					$filter('translate')("Note"),
					$filter('translate')("amount"),
					$filter('translate')("Balance")
				])
				let total = 0
				for(let i = 0; i < items.length; i++){
					const item = items[i];
					t.table.body.push([
						moment(item.dateBilled).format('YYYY-MM-DD'),
						item.noFacture,
						item.patient.patientRecordNumber,
						item.note ? item.note : "",
						roundNumber(item.grandTotal).toFixed(2) + "$",
						roundNumber(item.solde).toFixed(2) + "$"
					]);
					if(item.status != "ANNULE"){
						total += item.grandTotal;
					}
				}
				t.table.body.push([
					{text: $filter('translate')("TOTAL"), bold: true},
					"",
					"",
					"",
					{text:roundNumber(total).toFixed(2) + "$" , bold: true},
					""
					
				]);
			}else if(name == "product"){
				t.table.widths = ["25%", "25%", "25%", "25%"]
				t.table.body.push([
					$filter('translate')("productName"),
					$filter('translate')("numberSold"),
					$filter('translate')("price"),
					$filter('translate')("TOTAL")
				])
				let total = 0
				for(let i = 0; i < items.length; i++){
					const item = items[i];
					t.table.body.push([
						getName(item),
						item.quantity,
						roundNumber(item.prix).toFixed(2) + "$",
						roundNumber(item.prix * item.quantity).toFixed(2) + "$"
					]);
					total += item.prix * item.quantity;
				}
				t.table.body.push([
					{text: $filter('translate')("TOTAL"), bold: true},
					"",
					"",
					{text:roundNumber(total).toFixed(2) + "$" , bold: true}
				]);
			}else if(name == "balance"){
				t.table.widths = ["25%", "25%", "25%", "25%"]
				t.table.body.push([
					$filter('translate')("date"),
					$filter('translate')("invoice_number"),
					$filter('translate')("recordNumber"),
					$filter('translate')("Balance")
				])
				let total = 0
				for(let i = 0; i < items.length; i++){
					const item = items[i];
					t.table.body.push([
						moment(item.dateBilled).format('YYYY-MM-DD'),
						item.noFacture,
						item.patient.patientRecordNumber,
						roundNumber(item.solde).toFixed(2) + "$"
					]);
					total += item.solde;
				}
				t.table.body.push([
					{text: $filter('translate')("TOTAL"), bold: true},
					"",
					"",
					{text:roundNumber(total).toFixed(2) + "$" , bold: true}
				]);
			}else if(name == "taxes"){
				t.table.widths = ["40%", "15%", "15%", "15%", "15%"]
				t.table.body.push([
					$filter('translate')("Name"),
					$filter('translate')("rate"),
					$filter('translate')("beforeTax"),
					$filter('translate')("Taxes"),
					$filter('translate')("TOTAL")
				])
				for(let i = 0; i < items.length; i++){
					const item = items[i];
					t.table.body.push([
						getName(item),
						item.taux,
						item.totalPreTax.toFixed(2) + "$",
						roundNumber(item.totalPreTax * item.taux).toFixed(2) + "$",
						roundNumber(item.totalPreTax + (item.totalPreTax * item.taux)).toFixed(2) + "$"
					]);
				}
			}
			
			return t;
		}
		
		function roundNumber(num){
			return Math.round((num+ Number.EPSILON)*100)/100;
		}
		
		function getName(product){
			var name = "";
			if ($translate.use()=='en') {
                name = product.nameEn;
                if(!name || name.length == 0){
					name = product.nameFr;
				}
            }else{
				name = product.nameFr;
				if(!name || name.length == 0){
					 name = product.nameEn;
				}
			}
            return name;
		}
		
		return accessor;
	}]);
	
	finance.controller('FinancialReportController', ['$scope','model', 'RessourceAccessor', '$translate', 'financialReportPrintService',
						'FlView', 'QValidation', '$filter', 'Rights',
							function($scope, model, ressourceAccessor, $translate, financialReportPrintService,
								FlView, QValidation, $filter, Rights){
		
		model.activeController('ress');
		model.activeMenu('ress');
		
		$scope.listReportType = [
			{code: 'billed', name: 'reportBilled'},
			{code: 'taxes', name: 'reportTaxes'},
			{code: 'balance', name: 'reportBalance'},
			{code: 'product', name: 'reportProduct'}
		]
		
		$scope.quickDate = [
			'perso', 'currMonth', 'lastMonth', "currYear", "lastYear"
		]
		$scope.searchOption = {quickDateValue: 'perso'};
		
		$scope.dynaDateOptionsDocStart = {
			acceptFutureDate: true,
			onDateSelected: function (mDate, dAssist) {
				if(!mDate){
					mDate = moment();
				}
				model.billed().searchReport.startDate = mDate.startOf('day').valueOf();
				var m = mDate.format(dAssist.format);
				model.billed().searchReport.startDateS = m;
			}
		};
		$scope.dynaDateOptionsDocEnd = {
			acceptFutureDate: true,
			onDateSelected: function (mDate, dAssist) {
				if(!mDate){
					mDate = moment();
				}
				model.billed().searchReport.endDate = mDate.endOf('day').valueOf();
				var m = mDate.format(dAssist.format);
				model.billed().searchReport.endDateS = m;
			}
		};
		
		$scope.isActive = function(report){
			if(model.billed().chosenReport && model.billed().chosenReport.code !== undefined){
				return model.billed().chosenReport.code == report.code;
			}
		}
		
		$scope.selectReport = function(report){
			model.billed().chosenReport = report;
			model.billed().searchReport.type = report.code;
			if($scope.lstReport[report.code] && $scope.lstReport[report.code].list){
				$scope.nbrOfPage = Math.ceil($scope.lstReport[report.code].list.length/step)-1;
			}else{
				$scope.nbrOfPage = 0;
			}
			
			$scope.currPage = 0;
			offset = 0;
			model.actUpdated(true);
		}
		
		$scope.updateDate = function(){
			if($scope.searchOption.quickDateValue == 'currMonth'){
				model.billed().searchReport.startDate = moment().startOf('month').valueOf();
				model.billed().searchReport.startDateS = moment().startOf('month').format("YYYY-MM-DD");
				model.billed().searchReport.endDate = moment().endOf('month').valueOf();
				model.billed().searchReport.endDateS = moment().endOf('month').format("YYYY-MM-DD");
			}else if($scope.searchOption.quickDateValue == 'lastMonth'){
				model.billed().searchReport.startDate = moment().subtract(1, 'months').startOf('month').valueOf();
				model.billed().searchReport.startDateS = moment().subtract(1, 'months').startOf('month').format("YYYY-MM-DD");
				model.billed().searchReport.endDate = moment().subtract(1, 'months').endOf('month').valueOf();
				model.billed().searchReport.endDateS = moment().subtract(1, 'months').endOf('month').format("YYYY-MM-DD");
			}else if($scope.searchOption.quickDateValue == 'currYear'){
				model.billed().searchReport.startDate = moment().startOf('year').valueOf();
				model.billed().searchReport.startDateS = moment().startOf('year').format("YYYY-MM-DD");
				model.billed().searchReport.endDate = moment().endOf('year').valueOf();
				model.billed().searchReport.endDateS = moment().endOf('year').format("YYYY-MM-DD");
			}else if($scope.searchOption.quickDateValue == 'lastYear'){
				model.billed().searchReport.startDate = moment().subtract(1, 'years').startOf('year').valueOf();
				model.billed().searchReport.startDateS = moment().subtract(1, 'years').startOf('year').format("YYYY-MM-DD");
				model.billed().searchReport.endDate = moment().subtract(1, 'years').endOf('year').valueOf();
				model.billed().searchReport.endDateS = moment().subtract(1, 'years').endOf('year').format("YYYY-MM-DD");
			}
		}
		
		var offset = 0;
		var step = 50;
		$scope.nbrOfPage = 0;
		$scope.currPage = 0;
		$scope.searchReport = function(){
			ressourceAccessor.searchReport(model.billed().searchReport, function(res){
				if(!$scope.lstReport[model.billed().chosenReport.code]){
					$scope.lstReport[model.billed().chosenReport.code] = []
				}
				$scope.lstReport[model.billed().chosenReport.code].list = res;
				if(model.billed().chosenReport.code == "product" || model.billed().chosenReport.code == "balance"
						|| model.billed().chosenReport.code == "billed"){
					getTotalFromRes(res);
					if(model.billed().chosenReport.code == "product"){
						res.sort(function(a,b){
							if ($translate.use()=='en') {
				                aName = a.nameEn ? a.nameEn.toLowerCase() : a.nameFr.toLowerCase();
								bName = b.nameEn ? b.nameEn.toLowerCase() : b.nameFr.toLowerCase();
				            }else{
								aName = a.nameFr ? a.nameFr.toLowerCase() : a.nameEn.toLowerCase();
								bName = b.nameFr ? b.nameFr.toLowerCase() : b.nameEn.toLowerCase();
							}
							return aName.localeCompare(bName);
						})
					}
				}
				if($scope.showProfSearch() && model.billed().searchReport.idProf){
					$scope.lstReport[model.billed().chosenReport.code].prof = $scope.lstProf.find(e=>e.id ==model.billed().searchReport.idProf)
				}else{
					$scope.lstReport[model.billed().chosenReport.code].prof = undefined;
				}
				$scope.lstReport[model.billed().chosenReport.code].dateString = model.billed().searchReport.startDateS 
						+ ' - ' + (model.billed().searchReport.endDateS ?  model.billed().searchReport.endDateS : moment().endOf('day').format("YYYY-MM-DD"));
				$scope.nbrOfPage = Math.ceil(res.length/step)-1;
				$scope.currPage = 0;
				offset = 0;
				model.actUpdated(true);
			})
		}
		
		function getTotalFromRes(res){
			$scope.lstReport[model.billed().chosenReport.code].total = 0;
			if(model.billed().chosenReport.code == "product"){
				for(let i=0; i<res.length;i++){
					$scope.lstReport[model.billed().chosenReport.code].total += res[i].prix * res[i].quantity;
				}
			}else if(model.billed().chosenReport.code == "balance"){
				for(let i=0; i<res.length;i++){
					$scope.lstReport[model.billed().chosenReport.code].total += res[i].solde;
				}
			}else if(model.billed().chosenReport.code == "billed"){
				for(let i=0; i<res.length;i++){
					if(res[i].status != "ANNULE"){
						$scope.lstReport[model.billed().chosenReport.code].total += res[i].grandTotal;
					}
				}
			}
			$scope.lstReport[model.billed().chosenReport.code].total 
							= roundNumber($scope.lstReport[model.billed().chosenReport.code].total).toFixed(2);
		}
		
		$scope.canGetPrevious = function(){
			return offset === 0;
		}
		
		$scope.previousPage = function(){
			if(offset!==0){
				offset -= step
				$scope.currPage--
			}
			model.actUpdated(true);
		}
		
		$scope.canGetNext = function(){
			return $scope.currPage>=$scope.nbrOfPage;
		}
		
		$scope.nextPage = function(){
			if($scope.currPage<=$scope.nbrOfPage){
				offset += step
				$scope.currPage++
			}
			model.actUpdated(true);
		}
		
		$scope.showProfSearch = function(){
			return model.billed().chosenReport.code == 'billed' || model.billed().chosenReport.code == 'balance';
		}
		
		$scope.showResearchByBilled = function(){
			return model.billed().chosenReport.code == 'billed';
		}
		
		$scope.showReport = function(){
			return model.billed().chosenReport && $scope.lstReport[model.billed().chosenReport.code]
					&& $scope.lstReport[model.billed().chosenReport.code].list;
		}
		
		$scope.lstReport = [];
		$scope.getLstForReport = function(){
			return $scope.lstReport[model.billed().chosenReport.code].list.slice(offset, offset + step);
		}
		$scope.getTotal = function(){
			return $scope.lstReport[model.billed().chosenReport.code].total;
		}
		
		$scope.getProductName = function(product){
			var name = "";
			if ($translate.use()=='en') {
                name = product.nameEn;
                if(!name || name.length == 0){
					name = product.nameFr;
				}
            }else{
				name = product.nameFr;
				if(!name || name.length == 0){
					 name = product.nameEn;
				}
			}
            return name;
		}
		
		function roundNumber(num){
			return Math.round((num+ Number.EPSILON)*100)/100;
		}
		
		$scope.getTaxes = function(tax){
			return roundNumber(tax.totalPreTax * tax.taux).toFixed(2);
		}
		
		$scope.getTotalWithTaxes = function(tax){
			return roundNumber(tax.totalPreTax + tax.totalPreTax * tax.taux).toFixed(2);
		}
		
		$scope.getBilledDate = function(date){
			return moment(date).format('YYYY-MM-DD');
		}
		
		$scope.getBilledNote = function(bill){
			let note = ""
			if(bill.status =='ANNULE'){
				note += "("+ $filter('translate')('billedCanceled') + ")"
			}
			note += bill.note ? bill.note : "";
			return note;
		}
		
		$scope.getPatientInfo = function(patient){
			if($scope.canEdit(patient)){
				return patient.lastName + ', ' + patient.firstName + ' (' + patient.patientRecordNumber +')';
			}else{
				return '(' + patient.patientRecordNumber +')';
			}
		}
		
		$scope.fixedIfDecimal = function(num){
			num = Number(num);
			if(num%1 == 0){
				return num;
			}else{
				return roundNumber(num).toFixed(2);
			}
		}
		
		$scope.print = function(){
			var prof = "";
			prof += $scope.lstReport[model.billed().chosenReport.code].prof ? (" - " + $scope.lstReport[model.billed().chosenReport.code].prof.lastName + " " + $scope.lstReport[model.billed().chosenReport.code].prof.firstName) : " ";
			financialReportPrintService.printReport(
				model.billed().chosenReport.code, 
				$scope.lstReport[model.billed().chosenReport.code].list,
				$scope.lstReport[model.billed().chosenReport.code].dateString,
				prof
			)
		}
		
		$scope.canEdit = function(patient){
			if(!patient.viewbag ){
				patient.viewbag = {};
				patient.viewbag.limitations = Rights.getSessionUserConsent(patient);
			}
			return patient.viewbag.limitations.Address && patient.viewbag.limitations.ContactMeans && patient.viewbag.limitations.Billing
		}
		
		$scope.openBillAndInvoice = function(currPatient){
			ressourceAccessor.getRessBilled(currPatient, function(res){
				FlView.open(
					{
						templateUrl: "/dashboard/resources/ofys/ress/invoice.html?v=ay", 
						pat: currPatient, list: res,
						beforeCancel: function(e, obj){
							return QValidation.closeContext($filter('translate')('UnsavedChanges'), "invoice").then(function(successful){
								if(!successful){
									e.prevent();
								}
								return successful;
							});
						},
						fl:{}
					}, 
					{
						backdrop: 'static',windowClass: "top-modal1"
					}
				)
			})
		}
		
		model.callDashBoardCount();
												
	}]);
	
	finance.directive('tabFinancialReport', ['model', 'ModificationStatus',
	                               function(model, ModificationStatus){
		return {
			restrict: 'EA',
			templateUrl: '/dashboard/resources/ofys/ress/report/tab_report.html?v=bk',
//			controller: 'FinancialReportController',
			link: function(scope){
			}
		}
	}]);
	
})();