(function(){
    var store = angular.module('dash.store', []);

	store.factory('Store', ['DashAPI',function(DashAPI) {
        /**
         * @param {Object} list : Indexed cached items async function returning the list of initial indexed cached items. or an array of the items to be cached.
         * @param {fn} source : function that takes the index (id or string), successcallback and errorcallback and returns the item to be cached. 
         * @param {Object} filters : function that takes the index (id or string), successcallback and errorcallback and returns the item to be cached. 
         * @param {Array} parser : Array of function that parses data before adding it to the cache. 
         */
        function CACHE(list = {}, source, filters, parser){
            var c = this;
            c.index = {}
            c.filter = {};

            source = source;
            blackList = {};
            pending = {};
            filterFns = {};

            function init(){
                if(typeof list === "function"){// callback function
                    list(function(lst){
                        c.index = lst;
                        initFilters(filters);
                    })
                }else if(index !== undefined && typeof list === "object"){
                    c.index = list
                    initFilters(filters);
                }
            }

            function initFilters(initObj){
                if(initObj !== undefined && typeof initObj === "object"){
                    var keys = Object.keys(initObj);
                    for (let i = 0; i < keys.length; i++) {
                        c.addFilter(keys[i], initObj[keys[i]])
                    }
                }
            }

            function deleteFromObj(key, obj){
                if(obj[key]){
                    delete obj[key];
                }
            }

            c.list = function(){
                if(c.index)
                return OfysUtils.ObjectValuesAsArray(c.index);
            }

            function doFilter(name){
                var indexList = Object.keys(c.index);
                var includeInList = filterFns[name];
                if(includeInList){
                    for (var i = 0; i < indexList.length; i++) {
                        if(includeInList(c.index[indexList[i]])){
                            c.filter[name].index[indexList[i]] = c.index[indexList[i]]
                        }
                    }
                }
            }

            c.canFetch = function(index){
                if(pending[index] ||
                    blackList[index] && blackList[index] < 5){
                    return false;
                }
                return true;
            }
    
            /**
             * supports async and sync workflows.
             * Sync workflow returns undefined if object item not found
             */
            c.get = function(index, success, fail){
                if(index === undefined || index === null)return;
                if(c.index[index]){
                    success && success(c.index[index]);
                    // if(!c.pass[index]){
                    //     testGet(index)
                    // }else{
                    //     console.log("Fecthed correctly");
                    // }
                    return c.index[index]
                }else if(c.canFetch(index)){
                    pending[index] = true;
                    source(index, function(res){
                        c.addToCache(index, res)
                        deleteFromObj(index, pending)
                        deleteFromObj(index, blackList)
                        success && success(res, true);
                    }, function(){
                        fail && fail(arguments)
                        blackList[index] = blackList[index]?blackList[index]+1:0;
                        deleteFromObj(index, pending)
                    });
                }
            }

// c.pass = {}
//             function testGet(i){
//                 delete c.index[i];
//                 c.pass[i] = true;                
//             }

            c.addToCache = function (i, obj){
                parseData(obj);
                c.index[i] = obj;
                addToFilteredList(i, obj);
            }

            function parseData(obj){
                if(parser){
                    for (var i = 0; i < parser.length; i++) {
                        parser[i](obj)
                    }
                }
            }
    
            /**
             * supports async and sync workflows.
             * Sync workflow returns undefined if object item not found
             */
            c.addFilter = function(name, filterFn){
                if(!filterFns[name]){
                    filterFns[name] = filterFn;
                    c.filter[name] = {index: {}, 
                    list: function(){
                        return OfysUtils.ObjectValuesAsArray(this.index);
                    }};
                    doFilter(name);
                }else{
                    throw "The filter with the name "+name+" already exists. Make sure you are not overriding and existing filter. Remove+add the existing one to override it"
                }
            }

            function addToFilteredList(index, obj){
                var filterNames = Object.keys(filterFns)
                for (var i = 0; i < filterNames.length; i++) {
                    var f = filterNames[i];
                    if(filterFns[f](obj)){
                        c.filter[f].index[index] = obj
                    }
                }
            }

            init();
        }


        return {
            // liste des CBaseProfessionnal.
            profs: new CACHE(function(cb, err){// Initial list
                    return DashAPI.get('dashboard/Prof/ws/profs' ,function(res){
                        cb(_.indexBy(res.data, 'id'));
                    }, err)
                }, function(id, callback,error){ // Get one by id
                    return DashAPI.get('/dashboard/Prof/ws/findBaseProfById?id='+id ,function(res){
                        callback(res.data)
                    }, error);
                }, 
                {//filters... returns a filtered list with the same name. Filters should return true or false
                    actif: function(p) {
                        return p.isDeleted!==true;
                    },
                    treating:function(p) {
                        return p.isDeleted!==true && p.isProfTx===true;
                    },
                    treatingMD:function(p) {
                        return p.isDeleted !==true && p.isProfTx ===true && 
                                (p.professionalType === "MD_OMNIPRATICIEN" || 
                                p.professionalType === "MD_SPECIALISTE");
                    },
                    appointment:function(p) {
                        return p.isDeleted!==true && p.useAppointment===true;
                    },
                },
                [// parsers
                    function(e){
                        if (e.lastName===undefined) e.lastName='-';
                        if (e.firstName===undefined) e.firstName='-';
                    }
                ]
            ),
            // liste des CSite.
            sites: new CACHE(function(cb, err){// Initial list
                    return DashAPI.get('/dashboard/User/ws/sites' ,function(res){
                        cb(_.indexBy(res.data, 'id'));
                    }, err)
                }, function(id, callback,error){ // Get one by id
                    return DashAPI.get('/dashboard/site/ws/get?id='+id ,function(res){
                        callback(res.data)
                    }, error);
                }, 
                {//filters... returns a filtered list with the same name. Filters should return true or false
                    workSites: function(s) {
                        return s.isWorkSite && !s.isDrugStore; 
                    }
                },
            ),
			//liste tout les profs incluant non traitant
//			allProfs: new CACHE(function(cb, err){ 
//				return  DashAPI.post('/dashboard/User/ws/searchProfiles', {isProfessionnal: true} , function(res){
//					data = {referenceId: res.referenceId, pageNumber: 1, nbItemsPerPage: res.total }
//					var paramStr = [];
//					Object.keys(data).forEach(function(cur){
//						paramStr.push(cur +"="+data[cur]);
//					});
//					DashAPI.get('/dashboard/User/ws/getSearchProfilesPage?'+paramStr.join("&"), function(res2){
//						cb(_.indexBy(res2, 'id'))
//					})
//				}, err);
//			})

        }
    }])
})();