(function(){
	var m = angular.module("inspqVaccins", ['dashboard.websocket', 'dash.api', 'rtssOAuth']);
    
    m.factory('InspqImmunizationCache', ['$cacheFactory', function($cacheFactory) {
        return $cacheFactory('inspqImmunizationCache');
    }]);

    m.factory('InspqImmunizationAccessor', ['$q', '$log', 'DashAPI', 'RtssOAuthAccessor', 'InspqImmunizationCache', 
        function($q, $log, DashAPI, RtssOAuthAccessor, cache) {
        let genericPreCallback = function(ajaxResponse) {
            let status = DashAPI.getSimpleStatus(ajaxResponse.data.status);
            if (status.hasCode("rtss-oauth-http401")) {
                RtssOAuthAccessor.getAuthUrl(function(url) {
                    window.open(url);
                });
            }
            if (status.hasCode("inspq-http-redirect")) {
                let url = status.getData("inspq-http-redirect");
                if (url !== undefined) {
                    window.open(url);                
                }
            }
            if (status.hasCode("inspq-error")) {
                status.errors.unshift("Erreur inattendue lors de la communication avec le Registre de vaccination du Québe. Veuillez réessayer.\n Si le problème persiste, vous pouvez sauvegarder une acte vaccinale comme tâche pour le saisir plus tard.")
            }
            // else {
            //     status.notice(model.notice().fail, model.notice().warn, model.notice().info);
            // }
            return {'status' : status, 'data' : ajaxResponse.data.obj};
        }

        let jsonCallback = function(genericPreCallbackResponse) {
            let status = genericPreCallbackResponse.status;
            let json = undefined;
            if (genericPreCallbackResponse.status.isOk()) {
                try {
                    if (genericPreCallbackResponse.data !== undefined) {
                        const obj = JSON.parse(genericPreCallbackResponse.data);
                        json = obj;
                    }
                } catch (error) {
                    $log.error(error);
                    status = dashapi.newSimpleStatus().addError(error);
                    json = undefined;
                }
            } else {
                json = undefined;
            }
            return {'json' : json, 'status' : status};
        }

        let valueSetAsArrayCallback = function(jsonResponse) {
            let status = jsonResponse.status;
            let data = undefined;
            if (status.isOk()) {
                try {
                    if (jsonResponse.json !== undefined) {
                        data = new ValueSet(jsonResponse.json).getValues();
                    }
                } catch (error) {
                    $log.error(error);
                    status = dashapi.newSimpleStatus().addError(error);
                    data = undefined;
                }
            } else {
                data = undefined;
            }
            return {'data' : data, 'status' : status};
        }

        let pushStatus = function(scope, newStatus) {
            if (scope.status === undefined) {
                scope.status = newStatus;
            } else {
                scope.status = scope.status.merge(newStatus);
            }
        };

        let cleanStatus = function(scope) {
            scope.status = undefined;
        }
        var currentPopover;

		var api = {
            'pushStatus' : pushStatus,
            'cleanStatus' : cleanStatus,
            ValueSetGetCache:{},

            uniqueOpenPopover: function(scp){
                if(!currentPopover || 
                    (!currentPopover.editMode)){
                    //Popover is new or is not in editMode close previous if any.
                    if(currentPopover && currentPopover.$hide){
                        currentPopover.$hide();
                    }
                    currentPopover = scp;
                    scp.$on("$destroy",function(){
                        if(scp === currentPopover){
                            currentPopover = null;
                        }
                    });
                }else{
                    //Current popover is being edited. Close the new opened popover.
                    if(scp && scp.$hide){
                        scp.$hide();
                    }
                }
            },
            PatientGetImmunizationProfile : function (patientId){
                return DashAPI.get("/dashboard/inspq/immunization/patientGetImmunizationProfile?id="+patientId).then(genericPreCallback);
            },

            getterSetterCodeOrText : function(newValue, obj, field, get, set) {
                if (newValue === undefined) {
                    let value = undefined;
                    if (field !== undefined) {
                        value = obj[field];
                    } else if (get != undefined) {
                        value = get.call(obj)
                    }
                    if (value === undefined) {
                        return undefined;
                    } else {
                        return value.code;
                    }
                } else {
                    this.setterCodeOrText(newValue, obj, field, get, set);
                }
            },

            setterCodeOrText : function(newValue, obj, field, get, set) {
                let newValue2 = undefined;
                if (newValue !== undefined) {
                    newValue2 = new CodeOrText(newValue);
                    if (newValue2.code === 'undefined') {
                        newValue2 = undefined;
                    }
                }
                if (field !== undefined) {
                    obj[field] = newValue2;
                } else if (set != undefined) {
                    set.call(obj, newValue2)
                }
            },

            getterSetterCode : function(newValue, obj, field, get, set) {
                if (newValue === undefined) {
                    let value = undefined;
                    if (field !== undefined) {
                        value = obj[field];
                    } else if (get != undefined) {
                        value = get.call(obj)
                    }
                    if (value === undefined) {
                        return undefined;
                    } else {
                        return value;
                    }
                } else {
                    this.setterCode(newValue, obj, field, get, set);
                }
            },

            setterCode : function(newValue, obj, field, get, set) {
                let newValue2 = undefined;
                if (newValue !== undefined) {
                    newValue2 = new Code(newValue);
                    if (newValue2.code === 'undefined') {
                        newValue2 = undefined;
                    }
                }
                if (field !== undefined) {
                    obj[field] = newValue2;
                } else if (set != undefined) {
                    set.call(obj, newValue2)
                }
            },

            ValueSetGet : function (domain, scope, scopeOutputVar){
                let qstring = "";
                if(typeof domain !== "string"){
                    let res = [];
                    for (const key in domain) {
                        res.push(key+"="+domain[key]);
                    }
                    qstring = res.join("&");
                }else{
                    qstring = "domain="+domain;
                }
                function doValueSetGet(){
                    if(api.ValueSetGetCache[qstring]){
                        return $q(function(resolve, reject){
                            resolve(api.ValueSetGetCache[qstring]);
                        })
                    }else{
                        return DashAPI.get("/dashboard/inspq/immunization/valueSetGet?"+ qstring)
                            .then(genericPreCallback)
                            .then(function(res){
                                if(res && res.status && res.status.severity === "OK"){
                                    api.ValueSetGetCache[qstring] = res;
                                }
                                return res;
                            })
                    }
                }

                return doValueSetGet().then(jsonCallback)
                .then(valueSetAsArrayCallback)
                .then(function(response) {
                   scope[scopeOutputVar] = response.data;
                   pushStatus(scope, response.status);
                   return response;
                });
            },
            handleTransaction: function(scope, res, obj, successFn){
                let transactionId = res.status.removeStatusByCode('inspq-transactionid')
                this.pushStatus(scope, res.status)
                if(res.status.isError()){
                    scope.status.errors.unshift("Erreur de sauvegarde")
                    if(obj && transactionId){
                        obj.faTransactionId = transactionId.message;
                    }
                }else{
                    successFn(res)
                }
            },
            ImmunizationAdd : function (data){
                return DashAPI.post("/dashboard/inspq/immunization/immunizationAdd", data).then(genericPreCallback);
            },
            ImmunizationModify : function (data){
                return DashAPI.post("/dashboard/inspq/immunization/immunizationModify", data).then(genericPreCallback);
            },
            ImmunizationOverride : function (data){
                return DashAPI.post("/dashboard/inspq/immunization/immunizationOverride", data).then(genericPreCallback);
            },
            ImmunizationDelete : function (data){
                return DashAPI.post("/dashboard/inspq/immunization/immunizationDelete", data).then(genericPreCallback);
            },
            ImmunizationSettoforecast : function (data){
                return DashAPI.post("/dashboard/inspq/immunization/immunizationSettoforecast", data).then(genericPreCallback);
            },
            ConditionGet : function (data){
                return DashAPI.post("/dashboard/inspq/immunization/conditionGet", data).then(genericPreCallback);
            },
            ConditionAdd : function (data){
                return DashAPI.post("/dashboard/inspq/immunization/conditionAdd", data).then(genericPreCallback);
            },
            ConditionModify : function (data){
                return DashAPI.post("/dashboard/inspq/immunization/conditionModify", data).then(genericPreCallback);
            },
            RefusalGet : function (data){
                return DashAPI.post("/dashboard/inspq/immunization/refusalGet", data).then(genericPreCallback);
            },
            RefusalAdd : function (data){
                return DashAPI.post("/dashboard/inspq/immunization/refusalAdd", data).then(genericPreCallback);
            },
            RefusalModify : function (data){
                return DashAPI.post("/dashboard/inspq/immunization/refusalModify", data).then(genericPreCallback);
            },
            PractitionerGet : function (id){
                return DashAPI.get("/dashboard/inspq/immunization/practitionerGet?id="+id).then(genericPreCallback);
            },
            PractitionerSearch : function (text){
                var qstring;
                if(typeof text == "object"){
                    //{firstName: "", lastName: "", role: "", identifier:""}
                    qstring = "?"+ Object.keys(text).filter(function(e){return !!(text[e]);}).map(function(e){return e +"="+text[e]}).join("&")
                }
                return DashAPI.get("/dashboard/inspq/immunization/practitionerSearch"+qstring).then(genericPreCallback);
            },
            LocationGet : function (id){
                return DashAPI.get("/dashboard/inspq/immunization/locationGet?id="+id).then(genericPreCallback);
            },
            LocationSearch : function (name, city){
                return DashAPI.get("/dashboard/inspq/immunization/locationSearch?name="+name+"&city="+city).then(genericPreCallback);
            },
            MedicationGet : function (id){
                return DashAPI.get("/dashboard/inspq/immunization/medicationGet?id="+id).then(genericPreCallback);
            },          
            Signout : function (id){
                return DashAPI.get("/dashboard/inspq/immunization/signout").then(genericPreCallback);
            },          
        };
        
		return api;
    }]);

    m.directive('inspqPerformer', ['model','InspqImmunizationAccessor','$q',
         function(model, InspqImmunizationAccessor, $q){
        return {
            restrict: 'E',
            template: '<button type="button" class="btn sm" style="background-color: #e9e9e9;" data-bs-popover data-placement="bottom" data-animation="am-flip-x" data-auto-close="1" data-container="body" data-template-url="/dashboard/resources/ofys/inspq/search_practitioner.html?v=bk"> Recherche avancée <i class="fa fa-search"></i></button>',
            scope: {
                onselect:'=',
            },
			link: function (scope, element, attrs) {
                scope.searchTerms = {role:""};
                scope.searchResults = [];
                scope.roles = [];

                scope.select = function(performer, finished){
                    scope.onselect && scope.onselect(performer)
                    finished && finished();
                }

                InspqImmunizationAccessor.ValueSetGet('practitionnerrole', scope, scope.roles).then(function(res){
                    scope.roles = res.data;
                    scope.roles.unshift({code:"", display:""})
                })

                scope.search = function(){
                    scope.searchResults = [];
                    InspqImmunizationAccessor.PractitionerSearch(scope.searchTerms).then(function(res){
                        if(res && res.data){
                            let results = JSON.parse(res.data);
                            scope.searchResults = results.entry;
                        }else{
                            scope.searchResults = [];
                        }
                    });
                }
            }
        }
    }]);

    m.directive('inspqLocation', ['model','InspqImmunizationAccessor','$q',
         function(model, InspqImmunizationAccessor, $q){
        return {
            restrict: 'E',
            template: '<button type="button" class="btn sm" style="background-color: #e9e9e9;" data-bs-popover data-placement="bottom-right" data-animation="am-flip-x" data-auto-close="1" data-container="body" data-template-url="/dashboard/resources/ofys/inspq/search_location.html?v=bk"> <span data-ng-bind="locationSearch.city.display"></span> <i class="fa fa-search"></i></button>',
            scope: {
                locationSearch:'=',
            },
			link: function (scope, element, attrs) {
                var pref = {}
                model.addPrefSettings(['locationPref'], pref, 'inspq_vaccin_');
                function updateLocation(l){
                    $.extend(scope.locationSearch, l);
                }
                
                updateLocation(getObj(pref.locationPref()));
                scope.lSearch = angular.copy(scope.locationSearch)

                var countryDomain = {
                    domain:'country', list: 'countries', 
                    descrFn:function(e){
                        return e.display;
                    }, 
                    selectFn:function(e){
                        scope.lSearch.country = e;
                        if(e.display !== scope.locationSearch.country.display){
                            delete scope.lSearch.city;
                            delete scope.lSearch.province;
                        }
                        return e.display;
                    }
                };

                function getObj(str){
                    if(typeof str == "string"){
                        if(str.startsWith('[')|| str.startsWith('{')){//check if json array string.
                            try{
                                return JSON.parse(str);
                            }catch(e){
                                console.error(e);
                            }
                        }
                        return str.startsWith('[')? []: {};
                    }else{
                        return str;
                    }
                }
                
                scope.init = function(){
                    scope.citiesAssist = {
                        nextTabOnTab: true,
                        nextTabOnEnter: true,
                        hasDetails: false,
                        hasHeader: false,
                        trigger: 'focus',
                        debounce: 500,
                        keepOnScreen: true,
                        minChar: 0,
                        listWidth: 350,
                        listHeight: 300,
                        getAsyncData: function(query, assist){
                            if(query && query.length > 1){
                                return InspqImmunizationAccessor.ValueSetGet({
                                        domain:"city", 
                                        'province-code': scope.lSearch.province.code ,
                                        'city-name': query
                                    }, scope, scope.lSearch.province.code+"_cities").then(function(res){
                                    if(res && res.data){
                                        return res.data;
                                    }
                                    return [];
                                });
                            }
                            return $q.resolve([]);
                        },
                        getKey: function(e) {
                            return e.display;
                        },
                        selection: function(e, assistObject) {
                            try{
                                if(!scope.$$phase) {
                                    scope.$digest();
                                }
                            }catch(e){
                            }
                            scope.lSearch.city = e; 
                            pref.locationPref(JSON.stringify(scope.lSearch))
                            updateLocation(scope.lSearch);
                            return this.getKey(e);
                        }
                    };
    
                    scope.provincesAssist = {
                        nextTabOnTab: true,
                        nextTabOnEnter: true,
                        hasDetails: false,
                        hasHeader: false,
                        trigger: 'focus',
                        debounce: 500,
                        keepOnScreen: true,
                        minChar: 0,
                        listWidth: 350,
                        listHeight: 300,
                        getAsyncData: function(query, assist){
                            return InspqImmunizationAccessor.ValueSetGet({
                                domain:"provinces", 
                                'country-code': scope.lSearch.country.code
                            }, scope, scope.lSearch.country.code+"_provinces").then(function(res){
                                if(res && res.data){
                                    return res.data;
                                }
                                return [];
                            });
                        },
                        getKey: function(e) {
                            return e.display;
                        },
                        selection: function(e, assistObject) {
                            try{
                                if(!scope.$$phase) {
                                    scope.$digest();
                                }
                            }catch(e){
                            }
                            scope.lSearch.province = e; 
                            if(e.display !== scope.locationSearch.province.display){
                                delete scope.lSearch.city;
                            }
                            return this.getKey(e);
                        }
                    };
                    initCountryAssist()
                }

                function initCountryAssist(){
                    InspqImmunizationAccessor.ValueSetGet(countryDomain.domain, scope, countryDomain.list)
                    .then(function(res) {
                        scope[countryDomain.list+"Assist"] = getAssistConfig(res.data, countryDomain)
                        scope.loaded = true;
                    })
                }
                initCountryAssist();
                function getAssistConfig(list, domain){
                    var listSearchIndex = {};
                    list.forEach(function(e, i){
                        if (e === undefined) {
                            listSearchIndex[i] = "";
                        } else {
                            listSearchIndex[i] = Object.values(e).toString().toLowerCase();
                        }
                    });
                    return {
                        nextTabOnTab: true,
                        nextTabOnEnter: true,
                        hasDetails: false,
                        hasHeader: false,
                        trigger: 'focus',
                        debounce: 500,
                        keepOnScreen: true,
                        minChar: 0,
                        listWidth: 350,
                        listHeight: 300,
                        getAsyncData: function(query, assist){
                            return $q(function(resolve, reject) {
                                if(!list){
                                    reject();
                                }else{
                                    var res = [];
                                    if(domain.filterfn){
                                        res = list.filter(domain.filterfn);
                                    }else{
                                        if((!domain.unfiltered) && query && query.length > 0){
                                            res = list.filter(function(e, i){
                                                return listSearchIndex[i].indexOf(query.toLowerCase()) > -1
                                            });
                                        }else{
                                            if(domain.pref){
                                                res = domain.pref();
                                            }
                                            if(res.length === 0){
                                                res = list;
                                            }
                                        }
                                    }
                                    resolve(res);
                                }
                            });
                        },
                        getKey: function(e) {
                            return domain.descrFn(e);
                        },
                        selection: function(e, assistObject) {
                            // if(domain.selectFn){
                            //     domain.selectFn(e);
                            // }
                            try{
                                if(!scope.$$phase) {
                                    scope.$digest();
                                }
                            }catch(e){
        
                            }
                            return domain.selectFn(e);
                        }
                    }
                }
            }
        }
    }]);

    var immunizationController = m.controller('InspqImmunizationDetailController', ['model','$scope', '$filter','$q',  'InspqImmunizationAccessor', 'TaskAccessor',
        function(model, $scope, $filter,$q, InspqImmunizationAccessor, TaskAccessor) {
        if($scope.updateScope){
            $scope.updateScope();
        }

        $scope.inspqPref= {};
        $scope.inspqPrefObj= {};
		model.addPrefSettings(['tradeName'], $scope.inspqPref, 'inspq_vaccin_');
		model.addPrefSettings(['performer'], $scope.inspqPref, 'inspq_vaccin_');
		model.addPrefSettings(['location'], $scope.inspqPref, 'inspq_vaccin_');
        
        function getObj(str){
            if(typeof str == "string"){
                if(str.startsWith('[')|| str.startsWith('{')){//check if json array string.
                    try{
                        return JSON.parse(str);
                    }catch(e){
                        console.error(e);
                    }
                }
                return str.startsWith('{')? {}: [];
            }else{
                return str;
            }
        }

        function savePreference(){
            //save only if pref obj is ok
            if($scope.inspqPrefObj !== undefined && $scope.inspqPrefObj.tradeName !== undefined) {
                //save to pref only if tradeName and lotId is not undefined
                if ($scope.imm.tradeName !== undefined && $scope.imm.lotId !== undefined) {
                    var savabletradeNameIndex = $scope.inspqPrefObj.tradeName.findIndex(function(e){return e.tradeName === $scope.imm.tradeName});
                    var savabletradeName = $scope.inspqPrefObj.tradeName[savabletradeNameIndex];
                    if(!savabletradeName){
                        savabletradeName = {tradeName: $scope.imm.tradeName, lotIds: []};
                        $scope.inspqPrefObj.tradeName.unshift(savabletradeName)
                    }else if(savabletradeNameIndex > 0){
                        $scope.inspqPrefObj.tradeName.unshift($scope.inspqPrefObj.tradeName.splice(savabletradeNameIndex, 1));
                    }
                    var savableLot = savabletradeName.lotIds.find(function(e){return e == $scope.imm.lotId})
                    if(!savableLot){
                        savableLot = $scope.imm.lotId;
                        savabletradeName.lotIds.unshift(savableLot)
                    }
                    if($scope.inspqPrefObj.tradeName.length > 10){
                        $scope.inspqPrefObj.tradeName.splice(9);
                    }
                    $scope.inspqPref.tradeName(JSON.stringify($scope.inspqPrefObj.tradeName));
                }
                updatePrefList('performer');
                updatePrefList('location');
            }
        }

        function updatePrefList(pref){
            var save = false;
            var savable = $scope.inspqPrefObj[pref].findIndex(function(e){return e.value == $scope.imm[pref].value})
            if(savable === -1){
                $scope.inspqPrefObj[pref].unshift($scope.imm[pref])
                save = true;
            }else if(savable > 0){
                $scope.inspqPrefObj[pref].unshift($scope.inspqPrefObj[pref].splice(savable,1)[0])
                save = true;
            }
            if(save){
                if($scope.inspqPrefObj[pref].length > 10){
                    $scope.inspqPrefObj[pref].splice(9);
                }
                $scope.inspqPref[pref](JSON.stringify($scope.inspqPrefObj[pref]));
            }
        }

        function parsePrefs(){
            // var tradeNamePrefs = [{tradeName:"",lotIds : []}]
            $scope.inspqPrefObj.tradeName = getObj($scope.inspqPref.tradeName());
            // var performerPrefs = [{value: data[0], display: data[1]}]
            $scope.inspqPrefObj.performer = getObj($scope.inspqPref.performer());
            // var location = [{value: data[0], display: data[1]}]
            $scope.inspqPrefObj.location = getObj($scope.inspqPref.location());
        }

        function unique(a){
            return (a && a.length == 1)
        }

        function initPref(){
            parsePrefs();
            if($scope.inspqPref !== undefined){
                if(unique($scope.inspqPrefObj.tradeName)){
                    var lot;
                    $scope.imm.tradeName = angular.copy($scope.inspqPrefObj.tradeName[0].tradeName);
                    if(unique($scope.inspqPrefObj.tradeName[0].lotIds)){
                        lot = angular.copy($scope.inspqPrefObj.tradeName[0].lotIds[0]);
                    }
                    searchForBatch($scope.imm.tradeName, lot);
                }

                if(unique($scope.inspqPrefObj.performer)){
                    $scope.imm.performer = new Practitioner($scope.inspqPrefObj.performer[0]);
                }
                if(unique($scope.inspqPrefObj.location)){
                    $scope.imm.location = angular.copy($scope.inspqPrefObj.location[0]);
                }
            }
        }

        $scope.tradeName = function(value) {
            if (value === undefined) {
                return $scope.imm.tradeName;
            } else {
                $scope.setTradeName(value);
            }
        }

        $scope.setTradeName = function(value) {
            let imm = $scope.imm;
            if (value === undefined) {
                imm.tradeName = value;
                $scope.setAgent(undefined);
            } else {
                imm.tradeNameIsUnknown = false;
                imm.tradeName = value;
                $scope.setAgent(undefined);
            }
        }

        $scope.agent = function(value) {
            if (value === undefined) {
                const agent = $scope.imm.vaccineCode;
                if (agent === undefined) {
                    return undefined;
                } else {
                    return agent.display;
                }
            } else {
                $scope.setAgent(value);
            }
        }

        $scope.setAgent = function(value) {
            let imm = $scope.imm;
            if (value === undefined) {
                imm.vaccineCode = undefined;
            } else {
                imm.vaccineCode = new CodeOrText(value);
                // $scope.imm.agent.display = $scope.imm.agent.code.display;
            }
            imm.lotNumber = undefined;
            imm.lotId = undefined;
            imm.lotExpiration = undefined;
        }

        $scope.reason = function(value) {
            return InspqImmunizationAccessor.getterSetterCode(value, $scope.imm, 'reason');
        }

        $scope.route = function(value) {
            return InspqImmunizationAccessor.getterSetterCode(value, $scope.imm, 'route');
        }
        
        $scope.setRoute = function(value) {
            return InspqImmunizationAccessor.setterCode(value, $scope.imm, 'route');
        }
        
        $scope.site = function(value) {
            return InspqImmunizationAccessor.getterSetterCode(value, $scope.imm, 'site');
        }
        
        $scope.doseQuantityUnknown = function(value) {
            if (value === undefined) {
                return $scope.imm.doseQuantityUnknown;
            } else {
                $scope.imm.doseQuantityUnknown = value;
                $scope.imm.doseQuantityValue = undefined;
                $scope.imm.doseQuantityUnit = undefined;
            }
        }

        $scope.doseQuantityValue = function(value) {
            if (value === undefined) {
                return $scope.imm.doseQuantityValue;
            } else {
                $scope.imm.doseQuantityValue = value;
            }
        }

        $scope.doseQuantityUnit = function(value) {
            return InspqImmunizationAccessor.getterSetterCode(value, $scope.imm, 'doseQuantityUnit');
        }

        $scope.tradeNameIsUnknown = function(value) {
            if (value === undefined) {
                return $scope.imm.tradeNameIsUnknown;
            } else if (value) {
                $scope.imm.tradeNameIsUnknown = true;
                $scope.setTradeName(undefined);
            } else {
                $scope.imm.tradeNameIsUnknown = false;
                $scope.setTradeName(undefined);
            }
        }

        $scope.setLocation = function(value) {
            Resource.setLocation($scope.imm, value);
        }

        $scope.isEditable = function() {
            let profile = $scope.profile;
            if (profile === undefined) {
                return false;
            } else {
                return profile.isPatientFusionFlagOff();
            }
        }

        function getEditable(){
            if($scope.imm){
                let editable = $scope.imm.editable(); // editable version.
                if (editable) {
                    $scope.origImm = $scope.imm;
                    $scope.imm = editable; 
                }
            }
        }
        
        $scope.modify = function(){
            $scope.changeStatus = "none";
            getEditable();
            $scope.editMode = true;
        }

        $scope.cancel = function(){
            $scope.editMode = false;
            $scope.imm = $scope.origImm;

            InspqImmunizationAccessor.cleanStatus($scope)

            if ($scope.isNew && $scope.$hide) {
                $scope.$hide();
            }
        }

        function getSavableTask(){

            var note = [
                "Registre de vaccination du Québec",
                "Acte vaccinal à sauvegarder ou modifier",
                "",
                "Données saisies : ",
                "",
            ]

            var formData = [
                {key:'tradeName', name:"Nom commercial" },
                {key:'tradeNameIsUnknown', name:"Nom commercial inconnu" },
                {key:'lotNumber',  name:"No de lot" },
                {key:'vaccineCode.display',  name:"Agent immunisant" },
                {key:'date', name:"Date d'administration" },
                {key:'reason.display', name: "Raison d'administration"},
                {key:'doseQuantityUnknown', name:"Quantité inconnue" },                
                {key:'doseQuantityValue', name:"Quantité administrée" },
                {key:'doseQuantityUnit.display', name:"Unité posologique" },
                {key:'site.display', name: "Site d'administration"},
                {key:'route.display', name: "Voie d'administration"},                
                {key:'performer.display', name:"Vaccinateur (nom)" },
                {key:'performer.identifier', name:"Vaccinateur (permis)" },
                {key:'location.display', name: "Lieu de vaccination"},
                {key:'comment', name: "Commentaires"},
            ];

            formData.forEach(function(e){
                var val = $scope.imm;
                e.key.split(".").forEach(function(currKey, i){
                    if(val != undefined){
                       val =  val[currKey];
                    }
                });
                console.log(e.key + " : " + val);
                if(val != undefined) {
                    if (typeof val == "string" && val != "" && val != "false"){
                        e["val"] = val;
                    } 
                    else if (typeof val == "boolean" && val == true) {
                        e["val"] = "Oui";
                    }
                    else if (typeof val == "number") {
                        e["val"] = val;
                    } else {
                        e["val"] = undefined;    
                    }
                } else {
                    e["val"] = undefined;
                }
            });

            //justify
            var m = 0;
            for (let index = 0; index < formData.length; index++) {
                const e = formData[index];
                if (e["val"] != undefined) {
                    m = Math.max(m, e["name"].length);
                }
            }

            for (let index = 0; index < formData.length; index++) {
                const e = formData[index];
                const name = e["name"];
                const val = e["val"];
                if (val != undefined) {
                    const text = name + " ".repeat(m - name.length) + " : " + val;
                    note.push(text);
                }
            }

            var task = {
                priority: "HAUT",
                linkType: "PATIENT",
                modificationStatus: "STATUS_NEW",
                idLink: $scope.patient.id,
                idPatient: $scope.patient.id,
                toUser: model.user().sessionUser.user.id,
                note: note.join ("\n"),
            }
            return task;
        }

        $scope.saveAsTask = function(){
            // let task = getSavableTask();
            // console.log(task);
            // console.log(task.note);
            TaskAccessor.save(getSavableTask(), function(){
                model.notice().success($filter('translate')('operationSuccess')); 
                if($scope.$hide){
                    $scope.$hide();
                }
            })
        }
        
        function onSave(e, fnSuccess){
            InspqImmunizationAccessor.handleTransaction($scope, e,$scope.imm, function(){
                model.notice().success($filter('translate')('operationSuccess'));
                if(!$scope.noPref){
                    savePreference();
                }

                if($scope.profile instanceof EmptyImmunizationProfile){
                    $scope.loadProfile();
                } else {
                    var res = JSON.parse(e.data);
                    if (res) {
                        $scope.profile.update(res);
                    } else {
                        $scope.loadProfile();
                    }
                }

                $scope.editMode = false;
                fnSuccess && fnSuccess();
            });
        }

        $scope.save = function () {
            if ($scope.imm !== undefined) {
                InspqImmunizationAccessor.cleanStatus($scope)

                const data = new XInspqImmunization($scope.imm);
                if ($scope.isNew) {
                    InspqImmunizationAccessor.ImmunizationAdd({ data: data, idPatient: $scope.patient.id }).then(function (e) {
                        onSave(e, function () {
                            if ($scope.$hide) {
                                $scope.$hide();
                            }
                        });
                    });
                } else {
                    InspqImmunizationAccessor.ImmunizationModify({ data: data, idPatient: $scope.patient.id }).then(function (e) {
                        onSave(e);
                    });
                }
            }
        }
        
        $scope.changeStatusToNone = function(){
            $scope.changeStatus = 'none';
        }
        $scope.passerOutre = function(){
            $scope.changeStatus = 'passer';
        }
        $scope.determineCalendar = function(){
            $scope.changeStatus = 'cal';
        }
        $scope.remove = function(){
            $scope.changeStatus = 'del';
        }

        $scope.performerAssist = {
            nextTabOnTab: true,
            nextTabOnEnter: true,
            hasDetails: false,
            hasHeader: false,
            trigger: 'focus',
            debounce: 800,
            keepOnScreen: true,
            minChar: 0,
            listWidth: 350,
            listHeight: 300,
            getAsyncData: function(query, assist){
                if(query && query.length > 3) {
                    return InspqImmunizationAccessor.PractitionerSearch({text: query}).then(function(res){
                        if(res && res.data){
                            let results = JSON.parse(res.data);
                            return results.entry;
                        }
                        //id + name for location add.
                        return [];
                    });
                }
                return $q.resolve(angular.copy($scope.inspqPrefObj.performer));
            },
            getKey: function(e) {
                return e.resource ? e.resource.name.given.concat(e.resource.name.family).join(" "): e.display;
            },
            selection: function(e, assistObject) {
                try{
                    if(!$scope.$$phase) {
                        $scope.$digest();
                    }
                }catch(e){
                }
                $scope.selectPerformer(e);
                return this.getKey(e);
            }
        };

        $scope.selectPerformer = function(e){
            let res;
            if (e === undefined) {
                res = undefined;
            } else if (e.resource !== undefined) {
                res = e.resource;
            } else if (e.res !== undefined) {
                res = e.res;
            }
            if (res === undefined) {
                $scope.imm.performer = undefined;    
            } else {
                $scope.imm.performer = new Practitioner(res);
            }
        }

        $scope.locationSearch = {};
        $scope.locationAssist = {
            nextTabOnTab: true,
            nextTabOnEnter: true,
            hasDetails: false,
            hasHeader: false,
            trigger: 'focus',
            debounce: 800,
            keepOnScreen: true,
            minChar: 0,
            listWidth: 350,
            listHeight: 300,
            getAsyncData: function(query, assist){
                if(query && query.length > 3){
                    return InspqImmunizationAccessor.LocationSearch(query).then(function(res){
                        if(res && res.data){
                            let results = JSON.parse(res.data);
                            return results.entry;
                        }
                        //id + name for location add.
                        return [];
                    });
                }
                return $q.resolve(angular.copy($scope.inspqPrefObj.location));
            },
            getKey: function(e) {
                return e.resource ? e.resource.name: e.display;
            },
            selection: function(e, assistObject) {
                try{
                    if(!$scope.$$phase) {
                        $scope.$digest();
                    }
                }catch(e){
                }
                $scope.setLocation(e);
                return this.getKey(e);
            }
        };

        function getAssistConfig(list, domain){
            var listSearchIndex = {};
            list.forEach(function(e, i){
                if (e === undefined) {
                    listSearchIndex[i] = "";
                } else {
                    listSearchIndex[i] = Object.values(e).toString().toLowerCase();
                }
            });
            return {
                nextTabOnTab: true,
                nextTabOnEnter: true,
                hasDetails: false,
                hasHeader: false,
                trigger: 'focus',
                debounce: 500,
                keepOnScreen: true,
                minChar: 0,
                listWidth: 350,
                listHeight: 300,
                getAsyncData: function(query, assist){
                    return $q(function(resolve, reject) {
                        if(!list){
                            reject();
                        }else{
                            var res = [];
                            if(domain.filterfn){
                                res = list.filter(domain.filterfn);
                            }else{
                                if((!domain.unfiltered) && query && query.length > 0){
                                    res = list.filter(function(e, i){
                                        return listSearchIndex[i].indexOf(query.toLowerCase()) > -1
                                    });
                                }else{
                                    if(domain.pref){
                                        res = domain.pref();
                                    }
                                    if(res.length === 0){
                                        res = list;
                                    }
                                }
                            }
                            resolve(res);
                        }
                    });
                },
                getKey: function(e) {
                    return domain.descrFn(e);
                },
                selection: function(e, assistObject) {
                    // if(domain.selectFn){
                    //     domain.selectFn(e);
                    // }
                    try{
                        if(!$scope.$$phase) {
                            $scope.$digest();
                        }
                    }catch(e){

                    }
                    return domain.selectFn(e);
                }
            }
        }
        $scope.lotNumbers = [];
        $scope.lotNumbersAssist = getAssistConfig($scope.lotNumbers, 
            {domain:'lotNumber', list: 'lotNumbers', 
            filterfn: function(e){
                if($scope.imm.lotNumberShowInactif){
                    return true; // if show inactive return everything
                }else{
                    var expired = e.extension.find(function(e){return e.url === "http://www.santepublique.rtss.qc.ca/sipmi/fa/1.0.0/extensions/#medication/expired"});
                    var publicProgram = e.extension.find(function(e){return e.url === "http://www.santepublique.rtss.qc.ca/sipmi/fa/1.0.0/extensions/#medication/publicprogram"});
                    if(expired && expired.valueBoolean != undefined){
                        return !expired.valueBoolean;
                    }
                }
            },
            descrFn:function(e){return e.lotNumber;}, 
            selectFn:function(e){
                setLotBatch(e);
                return e.lotNumber;
            }
        });

        var searchForBatch = _.throttle(function (tradeName, prefLot){
            InspqImmunizationAccessor.MedicationGet(tradeName).then(function(e){
                if(e && e.data){
                    var medication = JSON.parse(e.data);
                    var agent = medication.extension.find(function(e){return e.url === "http://www.santepublique.rtss.qc.ca/sipmi/fa/1.0.0/extensions/#medication/agent"})
                    if (agent) {
                        setCode('agent', agent.valueCodeableConcept.coding[0])
                    }
                    $scope.lotNumbers.splice(0,$scope.lotNumbers.length, ...medication.product.batch);
                    if (prefLot) {
                        var defaultLot = medication.product.batch.find(function (e) { return e.id == prefLot });
                        defaultLot && setLotBatch(defaultLot)
                    }
                }
            });
        }, 100)

        function setLotBatch(batch){
            $scope.imm.lotNumber = batch.lotNumber;
            $scope.imm.lotExpiration = batch.expirationDate;
            var r = batch.extension.find(function(e){return e.url === "http://www.santepublique.rtss.qc.ca/sipmi/fa/1.0.0/extensions/#medication/defaultroute"});
            if(r.valueCodeableConcept && r.valueCodeableConcept.coding){
                $scope.setRoute(r.valueCodeableConcept);
            }
            var doseQ = batch.extension.find(function(e){return e.url === "http://www.santepublique.rtss.qc.ca/sipmi/fa/1.0.0/extensions/#medication/defaultquantity"});
            $scope.imm.doseQuantity = new Quantity(doseQ.valueQuantity);
            $scope.imm.lotNumber = batch.lotNumber;
            $scope.imm.lotId = batch.id;
        }

        function clearPreviousData(){
            delete $scope.imm.doseQuantity;
            delete $scope.imm.lotNumber;
            delete $scope.imm.lotId;
            $scope.setRoute(undefined);
        }

        var domains = [
            {domain:'tradename', list: 'tradeNames',
                pref: function(){
                    return angular.copy($scope.inspqPrefObj.tradeName).map(function(e){
                        return {display: e.tradeName, code: e.tradeName}
                    });
                }, 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){
                    $scope.setTradeName(e.code);
                    clearPreviousData()
                    var prefTrade = $scope.inspqPrefObj.tradeName.find(function(x){return x.tradeName === $scope.imm.tradeName;})
                    var lot;
                    if(prefTrade && prefTrade.lotIds){
                        lot = prefTrade.lotIds[0];
                    }
                    searchForBatch(e.code, lot);
                    return e.code;
                }
            },
            {domain:'agent', list: 'agents', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){ setCode('agent', e);return e.display;}
            },
            {domain:'administrationreason', list: 'administrationReasons', 
                unfiltered: true,
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){setCode('reason', e);return e.display;}
            },
            {domain:'administrationsite', list: 'administrationSites', 
                unfiltered: true,
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){setCode('site', e);return e.display;}
            },
            {domain:'administrationroute', list: 'administrationRoutes', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){setCode('route', e);return e.display;}
            },
            {domain:'dosageunit', list: 'dosageUnits', 
                unfiltered: true,
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){
                    if(!$scope.imm.doseQuantity)$scope.imm.doseQuantity = {};
                    $scope.imm.doseQuantity.code = e.code; return e.display;}
            },
        ];

        $scope.immDynaDateOption = {
            format: 'YYYY-MM-DD'
        }
        function setCode(name, code){
            if (name === 'agent') {
                $scope.setAgent(code);
            }
            else {
                if(!$scope.imm[name]){
                    $scope.imm[name] = {};
                }
                delete $scope.imm[name].text;
                $scope.imm[name].code = code;
            }
        }

        $scope.load = function() {
            $scope.loaded = false;
            domains.forEach(function(e){
                // reinitialise domain list in scope if not empty
                $scope[e.domaine] = undefined;
            });
            
            $q.all(domains.map(function(e){
                let query = e.domain;
                return InspqImmunizationAccessor.ValueSetGet(query, $scope, e.list)
            })).then(function(responses) {
                domains.forEach(function(e, i){
                    const domainValues = $scope[e.list];
                    if (domainValues !== undefined) {
                        domainValues.unshift({'code' : "undefined", 'display' : ""}); //add blank value at index 0 of all domains list
                    }
                    $scope[e.list+"Assist"] = getAssistConfig(responses[i].data, e)
                });
                $scope.loaded = true;
            });
        }

        if($scope.isNew && $scope.initPreferences){
            initPref();
            $scope.initPreferences = false;
        }
        $scope.load();
        
    }]);

    var conditionController = m.controller('InspqImmunizationConditionController', ['model','$scope', '$filter','$q',  'InspqImmunizationAccessor', 
        function(model, $scope, $filter,$q, InspqImmunizationAccessor) {
        $scope.inspqPref = {};
        model.addPrefSettings(['location'], $scope.inspqPref, 'inspq_vaccin_');
        $scope.inspqPrefObj = {location : getObj($scope.inspqPref.location())};

        function unique(a){
            return (a && a.length == 1)
        }

        function getObj(str){
            if(typeof str == "string"){
                if(str.startsWith('[')|| str.startsWith('{')){//check if json array string.
                    try{
                        return JSON.parse(str);
                    }catch(e){
                        console.error(e);
                    }
                }
                return str.startsWith('[')? []: {};
            }else{
                return str;
            }
        }

        if($scope.updateScope){
            $scope.updateScope();
        }

        $scope.isEditable = function() {
            if ($scope.editMode === true) {
                return true; //always editable if we are already in edit mode
            }
            const profile = $scope.profile;
            if (profile === undefined) {
                return false;
            } 
            else if (profile.isPatientFusionFlagOn()) {
                return false;
            }
            //cannot modify is onsetPeriodEnd < than today
            else {
                const condition = $scope.condition;
                if (condition === undefined) {
                    return false;
                } else if (condition.onsetPeriodEnd === undefined) {
                     return true;
                } else {
                    const now = new Date();
                    const end = moment(condition.onsetPeriodEnd);
                    return end.isSame(now, 'day') || end.isAfter(now, 'day');
                }
            }
        }
        
        $scope.isPrecaution = function () {
            const cond = $scope.condition;
            if (cond === undefined) {
                return false;
            } else {
                return cond.isImmunizationProof === false
            }
        }

        function changeAgent(){
            if($scope.condition.isAgent == "true"){
                
            }
        };

        function getEditable(){
            if ($scope.condition && $scope.condition.editable) {
                $scope.origCond = $scope.condition;
                $scope.condition = $scope.condition.editable(); //editable version.
            }
            if ($scope.isNew && unique($scope.inspqPrefObj.location)) {
                $scope.condition.setLocation(angular.copy($scope.inspqPrefObj.location[0]));
            }
        }

        $scope.modify = function(){
            load();
            getEditable();
            $scope.editMode = true;
        }

        $scope.cancel = function() {
            $scope.condition = $scope.origCond;
            $scope.editMode = false;

            InspqImmunizationAccessor.cleanStatus($scope)

            if ($scope.isNew && $scope.$hide) {
                $scope.$hide();
            } else {
                load();
                getEditable();
            }
        }

        function onSave(e, fn){
            InspqImmunizationAccessor.handleTransaction($scope, e,$scope.condition, function(){
                model.notice().success($filter('translate')('operationSuccess'));
                let res = JSON.parse(e.data);
                let newObjects = $scope.profile.update(res);
                $scope.condition = newObjects[0].editable;
                $scope.editMode = false;	
                fn && fn();
            });
        }

        $scope.save = function(frm){
            if($scope.condition !== undefined){
                InspqImmunizationAccessor.cleanStatus($scope)
                if($scope.isNew){
                    InspqImmunizationAccessor.ConditionAdd({data:$scope.condition, idPatient: $scope.patient.id}).then(function(e){
                        onSave(e, function(){
                            if ($scope.$hide) {
                                $scope.$hide();
                            }
                        })
                    });
                }else{
                    InspqImmunizationAccessor.ConditionModify({data:$scope.condition, idPatient: $scope.patient.id}).then(function(e){
                        onSave(e, function () {
                            //dont hide on modify
                        })
                    });
                }
            }
        }

        $scope.changeStatusToNone = function(){
            $scope.changeStatus = 'none';
        }
        $scope.passerOutre = function(){
            $scope.changeStatus = 'passer';
        }
        $scope.determineCalendar = function(){
            $scope.changeStatus = 'cal';
        }
        $scope.remove = function(){
            $scope.changeStatus = 'del';
        }
        $scope.locationSearch = {};

        function getAssistConfig(list, domain){
            var listSearchIndex = {};
            list.forEach(function(e, i){
                if (e === undefined) {
                    listSearchIndex[i] = "";
                } else {
                    listSearchIndex[i] = Object.values(e).toString().toLowerCase();
                }
            });
            return {
                nextTabOnTab: true,
                nextTabOnEnter: true,
                hasDetails: false,
                hasHeader: false,
                trigger: 'focus',
                debounce: 500,
                keepOnScreen: true,
                minChar: 0,
                listWidth: 350,
                listHeight: 300,
                getAsyncData: function(query, assist){
                    return $q(function(resolve, reject) {
                        if(!list){
                            reject();
                        }else{
                            var res = [];
                            if(query && query.length > 0){
                                res = list.filter(function(e, i){
                                    return listSearchIndex[i].indexOf(query.toLowerCase()) > -1
                                })
                            }else{
                                res = list;
                            }
                            resolve(res);
                        }
                    });
                },
                getKey: function(e) {
                    return domain.descrFn(e);
                },
                selection: function(e, assistObject) {
                    // if(domain.selectFn){
                    //     domain.selectFn(e);
                    // }
                    try{
                        if(!$scope.$$phase) {
                            $scope.$digest();
                        }
                    }catch(e){

                    }
                    return domain.selectFn(e);
                }
            }
        }

        var domains = [
            {domain:'agent', list: 'agents', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){
                    
                    setCode('agent', e, true);
                    return e.display;
                }
            },
            {domain:'antigen', list: 'antigens', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){setCode('antigen', e, true);return e.display;}
            },
            {domain:'evidencesource', list: 'evidencesources', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){setCode('evidence', e);return e.display;}
            },
            {domain:'contraindicationreason', list: 'contraindicationreasons', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){setCode('reason', e);return e.display;}
            },
            {domain:'administrationsite', list: 'administrationSites', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){setCode('site', e);return e.display;}
            },
            {domain:'country', list: 'countries', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){;return e.display;}
            },
        ];
        $scope.conditionStartDynaDateOption = {
            format: 'YYYY-MM-DD'
        }
        $scope.conditionEndDynaDateOption = {
            format: 'YYYY-MM-DD',
            acceptFutureDate: true
        }

        function setCode(name, code, isParent){
            if (name === 'agent') {
                $scope.condition.setAgent(code);
            }
            else if (name === 'antigen') {
                $scope.condition.setAntigen(code);
            }
            else {
                if(!$scope.condition[name]){
                    $scope.condition[name] = {};
                }
                if(isParent){
                    $scope.condition[name] = code;
                }else{
                    delete $scope.condition[name].text;
                    $scope.condition[name].code = code;
                }
            }
        }
        $scope.inspqPref= {};
        $scope.inspqPrefObj= {};
        model.addPrefSettings(['location'], $scope.inspqPref, 'inspq_vaccin_');
        
        function parsePrefs(){
            // var location = [{value: data[0], display: data[1]}]
            // $scope.inspqPrefObj.location = getObj($scope.inspqPref.location());
        }

        function unique(a){
            return (a && a.length == 1)
        }
        function initPref(){
            parsePrefs();
            if($scope.inspqPref !== undefined){
                if(unique($scope.inspqPrefObj.location)){
                    $scope.condition.setLocation(angular.copy($scope.inspqPrefObj.location[0]));
                }
            }
        }

        function load() {
            $scope.loaded = false;
            domains.forEach(function(e){
                // reinitialise domain list in scope if not empty
                $scope[e.domaine] = undefined;
            });
            
            $q.all(domains.map(function(e){
                let query = e.domain;
                return InspqImmunizationAccessor.ValueSetGet(query, $scope, e.list)
            })).then(function(responses) {
                domains.forEach(function(e, i){
                    $scope[e.list+"Assist"] = getAssistConfig(responses[i].data, e)
                });
                $scope.loaded = true;
            });

            //load function work on model object not on editable object
            //load set condition.location from condition.locationValue
            if ($scope.condition.locationValue) {
                InspqImmunizationAccessor.LocationGet($scope.condition.locationValue).then(function (res) {
                    var s = JSON.parse(res.data);
                    $scope.condition.setLocation(s);
                })
            }


            $scope.locationAssist = {
                nextTabOnTab: true,
                nextTabOnEnter: true,
                hasDetails: false,
                hasHeader: false,
                trigger: 'focus',
                debounce: 1000,
                keepOnScreen: true,
                minChar: 0,
                listWidth: 350,
                listHeight: 300,
                getAsyncData: function(query, assist){
                    if(query && query.length > 3){
                        return InspqImmunizationAccessor.LocationSearch(query).then(function(res){
                            if(res && res.data){
                                let results = JSON.parse(res.data);
                                return results.entry;
                            }
                            //id + name for location add.
                            return [];
                        });
                    }
                    return $q.resolve(angular.copy($scope.inspqPrefObj.location));
                },
                getKey: function(e) {
                    return e.resource ? e.resource.name: e.display;
                },
                selection: function(e, assistObject) {
                    try{
                        if(!$scope.$$phase) {
                            $scope.$digest();
                        }
                    }catch(e){
                    }
                    $scope.condition.setLocation(e);
                    return this.getKey(e);
                }
            };
        }

        if($scope.isNew && $scope.initPreferences){
            initPref();
            $scope.initPreferences = false;
        }

        load();

        //should call getEditable so new Condition work correctly
        //see $scope.newCounterIndication in profile controller
        getEditable();
    }]);

    var newRefusalController = m.controller('InspqImmunizationNewRefusalController', 
        ['model','$scope', '$filter','$q',  'InspqImmunizationAccessor', 
        function(model,$scope, $filter,$q, InspqImmunizationAccessor) {

        if ($scope.updateScope) {
            $scope.updateScope();
        }

        function getObj(str){
            if(typeof str == "string"){
                if(str.startsWith('[')|| str.startsWith('{')){//check if json array string.
                    try{
                        return JSON.parse(str);
                    }catch(e){
                        console.error(e);
                    }
                }
                return str.startsWith('[')? []: {};
            }else{
                return str;
            }
        }

        $scope.cancel = function(){
            InspqImmunizationAccessor.cleanStatus($scope)
            if ($scope.$hide) {
                $scope.$hide();
            }
        }

        var insqAll = {
            "system": "http://www.santepublique.rtss.qc.ca/sipmi/fa/1.0.0/vocabulary",
            "version": "1.0.0",
            "code": "inspq_all",
            "display": "Tous les antigènes"
        }
        
        $scope.save = function (frm) {
            if ($scope.refusal !== undefined) {
                InspqImmunizationAccessor.cleanStatus($scope)
                if ($scope.refusal.allAntigen === "true") {
                    $scope.refusal.antigens = [insqAll];
                } else if ($scope.currAgentAntigens !== undefined) {
                    $scope.refusal.antigens = _.filter($scope.currAgentAntigens, function (e) { return e.isSelected !== undefined && e.isSelected === true });
                }
                InspqImmunizationAccessor.RefusalAdd({ data: $scope.refusal, idPatient: $scope.patient.id }).then(function (e) {
                    InspqImmunizationAccessor.handleTransaction($scope, e, $scope.refusal, function () {
                        model.notice().success($filter('translate')('operationSuccess'));
                        var res = JSON.parse(e.data);
                        if (res) {
                            $scope.profile.update(res);
                        } else {
                            //anormal behavior, reload profile
                            $scope.loadProfile();
                        }
                        $scope.editMode = false;
                        if ($scope.$hide) {
                            $scope.$hide();
                        }
                    });
                });
            }
        }
        
        function getAntigens(code){
            InspqImmunizationAccessor.ValueSetGet({
                domain:'antigens-by-agent', 
                'agent-code': code
            }, $scope, "currAgentAntigens" ).then(function(res){
                
            });
        }

        function getAssistConfig(list, domain){
            var listSearchIndex = {};
            list.forEach(function(e, i){
                if (e === undefined) {
                    listSearchIndex[i] = "";
                } else {
                    listSearchIndex[i] = Object.values(e).toString().toLowerCase();
                }
            });
            return {
                nextTabOnTab: true,
                nextTabOnEnter: true,
                hasDetails: false,
                hasHeader: false,
                trigger: 'focus',
                debounce: 500,
                keepOnScreen: true,
                minChar: 0,
                listWidth: 350,
                listHeight: 300,
                getAsyncData: function(query, assist){
                    return $q(function(resolve, reject) {
                        if(!list){
                            reject();
                        }else{
                            var res = [];
                            if(query && query.length > 0){
                                res = list.filter(function(e, i){
                                    return listSearchIndex[i].indexOf(query.toLowerCase()) > -1
                                })
                            }else{
                                res = list;
                            }
                            resolve(res);
                        }
                    });
                },
                getKey: function(e) {
                    return domain.descrFn(e);
                },
                selection: function(e, assistObject) {
                    // if(domain.selectFn){
                    //     domain.selectFn(e);
                    // }
                    try{
                        if(!$scope.$$phase) {
                            $scope.$digest();
                        }
                    }catch(e){

                    }
                    return domain.selectFn(e);
                }
            }
        }

        var domains = [
            {domain:'agent', list: 'agents', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){
                    getAntigens(e.code);
                    setCode('agent', e, true);
                    return e.display;
                }
            },
            {domain:'antigen', list: 'antigens', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){setCode('antigen', e, true);return e.display;}
            },
            {domain:'vaccinationrefusalmotive', list: 'vaccinationrefusalmotives', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){setCode('reason', e);return e.display;}
            },
        ];

        function setCode(name, code, isParent){
            if(!$scope.refusal[name]){
                $scope.refusal[name] = {};
            }
            if(isParent){
                $scope.refusal[name] = code;
            }else{
                delete $scope.refusal[name].text;
                $scope.refusal[name].code = code;
            }
        }

        $scope.load = function() {
            $scope.loaded = false;
            domains.forEach(function(e){
                // reinitialise domain list in scope if not empty
                $scope[e.domaine] = undefined;
            });
            
            $q.all(domains.map(function(e){
                let query = e.domain;
                return InspqImmunizationAccessor.ValueSetGet(query, $scope, e.list)
            })).then(function(responses) {
                domains.forEach(function(e, i){
                    $scope[e.list+"Assist"] = getAssistConfig(responses[i].data, e)
                });
                $scope.loaded = true;
            });
            
        }

        $scope.load();
        
    }]);

    var refusalController = m.controller('InspqImmunizationRefusalController', 
        ['model','$scope', '$filter','$q',  'InspqImmunizationAccessor', 
        function(model,$scope, $filter,$q, InspqImmunizationAccessor) {

        if ($scope.updateScope) {
            $scope.updateScope();
        }

        $scope.isEditable = function() {
            if ($scope.editMode === true) {
                return true; //always editable if we are already in edit mode
            }
            const profile = $scope.profile;
            if (profile === undefined) {
                return false;
            } else if (profile.isPatientFusionFlagOn()) {
                return false;
            } else {
                const refusal = $scope.refusal;
                if (refusal === undefined) {
                    return false;
                } else if (refusal.periodEnd === undefined) {
                    return true;
                } else {
                    const now = new Date();
                    const end = moment(refusal.periodEnd);
                    return end.isAfter(now, 'day');
                }
            }
        }

        function unique(a){
            return (a && a.length == 1)
        }

        function getObj(str){
            if(typeof str == "string"){
                if(str.startsWith('[')|| str.startsWith('{')){//check if json array string.
                    try{
                        return JSON.parse(str);
                    }catch(e){
                        console.error(e);
                    }
                }
                return str.startsWith('[')? []: {};
            }else{
                return str;
            }
        }

        function getEditable(){
            if($scope.refusal && $scope.refusal.editable){
                $scope.origRef = $scope.refusal;
                $scope.refusal = $scope.refusal.editable;// editable version.
                if($scope.refusal.agent !== undefined){
                    getAntigens($scope.refusal.agent.code);
                }
                if($scope.refusal.location && $scope.refusal.location.value){
                    InspqImmunizationAccessor.LocationGet($scope.refusal.location.value).then(function(res){
                        var s = JSON.parse(res.data);
                        $scope.refusal.location.display = s.name;
                        $scope.refusal.managingOrganization = s.managingOrganization;
                    })
                }
            }
            if($scope.isNew && unique($scope.inspqPrefObj.location)){
                $scope.refusal.location = angular.copy($scope.inspqPrefObj.location[0]);
            }
        }

        $scope.changeStatusToNone = function(){
            $scope.changeStatus = 'none';
        }

        $scope.changeStatusToDel = function(){
            $scope.changeStatus = 'del';
        }

        var insqAll = {
            "system": "http://www.santepublique.rtss.qc.ca/sipmi/fa/1.0.0/vocabulary",
            "version": "1.0.0",
            "code": "inspq_all",
            "display": "Tous les antigènes"
        }
        
        $scope.save = function (frm) {
            if ($scope.refusal !== undefined) {
                InspqImmunizationAccessor.cleanStatus($scope)
                // $scope.condition.otherReason = "Preuve d'immunité"
                if ($scope.refusal.allAntigen === "true") {
                    $scope.refusal.antigens = [insqAll];
                } else if ($scope.currAgentAntigens !== undefined) {
                    $scope.refusal.antigens = _.filter($scope.currAgentAntigens, function (e) { return e.isSelected !== undefined && e.isSelected === true });
                }
                if ($scope.isNew) {
                    InspqImmunizationAccessor.RefusalAdd({ data: $scope.refusal, idPatient: $scope.patient.id }).then(function (e) {
                        InspqImmunizationAccessor.handleTransaction($scope, e, $scope.refusal, function () {
                            model.notice().success($filter('translate')('operationSuccess'));
                            var res = JSON.parse(e.data);
                            if (res) {
                                $scope.profile.update(res);
                            } else {
                                //anormal behavior, reload profile
                                $scope.loadProfile();
                            }
                            $scope.editMode = false;
                            if ($scope.$hide) {
                                $scope.$hide();
                            }
                        });
                    });
                } else {
                    InspqImmunizationAccessor.RefusalModify({ data: $scope.refusal, idPatient: $scope.patient.id }).then(function (e) {
                        InspqImmunizationAccessor.handleTransaction($scope, e, $scope.refusal, function () {
                            model.notice().success($filter('translate')('operationSuccess'));
                            var res = JSON.parse(e.data);
                            if (res && res.entry && res.entry.length > 0) {
                                var flags = res.entry.map(function (e) { return new Flag(e.resource); });
                                $scope.refusal = flags[0];
                            }
                            var index = $scope.profile.flags.findIndex(function (i) { return i.id == $scope.refusal.id });
                            if (index > -1) {
                                $scope.profile.flags[index] = $scope.refusal;
                            }
                            $scope.editMode = false;
                            if ($scope.$hide) {
                                $scope.$hide();
                            }
                        });
                    });
                }
            }
        }
        
        $scope.locationSearch = {};

        function getAssistConfig(list, domain){
            var listSearchIndex = {};
            list.forEach(function(e, i){
                if (e === undefined) {
                    listSearchIndex[i] = "";
                } else {
                    listSearchIndex[i] = Object.values(e).toString().toLowerCase();
                }
            });
            return {
                nextTabOnTab: true,
                nextTabOnEnter: true,
                hasDetails: false,
                hasHeader: false,
                trigger: 'focus',
                debounce: 500,
                keepOnScreen: true,
                minChar: 0,
                listWidth: 350,
                listHeight: 300,
                getAsyncData: function(query, assist){
                    return $q(function(resolve, reject) {
                        if(!list){
                            reject();
                        }else{
                            var res = [];
                            if(query && query.length > 0){
                                res = list.filter(function(e, i){
                                    return listSearchIndex[i].indexOf(query.toLowerCase()) > -1
                                })
                            }else{
                                res = list;
                            }
                            resolve(res);
                        }
                    });
                },
                getKey: function(e) {
                    return domain.descrFn(e);
                },
                selection: function(e, assistObject) {
                    // if(domain.selectFn){
                    //     domain.selectFn(e);
                    // }
                    try{
                        if(!$scope.$$phase) {
                            $scope.$digest();
                        }
                    }catch(e){

                    }
                    return domain.selectFn(e);
                }
            }
        }
        function getAntigens(code){
            InspqImmunizationAccessor.ValueSetGet({
                domain:'antigens-by-agent', 
                'agent-code': code
            }, $scope, "currAgentAntigens" ).then(function(res){
                
            });
        }
        var domains = [
            {domain:'agent', list: 'agents', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){
                    getAntigens(e.code);
                    setCode('agent', e, true);
                    return e.display;
                }
            },
            {domain:'antigen', list: 'antigens', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){setCode('antigen', e, true);return e.display;}
            },
            {domain:'evidencesource', list: 'evidencesources', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){setCode('evidence', e);return e.display;}
            },
            {domain:'vaccinationrefusalmotive', list: 'vaccinationrefusalmotives', 
                descrFn:function(e){return e.display;}, 
                selectFn:function(e){setCode('reason', e);return e.display;}
            },
        ];

        function setCode(name, code, isParent){
            if(!$scope.refusal[name]){
                $scope.refusal[name] = {};
            }
            if(isParent){
                $scope.refusal[name] = code;
            }else{
                delete $scope.refusal[name].text;
                $scope.refusal[name].code = code;
            }
        }

        $scope.load = function() {
            $scope.loaded = false;
            domains.forEach(function(e){
                // reinitialise domain list in scope if not empty
                $scope[e.domaine] = undefined;
            });
            
            $q.all(domains.map(function(e){
                let query = e.domain;
                return InspqImmunizationAccessor.ValueSetGet(query, $scope, e.list)
            })).then(function(responses) {
                domains.forEach(function(e, i){
                    $scope[e.list+"Assist"] = getAssistConfig(responses[i].data, e)
                });
                $scope.loaded = true;
            });
            
        }

        $scope.load();
        
    }]);

    var refusalRemoveDirective = m.directive('inspqRefusalRemove', ['InspqImmunizationAccessor','model','$filter', 
        function (InspqImmunizationAccessor, model, $filter) {
		return {
            restrict: 'E',
            templateUrl: "/dashboard/resources/ofys/inspq/immunization-refusal-remove.html?v=bk",
			link: function (scope, element, attrs) {

                scope.cancelChangeStatus = function(){
                    scope.changeStatusToNone && scope.changeStatusToNone();
                }

                scope.saveChangeStatus = function(){

                    InspqImmunizationAccessor.cleanStatus(scope)

                    scope.refusalEditable = scope.refusal.editable();
                    scope.refusalEditable.periodEnd = moment().format("YYYY-MM-DD");

                    const data = {idPatient: scope.patient.id, data: scope.refusalEditable};

                    InspqImmunizationAccessor.RefusalModify(data).then(function(e){
                        const transactionIdStatus = e.status.removeStatusByCode('inspq-transactionid')
                        InspqImmunizationAccessor.pushStatus(scope, e.status)
                        if (e.status.isError()) {
                            scope.status.errors.unshift("Erreur de sauvegarde")
                            if (transactionIdStatus) {
                                scope.refusalEditable.faTransactionId = transactionIdStatus.message;
                            }
                        } else {
                            model.notice().success($filter('translate')('operationSuccess'));
                            try {
                                var res = JSON.parse(e.data);
                                scope.profile.update(res);

                                scope.changeStatusToNone && scope.changeStatusToNone();
                            } catch (error) {
                                scope.changeStatusToNone && scope.changeStatusToNone();
                                scope.loadProfile();
                            }
                        }
                    });
                }
			}
		};
    }]);
    
	m.directive('inspqScopeInit', function () {
        return {
            restrict: 'A',
            scope: true,
			link: function (scope, element, attrs) {
                scope.updateScope = function(){
                    var initFn = scope.$eval(attrs.inspqScopeInit);
                    $.extend(scope, initFn());
                }

			}
		};
    });

    m.directive('inspqErrors', [function(){
        return {
            restrict: 'E',
            templateUrl: "/dashboard/resources/ofys/inspq/inspq-errors.html?v=bk",
			link: function (scope, element, attrs) {
            }
        }
    }]);

    m.directive('inspqImmunizationDetailRemove', ['InspqImmunizationAccessor','model','$filter', 
        function (InspqImmunizationAccessor, model, $filter) {
		return {
            restrict: 'E',
            templateUrl: "/dashboard/resources/ofys/inspq/immunization-detail-remove.html?v=bk",
			link: function (scope, element, attrs) {

                scope.reasonLst = [];// filled with domain values.

                scope.changestatus = {immunisationJson: JSON.stringify(scope.imm.res), res: scope.imm.res};
                InspqImmunizationAccessor.ValueSetGet('deletionreason', scope, 'reasonLst').then(function(e){
                    // console.log("Overridereason");
                    
                    // console.log(e);
                })

                //domain : deletionreason
                scope.cancelChangeStatus = function(){
                    scope.changeStatusToNone && scope.changeStatusToNone();
                }
                scope.saveChangeStatus = function(){
                    InspqImmunizationAccessor.cleanStatus(scope)
                    InspqImmunizationAccessor.ImmunizationDelete({data: scope.changestatus, idPatient: scope.patient.id}).then(function(e){
                        let transactionId = e.status.removeStatusByCode('inspq-transactionid')
                        InspqImmunizationAccessor.pushStatus(scope, e.status)
                        if(e.status.isError()){
                            scope.status.errors.unshift("Erreur de sauvegarde")
                            if(transactionId){
                                scope.changestatus.faTransactionId = transactionId.message;
                            }
                        }else{
                            model.notice().success($filter('translate')('operationSuccess'));
                            scope.changeStatusToNone && scope.changeStatusToNone();


                            scope.profile.remove(scope.changestatus.res);

                            // scope.loadProfile();

                            if (scope.$hide) {
                                scope.$hide();
                            }
                        }
                    });
                }
			}
		};
    }]);

	m.directive('inspqImmunizationDetailChangestatusbycal', ['InspqImmunizationAccessor', 'model', '$filter',
    function (InspqImmunizationAccessor, model, $filter) {
		return {
            restrict: 'E',
            templateUrl: "/dashboard/resources/ofys/inspq/immunization-detail-changestatusbycal.html?v=bk",
			link: function (scope, element, attrs) {

                scope.changestatus = {immunisationJson: JSON.stringify(scope.imm.res)};
                scope.cancelChangeStatus = function(){
                    scope.changeStatusToNone && scope.changeStatusToNone();
                }
                scope.saveChangeStatus = function(){

                    InspqImmunizationAccessor.cleanStatus(scope)
                    InspqImmunizationAccessor.ImmunizationSettoforecast({data: scope.changestatus, idPatient: scope.patient.id}).then(function(e){
                        let transactionId = e.status.removeStatusByCode('inspq-transactionid')
                        InspqImmunizationAccessor.pushStatus(scope, e.status)
                        if(e.status.isError()){
                            scope.status.errors.unshift("Erreur de sauvegarde")
                            if(transactionId){
                                scope.changestatus.faTransactionId = transactionId.message;
                            }
                        }else{
                            model.notice().success($filter('translate')('operationSuccess'));
                            scope.changeStatusToNone && scope.changeStatusToNone();

                            var res = JSON.parse(e.data);
                            if (res) {
                                scope.profile.update(res);
                            } else {
                                scope.loadProfile();
                            }

                            if (scope.$hide) {
                                scope.$hide();
                            }
                        }
                    });
                }
			}
		};
    }]);

	m.directive('inspqImmunizationDetailChangestatus', ['InspqImmunizationAccessor', 'model', '$filter',
    function (InspqImmunizationAccessor, model, $filter) {
		return {
            restrict: 'E',
            templateUrl: "/dashboard/resources/ofys/inspq/immunization-detail-changestatus.html?v=bk",
			link: function (scope, element, attrs) {

                scope.reasonLst = [];// filled with domain values.

                scope.changestatus = {immunisationJson: JSON.stringify(scope.imm.res)};
                InspqImmunizationAccessor.ValueSetGet('overridereason', scope, 'reasonLst').then(function(e){
                })
                scope.cancelChangeStatus = function(){
                    scope.changeStatusToNone && scope.changeStatusToNone();
                }
                
                scope.saveChangeStatus = function(){
                    InspqImmunizationAccessor.cleanStatus(scope)
                    InspqImmunizationAccessor.ImmunizationOverride({data: scope.changestatus, idPatient: scope.patient.id}).then(function(e){
                        let transactionId = e.status.removeStatusByCode('inspq-transactionid')
                        InspqImmunizationAccessor.pushStatus(scope, e.status)
                        if(e.status.isError()){
                            scope.status.errors.unshift("Erreur de sauvegarde")
                            if(transactionId){
                                scope.changestatus.faTransactionId = transactionId.message;
                            }
                        }else{
                            model.notice().success($filter('translate')('operationSuccess'));
                            scope.changeStatusToNone && scope.changeStatusToNone();

                            var res = JSON.parse(e.data);
                            if (res) {
                                scope.profile.update(res);
                            } else {
                                scope.loadProfile();
                            }

                            if (scope.$hide) {
                                scope.$hide();
                            }
                        }
                    });
                }
			}
		};
    }]);

	m.directive('inspqImmunizationDetailRead', function () {
		return {
            restrict: 'E',
            templateUrl: "/dashboard/resources/ofys/inspq/immunization-detail-read2.html?v=bk",
			link: function (scope, element, attrs) {
			}
		};
    });

	m.directive('uniqueOpenPopover', ['InspqImmunizationAccessor', function (InspqImmunizationAccessor) {
		return {
            restrict: 'A',
			link: function (scope, element, attrs) {
                InspqImmunizationAccessor.uniqueOpenPopover(scope);
			}
		};
    }]);

	m.directive('inspqImmunizationDetailEdit', function () {
		return {
            restrict: 'E',
            templateUrl: "/dashboard/resources/ofys/inspq/immunization-detail-edit.html?v=bk",
			link: function (scope, element, attrs) {
			}
		};
    });

    var profileController = m.controller('InspqImmunizationProfileController', ['model', '$scope', '$log', '$filter', 'DashAPI', 'InspqImmunizationAccessor', 
        function(model, $scope, $log, $filter, dashapi, InspqImmunizationAccessor) {

        $scope.noAccess = false;
        $scope.loading = false;
        $scope.loaded = false;
        $scope.status = undefined;

        $scope.signout = function(){
            InspqImmunizationAccessor.Signout();
        }
        $scope.clearPreferences = function(){
            var inspqPref= {};
            ['tradeName', 'performer', 'location'].forEach(function(e){
                model.addPrefSettings([e], inspqPref, 'inspq_vaccin_');
                inspqPref[e]("");
            });
            model.notice().success("Préférences effacés avec succès!")
        }

        $scope.canUploadPatientInformations = function() {
            let profile = $scope.profile;
            if (profile === undefined) {
                return false;
            }
            if (profile.isPatientFusionFlagOn()) {
                return false;
            }
            let p = $scope.getPatient();
            if (p === undefined) {
                return false;
            }
            if (profile.immunizations === undefined || profile.immunizations.length == 0) {
                return false;
            }
            if (p.matchRamq) {
                return false;
            }
            return true;
        }

        $scope.uploadPatientInformations = function() {
            if ($scope.profile !== undefined && !$scope.updatingPatient) {
                $scope.updatingPatient = true;
                let profile = $scope.profile;
                let patientId = $scope.patient.id;
               
                //take first immunization
                let imm = profile.immunizations[0];

                const saveable = new XInspqImmunization(imm);
                saveable.updatePatientProfile = true;
                saveable.addNote("Correction information usager");

                InspqImmunizationAccessor.cleanStatus($scope);
                InspqImmunizationAccessor.ImmunizationModify({data:saveable, idPatient: patientId})
                    .then(function(e) {
                        let obj = undefined; //dont pass obj, not needed here
                        InspqImmunizationAccessor.handleTransaction($scope, e, obj, function(){
                            //show success
                            model.notice().success($filter('translate')('operationSuccess'));
                            
                            //reload profile
                            $scope.loadProfile();
                        });
                    }).finally(function(){
                        $scope.updatingPatient = false;
                    });
            }
        }

        $scope.getPatient = function() {
            if ($scope.profile === undefined) {
                return undefined;
            } else {
                return $scope.profile.patient;
            }
        }

        $scope.getPatientMatchRamqDisplay = function() {
            if ($scope.profile === undefined) {
                return undefined;
            } else {
                let p = $scope.profile.patient;
                if (p.matchRamq) {
                    return "Oui";
                } else {
                    return "Non";
                }
            }
        }

        $scope.getPatientAddresseFirstRep = function() {
            let r = $scope.getPatientAddresses();
            if (r.length > 0) {
                return r[0];
            }
            return undefined;
        }

        $scope.getPatientAddresses = function() {
            let p = $scope.getPatient();
            let r = [];
            if(p !== undefined && p.address && p.address.length > 0){
                var a = p.address[0];
                if(a.line != undefined){
                    r.push(
                        a.line.concat(
                            ['city', 'state', 'postalCode', 'country'].map(
                                function (e){return a[e] != undefined ? a[e]:""}
                            )).join(", ")
                    );
                }
//                 line: ["1000 route de l'Église"]
// city: "Québec"
// state: "Québec"
// postalCode: "G1V3V9"
// country: "Canada"
                // patInfo.push(getAdressString())
            }
            return r;
        }

        $scope.getPatientPhone = function() {
            let p = $scope.getPatient();
            if (p !== undefined && p.telecoms && p.telecoms.length > 0) {
                for (var i = 0; i < p.telecoms.length; i++) {
                    var e = p.telecoms[i];
                    return e.value;
                    // if(e.system === "phone"){
                    //     return e.value;
                    //     patInfo.push("Téléphone: "+e.value)
                    // }else if(e.system === 5){
                    //     patInfo.push("Cellulaire: "+e.contact)
                }
            }
            return undefined;
        }

        function getPatientName(){
            return $scope.profile.patient.firstName + ", " + $scope.profile.patient.lastName;
        }

        function getAdressString(addr){
            return [
                addr.street,
                addr.city.name,
                addr.province.name,
                addr.country.name,
                addr.postalCode].join(" ");
        }
        function getGenderString(g){
            if(g == "male"){
                return "H";
            }else if( g == "female"){
                return "F"
            }else {
                return ""
            }
        }
        $scope.getPatientInfo = function (){
            var p = $scope.profile.patient;
            var patInfo = []
            if(p.patientRecordNumber != undefined){
                patInfo.push("No. dossier:")
                patInfo.push(p.patientRecordNumber)
            }else if(p.namQc != undefined){
                patInfo.push("NAM:")
                patInfo.push(p.namQc)
            }
            patInfo.push(p.firstName + ", " + p.lastName);
            patInfo.push(p.birthDate)
            patInfo.push("("+getGenderString(p.gender)+")")
            patInfo.push("\n")
            if(p.address && p.address.length > 0){
                var a = p.address[0];
                if(a.line != undefined){
                    patInfo.push(
                        a.line.concat(
                            ['city', 'state', 'postalCode', 'country'].map(
                                function (e){return a[e] != undefined ? a[e]:""}
                            )).join(" ") + "\n"
                    );
                }
//                 line: ["1000 route de l'Église"]
// city: "Québec"
// state: "Québec"
// postalCode: "G1V3V9"
// country: "Canada"
                // patInfo.push(getAdressString())
            }
            if(p.telecoms && p.telecoms.length > 0){
                for (var i = 0; i < p.telecoms.length; i++) {
                    var e = p.telecoms[i];
                    if(e.system === "phone"){
                        patInfo.push("Téléphone: "+e.value)
                    // }else if(e.system === 5){
                    //     patInfo.push("Cellulaire: "+e.contact)
                    }
                }
            }
            return patInfo.join(" ")
        }

        function getHeader(){
            return {
                layout:"noBorders",
                background: "#578be2",
                table: {
                    headerRows: 1,
                    widths: ["100%"],
                    body: [
                        [{ 
                            text:'Profil vaccinal de: ' + getPatientName(),
                            alignment: "center",
                            margin: 8,
                            color: "white",
                            fillColor: "#578be2",
                        }],
                    ],
                },
            }
            return ;
        }
        function getUserInfo(){
            return {
                layout:"noBorders",
                background: "#578be2",
                style: "patientInfoTableStyle",
                table: {
                    headerRows: 1,
                    widths: ["100%"],
                    body: [
                        [{ 
                            text:"Information de l'usager \n" + $scope.getPatientInfo(),
                            alignment: "center",
                            color: "white",
                            fontSize:10,
                            fillColor: "#578be2",
                        }],
                    ],
                },
            }
            return ;
        }

        function getDate(d){
            if(d != undefined){
                return $filter("date")(d, 'yyyy-MM-dd')
            }else{
                return "";
            }
        }

        function getHistoryTableDef(){
            return {
                title: "Histoire vaccinale",
                colDef: [
                    {
                        title: "Agent immunisant",
                        name: function(i){return i.vaccineCode.display;}
                    },
                    {
                        title: "Date d'administration",
                        name: function(i){return getDate(i.date);}
                    },
                    {
                        title: "Nom commercial",
                        name: "tradeName"
                    },
                    {
                        title: "Quantité administrée",
                        name: function(i){return i.doseQuantity.display;}
                    },
                    {
                        title: "Statut",
                        name: function(i){return i.overrideStatus.display;}
                    },
                ],
                lst:$scope.getImmunizations()
            }
        }
        function getVaccineRecommandationsTableDefLegend(){
            return{
                style:"profilTableLegendStyle",
                table: {
                    body: [
                        ['Admissible', 'La date d’admissibilité pour la dose est atteinte.'],
                        ['Prévue', 'La date recommandée pour la dose est atteinte.'],
                        ['Retard', 'La date de retard pour la dose est atteinte.'],
                        ['À jour', 'La vaccination n’est pas encore due pour cet usager'],
                    ]
                },
                layout: 'noBorders'
            }
        }
        function getVaccineRecommandationsTableDef(){
            return {
                title: "Vaccins prévus",
                colDef: [
                    {
                        title: "Agent immunisant",
                        name: function(i){return i.vaccineCode.display;}
                    },
                    {
                        title: "No de dose prévue",
                        name: "doseNumber"
                    },
                    {
                        title: "Prévue",
                        name: function(i){return getDate(i.plannedDate);}
                    },
                    {
                        title: "Admissible",
                        name: function(i){return getDate(i.eligibleDate);}
                    },
                    {
                        title: "Statut",
                        name: function(i){return i.forecastStatus.display;}
                    },
                ],
                lst:$scope.getVaccineRecommandations()
            }
        }
        function getAntigenRecommandationsTableDef(){
            return {
                title: "Antigène prévu restant",
                colDef: [
                    {
                        title: "Agent immunisant",
                        name: function(i){return i.vaccineCode.display;}
                    },
                    {
                        title: "No de dose prévue",
                        name: "doseNumber"
                    },
                    {
                        title: "Prévue",
                        name: function(i){return getDate(i.plannedDate);}
                    },
                    {
                        title: "Admissible",
                        name: function(i){return getDate(i.eligibleDate);}
                    },
                    {
                        title: "Statut",
                        name: function(i){return i.forecastStatus.display;}
                    },
                ],
                lst:$scope.getAntigenRecommandations()
            }
        }
        
        function getInvalidImmunizationsTableDef(){
            return {
                title: "Sommaire des vaccins non valides",
                colDef: [
                    {
                        title: "Agent immunisant",
                        name: function(i){return i.vaccineCode.display;}
                    },
                    {
                        title: "Date d'administration",
                        name: function(i){return getDate(i.date);}
                    },
                    {
                        title: "Motif d'invalidation",
                        name: function(i){return i.overrideReason.valueCodeableConcept.coding[0].display;}
                    },
                ],
                lst:$scope.getInvalidImmunizations()
            }
        }
        function getConditionPrecautionTableDef(){
            return {
                title: "Contre-indications / Précautions",
                colDef: [
                    {
                        title: "Antigène/Agent immunisant",
                        name: function(i){
                            if(i.antigen){
                                return i.antigen.display
                            }else if(i.agent){
                                return i.agent.display
                            }else{
                                return "";
                            }
                        }
                    },
                    {
                        title: "Motif",
                        name: function(i){return (i && i.reason && i.reason.display) ? i.reason.display: "";},
                        width: 200
                    },
                    {
                        title: "Source d'attestation",
                        name: function(i){return i.evidence.display;}
                    },
                    {
                        title: "Applicable du",
                        name: function(i){return getDate(i.onsetPeriodStart);}
                    },
                    {
                        title: "Jusqu'au",
                        name: function(i){return getDate(i.onsetPeriodEnd);}
                    },
                ],
                lst:$scope.getContraindicationPrecaution()
            }
        }

        function getImmunizationProofTableDef(){
            return {
                title: "Preuves d'immunité",
                colDef: [
                    {
                        title: "Antigène",
                        name: function(i){
                            if(i.antigen){
                                return i.antigen.display
                            }else if(i.agent){
                                return i.agent.display
                            }else{
                                return "";
                            }
                        }
                    },
                    {
                        title: "Motif",
                        name: function(i){return (i && i.reason && i.reason.display) ? i.reason.display: "";}
                    },
                    {
                        title: "Source d'attestation",
                        name: function(i){return i.evidence.display;}
                    },
                    {
                        title: "Applicable du",
                        name: function(i){return getDate(i.onsetPeriodStart);}
                    },
                    {
                        title: "Jusqu'au",
                        name: function(i){return getDate(i.onsetPeriodEnd);}
                    },
                ],
                lst:$scope.getImmunizationProof()
            }
        }
        function getRefusalsTableDef(){
            return {
                title: "Refus de vaccination",
                colDef: [
                    {
                        title: "Antigène/Agent immunisant",
                        name: function(i){ return i.code.display;}
                    },
                    {
                        title: "Motif",
                        name: function(i){return i.category.display;}
                    },
                    {
                        title: "Applicable du",
                        name: function(i){return getDate(i.periodStart);}
                    },
                    {
                        title: "Jusqu'au",
                        name: function(i){return getDate(i.periodEnd);}
                    },
                ],
                lst:$scope.getRefusals()
            }
        }

        function getTCTTableDef(){
            return {
                title: "Résultats tests cutanés à la tuberculine (TCT)",
                colDef: [
                    {
                        title: "Agent immunisant",
                        name: function(i){ return i.vaccineCode.display;}
                    },
                    {
                        title: "Date d’administration",
                        name: function(i){return getDate(i.date);}
                    },
                    {
                        title: "Commentaires",
                        width: 450,
                        name: function(i){
                            return i.notes.map(function(e){return e.text}).join("\n");
                        }
                    },
                ],
                lst:$scope.getTCT()
            }
        }
        function getFnOrStr(val, name){
            try{
                if(typeof val[name] === "string"){
                    return val[name]
                }else if(typeof val[name] === "function" ){
                    return val[name](...arguments);
                }
            }catch(e){
                console.error(e);
            }
        }
        function getColumnHeader(e){
            var c = { style: "columnHeaderStyle"};
            c.text = getFnOrStr(e, 'title');
            return c;
        }
        function getCell(data, def){
            try{
                if(typeof def.name === "string"){
                    return data[def.name] == undefined ? "": data[def.name].toString();
                }else if(typeof def.name === "function"){
					let result = def.name(data);
					if (result == undefined){
						result = "";
					}
                    return result;
                }
            }catch(e){
                console.error(e);
            }
            return "";
        }

        function getTable(tableDef){
            var headerRows = 1;
            var t = {
                style: 'profilTableStyle',
                table: {
                    headerRows: headerRows,
                    widths: [],
                    body: [
                        [],
                    ]
                },
            }

            if(tableDef.title != undefined){
                headerRows= 2;
                t.table.headerRows = headerRows;
                var tTitle = [{text: tableDef.title, colSpan: tableDef.colDef.length, style: 'tableTitleStyle'}, ];
                tTitle = tTitle.concat(Array(tableDef.colDef.length - 1).fill().map(function(){return {}}))
                t.table.body.unshift(tTitle);
            }
            var columnHederIndex = headerRows - 1;
            // Colomn definition.
            for (let i = 0; i < tableDef.colDef.length; i++) {
                const element = tableDef.colDef[i];
                t.table.body[columnHederIndex].push(getColumnHeader(element))
                t.table.widths.push(element.width == undefined? '*': element.width);
            }
            if(tableDef.lst != undefined && tableDef.lst.length > 0){
                //  data.
                for (let j = 0; j < tableDef.lst.length; j++) {
                    var row = [];
                    const item = tableDef.lst[j];
                    for (let i = 0; i < tableDef.colDef.length; i++) {
                        const element = tableDef.colDef[i];
                        row.push(getCell(item, element));
                    }
                    t.table.body.push(row);
                }
            }
            return t;
        }

        $scope.print = function(){
            var dd = {
                content: [
                    {
                        table: {
                            headerRows: 1,
                            widths: [520, '*'],
                            body: [
                                [
                                    {text: 'Registre de vaccination du Québec ', style: 'pageHeader'}, 
                                    {text: 'Date d’impression : '+ moment().format("YYYY-MM-DD")}, 
                                ],
                            ]
                        },
                        layout: 'noBorders'
                    },
                    getHeader(),
                    getUserInfo(),
                    getTable(getHistoryTableDef()),
                    getTable(getVaccineRecommandationsTableDef()),
                    getVaccineRecommandationsTableDefLegend(),
                    getTable(getAntigenRecommandationsTableDef()),
                    getTable(getInvalidImmunizationsTableDef()),
                    getTable(getConditionPrecautionTableDef()),
                    getTable(getImmunizationProofTableDef()),
                    getTable(getRefusalsTableDef()),
                    getTable(getTCTTableDef()),
                    
                ],
                header: function(currentPage, pageCount, pageSize){
                    if(currentPage > 1){
                        return getHeader();
                    }else{
                        return "";
                    }
                },
                footer: function(currentPage, pageCount, pageSize){
                    return {
                        columns: [
                            { text: 'Confidentiel', alignment: 'right' },
                            { text: 'Page '+ currentPage + " sur "+ pageCount, alignment: 'right', margin: [0, 0, 40, 0] }
                        ]
                    };
                },
                pageOrientation: 'landscape',
                pageSize: 'LETTER',
                styles:{
                    pageHeader:{
                        fontSize: 16,
                    },
                    tableTitleStyle: {
                        fontSize: 10,
                    },
                    columnHeaderStyle: {
                        fontSize: 10,
                        alignment: "center",
                    },
                    patientInfoTableStyle: {
                        margin: [0, 10, 0, 0],
                        fontSize: 10,
                    },
                    profilTableStyle: {
                        margin: [0, 10, 0, 15],
                        fontSize: 8,
                    },
                    profilTableLegendStyle: {
                        fontSize: 9,
                    },
                }
                // defaultStyle: {
                //   font: 'OpenSans'
                // }
                
            }
            pdfMake.createPdf(dd).open();
        };

        $scope.newHistoryImmAct = function() {
            return $scope.newImmAct(true);
        }

        $scope.newImmAct = function(noPref) {
            const imm = new Immunization({});
            imm.tradeNameIsUnknown = false;
            // imm.date = moment().format("YYYY-MM-DD");
            // imm.route = EditableImmunizationUndefinedDomainValue;
            // imm.site = EditableImmunizationUndefinedDomainValue;
            // imm.reason = EditableImmunizationUndefinedDomainValue;
            const editable = imm.editable();
            return {
                noPref: noPref,
                editMode: true,
                isNew: true,
                imm: editable,
                initPreferences: !noPref,
            }
        }

        $scope.newCounterIndication = function() {
            const cond = new Condition({});
            cond.setAsContraindicationPrecaution();
            return {
                editMode: true,
                condition : cond,
                isNew: true,
                initPreferences: true,
            }
        }
        $scope.newProof = function() {
            const cond = new Condition({});
            cond.setAsImmunizationProof();
            return {
                editMode: true,
                condition : cond,
                isNew: true,
                initPreferences: true,
            }
        }
        $scope.newRefusal = function() {
            const refusal = new NewRefusal();
            return {
                refusal : refusal,
            }
        }

        $scope.getImmunizations = function() {
            if ($scope.profile === undefined) {
                return undefined;
            } else {
                return $scope.profile.immunizations;
            }
        }
        
        $scope.getInvalidImmunizations = function() {
            if ($scope.profile === undefined) {
                return undefined;
            } else {
                return $scope.profile.immunizations.filter(function(imm) {
                    let status = imm.overrideStatus; 
                    return status !== undefined && status.code !== 'FV' && status.code !== 'OV';
                });
            }
        }

        $scope.getVaccineRecommandations = function() {
            if ($scope.profile === undefined) {
                return undefined;
            } else {
                return $scope.profile.recommandations.filter(function(recommandation) {
                    return recommandation.vaccineCode.isVaccine == true;
                });
            }
        }

        $scope.getAntigenRecommandations = function() {
            if ($scope.profile === undefined) {
                return undefined;
            } else {
                return $scope.profile.recommandations.filter(function(recommandation) {
                    return recommandation.vaccineCode.isVaccine == false;
                });        
            }
        }

        $scope.getContraindicationPrecaution = function() {
            if ($scope.profile === undefined) {
                return undefined;
            } else {
                return $scope.profile.conditions.filter(function(c) {
                    return c.isImmunizationProof === false;
                });
            }
        }

        $scope.getImmunizationProof = function() {
            if ($scope.profile === undefined) {
                return undefined;
            } else {
                return $scope.profile.conditions.filter(function(c) {
                    return c.isImmunizationProof === true;
                });
            }
        }

        $scope.getRefusals = function() {
            if ($scope.profile === undefined) {
                return undefined;
            } else {
                return $scope.profile.flags;
            }
        }

        $scope.getTCT = function() {
            if ($scope.profile === undefined) {
                return undefined;
            } else {
                return $scope.profile.immunizations.filter(function(imm) {
                    let status = imm.vaccineCode; 
                    return status !== undefined && status.display === 'TCT';
                });
            }
        }

        $scope.loadProfile = function() {
            $scope.loaded = false;
            $scope.loading = true;
            $scope.noAccess = false;

            let patient = $scope.patient;
            InspqImmunizationAccessor.PatientGetImmunizationProfile(patient.id).then(function(response) {
                $scope.loading = false;
                $scope.status = response.status;
                $scope.loaded = false;
                if (response.status.isOk()) {
                    try {
                        if (response.data !== undefined) {
                            const obj = JSON.parse(response.data);
                            $scope.profile = new ImmunizationProfile(obj);    
                        }
                        else if (response.status.hasCode('inspq-http204')) {
                            $scope.profile = new EmptyImmunizationProfile();    
                        }
                        $scope.loaded = true;
                    } catch (error) {
                        $log.error(error);
                        $scope.status = dashapi.newSimpleStatus().addError(error);
                        $scope.profile = undefined;
                        $scope.loaded = false;
                    }
                } else {
                    $scope.profile = undefined;
                    $scope.loaded = false;
                }

                $scope.noAccess = response.status.hasCode('rtss-oauth-http401');
            });
        };

        $scope.loadProfile();

    }]);
	
})();