(function(){
    var appointment = angular.module("appointment");
    appointment.factory('ScheduleFactory', ['OfysFCUtils','LoadStatus','model','$q','QValidation',
        '$filter','ModificationStatus','AppointmentAccessor','$interval', 'Rights',
        '$timeout','QConfirm','utils', 'PrintAccessor', 'FlView', 'RecallAccessor',
        function(OfysFCUtils, LoadStatus, model, $q, QValidation,
            $filter, ModificationStatus, AppointmentAccessor, $interval, Rights,
            $timeout, QConfirm, utils, PrintAccessor, FlView, RecallAccessor) {

        var APPOINTMENTUID = {
            sequence: 0,
            next: function (){
                this.sequence++;
                return this.sequence
            }
        }

        function getDefaultAppointmentType(){
            var allTypes = model.clientPreferences().appointmentTypes;
            if(allTypes){
                for (let i = 0; i < allTypes.length; i++) {
                    if(allTypes[i].isDefault){
                        return allTypes[i];
                    }
                }
                return allTypes[0]
            }
        }

        function Schedule(prof, viewers){
            var shdl = this;

            shdl.mvcConfig = {};
            shdl.needsRefresh = false;
            //context types
            shdl.contextTypes = {
                SCHEDULE_DATE: 'scheduleDate',
                WEEKTEMPLATE: 'weekTemplate',
                DATETEMPLATE: 'dateTemplate',
            }
            var index = {
                period: {}, //{'14245':'2020-01-01'}
                appointment: {},//{'1524245':'2020-01-01'}
            };
            shdl.prof = prof;
            var datesCache = {};// cache for all dates data.
            shdl.dates = function(date, val){
                if(shdl.isMultiSchedule){
                    return shdl.multiViewCtrl.currentSchedule && shdl.multiViewCtrl.currentSchedule.dates(...arguments);
                }
                if(arguments.length > 1){
                    datesCache[date] = val;
                    datesCache[date].date = date;
                    datesCache[date].lastUsed = moment().valueOf();
                    var allDates = _.sortBy(_.values(datesCache), 'lastUsed').reverse();
                    if(allDates.length > 200){
                        clearDateCache(removeActiveRelevantDates(allDates.splice(62)));
                    }
                }else{
                    if(datesCache[date]){
                        datesCache[date].lastUsed = moment().valueOf();
                    }
                    return datesCache[date];
                }
            };

            shdl.getAppointmentById = function(id){
                if(id != null && index.appointment[id] != null){
                    return datesCache[index.appointment[id]].appointments[id];
                }
            }
            function removeActiveRelevantDates(list){
                var viewspan = getMonthViewspan(selectedDate).allDates.reduce(function(vs, acc){
                    vs[acc] = true;
                    return vs;
                }, {});
                list = list.filter(function(e){
                    return !viewspan[e.date];
                });
                return list;
            }
            function clearDateCache(list){
                console.log("Schedule cache exceded max. Clearing cache.");
                clearDateCacheDayView(list);
                clearBaseAppointmentDate(list);
                list.forEach(function(dC){
                    flushCacheDate(dC.date);
                });
            }

            shdl.dateTemplateToWeekTemplateActive = false;
            shdl.viewers;
            shdl.currentViews = angular.copy(factory.appointmentViews);
            shdl.views = {
                scheduleHeader: {
                    visible:false,
                    activeModificationTab: "",
                    templateUrl:"schedule_header_dir_index.html"
                },
                appointmentEdit:{
                    visible: false,
                },
                searchAppointment: {
                    visible: true,
					templateUrl:"appointment_search_criteria_dir_index.html"
                },
				recallSearch: {
					visible: true,
                    templateUrl:"recall_search_dir_index.html"
				},
				recallList: {
					visible: false,
                    templateUrl:"recall_list_dir_index.html"
				},
				recallEdit: {
					visible: false,
					templateUrl:"recall_edit_dir_index.html"
				},
                scheduleTemplatesLst:{
                    visible: true,
                    showDateTemplateList: false,
                    showWeekTemplateList: false,
                    templateUrl:"schedule_templates_lst_dir_index.html"
                },
                scheduleDate:{
                    visible: true,
                    templateUrl:"schedule_date_dir_index.html"
                },
                dateTemplateEdit:{
                    visible: false,
                    templateUrl:"date_template_dir_index.html"
                },
                weekTemplateEdit:{
                    visible: false,
                    templateUrl:"week_template_dir_index.html"
                },
                periodEdit:{
                    visible: false,
                    templateUrl:"period_edit_dir_index.html"
                }
            }
            function setScheduleViewsAfter(afterwhich, which){
                if(shdl.isScheduleEditMode() == 1 && shdl.currentViews){
                    var i = shdl.currentViews.indexOf(which);
                    var iafter = shdl.currentViews.indexOf(afterwhich);
                    if(i+1 !== iafter){
                        shdl.currentViews.splice(i, 1);
                        shdl.currentViews.splice(iafter+1,0, which);
                    }
                }
            }
            var selectedDate = model.schedule().currDate? model.schedule().currDate: model.appointment().currDate;
            var allViewedDates;
            var selectedAppointment;
            var selectedPeriod;
            var selectedWeekTemplate;
            var selectedDateTemplate; 
			// 0:appointment 1:schedule 2:label
            var isScheduleEditMode = 0;

            var selectedContext;
            function hideTemplateLists(){
                shdl.views.scheduleTemplatesLst.showDateTemplateList = false;
                shdl.views.scheduleTemplatesLst.showWeekTemplateList = false;
            }

            function findAndRemovePeriodFromDateTemplate(template, period){
                if(period == selectedPeriod){
                    shdl.clearSelectedPeriod();
                }
                removeEventsFromDv([period]);
                var i = template.lstPeriods.findIndex(function(e){
                    return (e.id && e.id == period.id) || (e.tag && e.tag == period.tag)
                });
                if(i > -1){
                    if(period.id){
                        period.modificationStatus = ModificationStatus.STATUS_DELETED;
                    }else{
                        template.lstPeriods.splice(i, 1);
                    }
                }
            }

            function removeEventsFromDv(events){
                events && dv().ctrler.removeEvents(events);
            }

            function removeEventsFromMv(events){
                if(hasMonthViewer() &&  Array.isArray(events)){
                    mv().ctrler.removeEvents(events);
                    mv().ctrler.removeEvents(events.map(function(e){return e.statistic}));
                } 
            }

            function okToCloseSelectedPeriod(){
                if(selectedPeriod && selectedPeriod.viewbag && selectedPeriod.viewbag.okToClose){
                    return selectedPeriod.viewbag.okToClose();
                }else{
                    return true;// selectedPeriod either not selected or not initiated.
                }
            }
            var defaultRestoreOptions = {pre:true, post: true};
            function ScheduleDateContext(){
                var ctx = this;
                var ctxType = shdl.contextTypes.SCHEDULE_DATE;
                ctx.type  = function(){
                    return ctxType;
                }
                ctx.beforeUpdate = function(){
                    shdl.clearSelectedPeriod();
                    clearViewPeriods(selectedDate);
                }
                ctx.updated  = function(){
                }

                ctx.periodById = function(id){
                    if(id !== undefined){
                        return $q(function(resolve, reject){
                            if(selectedPeriod && selectedPeriod.viewbag && 
                                selectedPeriod.viewbag.okToClose && 
                                !selectedPeriod.viewbag.okToClose()){
                                reject();
                                return;
                            }else if(shdl.dates(selectedDate) && 
                                shdl.dates(selectedDate).periods[id] !== undefined){
                                    if(selectedPeriod){
                                        clearViewerSelection(selectedPeriod);
                                    }
                                    selectedPeriod = shdl.dates(selectedDate).periods[id];
                                    shdl.views.periodEdit.visible = true;
                                    hideTemplateLists();
                                    setViewerSelection(selectedPeriod);
                                    model.apptUpdated(true);
                            }
                            resolve();
                        })
                    }else{
                        return selectedPeriod
                    }
                }

                ctx.deletePeriod = function(period){
                    var idOrTag = OfysFCUtils.getIdOrTag(period);
                    if(shdl.dates(selectedDate).periods[idOrTag]){
                        delete shdl.dates(selectedDate).periods[idOrTag];
                        findAndRemovePeriodFromDateTemplate(shdl.dates(selectedDate).appointmentDate.dateTemplate, period);
                        ctx.dirty(true);
                    };
                }

                ctx.setPristine = function (){
                    if(shdl.dates(selectedDate) && shdl.dates(selectedDate).appointmentDate &&
                        shdl.dates(selectedDate).appointmentDate.viewbag &&
                        shdl.dates(selectedDate).appointmentDate.viewbag.manager){
                        shdl.dates(selectedDate).appointmentDate.viewbag.manager.dirty(false);
                    }
                }

                function setContextDirty(){
                    if(shdl.dates(selectedDate) && shdl.dates(selectedDate).appointmentDate &&
                        shdl.dates(selectedDate).appointmentDate.viewbag &&
                        shdl.dates(selectedDate).appointmentDate.viewbag.manager){
                        shdl.dates(selectedDate).appointmentDate.viewbag.manager.dirty(true);
                    }
                }
                
                ctx.currentDateTemplate = function(){
                    return shdl.dates(selectedDate).appointmentDate.dateTemplate;
                }

                ctx.getPeriodConflicts = function(period, range){
                    return fixCreationPeriodConflict(period,shdl.dates(selectedDate).appointmentDate.dateTemplate, range )
                }

                ctx.updatePeriodDateTimeIfPossible = function(p){
                    // check for conflicts on new day if no conflicts modify
                    var currentPeriod = shdl.dates(selectedDate).periods[p.id];
                    if(currentPeriod){
                        var nextPeriod = $.extend(_.omit(currentPeriod, ['uiEvent', 'viewbag']), {startTime: p.startTime, endTime: p.endTime});
                        var nextDate = shdl.dates(p.date).appointmentDate.dateTemplate;
                        var conflict = shdl.getConflictingIndexes(nextPeriod, nextDate)
                        if(conflict.hasConflicts && conflictNotWithSelf(conflict, currentPeriod, nextDate.lstPeriods) ){
                            // currentPeriod
                            return false;
                        }
                        currentPeriod.startTime = p.startTime;
                        currentPeriod.endTime = p.endTime;
                        if(p.date !== selectedDate){
                            if(currentPeriod.id){// period saved in backend
                                currentPeriod.modificationStatus = ModificationStatus.STATUS_DELETED;
                                delete nextPeriod.id ;
                                nextPeriod.tag = APPOINTMENTUID.next();
                                nextPeriod.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
                            }else{
                                removePeriodFromDate(selectedDate, currentPeriod);
                            }
                            dateModified(selectedDate);
                            addPeriodToDate(p.date, nextPeriod);
                        }
                        dateModified(p.date);
                        initViewAppointmentDate(shdl.dates(selectedDate));
                        updateViewStartEndTimes(p.date);
                    }else{
                        return false;
                    }
                    return true;
                }

                function dateModified(date){
                    shdl.addSavable(shdl.dates(date).appointmentDate, 'dates', date);
                }

                function removePeriodFromDate(date, period){
                    var id = OfysFCUtils.getIdOrTag(period);
                    delete shdl.dates(date).periods[id];
                    OfysFCUtils.findIndexTagOrId(shdl.dates(date).appointmentDate.dateTemplate.lstPeriods, id, function(i){
                        shdl.dates(date).appointmentDate.dateTemplate.lstPeriods.splice(i, 1);
                    });
                }
                function addPeriodToDate(date, period){
                    var id = OfysFCUtils.getIdOrTag(period);
                    shdl.dates(date).periods[id] = period;
                    shdl.dates(date).appointmentDate.dateTemplate.lstPeriods.push(period);
                }

                ctx.defaultPeriodDuration = function(){
                    if(shdl.dates(selectedDate) != undefined){
                        var vd = shdl.dates(selectedDate).appointmentDate;
                        return vd && vd.dateTemplate && vd.dateTemplate.scale;
                    }
                }

                ctx.addPeriods = function(periods){
                    periods.forEach(function(e){addPeriodToDate(selectedDate, e)})
                    setContextDirty();
                    shdl.addPeriodsToViewer(selectedDate, periods);
                }

                ctx.dirty = function(isDirty){
                    if(shdl.dates(selectedDate).appointmentDate
                        && shdl.dates(selectedDate).appointmentDate.viewbag
                        && shdl.dates(selectedDate).appointmentDate.viewbag.manager
                        ){
                            shdl.dates(selectedDate).appointmentDate.viewbag.manager.dirty(isDirty)
                    }
                }

                ctx.okToClose = function(){
                    if(dateWithViewbag(selectedDate)
                        && shdl.dates(selectedDate).appointmentDate.dateTemplate.viewbag.okToClose
                        ){
                            return shdl.dates(selectedDate).appointmentDate.dateTemplate.viewbag.okToClose() && okToCloseSelectedPeriod();
                    }else{
                        return true;// date has not been initialised yet.
                    }
                }

                function dateWithViewbag(date){
                    return shdl.dates(date).appointmentDate
                    && shdl.dates(date).appointmentDate.dateTemplate
                    && shdl.dates(date).appointmentDate.dateTemplate.viewbag
                }

                ctx.currentDate = function(date){
                    if(date !== undefined){
                        return $q(function(resolve, reject){
                            if(shdl.isMultiSchedule){
                                selectedDate = date;
                                if(selectedDate){
									//ajouter ici, si aucun prof de sélectionner permet de mettre à jour le calendrier
                                	model.schedule().currDate = date; 
								}
                                return resolve();
                            }
                            if(selectedDate && !ctx.okToClose()){
                                reject();
                            }else{
                                if(selectedDate !== date){
                                    shdl.clearSelectedAppointment();
                                    shdl.clearSelectedPeriod();
                                }
                                selectedDate = date;
                                model.schedule().currDate = date;
                                shdl.showCurrentDate();
                                if(dateWithViewbag(selectedDate)){
                                    resolve();
                                }else{
                                    $timeout(resolve, 0)
                                }
                            }
                        });
                    }else{
                        return selectedDate;
                    }
                }

                ctx.initState = function(){
                    setScheduleViewsAfter('scheduleDate', 'periodEdit');
                    shdl.views.scheduleDate.visible = true;
                }
                ctx.clearState = function(){
                    shdl.clearSelectedPeriod();
                    shdl.clearView();
                    shdl.views.scheduleDate.visible = false;
                }

                ctx.restore = function(fn, opt){
                    opt = opt ? opt:defaultRestoreOptions;
                    if(opt.pre){
                        ctx.clearState();
                    }
                    fn && fn();
                    if(opt.post){
                        shdl.updateSlotDuration();
                        model.schedule().currDate = selectedDate;
                        shdl.daysViewed(daysViewed, true);
                        ctx.setPristine();
                        ctx.initState();
                        updateViewSpan(selectedDate);
                        shdl.showCurrentDate();// fixes bug when switching from one prof to another where if the date is changed then returning to a schedule does not show the date.
                    }
                }

                ctx.initState();
            }

            function WeekTemplateContext(){
                var ctx = this;
                var ctxType = shdl.contextTypes.WEEKTEMPLATE;
                var copiedDaysViewed;
                var wtSelectedDate;
                ctx.type  = function(){
                    return ctxType;
                }
                ctx.beforeUpdate = function(){
                    shdl.clearSelectedPeriod();
                    getViewspanTemplates().forEach(clearPeriodsFromViewer);
                }
                ctx.updated = function(){
                    if(selectedWeekTemplate){
                        var ts = getViewspanTemplates();
                        var alldate = getCalWeekDates()
                        ts.forEach(function(e, i){
                            updateDayTemplate(e, alldate[i])
                        })
                        shdl.renderDV();
                    }
                }

                function getCalWeekDates(){
                    var viewspan = getViewspan(wtSelectedDate);
                    return allViewspanDates(viewspan);
                }

                function getViewspanTemplates(){
                    if(daysViewed == 1){
                        return [getDayTemplate(getCurrentDay())]
                    }else{
                        return shdl.WEEKDAYS.map(getDayTemplate);
                    }
                }

                function updateDayTemplate(dayTemplate, date){
                    if(dayTemplate){
                        addPeriodsToViewer(dayTemplate, date);
                    }
                }
                
                ctx.periodById = function(id){
                    if(id !== undefined){
                        var dayTemplate = getCurrentDayTemplate();
                        if(dayTemplate){
                            var i = dayTemplate.lstPeriods.findIndex(function(e){return e.id == id || e.tag == id;});
                            if(i > -1 && (!selectedPeriod || (selectedPeriod.viewbag && selectedPeriod.viewbag.okToClose()))){
                                if(selectedPeriod){
                                    clearViewerSelection(selectedPeriod);
                                }
                                selectedPeriod = dayTemplate.lstPeriods[i];
                                shdl.views.periodEdit.visible = true;
                                hideTemplateLists();
                                setViewerSelection(selectedPeriod);
                                model.apptUpdated(true);
                            }
                        }
                    }else{
                        return selectedPeriod
                    }
                }

                ctx.deletePeriod = function(period){
                    findAndRemovePeriodFromDateTemplate(selectedWeekTemplate[getCurrentDay()], period);
                    ctx.dirty(true);
                }

                ctx.clearState = function(){
                    ctx.beforeUpdate();
                    shdl.clearSelectedWeekTemplate();
                    shdl.daysViewed(copiedDaysViewed);
                }

                ctx.setPristine = function (){
                    if(selectedWeekTemplate &&
                        selectedWeekTemplate.viewbag &&
                        selectedWeekTemplate.viewbag.manager){
                        selectedWeekTemplate.viewbag.manager.dirty(false);
                    }
                }

                function setContextDirty(){
                    if(selectedWeekTemplate &&
                        selectedWeekTemplate.viewbag &&
                        selectedWeekTemplate.viewbag.manager){
                        selectedWeekTemplate.viewbag.manager.dirty(true);
                    }
                }
                
                ctx.currentDateTemplate = function(){
                    return getCurrentDayTemplate();
                }

                ctx.getPeriodConflicts = function(period, range){
                    return fixCreationPeriodConflict(period,getCurrentDayTemplate(), range)
                }

                ctx.updatePeriodDateTimeIfPossible = function(p){
                    // check for conflicts on new day if no conflicts modify
                    var currentDay = getCurrentDayTemplate()
                    var res = false;
                    OfysFCUtils.findIndexTagOrId(currentDay.lstPeriods, p.id, function(i){
                        var currentPeriod = currentDay.lstPeriods[i];
                        var nextPeriod = $.extend(_.omit(currentPeriod, ['uiEvent', 'viewbag']), {startTime: p.startTime, endTime: p.endTime});
                        var nextDate = getOrCreateDayTemplate(dateToDay(p.date));
                        var conflict = shdl.getConflictingIndexes(nextPeriod, nextDate)
                        if(conflict.hasConflicts && conflictNotWithSelf(conflict, currentPeriod, nextDate.lstPeriods) ){
                            // currentPeriod
                            res = false;
                            return;
                        }
                        currentPeriod.startTime = p.startTime;
                        currentPeriod.endTime = p.endTime;
                        if(p.date !== wtSelectedDate){
                            removePeriodFromDate(wtSelectedDate, currentPeriod);
                            addPeriodToDate(p.date, currentPeriod);
                        }
                        wtStartEndCalendarTimes();
                        setContextDirty();
                        res = true;
                    });
                    return res;
                }

                function removePeriodFromDate(date, period){
                    var dT = getDayTemplate(dateToDay(date))
                    OfysFCUtils.findIndexTagOrId(dT.lstPeriods, OfysFCUtils.getIdOrTag(period), function(i){
                        dT.lstPeriods.splice(i, 1);
                    });
                }

                function addPeriodToDate(date, period){
                    var dT = getDayTemplate(dateToDay(date))
                    dT.lstPeriods.push(period);
                }

                ctx.defaultPeriodDuration = function(){
                    var dt = getOrCreateDayTemplate(getCurrentDay());
                    return dt && dt.scale;
                }
                ctx.addPeriods = function(periods){
                    var dayTemplate = getOrCreateDayTemplate(getCurrentDay());
                    periods.forEach(function(e){
                        dayTemplate.lstPeriods.push(e);
                    });
                    setContextDirty();
                    shdl.addPeriodsToViewer(wtSelectedDate, periods);
                }

                ctx.copyTemplate = function(template){
                    ctx.beforeUpdate();
                    var t = _.omit(angular.copy(template), ['id', 'tag']);
                    t.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
                    selectedWeekTemplate[getCurrentDay()] = t;
                    ctx.dirty(true);
                    ctx.updated();
                }

                ctx.dirty = function(isDirty){
                    if(selectedWeekTemplate
                        && selectedWeekTemplate.viewbag
                        && selectedWeekTemplate.viewbag.manager
                        ){
                            selectedWeekTemplate.viewbag.manager.dirty(isDirty);
                    }
                }

                ctx.setHeaderName = function(obj){
                    if(daysViewed == 1){
                        return $filter('translate')("sd_"+getCurrentDay());
                    }else{
                        return $filter('translate')("sd_"+dateToDay(obj.date))
                    }
                }
                function getCurrentDayTemplate(){
                    return getDayTemplate(getCurrentDay());
                }
                function getOrCreateDayTemplate(day){
                    var dayTemplate = getDayTemplate(day);
                    if(!dayTemplate){
                        dayTemplate = selectedWeekTemplate[day] = shdl.createNewDateTemplate();
                    }
                    return dayTemplate;
                }
                function getDayTemplate(day){
                    return selectedWeekTemplate[day]
                }
                function dateToDay(date){
                    return shdl.WEEKDAYS[moment(date).day()];
                }
                function hasCurrentDay(){
                    return selectedWeekTemplate && selectedWeekTemplate.viewbag && selectedWeekTemplate.viewbag.selectedday;
                }
                function getCurrentDay(){
                    if(hasCurrentDay()){
                        return selectedWeekTemplate.viewbag.selectedday;
                    }else{
                        return "monday";
                    }
                }
                function clearPeriodsFromViewer(dayTemplate){
                    dayTemplate && dayTemplate.lstPeriods && dv().ctrler.removeEvents(dayTemplate.lstPeriods);
                }
                function addPeriodsToViewer(dayTemplate, date){
                    dayTemplate && dayTemplate.lstPeriods && shdl.addPeriodsToViewer(date, dayTemplate.lstPeriods);
                    wtStartEndCalendarTimes();
                }

                ctx.okToClose = function(){
                    if(selectedWeekTemplate &&
                        selectedWeekTemplate.viewbag && 
                        selectedWeekTemplate.viewbag.okToClose){
                        return selectedWeekTemplate.viewbag.okToClose();
                    }else{
                        return true;
                    }
                }
                ctx.currentDate = function(date){
                    if(date !== undefined){
                        return $q(function(resolve, reject){
                            if(selectedWeekTemplate && selectedWeekTemplate.viewbag 
                                && selectedWeekTemplate.viewbag.selectedday && (!ctx.okToClose() || !okToCloseSelectedPeriod())){
                                reject();
                            }else{
                                wtSelectedDate = date;
                                hasDayViewer() && dv().ctrler.cal.gotoDate(wtSelectedDate);
                                selectedWeekTemplate.viewbag.selectedday = shdl.WEEKDAYS[moment(date).day()]
                                resolve();
                            }
                        })
                    }else{
                        return wtSelectedDate;
                    }
                }

                ctx.initState = function(){
                    copiedDaysViewed = daysViewed;
                    wtSelectedDate = selectedDate;
                    shdl.daysViewed(7, true);
                    setScheduleViewsAfter('dateTemplateEdit', 'periodEdit');
                    ctx.updated();
                }

                ctx.restore = function(fn, opt){
                    opt = opt ? opt:defaultRestoreOptions;
                    if(opt.pre){
                        ctx.beforeUpdate();
                    }
                    fn && fn();
                    if(opt.post){
                        shdl.updateSlotDuration();
                        ctx.setPristine();
                        ctx.initState();
                        wtStartEndCalendarTimes();
                    }
                }

                function wtStartEndCalendarTimes(){
                    var start;
                    var end;
                    var range;
                    wtForAllViewedDates(function(d){
                        range = getPeriodsMaxMinHour(d.lstPeriods, {start : (d.startHour*60), end:(d.endHour*60)});
                        if(start == undefined || range.start < start){
                            start = range.start;
                        }
                        if(end == undefined || range.end > end){
                            end = range.end;
                        }
                    });
                    start = hourToTime(Math.floor(start/60));
                    end = hourToTime(Math.ceil(end/60));
                    calendarMinMaxUpdate(hourToTime(start), hourToTime(end));
                }
                function wtForAllViewedDates(fn){
                    if(fn){
                        var ts = getViewspanTemplates();
                        ts.forEach(function(e, i){
                            if(e){
                                fn(e)
                            }
                        })
                    }
                }

                ctx.initState();
            }

            function DateTemplateContext(){
                var ctx = this;
                var copiedDaysViewed;
                var ctxType = shdl.contextTypes.DATETEMPLATE;
                ctx.type  = function(){
                    return ctxType;
                }
                ctx.beforeUpdate = function(){
                    shdl.clearSelectedPeriod();
                    clearPeriodsFromViewer();
                }
                ctx.updated = function(){
                    addPeriodsToViewer();
                    if(selectedDateTemplate){
                        shdl.updateDateTemplateStartEnd(selectedDateTemplate);
                    }
                }

                ctx.currentDateTemplate = function(){
                    return selectedDateTemplate;
                }

                ctx.periodById = function(id){
                    if(id !== undefined){
                        if(selectedDateTemplate){
                            var i = selectedDateTemplate.lstPeriods.findIndex(function(e){return e.id == id || e.tag == id;});
                            if(i > -1 && (!selectedPeriod || (selectedPeriod.viewbag && selectedPeriod.viewbag.okToClose()))){
                                if(selectedPeriod){
                                    clearViewerSelection(selectedPeriod);
                                }
                                selectedPeriod = selectedDateTemplate.lstPeriods[i];
                                shdl.views.periodEdit.visible = true;
                                hideTemplateLists();
                                setViewerSelection(selectedPeriod);
                                model.apptUpdated(true);
                            }
                        }
                    }else{
                        return selectedPeriod
                    }
                }

                ctx.updatePeriodDateTimeIfPossible = function(p){
                    // check for conflicts on new day if no conflicts modify
                    var res = false;
                    OfysFCUtils.findIndexTagOrId(selectedDateTemplate.lstPeriods, p.id, function(i){
                        var currentPeriod = selectedDateTemplate.lstPeriods[i];
                        var nextPeriod = $.extend(_.omit(currentPeriod, ['uiEvent', 'viewbag']), {startTime: p.startTime, endTime: p.endTime});
                        var conflict = shdl.getConflictingIndexes(nextPeriod, selectedDateTemplate)
                        if(conflict.hasConflicts && conflictNotWithSelf(conflict, currentPeriod, selectedDateTemplate.lstPeriods) ){
                            // currentPeriod
                            res = false;
                            return;
                        }
                        currentPeriod.startTime = p.startTime;
                        currentPeriod.endTime = p.endTime;
                        setContextDirty();
                        shdl.updateDateTemplateStartEnd(selectedDateTemplate);
                        res = true;
                    });
                    return res;
                }

                ctx.deletePeriod = function(period){
                    findAndRemovePeriodFromDateTemplate(selectedDateTemplate, period);
                    ctx.dirty(true);
                }

                ctx.setHeaderName = function(obj){
                    if(selectedDateTemplate && selectedDateTemplate.note){
                        return selectedDateTemplate.note;
                    }else{
                        return "";
                    }
                }
                
                ctx.getPeriodConflicts = function(period, range){
                    return fixCreationPeriodConflict(period,selectedDateTemplate, range);
                }

                function setContextDirty(){
                    if(selectedDateTemplate &&
                        selectedDateTemplate.viewbag &&
                        selectedDateTemplate.viewbag.manager){
                            selectedDateTemplate.viewbag.manager.dirty(true);
                    }
                }

                ctx.okToClose = function(){
                    if(selectedDateTemplate
                        && selectedDateTemplate.viewbag
                        && selectedDateTemplate.viewbag.okToClose
                        ){
                            return selectedDateTemplate.viewbag.okToClose() && okToCloseSelectedPeriod();
                    }else{
                        return true;// date has not been initialised yet.
                    }
                }

                ctx.defaultPeriodDuration = function(){
                    return selectedDateTemplate && selectedDateTemplate.scale;
                }
                ctx.addPeriods = function(periods){
                    periods.forEach(function(e){
                        selectedDateTemplate.lstPeriods.push(e);
                    })
                    setContextDirty();
                    shdl.addPeriodsToViewer(selectedDate, periods);
                }

                ctx.setPristine = function(){
                    if(selectedDateTemplate
                        && selectedDateTemplate.viewbag
                        && selectedDateTemplate.viewbag.manager
                        ){
                            selectedDateTemplate.viewbag.manager.dirty(false);
                    }
                }
                ctx.dirty = function(isDirty){
                    if(selectedDateTemplate
                        && selectedDateTemplate.viewbag
                        && selectedDateTemplate.viewbag.manager
                        ){
                            selectedDateTemplate.viewbag.manager.dirty(isDirty);
                    }
                }
                function clearPeriodsFromViewer(){
                    selectedDateTemplate && selectedDateTemplate.lstPeriods && dv().ctrler.removeEvents(selectedDateTemplate.lstPeriods);
                }
                function addPeriodsToViewer(){
                    if(selectedDateTemplate && selectedDateTemplate.lstPeriods){
                        shdl.addPeriodsToViewer(selectedDate, selectedDateTemplate.lstPeriods)
                        shdl.updateDateTemplateStartEnd(selectedDateTemplate)
                    }
                }
                ctx.currentDate = function(date){
                    if(date !== undefined){
                        return $q.resolve();
                    }else{
                        return selectedDate;
                    }
                }
                ctx.initState = function(){
                    copiedDaysViewed = daysViewed;
                    shdl.daysViewed(1);
                    setScheduleViewsAfter('dateTemplateEdit', 'periodEdit');
                    ctx.updated();
                }

                ctx.clearState = function(){
                    ctx.beforeUpdate();
                    shdl.clearSelectedDateTemplate();
                    shdl.daysViewed(copiedDaysViewed);
                }

                ctx.restore = function(fn, opt){
                    opt = opt ? opt:defaultRestoreOptions;
                    if(opt.pre){
                        ctx.beforeUpdate();
                        if(selectedDateTemplate && selectedDateTemplate.lstPeriods){
                            dv().ctrler.removeEvents(selectedDateTemplate.lstPeriods);
                        }
                    }
                    fn && fn();
                    if(opt.post){
                        ctx.setPristine();
                        ctx.initState();
                    }
                }

                ctx.initState();
            }

            function getDates(date, viewspan){
                if(viewspan && viewspan.allDates){
                    return viewspan.allDates;
                }else{
                    return [date];
                }
            }
    
            function loadDayAppointments(date){
                if (shdl.prof && shdl.prof.id) {
                    shdl.dates(date).loading.appointments = LoadStatus.LOADING;
                    return AppointmentAccessor.list({
                        day: date,
                        idProf: shdl.prof.id
                    }, function(response) {
                        shdl.dates(date).loading.appointments = LoadStatus.LOADED;
                        shdl.addAppointments(response.data, date);
                    });
                } else {
                    shdl.addAppointments([], date);
                }
            }
            function periodAndDateUpdate(res){
                for (var i = 0; i < res.appointmentDates.length; i++) {
                    var ad = res.appointmentDates[i];
                    if(!loadedModifiedAD(sanitizeOfysDate(ad.date), ad)){
                        shdl.setAppointmentDate(ad);
                        shdl.addPeriods(ad, res.appointmentDates[i].date);
                    }
                }
                for (var i = 0; i < res.reservedAppointments.length; i++) {
                    shdl.updateReservationFromWS(res.reservedAppointments[i])
                }
                
            }
            function updateScheduleTemplates(res){
                model.schedule().appointmentDateTemplates = res.appointmentDateTemplates;
                model.schedule().appointmentWeekTemplates = res.appointmentWeekTemplates;
    
            }
            function updateDateAndPeriods(date, viewspan){
                getDates(date, viewspan).forEach(function(e){shdl.dates(e).loading.periods = LoadStatus.LOADING;})
                viewspan = viewspan ? viewspan: { day:date, idProf:shdl.prof.id };
                return AppointmentAccessor.getDate(viewspan, function(res){
                    getDates(date, viewspan).forEach(function(e){shdl.dates(e).loading.periods = LoadStatus.LOADED;})
                    periodAndDateUpdate(res);
                });
            }
    
            function updateCompleteDateAndPeriods(date, viewspan){
                model.schedule().status = LoadStatus.LOADING;
                getDates(date, viewspan).forEach(function(e){shdl.dates(e).loading.periods = LoadStatus.LOADING;})
                viewspan = viewspan ? viewspan: { day:date, idProf:shdl.prof.id };
                return AppointmentAccessor.getCompleteDate(viewspan, function(res){
                    model.schedule().status = LoadStatus.LOADED;
                    getDates(date, viewspan).forEach(function(e){shdl.dates(e).loading.periods = LoadStatus.LOADED;})
                    periodAndDateUpdate(res);
                    updateScheduleTemplates(res);
                });
            }

            function getMonthViewspan(date){
                // full calendar shows 6 weeks so the viewspan is the first sunday of the month + 6 weeks.
                var start = moment(date).startOf('month').startOf("week");
                var res = {
                    start: start.format(OfysUtils.DATEFORMAT), 
                    end: start.add(6, "weeks").subtract(1, "day").format(OfysUtils.DATEFORMAT)
                };
                allViewspanDates(res).forEach(initDate);
                return res;
            }

            function getBaseAppointmentDates(date){
                var viewspan = getMonthViewspan(date);
                return viewspan.allDates.filter(function(d){
                    return shdl.dates(d).baseAppointmentDate && shdl.dates(d).baseAppointmentDate.statistic;
                }).map(function(d){
                    return shdl.dates(d).baseAppointmentDate;
                });
            }

            function getMonthUpdateViewspan(date){
                var res = getMonthViewspan(date);
                // remove dates that might have already been loaded from a previous call.
                res.allDates = res.allDates.filter(function(d){
                    return LoadStatus.mustLoad(shdl.dates(d).loading.baseAppointmentDate);
                });
                if(res.allDates.length > 0){
                    res.start = res.allDates[0];
                    res.end = res.allDates[res.allDates.length -1];
                }
                return res;
            }

            function updateBaseAppointmentDateAppointmentList(date){
                if(shdl.dates(date).loading.baseAppointmentDate === LoadStatus.LOADED){
                    var baseAppDate = shdl.dates(date).baseAppointmentDate;
                    if(baseAppDate){
                        baseAppDate.statistic.appointments =  _.values(shdl.dates(date).appointments).filter(function(a){return !a.isDeleted && !a.cancelledBy}).map(appointmentToBaseAD);
                        shdl.addBaseAppointmentDatesToViewer([shdl.dates(date).baseAppointmentDate]);
                    }
                }
            }

            function pullBaseAppointmentDate(date){
                updateMonthStats(date, {start: date, end:date, allDates: [date]});
            }

            
            shdl.updateDateKey =function (dk){
                if(shdl.dates(dk.date)){
                    if(LoadStatus.mustLoad(shdl.dates(dk.date).loading.appointments)){
                        pullBaseAppointmentDate(dk.date);
                    }
                }
            }

            shdl.updateBaseAppointmentDate = function(e, fromAppointmentDate){
                var d = e.date;
                //date already exists(has already been loaded) - add else skip till loaded
                if(shdl.dates(d)){
                    if(fromAppointmentDate){// there is no notification for baseappointmentdates. Use appointmentDate notification
                        e = appointmentDateToBase(e);
                    }
                    if(shdl.dates(d).baseAppointmentDate){
                        removeEventsFromMv([shdl.dates(d).baseAppointmentDate]);
                    }
                    // remove if it's current.
                    indexBaseAppointmentDate(e);
                    shdl.addBaseAppointmentDatesToViewer([e]);
                }
            }

            function indexBaseAppointmentDate(e){
                shdl.dates(e.date).baseAppointmentDate = e;
            }

            function updateMonthStats(date, viewspan){
                var viewspan = viewspan? viewspan: getMonthUpdateViewspan(date);
                viewspan.allDates.forEach(function(e){shdl.dates(e).loading.baseAppointmentDate = LoadStatus.LOADING;})
                return AppointmentAccessor.getBaseDates({
                    start:viewspan.start,
                    end:viewspan.end,
                    idProf:shdl.prof.id
                }, function(res){
                    viewspan.allDates.forEach(function(e){shdl.dates(e).loading.baseAppointmentDate = LoadStatus.LOADED;})
                    if (res.baseAppointmentDates.length > 0) {
                        if(shdl.prof.id === res.baseAppointmentDates[0].professional){
                            var baseAppointmentDates = res.baseAppointmentDates.filter(function(e){
                                e.date = OfysUtils.daysFrom1970ToStr(e.date);
                                if(OfysFCUtils.hasUiEvent(shdl.dates(e.date).baseAppointmentDate)){
                                    removeEventsFromMv([shdl.dates(e.date).baseAppointmentDate])
                                }
                                indexBaseAppointmentDate(e);
                                return OfysFCUtils.hasStatsBaseAppointmentDate(e);
                            });
                            shdl.addBaseAppointmentDatesToViewer(baseAppointmentDates);
                        }
                    }
                });
            }

            shdl.initViewbag = function(item){
                item.viewbag = {orig: angular.copy(item)};
            }
            shdl.isScheduleEditMode = function(isSchedule){
                if(isSchedule !== undefined){
                    isScheduleEditMode = isSchedule;
                    if(isSchedule == 1){
                        switchToSchedule();
                    }else if(isSchedule == 0){
                        switchToAppointments();
                    }else if(isSchedule == 2){
						switchToRecalls();
					}
                }else{
                    return isScheduleEditMode;
                }
            }

			shdl.switchRecallEditMode = function(editMode){
				if(editMode !== undefined){
					model.recall().isEditView = editMode;
				}
				if(model.recall().isEditView){
					shdl.views.recallList.visible = true;
					shdl.views.recallEdit.visible = false;
				} else {
					shdl.views.recallList.visible = false;
					shdl.views.recallEdit.visible = true;
				}
				model.recall().isEditView = !model.recall().isEditView;
				model.apptUpdated(true);
			}

            shdl.monthChanged = function(){
                hasMonthViewer() && monthViewUpdater(mv().ctrler.getDate())
            }

            function periodToBaseAD(p){
                return {
                    id:p.id,
                    startTime:p.startTime,
                    endTime: p.endTime,
                    defaultAppointmentLength: p.defaultLength,
                    idType: p.appointmentPeriodType,
                    isClosed: p.isClosed,
                }
            }
            function appointmentToBaseAD(p){
                return {
                    id:p.id,
                    startTime:p.startTime,
                    endTime: p.endTime,
                    status: p.status,
                    patientStatus: p.patientStatus,
                }
            }
            function appointmentDateToBase(ad){
                // date: 19045
                // dateTemplate:{
                //     endHour: 18
                //     id: 983957
                //     isDeleted: false
                //     isReusable: false
                //     lstPeriods: Array(4)
                //     0:
                //     appointmentPeriodType: 101395
                //     defaultLength: 15
                //     endTime: 720
                //     id: 6376156
                //     idSite: 153
                //     isClosed: false
                //     isSofyEnabled: false
                //     isSofyTreatingRestricted: false
                //     modificationStatus: "STATUS_NEUTRAL"
                //     nomPeriod: "test"
                //     rvsqUidService: []
                //     startTime: 480
                //     version: 29635866
                //     versionDateTime: 1645209171864
                //     [[Prototype]]: Object
                //     length: 4
                //     [[Prototype]]: Array(0)
                //     modificationStatus: "STATUS_NEUTRAL"
                //     note: "2022-02-15"
                //     professionnal: 152319
                //     scale: 15
                //     startHour: 8
                //     version: 29635866
                //     versionDateTime: 1645209171864
                // }
                // id: 1058766
                // isDeleted: false
                // modificationStatus: "STATUS_NEUTRAL"
                // professionnal: 152319
                // version: 29635865
                // versionDateTime: 1645208702807


                var previousStats;
                if(shdl.dates(ad.date).baseAppointmentDate && 
                    shdl.dates(ad.date).baseAppointmentDate.statistic){
                    previousStats = _.pick(shdl.dates(ad.date).baseAppointmentDate.statistic, ['appointments'])
                    // if(shdl.dates(ad.dates].appointments){
                    //     previousStats.appointments = _.values(shdl.dates(ad.dates].appointments).map(appointmentToBase)
                    // }
                }else{
                    previousStats = {appointments:[]};
                }
                var previous = _.pick(shdl.dates(ad.date).baseAppointmentDate, ['message', 'messageAll', 'messageTypes', 'messageTypesAll', 'deGardeTypes'])

                return $.extend(previous, {
                    date: ad.date,
//                    deGardeTypes: [],
                    id: ad.id,
                    professional: ad.professionnal,
                    statistic:$.extend(previousStats,{
                        date: ad.date,
                        idDate: ad.dateTemplate.id,
                        idProf: ad.dateTemplate.professionnal,
                        periods: ad.dateTemplate.lstPeriods.map(periodToBaseAD)
                    })
                })
            }

            function switchToSchedule(){
                shdl.currentViews = angular.copy(factory.scheduleViews);
                shdl.updateScheduleSlotDuration();
                shdl.clearSelectedAppointment();
                shdl.clearView();
                shdl.addCurrentDayPeriodsToViewer();
            }

            function switchToAppointments(){
                // utils.showPopoverOverlay(false);
                shdl.currentViews = angular.copy(factory.appointmentViews);
                shdl.updateAppointmentSlotDuration();
                selectedContext.restore(null, {pre: true, post: false});;
                shdl.showCurrentDate();
                shdl.initDay();
            }

			function switchToRecalls(){
                shdl.currentViews = angular.copy(factory.recallsViews);
				shdl.updateAppointmentSlotDuration()
				shdl.clearSelectedAppointment();
                shdl.clearView();
				shdl.showCurrentDate();
            }

            shdl.update = function(date, viewspan){
                if(shdl.isMultiSchedule){
                    var allUpdators = [];
                    shdl.multiSchedules.forEach(s=>allUpdators.push(s.update(...arguments)));
                    return $q.all(allUpdators);
                }
                //Only make calls if the date is valid
                if(!moment(date, OfysUtils.DATEFORMAT, true).isValid())return;
                var updaters = [];
                if(LoadStatus.mustLoad(model.schedule().status)){
                    updaters.push(updateCompleteDateAndPeriods(date, viewspan));
                    updaters.push(updateMonthStats(date));
                } else{
                    if(mustLoad(date, viewspan, 'periods')){
                        updaters.push(updateDateAndPeriods(date, viewspan));
                    }
                    var monthUpdater = monthViewUpdater(date)
                    if(monthUpdater){
                        updaters.push(monthUpdater);
                    }
                }

    
                getDates(date, viewspan).forEach(function(e){
                    LoadStatus.mustLoad(shdl.dates(e).loading.appointments) &&
                    updaters.push(loadDayAppointments(e, viewspan));
                });
                
    
                return $q.all(updaters).then(function (res) {
                    if(shdl.currentContext().type() === shdl.contextTypes.SCHEDULE_DATE){
                        getDates(date, viewspan).forEach(shdl.dateDataLoaded);
                    }
                    // shdl.dateDataLoaded(date);
                });
            };

            function monthViewUpdater(date){
                var monthViewSpan = getMonthUpdateViewspan(date)
                if(mustLoad(date, monthViewSpan, 'baseAppointmentDate')){
                    return updateMonthStats(date, monthViewSpan);
                }
            }

            function mustLoad(date, viewspan, type){
                var d = getDates(date, viewspan);
                for (let i = 0; i < d.length; i++) {
                    if( LoadStatus.mustLoad(shdl.dates(d[i]).loading[type])){
                        return true;
                    };
                }
                return false;
            }


            function getContextByType(type){
                if(type === shdl.contextTypes.SCHEDULE_DATE){
                    return new ScheduleDateContext()
                }
                if(type === shdl.contextTypes.DATETEMPLATE){
                    return new DateTemplateContext();
                }
                if(type === shdl.contextTypes.WEEKTEMPLATE){
                    return new WeekTemplateContext()
                }
            }
            var defaultPresave = {
                askQuestion: false,
                dirty: false, 
                dates:{}, 
                dateTemplates:{}, 
                weekTemplates:{}
            }

            var presave = angular.copy(defaultPresave);

            function hasDayViewer(){
                return shdl.viewers && shdl.viewers.day;
            }

            function dv(){
                return shdl.viewers.day;
            }

            function mv(){
                return shdl.viewers.month;
            }

            function hasMonthViewer(){
                return shdl.viewers && shdl.viewers.month
            }

            function getNewDate (){
                return {
                    loading: {// once the day is loaded notifications should take over UPDATING
                        periods: LoadStatus.UNLOADED,
                        appointments: LoadStatus.UNLOADED,
                        baseAppointmentDate:LoadStatus.UNLOADED
                    },
                    periods: {},// all days periods
                    appointments: {},//all days appointments
                    appointmentDate: {},// server response appointment date
                };
            };

            function getAppointmentAsList(appointment){
                var res;
                if(!Array.isArray(appointment)){
                    res = [appointment];
                }else{
                    res = appointment;
                }
                return res;
            }

            var cleaner = {
                dates: function(el){
                    cleaner.dateTemplates(el.dateTemplate);
                },
                dateTemplates: function(el){
                    delete el.viewbag;// removed for contexts that include the date template.
                    el.lstPeriods && el.lstPeriods.forEach(function(e){
                        delete e.uiEvent;
                    });
                },
                weekTemplates: function(el){
                    shdl.WEEKDAYS.forEach(function(d){
                        if(el[d]){
                            cleaner.dateTemplates(el[d]);
                        }
                    })
                },
            }
            function cleanScheduleForSave(res){
                return function(value, key){
                    var list = _.values(value);
                    if(list && list.length > 0){
                        res[key] = [];
                        for (let i = 0; i < list.length; i++) {
                            const savableCopy = angular.copy(_.omit(list[i], ['viewbag']));
                            cleaner[key](savableCopy);
                            res[key].push(savableCopy)
                        }
                    }
                }
            }

            function deleteIfNew(item, type){
                if(!item.id){
                    if(type  == 'weekTemplates'){
                        shdl.deleteWeekTemplate(item);
                    }else if(type  == 'dateTemplates'){
                        shdl.deleteDateTemplate(item);
                    }
                }
            }
            function restoreBeforeEdit(value, key){
                
                _.values(value).forEach(function(val){
                    if(val && val.viewbag && val.viewbag.orig){
                        var orig = val.viewbag.orig;
                        var updater = val.viewbag.update;
                        val.viewbag.manager && val.viewbag.manager.dirty 
                            && val.viewbag.manager.dirty(false);
                        delete val.viewbag;
                        deleteIfNew(val, key);
                        OfysUtils.update(val, orig);
                        isSelectedItem(key, val) && updater && updater();
                        if(key == 'dates'){
                            initViewDatePeriods(val, val.date);
                        }
                    }
                })
            }

            function isSelectedItem(k, v){
                var sCT = selectedContext.type();
                return (k == "dates" && sCT == shdl.contextTypes.SCHEDULE_DATE && v.date == selectedDate) || 
                (k == 'dateTemplates' && sCT == shdl.contextTypes.DATETEMPLATE && v == selectedDateTemplate)||
                (k == 'weekTemplates' && sCT == shdl.contextTypes.WEEKTEMPLATE && v == selectedWeekTemplate);
            }
            function processSavables(process){
                ['dates','dateTemplates','weekTemplates'].forEach(function(k){
                    if(presave[k]){
                        process(presave[k], k);
                    }
                });
            }
            function preparesave (saveObj){
                var res =_.pick(saveObj, ['askQuestion']);
                processSavables(cleanScheduleForSave(res));
                // ['dates','dateTemplates','weekTemplates'].forEach(function(k){
                //     if(res[k]){
                //         res[k] = cleanForSave(_.values(res[k]), k);
                //     }
                // });
                // console.log(res);
                return res;
            }

            function restorePresave (){
                processSavables(restoreBeforeEdit);
            }
            
            var daysViewed = 1;// 1 or 7
            shdl.daysViewed = function(no, skipUpdate){
                if(no != undefined){
                    daysViewed = no
                    hasDayViewer() && dv().ctrler.cal.changeView(daysViewed == 1?'timeGridDay':'timeGridWeek' );
                    !skipUpdate && updateViewSpan(selectedDate);
                }else{
                    return daysViewed;
                }
            }

            shdl.toggleViewspan = function(){
                shdl.daysViewed(daysViewed == 1? 7: 1, selectedContext.type() !== shdl.contextTypes.SCHEDULE_DATE);
            }

            shdl.cancelModifications = function(){
                selectedContext.restore(function(){
                    restorePresave();
                    presave = angular.copy(defaultPresave);
                    checkPresaveDirty();
                    shdl.views.scheduleHeader.visible = false;
                });
                return $q.resolve();
            }

            shdl.saveSchedule = function(){
                // preparesave(presave);return;
                // delete app.uiEvent;
                // var saveDate = scope.schedule.dates[model.schedule().currDate].appointmentDate;
                // saveDate.modificationStatus = ModificationStatus.STATUS_UPDATED;
                // saveDate.dateTemplate.modificationStatus = ModificationStatus.STATUS_UPDATED;
                if(selectedContext.okToClose() && okToCloseSelectedPeriod()){
                    shdl.saving= true;
                    return AppointmentAccessor.saveschedule(preparesave(presave), function(res){
                        // console.log("Schedule save success :: object");
                        // console.log(res);
                        model.notice().success($filter("translate")("SaveSuccess"));
                        presave = angular.copy(defaultPresave);
                        selectedContext.setPristine();
                        checkPresaveDirty();
                        shdl.views.scheduleHeader.visible = false;
                        if(selectedContext.type() !== shdl.contextTypes.SCHEDULE_DATE){
                            shdl.showCurrentDate();
                        }else{
                            shdl.clearSelectedPeriod();
                        }
                        shdl.saving= false;
                    }, function(){
                        shdl.saving= false;
                    });
                }
                return $q.reject();
            }

            shdl.getScheduleSaveContainer = function(){
                return presave;
            }
            shdl.WEEKDAYS = ["sunday","monday","tuesday","wednesday","thursday","friday","saturday"];

            shdl.setWeekTemplateToDate = function(template, dateLst, options){
                shdl.setBatchDateTemplateToDate(function(i){return template[shdl.WEEKDAYS[dateLst[i].dayIndex]]}, dateLst,options)
			}

            shdl.setBatchDateTemplateToDate = function(getTemplate, dateLst, options){
                var i = 0; 
                function setToDate(){
                    var dayTemplate = getTemplate(i);
                    if(!dayTemplate){
                        dayTemplate = getNewDateTemplate();
                    }
                    var date ;
                    if(dateLst[i] != undefined){
                        date = dateLst[i].date;
                    }
                    if(dayTemplate && date){
                        shdl.setDateTemplateToDate(dayTemplate, date, options).then(nextDate)
                    }else{
                        nextDate()
                    }
                }
                function nextDate(){
                    i = i+1;
                    if(i < dateLst.length){
                        if(i % 7 == 0){
                            $timeout(setToDate, 200);
                        }else{
                            setToDate();
                        }
                    }else{
						shdl.isWeekRecuringLoading = false;
					}
                }
                setToDate();
            }
            shdl.CR = {
                CR_OVERRIDE: '1',
                CR_MERGE: '2',
                CR_MERGE_MODEL_FIRST: '21',
                CR_MERGE_DAY_FIRST: '22',
                CR_MERGE : '2',
                CR_SKIP : '3',
                CR_ASK : '4',
            }

            shdl.setDateTemplateToDate = function(template, date, options){
                options.conflictresolution == shdl.CR.CR_ASK;
                // var appointmentDate = {
                //     date: OfysUtils.daysFrom1970(date),
                //     dateTemplate: cloneDateNewTemplateInstance(template),
                //     modificationStatus: ModificationStatus.STATUS_NEW,
                //     professionnal: prof.id,
                // }
                return $q(function(resolve, reject){
                    getOrCreateAppointmentDate(date).then(function(viewappointmentDate){
                        if(hasConflicts(viewappointmentDate, template)){
                            solveConflicts(date, viewappointmentDate, template, options).then(resolve, reject);
                        }else{
                            initDateWithDateTemplate(date, viewappointmentDate,template)
                            resolve();
                        }
                    }, resolve);//in case of error fetching skip date.
                });
            }
            
            function initDateWithDateTemplate(date, viewappointmentDate,template){
                var tClone = angular.copy(_.omit(template, ['viewbag']));
                cleaner.dateTemplates(tClone);
                updateDateTemplate(viewappointmentDate, tClone);
                var isDateContext = selectedContext.type() === shdl.contextTypes.SCHEDULE_DATE;
                shdl.addPeriods(viewappointmentDate.appointmentDate, viewappointmentDate.appointmentDate.date);
                if( isDateContext && date === selectedDate){
                    shdl.dateDataLoaded(date);
                }
                shdl.addSavable(viewappointmentDate.appointmentDate, 'dates', date);
            }

            function getMergedTemplate(viewDate, template, privilege){
                var resTemplate = angular.copy(template);
                if(resTemplate && resTemplate.lstPeriods){
                    var addedPeriods = [];
                    var conflictings = {hasConflicts: false};
                    viewDate.appointmentDate.dateTemplate.lstPeriods.forEach(function(e){
                        var conflitsWithIndexs = shdl.getConflictingIndexes(e, resTemplate);
                        if(conflitsWithIndexs.hasConflicts){
                            if(privilege == shdl.CR.CR_MERGE_DAY_FIRST){
                                $.extend(conflictings, conflitsWithIndexs);
                                addedPeriods.push(e);
                            }
                        }else{
                            addedPeriods.push(e);
                        }
                    });
                    if(conflictings.hasConflicts){
                        resTemplate.lstPeriods = resTemplate.lstPeriods.filter(function(e, i){
                            return !conflictings[i];
                        });
                    }
                    resTemplate.lstPeriods = resTemplate.lstPeriods.concat(addedPeriods);
                    //update start end date times
                }
                return resTemplate;
            }

            function fixCreationPeriodConflict(period, template, range){
                var conflictingIndexes = shdl.getConflictingIndexes(period, template);
                if(conflictingIndexes.hasConflicts){
                    var indexes = Object.keys(conflictingIndexes).filter(function(e){return !isNaN(e);});
                    var periodDuration = period.endTime - period.startTime;
                    for (var i = 0; i < indexes.length; i++) {
                        var t = template.lstPeriods[indexes[i]];
                        var isOverbooked = period.startTime >= t.startTime && period.startTime < t.endTime;
                        var snapToLast = isOverbooked && range && t.endTime < period.startTime+range;
                        if(snapToLast){
                            isOverbooked = false;
                            period.startTime = t.endTime;
                            period.endTime = period.startTime + periodDuration;

                            //since we changed both start and end time assume the period is new and recheck conflicts.
                            conflictingIndexes = fixCreationPeriodConflict(period, template, range);
                        }
                        if(isOverbooked){
                            conflictingIndexes.hasConflicts = true;
                            return conflictingIndexes;
                        }
                        if(!snapToLast && period.endTime > t.startTime){
                            period.endTime = t.startTime;
                            conflictingIndexes.hasConflicts = false;
                        }
                    }
                }
                return conflictingIndexes;
            }

            shdl.getConflictingIndexes = function (period, template){
                var res = {hasConflicts: false};
                if(template && template.lstPeriods){
                    for (let i = 0; i < template.lstPeriods.length; i++) {
                        if(periodsInConflict(period, template.lstPeriods[i]) ){
                            res[i] = true;
                            res.hasConflicts = true;
                        }
                    }
                }
                return res;
            }

            shdl.noPeriodConflicts = function(period, template){
                var conflict = shdl.getConflictingIndexes(period, template);
                return !conflict.hasConflicts || !conflictNotWithSelf(conflict, period, template.lstPeriods);
            }
            function conflictNotWithSelf(conflict, self, lst){
                // fixes a bug where the period conflicts with itself when drag and dropped thus cant be dropped
                var indexes = Object.keys(conflict).filter(function(e){return !isNaN(e);});
                return !(indexes.length == 1 && lst[indexes[0]] == self);
            }
            function periodsInConflict(a,b){
                return overlaps(a, b) || overlaps(b, a) || same(a,b);
            }
            function overlaps(a, b){
                return (a.startTime > b.startTime && a.startTime < b.endTime) || 
                (a.endTime > b.startTime && a.endTime < b.endTime) 
            }
            function same(a,b){
                return (a.startTime == b.startTime && a.endTime == b.endTime) 
            }

            var handleConflicts = {};
            handleConflicts[shdl.CR.CR_OVERRIDE] = function(date, viewdate, template, options){
                initDateWithDateTemplate(date, viewdate, template);
                return $q.resolve();
            }
            handleConflicts[shdl.CR.CR_MERGE] = function(date, viewdate, template, options){
                initDateWithDateTemplate(date,viewdate, getMergedTemplate(viewdate, template, options.conflictresolutionprivilege));
                return $q.resolve();
            }
            handleConflicts[shdl.CR.CR_SKIP] = function(date, viewdate, template, options){
                return $q.resolve();
            }
            handleConflicts[shdl.CR.CR_ASK] = function(date, viewdate, template, options){
                return $q(function(resolve, reject){
                    var qconfirmOptions = {
                        templateUrl: 'ask_for_conflict_resolution_index.html',
                        dateToMod: viewdate,
                        schdlTempmlate: template,
                        tagOrId: OfysFCUtils.getIdOrTag,
                        humanReadableDate: function(date){
                            if(date){
                                return moment(date).format($filter("translate")("dateFormatHumanReadable"))
                            }
                        },
                        resolution:{
                            type: shdl.CR.CR_OVERRIDE,
                            fusionType:shdl.CR.CR_MERGE_DAY_FIRST,
                            thisForEvery: false,
                        },
                        select: function(pat){
                            setDirty(false);
                            // scope.patient = pat;
                            model.patient().currPatient = pat;
                            this.qconfirm.cancel();

                        },
                        qconfirm: {
                            hideNo: true,
                            hideCancel:true,
                            yesTitle: "ScheduleApplyResolution",
                            beforeYes: function(e, obj){
                                // console.log(e);//preventDefault
                                // console.log(obj);//scope object
                                var opt = {conflictresolution: obj.resolution.type, 
                                        conflictresolutionprivilege:obj.resolution.fusionType};
                                if(qconfirmOptions.resolution.thisForEvery){
                                    $.extend(options,opt);
                                }
                                handleConflicts[obj.resolution.type](date, viewdate, template, opt).then(resolve, reject)
                            }
                        }
                    };
                    QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(function(res){
                        // console.log(res);
                    }, function(){

                    });
                });
            }
            
            function solveConflicts(date, viewdate, template, options){
                if(handleConflicts[options.conflictresolution]){
                    return handleConflicts[options.conflictresolution](date, viewdate, template, options)
                }
            }

            function hasConflicts(viewdate, template){
                return viewdate.appointmentDate && 
                    viewdate.appointmentDate.dateTemplate &&
                    viewdate.appointmentDate.dateTemplate.lstPeriods.length > 0;
            }

            function updateDateTemplate(viewappointmentDate, newTemplate){
                clearDateTemplate(viewappointmentDate)
                shdl.initViewbag(viewappointmentDate.appointmentDate);
                viewappointmentDate.appointmentDate.dateTemplate = newTemplate;
                viewappointmentDate.appointmentDate.modificationStatus = ModificationStatus.STATUS_UPDATED;
                initViewAppointmentDate(viewappointmentDate);
            }

            function clearDateTemplate(viewappointmentDate){
                //clear any ui elements of old template;
                if(hasDayViewer() && viewappointmentDate.appointmentDate.dateTemplate && 
                    viewappointmentDate.appointmentDate.dateTemplate.lstPeriods){
                    dv().ctrler.removeEvents(viewappointmentDate.appointmentDate.dateTemplate.lstPeriods)
                }
            }

            function getOrCreateAppointmentDate(date){
                return getAppointmentDate(date).then(function(appointmentDate){
                    if(appointmentDate.appointmentDate && _.isEmpty(appointmentDate.appointmentDate)){
                        appointmentDate.appointmentDate =  {
                            date: date,
                            isDeleted: false,
                            modificationStatus: ModificationStatus.STATUS_UPDATED,
                            professionnal: prof.id,
                        }
                    }
                    return appointmentDate
                })
            }

            function getAppointmentDate(date){
                return $q(function(resolve, reject){
                    if(shdl.dates(date) == undefined ){
                        shdl.dates(date, getNewDate());
                    }
                    if(shdl.dates(date).loading.periods != LoadStatus.LOADED){
                        shdl.update(date).then(function(){
                            resolve(shdl.dates(date));
                        });
                    } else{
                        resolve(shdl.dates(date));
                    }
                });
            }


            function cloneDateNewTemplateInstance(template, date){
                var res = _.omit(angular.copy(template), ['id', 'version','tag']);
                if(res.lstPeriods && res.lstPeriods.length > 0){
                    res.lstPeriods.forEach(function(e){
                        delete e.id;
                        delete e.version;
                        delete e.tag;
                        e.modificationStatus = ModificationStatus.STATUS_NEW;
                    })
                }
                res.note = date;
                res.modificationStatus = ModificationStatus.STATUS_NEW;
                return res;
            }

            shdl.addSavable = function(savable, type, key){
                if(savable && type && key){
                    setScheduleDirty(true);
                    presave[type][key]= savable;
                    shdl.views.scheduleHeader.visible = true;
                    shdl.views.scheduleHeader.activeModificationTab = type;
                }
            }
            
            shdl.removeSavable = function(type, key){
                if(type && key){
                    delete presave[type][key];
                    setScheduleDirty(true);
                    checkPresaveDirty();
                }
            }
            function checkPresaveDirty(){
                if(_.isEmpty(presave.dates) &&
                    _.isEmpty(presave.dateTemplates) &&
                    _.isEmpty(presave.weekTemplates)){
                        setScheduleDirty(false);
                    shdl.views.scheduleHeader.visible = false;
                }
            }

            shdl.currentContext = function(type){
                if(shdl.isMultiSchedule && shdl.multiViewCtrl.currentSchedule){
                    return shdl.multiViewCtrl.currentSchedule.currentContext(...arguments);
                }
                if(type){
                    if(selectedContext){
                        if(selectedContext.type() === type){
                            selectedContext.updated();
                        }else{
                            selectedContext.clearState();
                            selectedContext = getContextByType(type);
                        }
                    }else{
                        selectedContext = getContextByType(type);
                    }
                    model.apptUpdated(true);
                }else{
                    return selectedContext;
                }
            }

            shdl.currentWeekTemplate = function(template){
                if(template && shdl.currentContext().okToClose()){
                    if(selectedWeekTemplate != undefined ){
                        selectedContext.beforeUpdate();
                    }
                    selectedWeekTemplate = template;
                    shdl.currentContext(shdl.contextTypes.WEEKTEMPLATE);
                    shdl.views.weekTemplateEdit.visible = true;
                    model.apptUpdated(true);
                }else{
                    return selectedWeekTemplate
                }
            }

            shdl.currentDateTemplate = function(template){
                if(template && shdl.currentContext().okToClose()){
                    if(selectedDateTemplate != undefined){
                        selectedContext.beforeUpdate();
                    }
                    selectedDateTemplate = template;
                    shdl.currentContext(shdl.contextTypes.DATETEMPLATE);
                    shdl.views.dateTemplateEdit.visible = true;
                    model.apptUpdated(true);
                }else{
                    return selectedDateTemplate
                }
            }
            function filterApptsToShow(e){
                return showDeleted(e) && showCanceled(e);
            }

            function showCanceled(e){
                return model.prefSettings('user_settings_ShowCanceledAppt')? true: (e.patientStatus !== 'CANCEL' && e.patientStatus !== 'CANCEL_LESS_24H');
            }
            function showDeleted(e){
                return model.prefSettings('schedule_settings_showDeletedAppt')? true: !e.isDeleted;
            }

            shdl.addAppointments = function(appointments){
                var apps = [];
                _.each(appointments, function(e){
                    initUiAppointment(e);
                    if(e.idProfessionals.indexOf(shdl.prof.id) > -1){
                        // des fois qu'il changerait de médecin durant le chargement
                        // TODO faut il aussi confirmer que la date n'a pas changé et que
                        // le rv n'est pas déjà dans la liste (call de /list et updateViaWS en même temps)?
                        apps.push(e);
                        indexAppointment(e);
                    }
                });

                shdl.addAppointmentsToViewer(apps);
            }


            // only from web sockect message.
            shdl.updateReservationFromWS = function(reservation){
                var invalid = reservation.invalidateMe; // si true, il faut retirer la réservation
                if (invalid!==true && selectedAppointment && selectedAppointment.reservation &&
                        (reservation.id === selectedAppointment.reservation.id ||
                                (reservation.startTime === selectedAppointment.reservation.startTime &&
                                        reservation.endTime === selectedAppointment.reservation.endTime &&
                                        reservation.date === selectedAppointment.reservation.date)
                        )
                ) {
                    // c'est une réservation faite à partir de ce poste - il ne faut pas la considérer.
                    return;
                }
                var indexId = getIndexedId(reservation);
                var theDate = OfysUtils.daysFrom1970ToStr(reservation.date);
                var app;
                if(indexId !== undefined){
                    if(shdl.dates(theDate) && shdl.dates(theDate).appointments[indexId] !== undefined){
                        app = shdl.dates(theDate).appointments[indexId];
                    }
                    if (app) {
                        shdl.removeReservation(app);
                        shdl.clearAppointment(app);
                    }
                }
                if (invalid!==true && prof.id == reservation.idProfessional) {
                    var n = getNewAppointment(prof, theDate, reservation.startTime, reservation.endTime-reservation.startTime);
                    n.isReservFromWS = true;
                    n.editLocked = true;
                    n.id = reservation.id;
                    shdl.addAppointments([n]);
                }
                model.apptLstUpdated(true);                                    	
                model.apptUpdated(true);
            }

            shdl.appointmentHasChangedDateAndInEditMode = function (appointment){
                var indexAppointmentId = getIndexedId(appointment);
                if(indexAppointmentId !== undefined && index.appointment[indexAppointmentId] != appointment.date){// appointment notification changed dates. Remove old appointment
                    var currentIndexedAppointment = shdl.dates(index.appointment[indexAppointmentId]).appointments[indexAppointmentId]
                    if(selectedAppointment && (currentIndexedAppointment === selectedAppointment || currentIndexedAppointment.id == selectedAppointment.id)){
                        if(currentIndexedAppointment.editable && currentIndexedAppointment.editable.editMode){
                            currentIndexedAppointment.editable.latestVersion = appointment;
                            // if the appointment is in editmode let the user close the appointment.
                            return true;
                        }
                    }
                    shdl.clearAppointment(currentIndexedAppointment);//removed on notification if the date of the appointment has changed.
                }
                return false;
            }

            shdl.updateAppointment = function(appointment,  latestVersion){
                if(shdl.dates(appointment.date) != undefined ){
                    if(shdl.dates(appointment.date).loading.appointments === LoadStatus.LOADED){
                        var indexAppointmentId = getIndexedId(appointment);
                        var app;
                        var isActive;
                        if(indexAppointmentId !== undefined){
                            app = shdl.dates(index.appointment[indexAppointmentId]).appointments[indexAppointmentId]
                            isActive = selectedAppointment && (app === selectedAppointment || app.id == selectedAppointment.id);
                            if(app.editable && app.editable.editMode && !latestVersion){
                                app.editable.latestVersion = appointment;
                                // if the appointment is in editmode let the user close the appointment.
                                return;
                            }
                            shdl.clearAppointment(appointment);// for new appointments
                            shdl.clearAppointment(app);// for notifications.
                        }
                        if(latestVersion && appointment){
                            OfysUtils.update(appointment, latestVersion);
                        }
                        // if(!appointment.isDeleted){ // this is now filtered out when showing
                            shdl.insertAppointment(appointment)
                        // }
                        if(isActive){
                            shdl.currentAppointment(OfysFCUtils.getIdOrUid(appointment));
                        }
                    }
    
                    updateBaseAppointmentDateAppointmentList(appointment.date)
                }
                
                model.apptLstUpdated(true);                                    	
                model.apptUpdated(true);
            }

            function initUiAppointment(app){
                if(app == undefined) return;

                if(OfysFCUtils.confidentialAccessDenied(app)){
                    app.editLocked = true;
                }
                if(app.contactMethods != undefined && app.contactMethodsList == undefined ){
                    app.contactMethodsList = JSON.parse(app.contactMethods);
                    app.contactMethodsList.sort(function(x, y) {
                        return (x.isPrefered === y.isPrefered)? 0 : x.isPrefered? -1 : 1;
                    });
                }
            }
			shdl.toggleRightSideBar = function(){
                model.schedule().showRightSideBar = !model.schedule().showRightSideBar;
				shdl.renderDV();
            }
            shdl.redrawAppointment = function(appointment, previous){
                eraseAppointmentFromViewer(appointment);
                if(previous && previous.uiEvent){
                    eraseAppointmentFromViewer(previous);
                }
                shdl.addAppointmentsToViewer([appointment]);
                if(selectedAppointment == previous){
                    setViewerSelection(appointment);
                };
				if(shdl.isMultiSchedule && shdl.multiViewCtrl.currentSchedule){
                    shdl.multiViewCtrl.currentSchedule.redrawAppointment(...arguments);
                }
            }

            shdl.redrawPeriod = function(period){
                erasePeriodFromViewer(period);
                shdl.addPeriodsToViewer(shdl.currentDate(), [period]);
                if(selectedPeriod == period){
                    setViewerSelection(selectedPeriod);
                }
            }

            function indexAppointment(app){
                var id = OfysFCUtils.getIdOrUid(app)
                if(id){
                    index.appointment[id] = app.date;
                    var appDate = shdl.dates(app.date);
                    if (appDate)  appDate.appointments[id] = app;
                }
            }

            function alreadyIndexed(app){
                var appDate = shdl.dates(app.date);
                if(appDate){
                    return appDate.appointments[OfysFCUtils.getIdOrUid(app)];
                }
            }

            function unindexAppointment(app){
                var id = getIndexedId(app);
                if(id){
                    delete shdl.dates(index.appointment[id]).appointments[id];
                    delete index.appointment[id];
                }
            }

            function getIndexedId(app){
                if(index.appointment[app.tag]) {
                    return app.tag;
                }else if(index.appointment[app.uid]) {
                    return app.uid;
                }else if(index.appointment[app.id]){
                    return app.id;
                }
            }

            shdl.addAppointmentsToViewer = function(appointments){
                if(hasDayViewer() && (shdl.isScheduleEditMode()!=1)){
                    removeEventsFromDv(appointments);
                    dv().ctrler.addEvents(appointments.filter(filterApptsToShow), OfysFCUtils.appointmentToFullCalendarEvent);
                    if(appointments && appointments.length > 0){
                        var date = appointments[0].date;
                        initViewAppointmentDate(shdl.dates(date));
                        updateViewStartEndTimes(date);
                    }
                }
            }

            shdl.initMonth = function(){
                shdl.addBaseAppointmentDatesToViewer(getBaseAppointmentDates(selectedDate).filter(OfysFCUtils.hasStatsBaseAppointmentDate));
            }

            shdl.initDay = function(){
                updateViewSpan(selectedDate)
                updateViewStartEndTimes(selectedDate)
                shdl.addCurrentDayPeriodsToViewer();
                shdl.addCurrentDayAppointmentsToViewer();
            }

            shdl.addCurrentDayAppointmentsToViewer = function(){
                for (var i = 0; i < allViewedDates.length; i++) {
                    shdl.addDateAppointmentsToViewer(allViewedDates[i]);
                }
            }

            shdl.addDateAppointmentsToViewer = function(date){
                if(date && shdl.dates(date).appointments){
                    shdl.addAppointmentsToViewer(_.values(shdl.dates(date).appointments));
                    shdl.dates(date).clearedAppointments = false;
                }
            }

            function getNewAppointmentDate(date){
                var res = {
                    date: date,
                    dateTemplate:{
                        endHour: model.clientPreferences().appointmentEndHour,
                        isDeleted: false,
                        isReusable: false,
                        lstPeriods: [],
                        modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
                        // note: "2021-04-19",
                        professionnal: prof.id,
                        scale: model.clientPreferences().appointmentBaseTime,
                        startHour: model.clientPreferences().appointmentStartHour,
                        // version: 29635077,
                    },
                    isDeleted: false,
                    modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
                    professionnal: prof.id,
                    // version: 29635077,
                }
                return res;
            }

            function createAppointmentDateIfNecessary(date){
                if(!shdl.dates(date).appointmentDate.date){
                    shdl.setAppointmentDate(getNewAppointmentDate(date))
                }
            }
            // Called every time a date data has changed (updated periods, appointments or date)
            shdl.dateDataLoaded = function(date){
                if(shdl.isMultiSchedule){
                    shdl.multiSchedules.forEach(s=>s.dateDataLoaded(...arguments));
                    return;
                }
                // console.log(shdl.dates(date].appointmentDate);
                createAppointmentDateIfNecessary(date);
                updateViewStartEndTimes(date);
                shdl.isScheduleEditMode() != 1 && shdl.dates(date).clearedAppointments && shdl.addDateAppointmentsToViewer(date);
                shdl.dates(date).clearedPeriods && shdl.addDatePeriodsToViewer(date);
            }

            function updateViewStartEndTimes(date){
                if(date !== selectedDate)return;
                calendarMinMaxUpdate(getMultiViewCtrlerOrSelf().getViewSpanMinTime(), getMultiViewCtrlerOrSelf().getViewSpanMaxTime() )
                model.apptLstUpdated(true);                                    	
            }

            //
            function getMultiViewCtrlerOrSelf(){
                if(shdl.isChildSchedule && shdl.parentCtrler != null){
                    return shdl.parentCtrler;
                }else{
                    return shdl;
                }
            }

            function forAllViewedDates(fn){
                if(allViewedDates != undefined){
                    for (let i = 0; i < allViewedDates.length; i++) {
                        fn && fn(shdl.dates(allViewedDates[i]));
                    }
                }
            }
            shdl.getViewSpanMinTime = function(){
                var res = "";
                forAllViewedDates(function(d){
                    if(d && d.minTime && (res == "" || d.minTime < res)){
                        res = d.minTime;
                    }
                })
                return res;
            }

            shdl.getViewSpanMaxTime = function(){
                var res = "";
                forAllViewedDates(function(d){
                    if(d && d.maxTime && (res == "" || d.maxTime > res)){
                        res = d.maxTime;
                    }
                })
                return res;
            }


            shdl.updateDateTemplateStartEnd = function(dateTemplate){
                if(dateTemplate.startHour != null && dateTemplate.endHour != null && dateTemplate.endHour > dateTemplate.startHour){
                    var range = getPeriodsMaxMinHour(dateTemplate.lstPeriods, {start : (dateTemplate.startHour*60), end:(dateTemplate.endHour*60)});
                    calendarMinMaxUpdate(hourToTime(Math.floor(range.start/60)), hourToTime(Math.ceil(range.end/60)));
                }
            }

            shdl.renderDV = function(){
                if(shdl.isMultiSchedule){
                    shdl.multiSchedules.forEach(s=>s.renderDV(...arguments));
                    return;
                }
                $timeout(function(){dv().ctrler.cal.render()}, 10)
            }
            shdl.renderMV = function(){
                hasMonthViewer() && $timeout(function(){mv().ctrler.cal.render()}, 10)
            }

            function calendarMinMaxUpdate(minTime, maxTime){
                if(hasDayViewer() && dv().ctrler){
                    var calMin = moment(dv().ctrler.cal.getOption('slotMinTime'), 'HH:mm:ss', true).format('HH:mm:ss');
                    var calMax = moment(dv().ctrler.cal.getOption('slotMaxTime'), 'HH:mm:ss', true).format('HH:mm:ss');
                    if(minTime && calMin!==minTime){
                        dv().ctrler.cal.setOption('slotMinTime', minTime);
                    }
                    if(maxTime && calMax!==maxTime){
                        dv().ctrler.cal.setOption('slotMaxTime', add15minsToTime(maxTime));
                    }
                }
            }
            shdl.calendarMinMaxUpdate = calendarMinMaxUpdate;//exposed to allow multiviewCtrler to update the time.

            function add15minsToTime(time){
                //View fix so as to make sure that the max time is displayed
                var timeArr = time.split(":") 
                timeArr[1] = "15";
                return timeArr.join(":");
            }

            function hourToTime(h){
                if(h != undefined){
                    if(24 == h )return "24:00:00";// moment semble interpreter 24h comme 00h00 qui cause des bugs dans le calendrier.
                    return moment(h+"", "H").startOf('hour').format("HH:mm:ss");
                }
            }

            function getStartHour(dateTemplate){
                if(dateTemplate && dateTemplate.startHour != undefined){
                    return dateTemplate.startHour;
                }else if(model.clientPreferences().appointmentStartHour != undefined){
                    return model.clientPreferences().appointmentStartHour;
                }else{
                    return 8;
                }
            }

            function getEndHour(dateTemplate){
                if(dateTemplate && dateTemplate.endHour != undefined){
                    return dateTemplate.endHour;
                }else if(model.clientPreferences().appointmentEndHour != undefined){
                    return model.clientPreferences().appointmentEndHour;
                }else{
                    return 16;
                }
            }


            function getPeriodsMaxMinHour(lst, res){
                if(lst && lst.length > 0){
                    res = res == undefined?{start:lst[0].startTime,end:lst[0].endTime}:res;
                    for (var i = 0; i < lst.length; i++) {
                        if(lst[i].startTime < res.start){
                            res.start = lst[i].startTime
                        };
                        if(lst[i].endTime > res.end){
                            res.end = lst[i].endTime
                        };
                    }
                }
                return res
            }

            function getAppointmentMaxMinHour(lst, res){
                if(lst && lst.length > 0){
                    res = res == undefined?{start:lst[0].startTime,end:lst[0].endTime}:res;
                    for (var i = 0; i < lst.length; i++) {
                        if(lst[i].startTime < res.start){
                            res.start = lst[i].startTime
                        };
                        if(lst[i].endTime > res.end){
                            res.end = lst[i].endTime
                        };
                    }
                }
                return res
            }

            shdl.redrawAll = function(){
                if(shdl.isMultiSchedule){
                    shdl.multiSchedules.forEach(s=>s.redrawAll(...arguments));
                    return;
                }
                shdl.clearView();
                shdl.showCurrentDate();
            }

			shdl.getReportsAppDate = function(){
				var ap = shdl.dates(shdl.currentDate()).appointmentDate;
				var bAppDate = shdl.dates(shdl.currentDate()).baseAppointmentDate;
				if(ap.id && bAppDate && bAppDate.statistic.appointments.length > 0){
					model.print().type.id = ap.professionnal;
					model.print().type.type = "appointmentDate";
					model.print().type.date = moment(ap.date).startOf('day').valueOf();
					PrintAccessor.getAvailableReports(model.print().type, function(res){
						res.data.sort((a,b) => (a.name > b.name) ? 1 : ((b.name > a.name) ? -1 : 0))
						for(list of res.data){
							list.reports.sort((a,b) => (a.name > b.name) ? 1 : ((b.name > a.name) ? -1 : 0))
						}
						model.print().currList = res.data;
						FlView.open({templateUrl: "/dashboard/resources/ofys/print/print.html?v=bk", list: res.data, type: ap}, {
							backdrop: 'static',windowClass: "printmodal"}).then(function(data){
								
						});
					});
				} else{
					model.notice().note($filter('translate')('err_no_app'));	
				}
			}
            shdl.isEmptyWeekTemplate = function(wt){
                for (let i = 0; i < shdl.WEEKDAYS.length; i++) {
                    const dt = wt[shdl.WEEKDAYS[i]];
                    if(!shdl.isEmptyDateTemplate(dt)){
                        return false;
                    }
                }
                return true;
            }
            shdl.isEmptyDateTemplate = function(dt){
                return !(dt && dt.lstPeriods && dt.lstPeriods.length > 0);
            }

            shdl.deleteWeekTemplate = function(template){
                var i = model.schedule().appointmentWeekTemplates.indexOf(template);
                if(i>-1){
                    if(template.id){
                        shdl.initViewbag(template);
                        template.modificationStatus = ModificationStatus.STATUS_DELETED;
                        template.isDeleted = true;
                        shdl.addSavable(template, 'weekTemplates', template.id);
                    }else{
                        model.schedule().appointmentWeekTemplates.splice(i, 1);
                        shdl.removeSavable('weekTemplates', template.tag);
                    }
                    if(shdl.currentWeekTemplate() == template ){
                        shdl.showCurrentDate();
                    }
                }
            }

            shdl.deleteDateTemplate = function(template){
                var i = model.schedule().appointmentDateTemplates.indexOf(template);
                if(i>-1){
                    if(template.id){
                        shdl.initViewbag(template);
                        template.modificationStatus = ModificationStatus.STATUS_DELETED;
                        template.isDeleted = true;
                        shdl.addSavable(template, 'dateTemplates', template.id);
                    }else{
                        model.schedule().appointmentDateTemplates.splice(i, 1);
                        shdl.removeSavable('dateTemplates', template.tag);
                    }
                    if(shdl.currentDateTemplate() == template ){
                        shdl.showCurrentDate();
                    }
                }
            }

            shdl.showCurrentDate = function(){
                if(selectedDate){
                    shdl.currentContext(shdl.contextTypes.SCHEDULE_DATE);
                    shdl.views.scheduleDate.visible = true;
                    hasDayViewer() && dv().ctrler.cal.gotoDate(selectedDate);
                    if(hasMonthViewer()){
                        mv().ctrler.cal.gotoDate(selectedDate);
                        mv().ctrler.cal.select(selectedDate);
                    }

                    // if(!shdl.dates(selectedDate]){
                    //     shdl.dates(selectedDate] = getNewDate();
                    // }
                    // shdl.update(selectedDate);
                    updateViewSpan(selectedDate)
                }
            }

            function updateViewSpan(date){
                var viewspan = getViewspan(date);
                allViewedDates = allViewspanDates(viewspan);
                allViewedDates.forEach(initDate);
                return shdl.update(date, viewspan);
            }

            function initDate(date){
                if(!shdl.dates(date)){
                    shdl.dates(date, getNewDate());
                }
            }

            function allViewspanDates(viewspan){
                var res = [];
                if(viewspan.day){
                    res.push(viewspan.day);
                }else{
                    var start = moment(viewspan.start);
                    var end = moment(viewspan.end);
                    for (; start.isBefore(end);start.add(1, 'day')) {
                        res.push(start.format("YYYY-MM-DD"));
                    }
                    res.push(viewspan.end);
                }
                viewspan.allDates = res;
                return res;
            }

            function getViewspan(date){
                var res = {idProf:shdl.prof.id};
                if(daysViewed == 1){
                    res.day = date;
                }else if(daysViewed == 7){
                    res.start = AppointmentAccessor.getStartOfWeek(date);
                    res.end = AppointmentAccessor.getEndOfWeek(date);
                }
                return res;
            }
            
            shdl.setSelectedDateIfDiffrent = function (date){
                return $q(function(resolve, reject){
                    if(shdl.currentDate() !== date){
                        shdl.currentDate(date).then(resolve, reject);
                    }else{
                        resolve();
                    }
                })
            }

            shdl.currentDate = function(date){
                if(shdl.isMultiSchedule){
                    shdl.multiSchedules.forEach(s=>s.currentDate(...arguments));
                }
                if(date !== undefined){
                    return selectedContext.currentDate(date);
                }else{
                    return selectedContext.currentDate();
                }
            }

            function loadedModifiedAD(date, ad){
                if(shdl.dates(date).appointmentDate && shdl.dates(date).appointmentDate &&
                    shdl.dates(date).appointmentDate.id &&
                    shdl.dates(date).appointmentDate.id === ad.id){
                        return true;
                }
                return false;

            }
            function sanitizeOfysDate(d){
                return typeof d == 'number' ? OfysUtils.daysFrom1970ToStr(d) : d;
            }

            shdl.setAppointmentDate = function(appointmentDate){
                if(shdl.isMultiSchedule){
                    return shdl.multiViewCtrl.currentSchedule && shdl.multiViewCtrl.currentSchedule.setAppointmentDate(...arguments);
                }
                var date = appointmentDate.date = sanitizeOfysDate(appointmentDate.date);
                if(shdl.dates(date)){
                    clearDateTemplate(shdl.dates(date));
                    shdl.dates(date).appointmentDate = appointmentDate;
                    initViewAppointmentDate(shdl.dates(date));
                    updateViewStartEndTimes(date);
                }
                model.apptLstUpdated(true);                                    	
                model.apptUpdated(true);
            }

            function initViewAppointmentDate(viewAppointmentDate){
                var periods = viewAppointmentDate.appointmentDate.dateTemplate != undefined ? viewAppointmentDate.appointmentDate.dateTemplate.lstPeriods:undefined;
                var range = getAppointmentMaxMinHour(_.values(viewAppointmentDate.appointments), 
                    getPeriodsMaxMinHour(periods, 
                    {
                        start : (60*getStartHour(viewAppointmentDate.appointmentDate.dateTemplate)), 
                        end:(60*getEndHour(viewAppointmentDate.appointmentDate.dateTemplate))
                    }));

                viewAppointmentDate.minTime = hourToTime(Math.floor(range.start/60));
                viewAppointmentDate.maxTime = hourToTime(Math.ceil(range.end/60));//+ slot duration to show last time in 
            }

            shdl.cancelEdit = function(){
                if(shdl.isMultiSchedule){
                    return shdl.multiViewCtrl.currentSchedule && shdl.multiViewCtrl.currentSchedule.cancelEdit();
                }
                if(selectedAppointment.modificationStatus === ModificationStatus.STATUS_NEW){
                    shdl.clearAppointment(selectedAppointment);
                    shdl.clearAppointment(selectedAppointment.editable);
                    selectedAppointment = null;
                    utils.showPopoverOverlay(false);
                }else if(selectedAppointment.editable){
                    shdl.setAppointmentEditMode(selectedAppointment.editable, false);
                    eraseAppointmentFromViewer(selectedAppointment.editable);
                }
                model.apptLstUpdated(true);                                    	
                model.apptUpdated(true);
            }

            shdl.clearAppointment = function (app){
                if(shdl.isMultiSchedule){
                    return shdl.multiViewCtrl.currentSchedule && shdl.multiViewCtrl.currentSchedule.clearAppointment(...arguments);
                }
                eraseAppointmentFromViewer(app);
                if(app && app.viewbag && app.viewbag.orig){
                    eraseAppointmentFromViewer(app.viewbag.orig);
                }
                unindexAppointment(app);
                model.apptLstUpdated(true);                                    	
                model.apptUpdated(true);
            }

            function getNewDateTemplate(){
                var res = {
                    // id: 791117,
                    isDeleted: false,
                    isReusable: true,
                    lstPeriods: [],
                    modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
                    note: "",
                    scale: model.clientPreferences().appointmentBaseTime,
                    startHour: model.clientPreferences().appointmentStartHour,
                    endHour: model.clientPreferences().appointmentEndHour,
                    tag: APPOINTMENTUID.next(),
                    // version: 29635097,
                }
                return res;
            }

            shdl.createNewDateTemplate = function (){
                return getNewDateTemplate();
            }

            shdl.cloneDateAsTemplate = function(d){
                var t = _.omit(angular.copy(d.appointmentDate.dateTemplate), ['viewbag', 'id', 'version', 'tag']);
                t.note = ""
                if(t.lstPeriods){
                    t.lstPeriods.forEach(function(p){
                        delete p.uiEvent;
                        delete p.viewbag;
                        delete p.id;
                        p.tag = APPOINTMENTUID.next();
                        p.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
                    })
                }
                t.tag = APPOINTMENTUID.next();
                t.isReusable = true;
                t.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
                shdl.currentDateTemplate(t);
                $timeout(function(){
                    shdl.currentContext().dirty(true);
                }, 200);
                return t;
            }

            function getNewWeekTemplate(){
                var res = {
                    // id: 791117,
                    isDeleted: false,
                    modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
                    // note:"",
                    tag: APPOINTMENTUID.next(),
                    // version: 29635097,
                }
                return res;
            }

            shdl.createNewWeekTemplate = function (){
                return getNewWeekTemplate();
            }

            shdl.insertAppointment = function (appointment){
                var existingAppointment = alreadyIndexed(appointment);
                if(existingAppointment){
                    // Last in wins in case of appointments the most recently inserted one is added to UI. 
                    //Useful in notification cases where save and notif are not in sequence.
                    shdl.clearAppointment(existingAppointment);
                }
                indexAppointment(appointment);
                shdl.addAppointmentsToViewer([appointment]);
            }

            function cleanForSave(appointment){
                var res = [];
                if(appointment){
                    _.each(appointment, function(e){
                        var savable = JSON.parse(OfysUtils.safeStringify(_.omit(e, ['viewbag', 'reservation', 'selectedPatient','editable', 'uiEvent'])));
                        savable.patients.forEach(function(e){
                            delete e.viewbag;
                        })
                        res.push(savable);
                    });
                }
                return res;
            }

            shdl.undeleteAppointment = function(appointment){
                appointment.isDeleted = false;
                return shdl.saveAppointment(appointment);
            }

            shdl.deleteAppointment = function(appointment){
                var apps = getAppointmentAsList(appointment);
                var app = angular.copy(_.omit(appointment, ['viewbag', 'reservation', 'selectedPatient','editable']));
                return AppointmentAccessor.deleteappointment(app, function (res) {
                    onSaveSuccess(apps, getSavedAppointments(res));
                    clearViewerSelection(app);
                    selectedAppointment = null;
                    model.apptLstUpdated(true);                                    	
                    model.apptUpdated(true);
                }, function(errors){
                    console.error(errors);
                }, {
                    getMessage: function (status, msg) {
                        return AppointmentAccessor.utils.translateMsg(msg);
                    }
                });
            }

            shdl.setRefreshNeeded = function(needsRefresh){
                shdl.needsRefresh = needsRefresh;
                if(shdl.isMultiSchedule){
                    shdl.multiSchedules.forEach(s=>s.setRefreshNeeded(...arguments));
                    return;
                }
            }

            shdl.refresh = function(){
                shdl.setRefreshNeeded(false);
                if(shdl.isMultiSchedule){
                    shdl.multiSchedules.forEach(s=>s.refresh(...arguments));
                    return;
                }
                QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
                    if(successful){
                        shdl.close();
                        hasMonthViewer() &&  mv().ctrler.purgeEvents();
                        hasDayViewer() &&  dv().ctrler.purgeEvents();
                        flushCache();
                        $timeout(shdl.open, 200);// delay only here as a visual cue that a refresh happened not really required for logic
                    }
                })
            }

			shdl.refreshNoTimeout = function(appointment){
                if(shdl.isMultiSchedule){
                    shdl.multiSchedules.forEach(s=>s.refresh(...arguments));
                    return;
                }
                shdl.close();
                shdl.flushCacheAndOpen();    
				shdl.currentAppointment(OfysFCUtils.getIdOrUid(appointment));
            }

			shdl.flushCacheAndOpen = function(){
				hasMonthViewer() &&  mv().ctrler.purgeEvents();
                hasDayViewer() &&  dv().ctrler.purgeEvents();
				flushCache();
				shdl.open();
			}

            function flushCache(){
                [index.period, index.appointment, datesCache].forEach(function(obj){
                    Object.keys(obj).forEach(function(d){
                        delete obj[d];
                    });
                })
            }

            function flushCacheDate(date){
                [index.period, index.appointment].forEach(function(obj){
                    Object.keys(obj).forEach(function(d){
                        if(obj[d] == date){
                            delete obj[d];
                        }
                    });
                })
                delete datesCache[date];
            }

            var skipOverlayToggle = false;
            shdl.saveAppointment = function(appointment, skipOverlay, recall){
                if(shdl.isMultiSchedule && shdl.multiViewCtrl.currentSchedule){
                    return shdl.multiViewCtrl.currentSchedule.saveAppointment(...arguments);
                }
                skipOverlayToggle = skipOverlay== true;
                var apps = getAppointmentAsList(appointment);
                return AppointmentAccessor.saveappointment(cleanForSave(apps), function (res) {
                    onSaveSuccess(apps, getSavedAppointments(res));
					if(recall){
						model.recall().copyRecall.status = "APPOINTMENT_GIVEN";
						RecallAccessor.save(model.recall().copyRecall, function(res){
							var saved ;
	                        if(res.className === "CPatientRecall"){
	                            saved = res;
								saved.isShowPatient = true;
								const index = model.recall().currList.findIndex(e => e.id == model.recall().currRecall.id);
								model.recall().currList[index] = saved;
	                        }
	                        if (!saved) {
	                            model.notice().fail($filter('translate')('SaveError'));
	                        }
							model.recall().copyRecall = null;
						})
					}
//					shdl.refresh();
                }, function(errors){
                    console.error(errors);
//                    model.notice().fail($filter("translate")("SaveError") + "\n "+ errors);
                }, {
                    jsonActionResultFailAsError:true,
                    warnNoticeConfig:{
                        autoClose:5000
                    },
                    getMessage: function (status, msg) {
                        return AppointmentAccessor.utils.translateMsg(msg);
                    }
                });
            }

            function onSaveSuccess(apps, savedApps){
                for (var i = 0; i < apps.length; i++) {
                    shdl.removeReservation(apps[i]);
                    shdl.updateAppointment(apps[i], savedApps[i]);
                    shdl.setAppointmentEditMode(apps[i], false);
                }
            }

            function getSavedAppointments(response){
                return response;
            }

            shdl.setAppointmentEditMode = function (app, status){
                if(shdl.isMultiSchedule && shdl.multiViewCtrl.currentSchedule){
                    return shdl.multiViewCtrl.currentSchedule.setAppointmentEditMode(...arguments);
                }
                app.editMode = status;
                if(skipOverlayToggle){
                    skipOverlayToggle = false;
                    return;
                }
                utils.showPopoverOverlay(status);
            }

            // function updateSavedAppointment(app, saved){
            //     if(app.viewbag && app.viewbag.orig ){
            //         if(saved){
            //             shdl.clearAppointment(app);
            //             OfysUtils.update(app.viewbag.orig, saved);
            //             OfysUtils.update(app, saved);
            //             shdl.insertAppointment(app);
            //         }
            //     }
            // }

            shdl.removeReservation = function(app){
                if(shdl.isMultiSchedule && shdl.multiViewCtrl.currentSchedule){
                    return shdl.multiViewCtrl.currentSchedule.removeReservation(...arguments);
                }
                shdl.reservationLock = false;
                stopCountDown(app);
                delete app.reservation;
                if(app.viewbag && app.viewbag.orig ){
                    if(app.viewbag.orig.reservation){
                        stopCountDown(app.viewbag.orig);
                        delete app.viewbag.orig.reservation;
                    }
                }
            }


            shdl.updatePeriodDateTimeIfPossible = function(event){
                if(shdl.isMultiSchedule && shdl.multiViewCtrl.currentSchedule){
                    return shdl.multiViewCtrl.currentSchedule.updatePeriodDateTimeIfPossible(...arguments);
                }
                if(event && event.id !== undefined){
                    return selectedContext.updatePeriodDateTimeIfPossible({
                        id: event.id,
                        startTime: OfysFCUtils.eventTimeToOfysTime(event.start),
                        endTime: OfysFCUtils.eventTimeToOfysTime(event.end),
                        date: moment(event.start).format(OfysUtils.DATEFORMAT)
                    }) ? $q.resolve(): $q.reject();
                }
                return $q.reject();
            }

            shdl.updateAppointmentDateTime = function(event){
                if(event && event.id !== undefined){
                    if(shdl.dates(selectedDate) && shdl.dates(selectedDate).appointments[event.id] !== undefined){
                        var app = shdl.dates(selectedDate).appointments[event.id];
                        var ndate = moment(event.start).format(OfysUtils.DATEFORMAT);
                        if(app.date !== ndate){
                            app.date = ndate;
                            app.idAppointmentDate = shdl.dates(ndate).appointmentDate.id;
                        }
                        app.startTime = OfysFCUtils.eventTimeToOfysTime(event.start);
                        app.endTime = OfysFCUtils.eventTimeToOfysTime(event.end);
                        return shdl.saveAppointment(app);
                    }
                }
                return $q.reject();
            }
            
            function canSelectAppointment(app){
                var currentUserId = model.user().profil.id;
                if(app.isReservFromWS === true && app.isConfidential && app.idProfessionals.findIndex(function(e){return e === currentUserId} ) == -1){
                    return false;
                }
                return true;
            }

            shdl.getMultiProfOrSelf = function(profId){
                if(shdl.isMultiSchedule){
                    return shdl.multiViewCtrl.getScheduleByProfId(profId, function(s){return s;})
                }
                return shdl;
            }

            shdl.getProfId = function(){
                if(shdl.isMultiSchedule){
                    return shdl.multiViewCtrl.currentSchedule && shdl.multiViewCtrl.currentSchedule.getProfId();
                }
                return shdl.prof.id;
            }

            shdl.currentAppointment = function(id,prof){
                if(shdl.isMultiSchedule){
                    return shdl.multiViewCtrl.currentSchedule && shdl.multiViewCtrl.currentSchedule.currentAppointment(id,prof);
                }
                if(id !== undefined){
                    if(shdl.dates(selectedDate) && shdl.dates(selectedDate).appointments[id] !== undefined){
                        if(!canSelectAppointment(shdl.dates(selectedDate).appointments[id])){
                            return;
                        }
                        if(selectedAppointment){
                            clearViewerSelection(selectedAppointment);
                        }
                        selectedAppointment = shdl.dates(selectedDate).appointments[id];
                        setViewerSelection(selectedAppointment);
                        if(selectedAppointment && selectedAppointment.selectedPatient === undefined){
                            selectedAppointment.patients.forEach(updatePatientWithLimitation)
                            if(selectedAppointment.patients.length > 0){
                                selectedAppointment.selectedPatient = selectedAppointment.patients[0];
                            }else if(selectedAppointment.adhocPatient != undefined){
                                selectedAppointment.adhocPatient.isAdhocPatient = true;
                                selectedAppointment.selectedPatient = selectedAppointment.adhocPatient;
                            }
                        }
                        model.apptUpdated(true);
						model.patientUpdated(true);
                    }
                }else{
                    return selectedAppointment;
                }
            };

            shdl.currentPeriod = function(id){
                return selectedContext.periodById(id);
            };

            function updatePatientWithLimitation(p){
                if(p && !p.viewbag){
                    p.viewbag = {};
                    p.viewbag.limitations = Rights.getSessionUserConsent(p);
                }
            }
            shdl.clearSelectedAppointment = function(){
                clearViewerSelection(selectedAppointment);
				AppointmentAccessor.clearMessageLink();
                selectedAppointment = null;
            }

            shdl.clearSelectedPeriod = function(){
                if(selectedPeriod){
                    clearViewerSelection(selectedPeriod);
                }
                shdl.views.periodEdit.visible = false;
                selectedPeriod = null;
            }

            function clearBaseAppointmentDate(list){
                if(hasMonthViewer()){
                    var datesWithEvents = list.filter(function(bAD){
                        return !!bAD.baseAppointmentDate 
                    }).map(function(e){
                        return e.baseAppointmentDate;
                    })


                    removeEventsFromMv(datesWithEvents);
                }
            }

            shdl.clearSelectedWeekTemplate = function(){
                selectedWeekTemplate = null;
                shdl.views.weekTemplateEdit.visible = false;
                shdl.dateTemplateToWeekTemplateActive = false;
                // shdl.showCurrentDate();
                model.apptUpdated(true);
            }
            shdl.clearSelectedDateTemplate = function(){
                if(selectedDateTemplate && selectedDateTemplate.lstPeriods){
                    dv().ctrler.removeEvents(selectedDateTemplate.lstPeriods);
                }
                selectedDateTemplate = null;
                shdl.views.dateTemplateEdit.visible = false;
                // shdl.showCurrentDate();
                model.apptUpdated(true);
            }

            var SELECTIONCLASS = "schdl-selected";
            function clearViewerSelection(app){
                if(app && hasDayViewer() && app.uiEvent){
                    var i = app.uiEvent.classNames.indexOf(SELECTIONCLASS);
                    i > -1 && app.uiEvent.classNames.splice(i, 1);
                    app.uiEvent.setProp("classNames", app.uiEvent.classNames);
                }
            }

            function setViewerSelection(app){
                if(app && hasDayViewer() && app.uiEvent !== undefined){
                    var i = app.uiEvent.classNames.indexOf(SELECTIONCLASS);
                    if(i === -1){
                        var temp = angular.copy(app.uiEvent.classNames);
                        temp.push(SELECTIONCLASS);
                        app.uiEvent.setProp("classNames", temp);
                    }
                }
            }

            shdl.addPeriods = function(appointmentDate, date){
                if(shdl.prof.id === appointmentDate.professionnal && shdl.dates(date)){
                    initViewDatePeriods(appointmentDate, date);
                    selectedContext.type() === shdl.contextTypes.SCHEDULE_DATE && shdl.addDatePeriodsToViewer(appointmentDate.date)
                }
            }

            function initViewDatePeriods(appointmentDate, date){
                if(appointmentDate && appointmentDate.dateTemplate){
                    shdl.dates(date).periods = {};
                    _.each(appointmentDate.dateTemplate.lstPeriods ,function(e){
                        index.period[e.id] = date;
                        shdl.dates(date).periods[e.id] = e;
                    });
                }
            }

            shdl.addBaseAppointmentDatesToViewer = function(lst){
                if(hasMonthViewer()){
                    mv().ctrler.removeEvents(lst);//remove higlight
                    mv().ctrler.removeEvents(lst.map(function(e){return e.statistic}));//remove stats

                    // Date highlighting.
//					if(lst[0].length > 1 || lst[0].statistic.appointments.length > 0 || lst[0].statistic.periods.length > 0){
                    mv().ctrler.addEvents(
                        lst,
                        OfysFCUtils.baseAppointmentDateToFullCalendar
                    );
//					}

                    // Date stats numbers
                    mv().ctrler.addEvents(
                        lst,
                        OfysFCUtils.baseAppointmentDateStatsToFullCalendar,
                        function(e, uiEvent){
                            e.statistic.uiEvent = uiEvent;
                        }
                    );
                }
            }
            shdl.addPeriodsToViewer = function(date, lst){
                if(hasDayViewer()){
                    removeEventsFromDv(lst);
                    dv().ctrler.addEvents(lst,
                        OfysFCUtils.periodToFullCalendar(date, shdl.isScheduleEditMode() != 1)
                    );
                }
            }
            shdl.updateSlotDuration = function(){
                if(shdl.isMultiSchedule){
                    shdl.multiSchedules.forEach(s=>s.updateSlotDuration(...arguments));
                    return;
                }
                if(shdl.isScheduleEditMode() == 1){
                    shdl.updateScheduleSlotDuration();
                }else if (shdl.isScheduleEditMode() == 0){
                    shdl.updateAppointmentSlotDuration();
                }
            }
            shdl.updateScheduleSlotDuration = function(settingsPriority){
                if(hasDayViewer()){
                    dv().ctrler.cal.setOption('slotDuration', safeSlotDuration(getScheduleDayViewScale(settingsPriority)))
                } 
            }

            var validSlotDuration = {1: true, 5:true, 10:true, 15:true,30:true};
            function getScheduleDayViewScale(settingsPriority){
                var dvDuration = model.prefSettings('schedule_settings_scheduleDayViewScale')
                if(!validSlotDuration[dvDuration]){
                    var duration = getPeriodDefaultDuration(selectedContext);
                    if(duration != dvDuration){
                        if(validSlotDuration[duration]){
                            model.prefSettings('schedule_settings_scheduleDayViewScale', duration)
                            return duration;
                        } else{
                            var hvd = highestValidDivisor(duration);
                            if(hvd !== undefined){
                                return hvd;
                            }
                        }
                    }
                }
                return dvDuration;
            }

            function highestValidDivisor(n){
                return Object.keys(validSlotDuration).map(function(k){return k *1}).filter(function(x){
                    return x <= n && (n%x == 0)
                }).sort()[0];
            }
            
            shdl.updateAppointmentSlotDuration = function(){
                if(shdl.isMultiSchedule){
                    shdl.multiSchedules.forEach(s=>s.updateAppointmentSlotDuration(...arguments));
                    return;
                }
                hasDayViewer() && dv().ctrler && dv().ctrler.cal.setOption('slotDuration', 
                    safeSlotDuration(model.prefSettings('schedule_settings_appointmentDayViewScale')));
            }

            shdl.updateAppointmentCalendarText = function(){
                if(shdl.isMultiSchedule){
                    shdl.multiSchedules.forEach(s=>s.updateAppointmentCalendarText(...arguments));
                    return;
                }
                shdl.updatePeriodEventTitle();
                hasDayViewer() && dv().ctrler.cal.setOption('displayEventTime', 
                safeShowAppTime(model.prefSettings('schedule_settings_showAppTime')));
            }
            
            function safeShowAppTime(sValue){
                if(sValue != undefined && typeof sValue === "boolean"){
                    return sValue;
                }
                return true;
            }

            function safeSlotDuration(sValue){
                if(sValue && typeof sValue === "number"){
                    return OfysFCUtils.minsToDuration(sValue);
                }
                return "00:05:00";
            }

            shdl.addCurrentDayPeriodsToViewer = function(){
                for (var i = 0; i < allViewedDates.length; i++) {
                    shdl.addDatePeriodsToViewer(allViewedDates[i])
                }
            }

            shdl.updatePeriodEventTitle = function(){
                var isBackgroundPeriod = shdl.isScheduleEditMode() != 1;
                if(allViewedDates && isBackgroundPeriod){// only does this for background events for gitlab issue #123
                    for (var i = 0; i < allViewedDates.length; i++) {
                        var d = allViewedDates[i]
                        if(d && shdl.dates(d).periods){
                            _.values(shdl.dates(d).periods).forEach(function(p){
                                OfysFCUtils.updatePeriodEventTitle(p, d,isBackgroundPeriod);
                            })
                        }
                    }
                }
            }

            shdl.addDatePeriodsToViewer = function(date){
                if(date && shdl.dates(date).periods){
                    shdl.dates(date).clearedPeriods = false;
                    shdl.addPeriodsToViewer(date, _.values(shdl.dates(date).periods));
                }
            }

            shdl.clearView = function(){
                if(hasDayViewer()){
                    clearDateCacheDayView(_.values(datesCache));
                }
            }

            function clearDateCacheDayView(list){
                list.forEach(function(date){
                    !date.clearedAppointments && clearViewAppointments(date)
                    !date.clearedPeriods && clearViewPeriods(date);
                });
            }

            function clearViewAppointments(date){
                date.appointments && dv().ctrler.removeEvents(_.values(date.appointments));
                date.clearedAppointments = true;
            }

            shdl.clearViewShdlDateAppointments = clearViewAppointments;

            function clearViewPeriods(date){
                date.clearedPeriods = true;
                date.periods && date.appointmentDate && date.appointmentDate.dateTemplate &&
                    dv().ctrler.removeEvents(getPeriodsFromShdlDate(date));
            }

            function getPeriodsFromShdlDate(d){
                return d.appointmentDate.dateTemplate.lstPeriods;
            }

            function erasePeriodFromViewer(period){
                if(appointment && hasDayViewer()){
                    dv().ctrler.removeEvents([period]);
                }
            }

            function eraseAppointmentFromViewer(appointment){
                if(appointment && hasDayViewer()){
                    dv().ctrler.removeEvents([appointment]);
                }
            }

            shdl.renewReservation = function(appointment){
                if(appointment.reservation && appointment.reservation.numberOfSecToExpire > 0){
                    renewAppointment(getAppointmentReservation(appointment, appointment.reservation)).then(function(res){
                        if(res && res.data && res.data.obj && res.data.obj.length === 1){
                            stopCountDown(appointment);
                            appointment.reservation = res.data.obj[0];
                        }
                        reservationCountDown(appointment);
                    });
                }
            }

            shdl.currentInEditMode = function(){
                var curr = shdl.currentAppointment()
                var isInEditMode = curr && curr.editable && curr.editable.editMode;
                return isInEditMode;
            }

            shdl.currentPeriodInEditMode = function(){
                // if(shdl.isScheduleEditMode()){
                    var curr = shdl.currentPeriod()
                    var isInEditMode = curr && curr.editable && curr.editable.editMode;
                    return isInEditMode;
                // }else{
                //     return false;
                // }
            }

            shdl.createNewPeriod = function(datetime, rangeMins){
                var duration = getPeriodDefaultDuration(selectedContext);
				var start = moment(datetime).hours() * 60 + moment(datetime).minutes();
//                var start = moment(datetime).diff(moment(datetime).startOf('day'), 'm');
                var n = getNewPeriod(start, duration);
                return $q(function(resolve, reject){
                    if(!selectedContext.okToClose() || selectedContext.getPeriodConflicts(n, rangeMins).hasConflicts || !okToCloseSelectedPeriod()){
                        reject();
                    }else{
                        selectedContext.addPeriods([n]);
                        selectedContext.periodById(OfysFCUtils.getIdOrTag(n));
                        resolve();
                    }
                })
            };

            shdl.createNewAppointment = function(datetime, idPeriod){
                var period = shdl.getPeriod(idPeriod);
                var duration = OfysFCUtils.getDuration(period, shdl.dates(selectedDate).appointmentDate.dateTemplate);
				var start = moment(datetime).hours() * 60 + moment(datetime).minutes();
//                var start = moment(datetime).diff(moment(datetime).startOf('day'), 'm');
                var n = getNewAppointment(prof, selectedDate, start, duration, period);
                reserveAppointment(getAppointmentReservation(n)).then(function(res){
                    if(res && res.data && res.data.obj && res.data.obj.length === 1){
                        n.reservation = res.data.obj[0];
                        reservationCountDown(n);
                    }
                    shdl.addAppointments([n]);
                    shdl.currentAppointment(OfysFCUtils.getIdOrUid(n));
                });
            };

			shdl.createNewAppointmentRecall = function(start, selectedDate, idPeriod){
//				var selectedDate = shdl.currentDate();
				var period = shdl.getPeriod(idPeriod);
		        var duration = OfysFCUtils.getDuration(period, shdl.dates(selectedDate).appointmentDate.dateTemplate);
				var recallProf = {};
				recallProf.id = shdl.prof.id;
				var n = getNewAppointment(recallProf, selectedDate, start, duration, period);
		        reserveAppointment(getAppointmentReservation(n)).then(function(res){
		            if(res && res.data && res.data.obj && res.data.obj.length === 1){
		                n.reservation = res.data.obj[0];
		                reservationCountDown(n);
		            }

					n.note = model.recall().copyRecall.reason;
					n.patients.push(model.recall().copyRecall.patient);
					shdl.addAppointments([n]);
					shdl.saveAppointment(n, false, true);				
		        });			        
			}
			
			shdl.pasteAppointment = function(chosenDate, startTime, idPeriod){
				var period = shdl.getPeriod(idPeriod);
				diff = model.appointment().copyApp.endTime - model.appointment().copyApp.startTime
				model.appointment().copyApp.startTime = startTime;
				model.appointment().copyApp.endTime = startTime + diff;
				model.appointment().copyApp.date = chosenDate;
				model.appointment().copyApp.idAppointmentDate = shdl.dates(chosenDate).appointmentDate.id;
				model.appointment().copyApp.idProfessional = shdl.prof.id;
                model.appointment().copyApp.idProfessionals = [shdl.prof.id];

				if(!model.appointment().toCut){
					delete model.appointment().copyApp.id // create a new appointment
				}
				var idService = getPeriodTypeId(period);
                if(idService){
                    model.appointment().copyApp.idService = idService;
                }
                shdl.saveAppointment(model.appointment().copyApp);
				if(model.appointment().toCut){
					delete model.appointment().copyApp;
				}
				model.appointment().toCut = false;
                model.apptLstUpdated(true);
                model.apptUpdated(true);	
			}

            function getPeriodTypeId(p){
                if(p && p.appointmentPeriodType){
                    return p.appointmentPeriodType
                }
            }

            function stopCountDown(appointment){
                if(appointment && appointment.reservation &&
                    appointment.reservation.countdown){
                        $interval.cancel(appointment.reservation.countdown);
                }
            }

            function reservationCountDown(appointment){
                stopCountDown(appointment);
                appointment.reservation.countdown = $interval(function(){
                    if(appointment.reservation.numberOfSecToExpire> 0){
                        appointment.reservation.numberOfSecToExpire--;
                    }else{
                        $interval.cancel(appointment.reservation.countdown);
                    }
                }, 1000);
                return appointment;
            }

//                    function cleanReservationForSave(app){
//                        var res = angular.copy(app);
//                        res.date = OfysUtils.stringToLocalDate(app.date);
//                        return res;
//                    }
            function reserveAppointment(reservation){
                shdl.reservationLock = true;
                return AppointmentAccessor.reserveappointment(reservation, angular.noop);
            }
            
            function renewAppointment(reservation){
                shdl.reservationLock = true;
                return AppointmentAccessor.extendReservation(reservation, angular.noop);
            }


            function getPeriodDefaultDuration(ctx){
                var duration = model.clientPreferences().appointmentBaseTime;
                var ctxDuration = ctx.defaultPeriodDuration();
                if(ctxDuration){
                    duration = ctxDuration;
                }
                return duration;
            }

            shdl.getPeriod = function(id){
                if(id !== undefined && index.period[id] !== undefined){
                    return shdl.dates(index.period[id]).periods[id]
                }
            };
            shdl.lastModifiedPeriodType;
            function getDefaultPeriodType(){
                if(shdl.lastModifiedPeriodType){
                    return shdl.lastModifiedPeriodType;
                }
                return model.clientPreferences().appointmentPeriodTypes.find(function(e){return e.isDefault});
            }

            shdl.moveReservation = function(event, app) {
                var prevApp = angular.copy(_.omit(app, ['viewbag','selectedPatient','editable']))
                var oldResv = getAppointmentReservation(prevApp, prevApp.reservation);
                AppointmentAccessor.deleteReservation(oldResv, angular.noop);
    
                app.startTime = OfysFCUtils.eventTimeToOfysTime(event.start);
                app.endTime = OfysFCUtils.eventTimeToOfysTime(event.end);
                app.editable.startTime = app.startTime;
                app.editable.endTime = app.endTime;
                var res;
                if (app.reservation) {
                    app.reservation.startTime = app.startTime;
                    app.reservation.endTime = app.endTime;
                    res = app.reservation;
                } else {
                    res = getAppointmentReservation(app);
                }
                AppointmentAccessor.reserveappointment(res, angular.noop);
            }
            
            function getAppointmentReservation(app, n){
                var reservation;
                if (n) {
                    reservation = n;
                    reservation.timeOfExpiration= moment().add(5,'m').valueOf();
                    reservation.numberOfSecToExpire= moment.duration(5,'minutes').asSeconds();
                } else {
                    reservation = {
                        idClient: model.client().id,
                        timeOfExpiration: moment().add(5,'m').valueOf(),
                        numberOfSecToExpire : moment.duration(5,'minutes').asSeconds(),
                        date: OfysUtils.stringToLocalDate(app.date),
                        idProfessional: app.idProfessional,
                        endTime: app.endTime,
                        startTime: app.startTime,
                        idSite: app.idSite
                    };
                }
                // if (isRvsqActive) {
                // 	if (site!=null && site.getRvsqId()!=null) {
                // 		xr.rvsqLocId = site.getRvsqId();
                // 		XBaseProfessionnal prof = PersonUiPlugin.getDefault().getProfessionnal(xdate.getProfessional());
                // 		xr.rvsqPractNo = XBaseProfessionnal.getCode6chiffres(prof);
                // 	}
                // }
                return reservation;
                // XReservedAppointment xr = new XReservedAppointment();
                // xr.date = xdate.getDate();
                // xr.idProfessional = xdate.getProfessional();
                // xr.endTime = appointment.getEndTime();
                // xr.startTime = appointment.getStartTime();
                // xr.idClient = ca.infodata.ofys.client.Application.get().getGlobalInstances().getSession().getClient().getId();
                // xr.idSite = appointment.getSite();
                // xr.timeOfExpiration = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5);
                // xr.numberOfSecToExpire = (int) TimeUnit.MINUTES.toSeconds(5);
                // if (isRvsqActive) {
                // 	if (site!=null && site.getRvsqId()!=null) {
                // 		xr.rvsqLocId = site.getRvsqId();
                // 		XBaseProfessionnal prof = PersonUiPlugin.getDefault().getProfessionnal(xdate.getProfessional());
                // 		xr.rvsqPractNo = XBaseProfessionnal.getCode6chiffres(prof);
                // 	}
                // }        
            }

            function getNewPeriod(start, duration){
                var nowUnix = moment().valueOf();
                var res = {
                    "className": "CAppointmentPeriod",
                    // "id":12451,
                    "tag": APPOINTMENTUID.next(),
                    "startTime": start,
                    "endTime": getDefaultEndTime(start,duration),
                    "appointmentPeriodType": getDefaultPeriodType().id,
                    "defaultLength": duration ? duration : model.clientPreferences().appointmentBaseTime,
                    // "nomPeriod": ,
                    "idSite": getDefaultSite(),
                    "isClosed": false,
                    "isSofyEnabled": false,
                    "isSofyTreatingRestricted": false,
                    // "updateNumber": "",
                    "rvsqIsVisibleToClient": "",
                    // "visibleNbMinBefore": "",
                    // "rvsqUidService": "",
                    "modificationStatus": ModificationStatus.STATUS_NEW_UPDATED
                }
                return res;
            }

            function getNewAppointment(prof, date, start, duration, period){
                var nowUnix = moment().valueOf();	// unix time != in ms but in SEC!
                var res = {
                    "className": "CAppointment",
                    // "id":12451,
                    "uid": APPOINTMENTUID.next(),
                    "startTime": start,
                    "endTime": getDefaultEndTime(start,duration,period),
                    "patientStatus": "NONE",
                    "status": "NORMAL",
                    "isAnnualExam": false,
                    // "note": "",
                    // "statusNote": "",
                    "autoSendReminder": false,
                    "isDeleted": false,
                    "isConfidential": false,
                    "dateCreated": nowUnix,
                    "dateEntryLast": nowUnix,
                    "nameUser": model.user().profil.name,
                    // "idAppointmentDate": 1058297,
                    "date": date,
                    "idProfessional": prof.id,
                    "idProfessionals":[prof.id],
                    "patients": [],
                    "typeAppointment": getDefaultAppointmentType().id, //@deprecated use period type
                    "idSite": getDefaultSite(period, prof),
                    "when": -1,
                    "force": false,
                    // "version": 29633311,
                    "modificationStatus": ModificationStatus.STATUS_NEW
                }
                var idService = getPeriodTypeId(period);
                if(idService){
                    res.idService = idService;
                }
                return res;
            }

            function getDefaultEndTime(start, duration, period ){
                if(period && period.defaultLength){
                    return start+period.defaultLength;
                }else if(duration){
                    return start+duration;
                }
            }

            function getDefaultSite(period){
                if(period){
                    return period.idSite;
                }else if(shdl.selectedProfSite){
                    return shdl.selectedProfSite.idSite;
                }else if(model.schedule().contextSite){
                    return model.schedule().contextSite.id;
                }
            }

            shdl.restoreSelectedEvents = function(){
                $timeout(function(){
                    if(selectedAppointment && selectedAppointment.uiEvent){
                        setViewerSelection(selectedAppointment);
                    }
                    if(selectedPeriod && selectedPeriod.uiEvent){
                        setViewerSelection(selectedPeriod);
                    }
                }, 50)
            }

            //Useful when doing operations that changes the current schedule but want to set the current one after the operations are complete. e.g when reloading from another tab in the application.
            function RememberCurrentSchedule(){
                    var current = {};
					this.currentVal = function(){
						return current.val
					}
                    this.isForgotten = function(){
                        return !current.val;
                    }
                    this.remember = function(){
                        current.val = shdl.multiViewCtrl.currentSchedule;
                    }
                    this.setAndForget = _.throttle(_.debounce(function(){
                        if(current.val){
                            shdl.multiViewCtrl.currentSchedule = current.val;
                            delete current.val;
                        }
                    }, 200), 200, {leading: false})

            }
            function MultiViewCtrl(){
                var mvc = this;
                var minDisplayTime, maxDisplayTime;
                var updateSchedulesMinMaxTime = _.throttle(function(){
                    // console.log("Min time :"+minDisplayTime);
                    // console.log("Max time :"+maxDisplayTime);
                    shdl.multiSchedules.forEach(function(c){
                        c.calendarMinMaxUpdate(minDisplayTime,maxDisplayTime);
                    })
                },100, {leading:false});

                mvc.currentSchedule = null;
                mvc.rememberCurrentSchedule = new RememberCurrentSchedule();
                mvc.init = function(){
                    shdl.currentContext(shdl.contextTypes.SCHEDULE_DATE);
                    if(prof.profs.length > 0){
                        for (let i = 0; i < prof.profs.length; i++) {
                            mvc.addSchedule(prof.profs[i]);
                        }
                    }
                }

                mvc.addSchedule = function(prof){
                    var schedulePart = factory.getNew(prof, {});
                    
                    schedulePart.isChildSchedule = true; 
                    schedulePart.parentCtrler = mvc;
                    schedulePart.currentContext(shdl.contextTypes.SCHEDULE_DATE);
                    mvc.initDayView(schedulePart);
                    shdl.multiSchedules.push(schedulePart);
                    shdl.mvcConfig.registerForNotifications(prof.id, shdl.prof.id);
                    shdl.mvcConfig.updateFavorite(shdl.prof);
                }

                mvc.initDayView = function(s){
                    s.viewers = {};
                    s.viewers.day = shdl.prof.dayViewGen(function(){
                        if(mvc.rememberCurrentSchedule.isForgotten() && mvc.currentSchedule && 
                            mvc.currentSchedule.prof.id !== s.prof.id){
                            mvc.currentSchedule.clearSelectedAppointment();
                        }
                        mvc.currentSchedule = s;
                        return s;
                    });
                }

                mvc.removeSchedule = function(prof){
                    mvc.getScheduleIndexByProf(prof,function(i){
                        shdl.multiSchedules.splice(i, 1);
                    });
                    shdl.mvcConfig.unRegisterForNotifications(prof.id, shdl.prof.id);
                    if(shdl.prof.profs && shdl.prof.profs.length > 0){
                        var i = shdl.prof.profs.indexOf(prof);
                        shdl.prof.profs.splice(i,1);
                    }
                    shdl.mvcConfig.updateFavorite(shdl.prof);
                    
                }
                mvc.renderCalendars = function(){
                    shdl.multiSchedules.forEach(function(c){
                        c.renderDV();
                    })
                }
                mvc.getViewSpanMinTime = function(){
                    var time;
                    var shdlTime;
                    shdl.multiSchedules.forEach(function(c){
                        shdlTime = c.getViewSpanMinTime();
                        if(time == null || time > shdlTime){
                            time = shdlTime
                        }
                    });
                    if(time != null && time != "" ){
                        if(minDisplayTime != time){
                            updateSchedulesMinMaxTime();
                        }
                        minDisplayTime = time;
                    }
                    // console.log("MVC min time: "+time);
                    return time;
                }
                mvc.getViewSpanMaxTime = function(){
                    var time;
                    var shdlTime;
                    shdl.multiSchedules.forEach(function(c){
                        shdlTime = c.getViewSpanMaxTime();
                        if(time == null || time < shdlTime){
                            time = shdlTime
                        }
                    })
                    if(maxDisplayTime == null ){
                        maxDisplayTime = time;
                    }else if(maxDisplayTime != time){
                        updateSchedulesMinMaxTime();
                        maxDisplayTime = time;
                    }
                    // console.log("MVC max time: "+time);
                    return time;
                }
                mvc.getScheduleIndexByProf = function(prof, fnFound,fnNotFound){
                    var i = shdl.multiSchedules.findIndex(function(e){
                        return e.prof.id == prof.id;
                    });
                    if(i > -1 ){
                        return fnFound != null && fnFound(i);
                    }else{
                        return fnNotFound != null && fnNotFound(i);
                    }
                }

                mvc.getScheduleByProf = function(prof, fnFound,fnNotFound){
                    mvc.getScheduleIndexByProf(prof,function(i){
                        return fnFound(shdl.multiSchedules[i])
                    }, fnNotFound)
                }

                mvc.getScheduleByProfId = function(profId, fnFound,fnNotFound){
                    var i = shdl.multiSchedules.findIndex(function(e){
                        return e.prof.id == profId;
                    });
                    if(i > -1 ){
                        return fnFound != null && fnFound(shdl.multiSchedules[i]);
                    }else{
                        return fnNotFound != null && fnNotFound(ishdl.multiSchedules[i]);
                    }
                }
            }

            // Initiate schedule state. 
            // called when schedule is being viewed and is the current viewed schedule
            //Potentially called multiple times.
            shdl.init = function(){
                if(shdl.isMultiSchedule){
                    if(shdl.multiViewCtrl == undefined){
                        shdl.multiViewCtrl = new MultiViewCtrl();
                        shdl.multiViewCtrl.init();
                    }
                }else{
                    shdl.updateSlotDuration();
                    shdl.updateAppointmentCalendarText();
                    shdl.daysViewed(daysViewed);
                    shdl.currentContext(selectedContext ? selectedContext.type() : shdl.contextTypes.SCHEDULE_DATE);
                    shdl.currentDate(selectedDate);
                    shdl.restoreSelectedEvents();

                }
            }

            // close view should clear all calendar states and 
            //any state that is not required when schedule is not viewed.
            shdl.close = function(){
                selectedContext.restore(null, {pre: true, post: false});
                clearBaseAppointmentDate(_.values(datesCache));
            }

            // open view should restore calendar states and any state
            // required to view the schedule drawn on the calendar
            shdl.open = function(){
                selectedContext.restore(null, {pre:false, post:true});
                shdl.initMonth();
            }

            function dirtySchedule(){
                if(presave.dirty){
                    presave.unsavedChanges = true;
                    $timeout(function(){presave.unsavedChanges = false;}, 2000)
                }
                return presave.dirty;
            }

            function setScheduleDirty(state){
                if(state === true){
                    presave.dirty = true;
                    registerDirtySchedule();
                }else if (state === false){
                    presave.dirty = false;
                    unregisterDirtySchedule();
                }
            }
            var registeredDirtyId;

            function registerDirtySchedule(){
                registeredDirtyId = "schdl_"+shdl.prof.id;
                QValidation.registerDirty(registeredDirtyId, shdl.saveSchedule, shdl.cancelModifications);
            }

            function unregisterDirtySchedule(){
                if(registeredDirtyId){
                    QValidation.unregisterDirty(registeredDirtyId);
                    registeredDirtyId = undefined;
                }
            }

            shdl.canClose = function(){
                if(shdl.isMultiSchedule){
                    if(shdl.multiViewCtrl.currentSchedule){
                        return shdl.multiViewCtrl.currentSchedule.canClose(...arguments);
                    }else{
                        return true;
                    }
                }
                return selectedContext.okToClose() && !dirtySchedule();
            }

            function setProfSite(){
                if(prof && prof.sites && prof.sites.length > 0){
                    var workSite = null;
                    if(model.user().session.workSite){
                        worksite = prof.sites.find(e => e.idSite == model.user().session.workSite.id)
                    }
                    shdl.selectedProfSite = workSite ? workSite : prof.sites[0];
                }
            }

            setProfSite();
        }


        var factory = {
            appointmentViews: ['searchAppointment','appointmentEdit'],
            scheduleViews: ['scheduleHeader', 'scheduleDate','periodEdit', 'scheduleTemplatesLst', 'weekTemplateEdit','dateTemplateEdit'],
            recallsViews: ['recallSearch','recallList','recallEdit'],
			getNew: function(prof, viewers){
                return new Schedule(prof, viewers);
            }
        }
        return factory;
	}]);

    appointment.factory('ScheduleStore', ['ScheduleFactory','$timeout','model','$q','$filter','utils',
		 function(ScheduleFactory, $timeout, model, $q, $filter,utils) {

        //Active schedules stay open even after the user selects another schedule(professional)
        function scheduleIsActive(id){
            return store.selectedProfSchedule.ids[id];
        }
        function deactivateSchedule(id){
            store.selectedProfSchedule.ids[id] = false;
            store.updateActiveProfs();
        }
        //All opened schedules should be indexed.
        function scheduleIsIndexed(id){
            return store.activeSchedulesIndex[id];
        }
        function removeFromIndex(id){
            delete store.activeSchedulesIndex[id];
        }

        function getPreviousSchedule(prof){
            var i = store.viewerTabs.tabs.findIndex(e=>e.name == prof.id);
            if(i == 0) i = 2;// if the prof is first get the second item;
            var scheduleId = store.viewerTabs.tabs[i-1].name;
            return store.scheduleProfs.find(e=>e.id == scheduleId);
        }

        function setActiveTab(id){
            var i = store.viewerTabs.tabs.findIndex(function(e){
                return e.name == id;
            });
            if(i > -1){
                store.viewerTabs.activeTab = i;
            }
        }

        function updateTabs(){
            for (var i = store.viewerTabs.tabs.length-1; i >= 0; i--) {
                var id = store.viewerTabs.tabs[i].name;
                if(store.selectedProfSchedule.ids[id] !== true){
                    store.viewerTabs.tabs.splice(i,1);
                }
            }
        }

        function clearSchedule(shdl){
            if(shdl.canClose()){
                shdl.close();
                shdl.viewers = null;
                if(shdl.isMultiSchedule){
                    shdl.multiSchedules.forEach(e=>e.viewers = null);
                }
                if(!scheduleIsActive(shdl.prof.id)){
                    removeFromIndex(shdl.prof.id);
                }
            }
        }

        function registerMultiViewForNotifications(idProf, multiViewScheduleId){
            if(!store.multiViewNofiticationIndex[idProf]){
                store.multiViewNofiticationIndex[idProf] = {};
            }
            store.multiViewNofiticationIndex[idProf][multiViewScheduleId] = true;
        }

        function unRegisterMultiViewForNotifications(idProf, multiViewScheduleId){
            delete store.multiViewNofiticationIndex[idProf][multiViewScheduleId];
            if(_.isEmpty(store.multiViewNofiticationIndex[idProf])){
                delete store.multiViewNofiticationIndex[idProf];
            }
        }

        function setCurrentSchedule(prof){
            var scheduleIsNew = !scheduleIsIndexed(prof.id);
            store.updateActiveProfs();
            var scheduleIsNew = !scheduleIsIndexed(prof.id);
            if(scheduleIsNew){
                store.activeSchedulesIndex[prof.id] = ScheduleFactory.getNew(prof, store.viewers);
				if(!store.selectedProfSchedule.ids[prof.id]){
	                store.viewerTabs.tabs.push({
	                    title: store.viewerTabs.getTabTitle(prof),
	                    name: prof.id,
	                });
				}
                store.viewerTabs.activeTab = store.viewerTabs.tabs.length -1;
            }
			store.selectedProfSchedule.ids[prof.id] = true;
            store.schedule = store.activeSchedulesIndex[prof.id];
            if(!prof.isMultiSchedule){
                store.schedule.viewers = store.viewers;
                store.schedule.isMultiSchedule = false;
            }else{
                if(scheduleIsNew){
                    store.schedule.mvcConfig.registerForNotifications = registerMultiViewForNotifications;
                    store.schedule.mvcConfig.unRegisterForNotifications = unRegisterMultiViewForNotifications;
                    store.schedule.mvcConfig.updateFavorite = function(prof){
                        if(!!store.listMultiProfessionnalFavorite.schdls[prof.id]){
                            store.listMultiProfessionnalFavorite.schdls[prof.id] = {profs:prof.profs.map(e=>e.id), name: prof.name};
                            saveMultiProfFavoriteJson();
                        }
                    }
                    store.schedule.isMultiSchedule = true;
                    store.schedule.multiSchedules = [];
                    store.schedule.viewers = {};
                }else{
                    store.schedule.multiSchedules.forEach(store.schedule.multiViewCtrl.initDayView)
                }
            }
            var emptyProfs = prof.isMultiSchedule &&  prof.profs.length == 0
            if(scheduleIsNew || emptyProfs){
                store.schedule.init();
                if(emptyProfs){
                    $timeout(function(){
                        if(store.togglePicker){
                            store.togglePicker();
                        }
                    }, 100);
                }
             }else{
                 store.schedule.flushCacheAndOpen();
             } 
        }

        function isCurrentSchedule(id){
            return id === store.schedule.prof.id;
        }

        function findByTagOrId(notif){
            return function(e){
                return (e.tag && e.tag == notif.tag) || (notif.id && e.id == notif.id);
            }
        }
        function updateTemplateListFromNotif(notif, list){
            var index = list.findIndex(findByTagOrId(notif));
            if(index > -1){
                if(notif.isDeleted){ // 
                    list.splice(index, 1);
                }else{
                    list.splice(index, 1, notif);
                }
            }else if(!notif.isDeleted && notif.isReusable){
                list.push(notif);
            }
        }

        function handleIfLoaded(idProf, handlFn){
            var shdl = store.activeSchedulesIndex[idProf];
            shdlHandleIfLoaded(shdl, idProf, handlFn);//Single prof schedule viewer
            if(store.multiViewNofiticationIndex[idProf]){//Multi prof schedule viewer
                Object.keys(store.multiViewNofiticationIndex[idProf]).forEach(function(multiViewId){
                    shdlHandleIfLoaded(store.activeSchedulesIndex[multiViewId], idProf, handlFn)
                });
            }
        }

        function shdlHandleIfLoaded(shdl, idProf, handlFn){
            if(shdl){
                if(!shdl.isMultiSchedule){
                    handlFn(shdl);
                }else {
                    if(!shdl.patientInEdit){
                        shdl.multiViewCtrl.rememberCurrentSchedule.remember();
                        shdl.multiViewCtrl.getScheduleByProfId(idProf, handlFn);
                        shdl.multiViewCtrl.rememberCurrentSchedule.setAndForget();
                    }else{
                        shdl.reloadAfterSave = true;
				        shdl.appToload.push({idProf, handlFn})
                    }
                }
            }
        }

        // AppointmentAccessor.appointementStatus(function(res){
        //     scope.allstatus = res;
        //     scope.allstatusByType = _.indexBy(res, 'type');
        // })

        OfysUtils.scheduleTabCloseProf = function(id){
            var prof = store.scheduleProfs.find(function(e){return e.id == id});
            if(prof){
                store.closeSchedule(prof);
            }
        }
        function MultiViewId(){
            this.idCounter = 1;
            this.idIndex = {};
            this.next = function(){
                var candidate = "mt"+this.idCounter;
                // find nex counter id
                for (;!!this.idIndex[candidate]; this.idCounter++) {
                    candidate = "mt"+this.idCounter;
                }
                this.idIndex[candidate] = true;
                return candidate;
            }
            this.nextName = function(){
                return "Vue multi-professionnels";
            }
        }
        
        function ProfListCtrl(){
            this.getName = function(item){
                if(item == undefined){
                    return "";
                }
                if(!!item.isMultiSchedule){
                    return item.name;
                }else{
                    var n = item.lastName + ' ' + item.firstName;
                    return n ? MyNamespace.helpers.abbreviate(n, 35) : "";
                }
            }

            this.toggleEditMultiName = function(item){
                if(item.name.length > 0){
                    item.editMultiName = !item.editMultiName;
                }
            }
        }


        var store = {
            viewers: {},
            scheduleProfs:[],
            selectedProfSchedule: {ids:{}},
			listProfessionnalFavorite: model.prefSettings('user_list_profFavorite') != null ? model.prefSettings('user_list_profFavorite') : [],
			listMultiProfessionnalFavorite: {
                schdls:{},
                jsonV: model.prefSettings('user_list_multiProfFavorite') != null ? model.prefSettings('user_list_multiProfFavorite') : ""
            },
            MultiViewId: new MultiViewId(),
            ProfListCtrl:new ProfListCtrl(),
            viewerTabs:{
                activeTab: 0,
                tabs:[],
                getTabTitle: function(prof){
                    return store.ProfListCtrl.getName(prof)+'<span class="tabCloseProf fa fa-times" onclick="OfysUtils.tabCloseProf('+
                    (prof.isMultiSchedule ? "'"+prof.id+"'": prof.id)+')"></span>'
                },
                onChangeTab: function(i){
                    var tabsCtrl= this;
                    if(store.schedule != undefined && i !== undefined && tabsCtrl.tabs[i] != undefined &&
                         tabsCtrl.tabs[i].name !== store.schedule.prof.id){
                        var prof = store.scheduleProfs.find(p=>p.id === tabsCtrl.tabs[i].name);
                        store.selectProf(prof).then(function(){
                            store.viewerTabs.activeTab = i;
                        }, function(){
                            var iActive = tabsCtrl.tabs.findIndex(function(t){return t.name == store.schedule.prof.id;})
                            if(iActive > -1){
                                $timeout(function(){
                                    store.viewerTabs.activeTab = iActive;
                                });
                            }
                        })
                    }
                }
            },
            activeSchedulesIndex: {},// contains all active schedules
            multiViewNofiticationIndex:{},
            updateActiveProfs:function(){
                updateTabs();
            },
            toggleSelectedProf:function(prof){
                if (prof && prof.id) {
                    if(store.selectedProfSchedule.ids[prof.id]){
                        store.closeSchedule(prof)
                    }else{
                        this.selectProf(prof);
                    }
                }
            },
			toggleScheduleFavoriteProf:function(profs){
				for(const prof of profs){
					if(!store.selectedProfSchedule.ids[prof.id]){
	                    store.selectedProfSchedule.ids[prof.id] = true;
			            store.updateActiveProfs();
		                store.viewerTabs.tabs.push({
		                    title: store.viewerTabs.getTabTitle(prof),
		                    name: prof.id,

		                });
	                }
				}
			},
			profFavorite:function(schedule){
                if(schedule.isMultiSchedule){
                    multiProfFavorite(schedule)
                }else{
                    profFav(schedule);
                }
			},
            isFavoriteSchedule: function(item){
                if(item.isMultiSchedule){
                    return store.listMultiProfessionnalFavorite.schdls[item.id];
                }else{
                    return store.listProfessionnalFavorite.includes(item.id);
                }
            },
            getSchedule: function(prof){
                return store.activeSchedulesIndex[prof.id];
            },
            selectProf: function(prof){
                return $q(function(resolve, reject){
                    if (prof && prof.id) {
                        if(store.schedule){// current schedule exists
                            if(!store.schedule.canClose()){
                                reject();
                                return;
                            }

                            if(isCurrentSchedule(prof.id)){
                                store.schedule.init();
                                setActiveTab(prof.id);
                                resolve();
                                return;// if the professional is the same don't recreate the schedule.
                            }
                            clearSchedule(store.schedule);
                        }
                        setCurrentSchedule(prof);
                        setActiveTab(prof.id);
                        resolve();
                    } else{
                        reject();
                    }
                });
            },
            closeSchedule:function(prof){
                return $q(function(resolve, reject){
                    var isLastScheduleOpen = Object.keys(store.selectedProfSchedule.ids).filter(id=>store.selectedProfSchedule.ids[id]).length == 1;
					if(prof && prof.id && !isLastScheduleOpen && !scheduleIsIndexed(prof.id)){
						store.updateActiveProfs();
						deactivateSchedule(prof.id);
					}else if(prof && prof.id && !isLastScheduleOpen && store.activeSchedulesIndex[prof.id].canClose()){
                        var previousSchedule = getPreviousSchedule(prof);
                        deactivateSchedule(prof.id);
                        if(prof.id == store.schedule.prof.id){
                            // when closing the currently opened schedule.
                            store.selectProf(previousSchedule)
                        }else{
                            //when closing a schedule that is not currently opened.
                            clearSchedule(store.activeSchedulesIndex[prof.id]);
                        }
                        resolve();
                    }else{
                        reject();
                    }
                });
            },
            handleSchdlDatetemplateUpdateNotification: function(notif){
                updateTemplateListFromNotif(notif, model.schedule().appointmentDateTemplates);
            },
            handleSchdlWeektemplateUpdateNotification: function(notif){
                updateTemplateListFromNotif(notif, model.schedule().appointmentWeekTemplates);
            },
            handleSchdlAppointmentperiodtypeUpdateNotification: function(app){

            },
            handleAppointmentNotification: function(app){
                app.idProfessionals.forEach(function(idProf){
                    handleIfLoaded(idProf, function(shdl){
                        if(shdl.appointmentHasChangedDateAndInEditMode(app) == false){
                            shdl.updateAppointment(app);
                        };
                    });
                });
            },
            handleAppointmentReservationNotification: function(reservation){
                handleIfLoaded(reservation.idProfessional, function(shdl){
					shdl.updateReservationFromWS(reservation);	
                })
            },
            handleAppointmentDateNotification: function(appDate){
                handleIfLoaded(appDate.professionnal, function(shdl){
                    shdl.setAppointmentDate(appDate);
                    shdl.addPeriods(appDate, appDate.date);
                    shdl.updateBaseAppointmentDate(appDate, true);
                });
            },
            handleBaseAppointmentDateNotification: function(baseAppDate){
                handleIfLoaded(baseAppDate.professionnal, function(shdl){
                    baseAppDate.date = OfysUtils.daysFrom1970ToStr(baseAppDate.date);
                    shdl.updateBaseAppointmentDate(baseAppDate);
                });
            },
            handleDateKeyNotification: function(datekey){
                datekey.date = OfysUtils.daysFrom1970ToStr(datekey.date);
                handleIfLoaded(datekey.professional, function(shdl){
                    shdl.updateDateKey(datekey);
                });
            },
        };

        function multiProfFavorite(schdl){
            if(!store.listMultiProfessionnalFavorite.schdls[schdl.id]){
                store.listMultiProfessionnalFavorite.schdls[schdl.id] = {profs:schdl.profs.map(e=>e.id), name: schdl.name};
            }else{
                delete store.listMultiProfessionnalFavorite.schdls[schdl.id];
            }
            saveMultiProfFavoriteJson();
        }
        
        function saveMultiProfFavoriteJson(){
            store.listMultiProfessionnalFavorite.jsonV = JSON.stringify(store.listMultiProfessionnalFavorite.schdls);
            model.prefSettings('user_list_multiProfFavorite', store.listMultiProfessionnalFavorite.jsonV);
        }
        
        function profFav(prof){
            if(store.listProfessionnalFavorite.includes(prof.id)){
                const index = store.listProfessionnalFavorite.indexOf(prof.id);
                if (index > -1) {
                    store.listProfessionnalFavorite.splice(index, 1);
                }
            } else {
                store.listProfessionnalFavorite.push(prof.id);
            }
            model.prefSettings('user_list_profFavorite', store.listProfessionnalFavorite);
        }
        store.scheduleProfs = model.store.profs.filter.appointment.list();
        store.scheduleProfs.sort(function(a,b){
            return (+store.listProfessionnalFavorite.includes(b.id)) - (+store.listProfessionnalFavorite.includes(a.id)) || store.ProfListCtrl.getName(a).localeCompare(store.ProfListCtrl.getName(b));
        });
        if(store.listMultiProfessionnalFavorite.jsonV.length > 0){
            store.listMultiProfessionnalFavorite.schdls = JSON.parse(store.listMultiProfessionnalFavorite.jsonV)
            var multi = [];
            Object.keys(store.listMultiProfessionnalFavorite.schdls).forEach(e=>{
                store.MultiViewId.idIndex[e] = true;
                multi.push({
                    id: e,
                    name: store.listMultiProfessionnalFavorite.schdls[e].name ?store.listMultiProfessionnalFavorite.schdls[e].name : store.MultiViewId.nextName(),
                    profs: store.listMultiProfessionnalFavorite.schdls[e].profs.map(profId=>model.store.profs.get(profId)),
                    isMultiSchedule: true,
                    initOnOpen: true,
                })
            });
			multi.forEach(m=> m.profs = m.profs.filter(function(p){
                return p!=undefined && model.store.profs.filter.appointment.index[p.id] != null;
            }));
            if(multi.length > 0){
                store.scheduleProfs = multi.concat(store.scheduleProfs);
            }
        }
        return store;
    }]);


	appointment.controller('ScheduleController',
		['$scope','model',
		function($scope, model){
            // if (!model.user().profil) return;

            model.activeController('sc');
            model.activeMenu('Schedule');
			model.callDashBoardCount();
        }
    ]);
})();