/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.ui.dashboard.models.Utils;

public class LaboDescription {
    private Long receivedDate;
    private int receivedTests;
    private int pendingTests;
    private int totalTests;
    private String[] tests;

    public LaboDescription(String desc) {
        this.parseLaboDescriptionString(desc);
    }

    public LaboDescription(String tests, Long receivedDate) {
        this.receivedDate = receivedDate;
        this.parseTest(tests);
    }

    public void parseLaboDescriptionString(String name) {
        String[] namearray = name.split(":");
        this.setReceivedDate(namearray[0]);
        this.parseTest(namearray[2]);
    }

    private void parseTest(String tests) {
        String[] desc = tests.split("-");
        if (desc.length > 1) {
            String[] count = desc[0].split("/");
            int nCount = count.length;
            this.setReceivedTests(nCount > 0 ? this.cleanAndParse(count[0]) : -1);
            this.setPendingTests(nCount > 2 ? this.cleanAndParse(count[1]) : -1);
            this.setTotalTests(nCount > 1 ? this.cleanAndParse(count[nCount - 1]) : -1);
            this.setTests(desc[1].split(","));
        } else if (desc.length == 1) {
            this.setTests(desc[0].split(","));
        }
    }

    private int cleanAndParse(String number) {
        number = number.trim();
        int res = 0;
        if (number.contains("*")) {
            number = number.replace("*", "");
        }
        try {
            res = Integer.parseInt(number.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return res;
    }

    public Long getReceivedDate() {
        return this.receivedDate;
    }

    public void setReceivedDate(Long receivedDate) {
        this.receivedDate = receivedDate;
    }

    public void setReceivedDate(String receivedDate) {
        this.receivedDate = Utils.strToDate(receivedDate, "yyyy-MM-dd HH'h'mm").getTime();
    }

    public int getReceivedTests() {
        return this.receivedTests;
    }

    public void setReceivedTests(int receivedTests) {
        this.receivedTests = receivedTests;
    }

    public int getPendingTests() {
        return this.pendingTests;
    }

    public void setPendingTests(int pendingTests) {
        this.pendingTests = pendingTests;
    }

    public int getTotalTests() {
        return this.totalTests;
    }

    public void setTotalTests(int totalTests) {
        this.totalTests = totalTests;
    }

    public String[] getTests() {
        return this.tests;
    }

    public void setTests(String[] tests) {
        this.tests = tests;
    }
}

