/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.accessor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.cache.IPatientCache;
import ca.infodata.ofys.data.dataaccess.IPatientAccessor;
import ca.infodata.ofys.data.dataaccess.XFindPatientSummaryCriteria;
import ca.infodata.ofys.data.middle.dataobjects.PatientFlag;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPatientListText;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.XFusionPatient;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.dashboard.accessor.AbstractDashboardAccessorClient;
import ca.infodata.util1.date.LocalDateRange;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatientSyncAccessorClient
extends AbstractDashboardAccessorClient {
    private static final Logger logger = Logger.getLogger(PatientSyncAccessorClient.class.getName());
    private IPatientAccessor accessor = Application.get().getDataAccessors().getPatientAccessor();
    private final IPatientCache patientCache = Application.get().getCache().getPatientCache();

    public XPatient[] findLastSeen() {
        try {
            ReturnObject response = this.accessor.findLastUsed();
            XPatient[] list = (XPatient[])response.getObj();
            this.tryAddToCacheSafe(list);
            return list;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not find last seen patients", e);
            return null;
        }
    }

    public XPatient[] findPatientDependents(Integer patientId) {
        try {
            ReturnObject response = this.accessor.findPatientDependents(patientId);
            XPatient[] list = (XPatient[])response.getObj();
            this.tryAddToCacheSafe(list);
            return list;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in findPatient", e);
            return new XPatient[0];
        }
    }

    public XPatientListText[] findPatient(String query) {
        boolean noLimit = false;
        String nameDossier = query;
        String noDossier = null;
        String nam = null;
        String[] dateDernActivite = null;
        String noTelephone = "";
        String[] dateRapp = null;
        String note = "";
        boolean inObjectUsage = false;
        int idProfessionnal = -1;
        Integer idIntervenant = -1;
        boolean rdvsToMove = false;
        List<XSite> sites = null;
        boolean returnOneOrNull = false;
        XPatientListText[] list = this.findPatient(noLimit, nameDossier, noDossier, nam, dateDernActivite, noTelephone, dateRapp, note, inObjectUsage, idProfessionnal, idIntervenant, rdvsToMove, sites, returnOneOrNull);
        return list;
    }

    public XPatientListText[] findPatient(PatientSearchQuery query) {
        XPatientListText[] list = this.findPatient(query.noLimit, query.q, query.noDossier, query.nam, query.dateDernActivite, query.noTelephone, query.dateRapp, query.note, query.inObjectUsage, query.idProfessionnal, query.idIntervenant, query.rdvsToMove, query.sites, query.returnOneOrNull);
        return list;
    }

    public XPatient findPatientExactNoDossier(String noDossier) {
        try {
            ReturnObject ro = this.accessor.findPatientExactNoDossier(noDossier);
            if (ro.getStatus().isOK()) {
                XPatient patient = (XPatient)ro.getObj();
                this.tryAddToCacheSafe(patient);
                return patient;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in findPatientExactNoDossier", e);
        }
        return null;
    }

    public XPatientListText[] findPatient(boolean noLimit, String nameDossier, String noDossier, String nam, String[] dateDernActivite, String noTelephone, String[] dateRapp, String note, boolean inObjectUsage, Integer idProfessionnal, Integer idIntervenant, boolean rdvsToMove, List<XSite> sites, boolean returnOneOrNull) {
        try {
            ReturnObject returnObject = this.accessor.findPatient(noLimit, nameDossier, noDossier, nam, dateDernActivite, noTelephone, dateRapp, note, inObjectUsage, idProfessionnal, idIntervenant, rdvsToMove, sites, returnOneOrNull, null);
            XPatientListText[] list = (XPatientListText[])returnObject.getObj();
            this.tryAddToCacheSafe(list);
            return list;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in findPatient", e);
            return new XPatientListText[0];
        }
    }

    public List<Object> getPatientActivities(Integer idProf, Integer idPatient, LocalDateRange dateRange) {
        ArrayList obj = null;
        try {
            ReturnObject returnObject = this.accessor.findPatientSummary(idPatient, new XFindPatientSummaryCriteria(idProf, dateRange));
            obj = (ArrayList)returnObject.getObj();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error getPatientActivities profId=" + idProf + ", patientId=" + idPatient + ", dateRange=" + dateRange, e);
        }
        if (obj == null) {
            obj = new ArrayList();
        }
        return obj;
    }

    public List<Object> getPatientSummary(Integer profId, int patientId, LocalDateRange dateRange) {
        try {
            ReturnObject response = this.accessor.findPatientSummary(patientId, new XFindPatientSummaryCriteria(profId, dateRange));
            ArrayList obj = (ArrayList)response.getObj();
            if (obj == null) {
                obj = new ArrayList();
            }
            return obj;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error getting Patient Summary profId=" + profId + ", patientId=" + patientId + ", dateRange=" + dateRange, e);
            return null;
        }
    }

    public void setAsUsed(int patientId) {
        this.accessor.setAsUsed(patientId);
    }

    public ReturnObject getPatientFlagDetail(int id) {
        return this.accessor.getPatientFlagDetail(id, PatientFlag.CREAT_CLEARANCE);
    }

    public ReturnObject getFusionPatient(int idPatient) {
        return this.accessor.getFusionPatient(idPatient);
    }

    public XPatient getPatient(int patientId) {
        ReturnObject response = this.accessor.getPatient(patientId);
        XPatient patient = (XPatient)response.getObj();
        this.tryAddToCacheSafe(patient);
        return patient;
    }

    public XPatientListText[] getPatientsByIds(String ids) {
        ReturnObject returnObject = this.accessor.getPatientsByIds(ids);
        XPatientListText[] list = (XPatientListText[])returnObject.getObj();
        this.tryAddToCacheSafe(list);
        return list;
    }

    public ReturnObject save(XPatient objectToSave, boolean askQuestion) {
        return this.save((IDataObject)objectToSave, askQuestion, this.accessor);
    }

    public ReturnObject saveFusion(XFusionPatient objectToSave, boolean askQuestion) {
        return this.save((IDataObject)objectToSave, askQuestion, this.accessor);
    }

    private void tryAddToCacheSafe(XPatient[] list) {
        try {
            if (list != null && list.length > 0) {
                for (int i = 0; i < list.length; ++i) {
                    this.tryAddToCacheSafe(list[i]);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error adding XPatient[] to cache", e);
        }
    }

    private void tryAddToCacheSafe(XPatientListText[] list) {
        try {
            if (list != null && list.length > 0) {
                for (int i = 0; i < list.length; ++i) {
                    XPatientListText xPatientListText = list[i];
                    if (xPatientListText == null) continue;
                    this.tryAddToCacheSafe(xPatientListText.patient);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error adding XPatientListText[] to cache", e);
        }
    }

    private void tryAddToCacheSafe(XPatient patient) {
        if (patient != null) {
            try {
                Integer id = patient.getId();
                if (id != null) {
                    this.patientCache.put(patient.getId(), patient);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error adding XPatient to cache", e);
            }
        }
    }

    public class PatientSearchQuery {
        public Boolean noLimit = false;
        public String q;
        public String noDossier = null;
        public String nam = null;
        public String[] dateDernActivite = null;
        public String noTelephone = "";
        public String[] dateRapp = null;
        public String note = "";
        public Boolean inObjectUsage = false;
        public Integer idProfessionnal = -1;
        public Integer idIntervenant = -1;
        public Boolean rdvsToMove = false;
        public List<XSite> sites = null;
        public Boolean returnOneOrNull = false;
    }
}

