/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.communication.XPatientSurvey;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.dashboard.accessor.PatientSurveySyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CPatientSurvey;
import ca.infodata.util1.StringUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatientSurveyController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(PatientSurveyController.class.getName());
    private final PatientSurveySyncAccessorClient patientSurveyAccessor = new PatientSurveySyncAccessorClient();

    public PatientSurveyController() {
        this.getNotificationSystemConsumer().setHandleMethod(this::handleNotification);
    }

    private void handleNotification(DataObjectUpdatedNotification notification) {
        if (notification != null && notification.getObject() instanceof XPatientSurvey) {
            try {
                CPatientSurvey jMsg = new CPatientSurvey((XPatientSurvey)notification.getObject());
                ServerResponses.sendJsonToClient(notification.getClientId(), "patient.survey.update", jMsg);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "notification=" + StringUtils.safeToString((Logger)logger, (Object)notification), e);
            }
        }
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard", RouterFunctions.routes("/PatientSurvey/ws", RouterFunctions.routeAction("/getPatientSurveysByIdPatient", req -> {
            Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
            List<XPatientSurvey> patientSurveysByIdPatientId = this.patientSurveyAccessor.getPatientSurveysByIdPatient(idPatient);
            CPatientSurvey[] xToCPatientSurvey = this.XToCPatientSurvey(patientSurveysByIdPatientId);
            return ServerResponses.toJsonActionResult(xToCPatientSurvey);
        }), RouterFunctions.routeAction("/getPatientSurveysByIdPatientIdApt", req -> {
            Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
            Integer idApt = req.getRequiredQueryParam("idApt", Integer.class);
            List<XPatientSurvey> patientSurveysByIdPatientIdApt = this.patientSurveyAccessor.getPatientSurveysByIdPatientIdApt(idPatient, idApt);
            CPatientSurvey[] xToCPatientSurvey = this.XToCPatientSurvey(patientSurveysByIdPatientIdApt);
            return ServerResponses.toJsonActionResult(xToCPatientSurvey);
        }), RouterFunctions.routeAction("/getListOfPatientSurveysForClient", req -> {
            LinkedHashMap<String, String> surveysForClient = this.patientSurveyAccessor.getListOfPatientSurveysForClient();
            return ServerResponses.toJsonActionResult(surveysForClient);
        }), RouterFunctions.routeAction("/getResponsePatientSurveys", req -> {
            Integer idQuest = req.getRequiredQueryParam("idQuest", Integer.class);
            Integer idResp = req.getRequiredQueryParam("idResp", Integer.class);
            List<LinkedHashMap<String, List<LinkedHashMap<String, String>>>> responseSurveys = this.patientSurveyAccessor.getResponsePatientSurveys(idQuest, idResp);
            return ServerResponses.toJsonActionResult(responseSurveys);
        }), RouterFunctions.routeAction("/sendSurveyToEmail", req -> {
            Integer idQuest;
            Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
            ReturnObject surveyToEmail = this.patientSurveyAccessor.sendSurveyToEmail(idPatient, idQuest = req.getRequiredQueryParam("idQuest", Integer.class));
            if (surveyToEmail.getStatus().isOkToProceed()) {
                return ServerResponses.SUCCESS();
            }
            return ServerResponses.statusPage("sendSurveyToEmail", (IStatus)surveyToEmail.getStatus());
        })));
    }

    private CPatientSurvey[] XToCPatientSurvey(List<XPatientSurvey> patients) {
        if (patients == null) {
            return new CPatientSurvey[0];
        }
        CPatientSurvey[] res = new CPatientSurvey[patients.size()];
        for (int i = 0; i < patients.size(); ++i) {
            res[i] = new CPatientSurvey(patients.get(i));
        }
        return res;
    }
}

